unit Plus4;

interface

Type
	TOpCode = Record
		mn : String;
		by : Byte;
		ad : Byte;
		il : Byte;
	End;

Const
	OpCodes : Array [ 0 .. 255 ] Of TOpCode =
	(
		( mn : 'BRK';    by : 1; ad : 0; il : 0 ),             { $00 }
		( mn : 'ORA';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $01 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $02 }
		( mn : 'ASLORA'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $03 }
		( mn : 'NOP2';   by : 2; ad : 6; il : 1 ), { $nn }     { $04 }
		( mn : 'ORA';    by : 2; ad : 6; il : 0 ), { $nn }     { $05 }
		( mn : 'ASL';    by : 2; ad : 6; il : 0 ), { $nn }     { $06 }
		( mn : 'ASLORA'; by : 2; ad : 6; il : 1 ), { $nn }     { $07 }
		( mn : 'PHP';    by : 1; ad : 0; il : 0 ),             { $08 }
		( mn : 'ORA';    by : 2; ad : 2; il : 0 ), { #$nn }    { $09 }
		( mn : 'ASL';    by : 1; ad :15; il : 0 ),             { $0A }
		( mn : 'ANC';    by : 2; ad : 2; il : 1 ), { #$nn }    { $0B }
		( mn : 'NOP3';   by : 3; ad : 1; il : 1 ), { $nnnn }   { $0C }
		( mn : 'ORA';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $0D }
		( mn : 'ASL';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $0E }
		( mn : 'ASLORA'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $0F }
		( mn : 'BPL';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $10 }
		( mn : 'ORA';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $11 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $12 }
		( mn : 'ASLORA'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $13 }
		( mn : 'NOP2';   by : 2; ad : 5; il : 1 ), { $nn,X }   { $14 }
		( mn : 'ORA';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $15 }
		( mn : 'ASL';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $16 }
		( mn : 'ASLORA'; by : 2; ad : 5; il : 1 ), { $nn,X }   { $17 }
		( mn : 'CLC';    by : 1; ad : 0; il : 0 ),             { $18 }
		( mn : 'ORA';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $19 }
		( mn : 'NOP1';   by : 1; ad : 0; il : 1 ),             { $1A }
		( mn : 'ASLORA'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $1B }
		( mn : 'NOP2';   by : 3; ad : 3; il : 1 ), { $nnnn,X } { $1C }
		( mn : 'ORA';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $1D }
		( mn : 'ASL';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $1E }
		( mn : 'ASLORA'; by : 3; ad : 3; il : 1 ), { $nnnn,X } { $1F }
		( mn : 'JSR';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $20 }
		( mn : 'AND';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $21 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $22 }
		( mn : 'ROLAND'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $23 }
		( mn : 'BIT';    by : 2; ad : 6; il : 0 ), { $nn }     { $24 }
		( mn : 'AND';    by : 2; ad : 6; il : 0 ), { $nn }     { $25 }
		( mn : 'ROL';    by : 2; ad : 6; il : 0 ), { $nn }     { $26 }
		( mn : 'ROLAND'; by : 2; ad : 6; il : 1 ), { $nn }     { $27 }
		( mn : 'PLP';    by : 1; ad : 0; il : 0 ),             { $28 }
		( mn : 'AND';    by : 2; ad : 2; il : 0 ), { #$nn }    { $29 }
		( mn : 'ROL';    by : 1; ad :15; il : 0 ),             { $2A }
		( mn : 'ANC';    by : 2; ad : 2; il : 1 ), { #$nn }    { $2B }
		( mn : 'BIT';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $2C }
		( mn : 'AND';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $2D }
		( mn : 'ROL';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $2E }
		( mn : 'ROLAND'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $2F }
		( mn : 'BMI';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $30 }
		( mn : 'AND';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $31 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $32 }
		( mn : 'ROLAND'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $33 }
		( mn : 'NOP2';   by : 2; ad : 5; il : 1 ), { $nn,X }   { $34 }
		( mn : 'AND';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $35 }
		( mn : 'ROL';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $36 }
		( mn : 'ROLAND'; by : 2; ad : 5; il : 1 ), { $nn,X }   { $37 }
		( mn : 'SEC';    by : 1; ad : 0; il : 0 ),             { $38 }
		( mn : 'AND';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $39 }
		( mn : 'NOP1';   by : 1; ad : 0; il : 1 ),             { $3A }
		( mn : 'ROLAND'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $3B }
		( mn : 'NOP3';   by : 3; ad : 3; il : 1 ), { $nnnn,X } { $3C }
		( mn : 'AND';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $3D }
		( mn : 'ROL';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $3E }
		( mn : 'ROLAND'; by : 3; ad : 3; il : 1 ), { $nnnn,X } { $3F }
		( mn : 'RTI';    by : 1; ad : 0; il : 0 ),             { $40 }
		( mn : 'EOR';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $41 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $42 }
		( mn : 'LSREOR'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $43 }
		( mn : 'NOP2';   by : 2; ad : 6; il : 1 ), { $nn }     { $44 }
		( mn : 'EOR';    by : 2; ad : 6; il : 0 ), { $nn }     { $45 }
		( mn : 'LSR';    by : 2; ad : 6; il : 0 ), { $nn }     { $46 }
		( mn : 'LSREOR'; by : 2; ad : 6; il : 1 ), { $nn }     { $47 }
		( mn : 'PHA';    by : 1; ad : 0; il : 0 ),             { $48 }
		( mn : 'EOR';    by : 2; ad : 2; il : 0 ), { #$nn }    { $49 }
		( mn : 'LSR';    by : 1; ad :15; il : 0 ),             { $4A }
		( mn : 'ANDLSR'; by : 2; ad : 2; il : 1 ), { #$nn }    { $4B }
		( mn : 'JMP';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $4C }
		( mn : 'EOR';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $4D }
		( mn : 'LSR';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $4E }
		( mn : 'LSREOR'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $4F }
		( mn : 'BVC';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $50 }
		( mn : 'EOR';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $51 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $52 }
		( mn : 'LSREOR'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $53 }
		( mn : 'NOP2';   by : 2; ad : 5; il : 1 ), { $nn,X }   { $54 }
		( mn : 'EOR';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $55 }
		( mn : 'LSR';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $56 }
		( mn : 'LSREOR'; by : 2; ad : 5; il : 1 ), { $nn,X }   { $57 }
		( mn : 'CLI';    by : 1; ad : 0; il : 0 ),             { $58 }
		( mn : 'EOR';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $59 }
		( mn : 'NOP1';   by : 1; ad : 0; il : 1 ),             { $5A }
		( mn : 'LSREOR'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $5B }
		( mn : 'NOP2';   by : 3; ad : 3; il : 1 ), { $nnnn,X } { $5C }
		( mn : 'EOR';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $5D }
		( mn : 'LSR';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $5E }
		( mn : 'LSREOR'; by : 3; ad : 3; il : 1 ), { $nnnn,X } { $5F }
		( mn : 'RTS';    by : 1; ad : 0; il : 0 ),             { $60 }
		( mn : 'ADC';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $61 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $62 }
		( mn : 'RORADC'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $63 }
		( mn : 'NOP2';   by : 2; ad : 6; il : 1 ), { $nn }     { $64 }
		( mn : 'ADC';    by : 2; ad : 6; il : 0 ), { $nn }     { $65 }
		( mn : 'ROR';    by : 2; ad : 6; il : 0 ), { $nn }     { $66 }
		( mn : 'RORADC'; by : 2; ad : 6; il : 1 ), { $nn }     { $67 }
		( mn : 'PLA';    by : 1; ad : 0; il : 0 ),             { $68 }
		( mn : 'ADC';    by : 2; ad : 2; il : 0 ), { #$nn }    { $69 }
		( mn : 'ROR';    by : 1; ad :15; il : 0 ),             { $6A }
		( mn : 'ANDROR'; by : 2; ad : 2; il : 1 ), { #$nn }    { $6B }
		( mn : 'JMP';    by : 3; ad : 8; il : 0 ), { ($nnnn) } { $6C }
		( mn : 'ADC';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $6D }
		( mn : 'ROR';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $6E }
		( mn : 'RORADC'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $6F }
		( mn : 'BVS';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $70 }
		( mn : 'ADC';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $71 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $72 }
		( mn : 'RORADC'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $73 }
		( mn : 'NOP2';   by : 2; ad : 5; il : 1 ), { $nn,X }   { $74 }
		( mn : 'ADC';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $75 }
		( mn : 'ROR';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $76 }
		( mn : 'RORADC'; by : 2; ad : 5; il : 1 ), { $nn,X }   { $77 }
		( mn : 'SEI';    by : 1; ad : 0; il : 0 ),             { $78 }
		( mn : 'ADC';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $79 }
		( mn : 'NOP1';   by : 1; ad : 0; il : 1 ),             { $7A }
		( mn : 'RORADC'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $7B }
		( mn : 'NOP3';   by : 3; ad : 3; il : 1 ), { $nnnn,X } { $7C }
		( mn : 'ADC';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $7D }
		( mn : 'ROR';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $7E }
		( mn : 'RORADC'; by : 3; ad : 3; il : 1 ), { $nnnn,X } { $7F }
		( mn : 'NOP2';   by : 2; ad : 2; il : 1 ), { #$nn }    { $80 }
		( mn : 'STA';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $81 }
		( mn : 'NOP2';   by : 2; ad : 2; il : 1 ), { #$nn }    { $82 }
		( mn : 'STXSTA'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $83 }
		( mn : 'STY';    by : 2; ad : 6; il : 0 ), { $nn }     { $84 }
		( mn : 'STA';    by : 2; ad : 6; il : 0 ), { $nn }     { $85 }
		( mn : 'STX';    by : 2; ad : 6; il : 0 ), { $nn }     { $86 }
		( mn : 'STXSTA'; by : 2; ad : 6; il : 1 ), { $nn }     { $87 }
		( mn : 'DEY';    by : 1; ad : 0; il : 0 ),             { $88 }
		( mn : 'NOP2';   by : 2; ad : 2; il : 1 ), { #$nn }    { $89 }
		( mn : 'TXA';    by : 1; ad : 0; il : 0 ),             { $8A }
		( mn : 'TXAAND'; by : 2; ad : 2; il : 1 ), { #$nn }    { $8B }
		( mn : 'STY';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $8C }
		( mn : 'STA';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $8D }
		( mn : 'STX';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $8E }
		( mn : 'STXSTA'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $8F }
		( mn : 'BCC';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $90 }
		( mn : 'STA';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $91 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $92 }
		( mn : 'SHA';    by : 2; ad : 9; il : 1 ), { ($nn),y } { $93 }
		( mn : 'STY';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $94 }
		( mn : 'STA';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $95 }
		( mn : 'STX';    by : 2; ad :12; il : 0 ), { $nn,Y }   { $96 }
		( mn : 'STXSTA'; by : 2; ad :12; il : 1 ), { $nn,Y }   { $97 }
		( mn : 'TYA';    by : 1; ad : 0; il : 0 ),             { $98 }
		( mn : 'STA';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $99 }
		( mn : 'TXS';    by : 1; ad : 0; il : 0 ),             { $9A }
		( mn : 'SHS';    by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $9B }
		( mn : 'SHY';    by : 3; ad : 3; il : 1 ), { $nnnn,X } { $9C }
		( mn : 'STA';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $9D }
		( mn : 'SHX';    by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $9E }
		( mn : 'SHA';    by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $9F }
		( mn : 'LDY';    by : 2; ad : 2; il : 0 ), { #$nn }    { $A0 }
		( mn : 'LDA';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $A1 }
		( mn : 'LDX';    by : 2; ad : 2; il : 0 ), { #$nn }    { $A2 }
		( mn : 'LDXLDA'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $A3 }
		( mn : 'LDY';    by : 2; ad : 6; il : 0 ), { $nn }     { $A4 }
		( mn : 'LDA';    by : 2; ad : 6; il : 0 ), { $nn }     { $A5 }
		( mn : 'LDX';    by : 2; ad : 6; il : 0 ), { $nn }     { $A6 }
		( mn : 'LDXLDA'; by : 2; ad : 6; il : 1 ), { $nn }     { $A7 }
		( mn : 'TAY';    by : 1; ad : 0; il : 0 ),             { $A8 }
		( mn : 'LDA';    by : 2; ad : 2; il : 0 ), { #$nn }    { $A9 }
		( mn : 'TAX';    by : 1; ad : 0; il : 0 ),             { $AA }
		( mn : 'LXA';    by : 2; ad : 2; il : 1 ), { #$nn }    { $AB }
		( mn : 'LDY';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $AC }
		( mn : 'LDA';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $AD }
		( mn : 'LDX';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $AE }
		( mn : 'LDXLDA'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $AF }
		( mn : 'BCS';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $B0 }
		( mn : 'LDA';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $B1 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $B2 }
		( mn : 'LDXLDA'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $B3 }
		( mn : 'LDY';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $B4 }
		( mn : 'LDA';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $B5 }
		( mn : 'LDX';    by : 2; ad :12; il : 0 ), { $nn,Y }   { $B6 }
		( mn : 'LDXLDA'; by : 2; ad :12; il : 1 ), { $nn,Y }   { $B7 }
		( mn : 'CLV';    by : 1; ad : 0; il : 0 ),             { $B8 }
		( mn : 'LDA';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $B9 }
		( mn : 'TSX';    by : 1; ad : 0; il : 0 ),             { $BA }
		( mn : 'LAS';    by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $BB }
		( mn : 'LDY';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $BC }
		( mn : 'LDA';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $BD }
		( mn : 'LDX';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $BE }
		( mn : 'LDXLDA'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $BF }
		( mn : 'CPY';    by : 2; ad : 2; il : 0 ), { #$nn }    { $C0 }
		( mn : 'CMP';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $C1 }
		( mn : 'NOP2';   by : 2; ad : 2; il : 1 ), { #$nn }    { $C2 }
		( mn : 'DECCMP'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $C3 }
		( mn : 'CPY';    by : 2; ad : 6; il : 0 ), { $nn }     { $C4 }
		( mn : 'CMP';    by : 2; ad : 6; il : 0 ), { $nn }     { $C5 }
		( mn : 'DEC';    by : 2; ad : 6; il : 0 ), { $nn }     { $C6 }
		( mn : 'DECCMP'; by : 2; ad : 6; il : 1 ), { $nn }     { $C7 }
		( mn : 'INY';    by : 1; ad : 0; il : 0 ),             { $C8 }
		( mn : 'CMP';    by : 2; ad : 2; il : 0 ), { #$nn }    { $C9 }
		( mn : 'DEX';    by : 1; ad : 0; il : 0 ),             { $CA }
		( mn : 'SBX';    by : 2; ad : 2; il : 1 ), { #$nn }    { $CB }
		( mn : 'CPY';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $CC }
		( mn : 'CMP';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $CD }
		( mn : 'DEC';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $CE }
		( mn : 'DECCMP'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $CF }
		( mn : 'BNE';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $D0 }
		( mn : 'CMP';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $D1 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $D2 }
		( mn : 'DECCMP'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $D3 }
		( mn : 'NOP2';   by : 2; ad : 5; il : 1 ), { $nn,X }   { $D4 }
		( mn : 'CMP';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $D5 }
		( mn : 'DEC';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $D6 }
		( mn : 'DECCMP'; by : 2; ad : 5; il : 1 ), { $nn,X }   { $D7 }
		( mn : 'CLD';    by : 1; ad : 0; il : 0 ),             { $D8 }
		( mn : 'CMP';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $D9 }
		( mn : 'NOP1';   by : 1; ad : 0; il : 1 ),             { $DA }
		( mn : 'DECCMP'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $DB }
		( mn : 'NOP3';   by : 3; ad : 3; il : 1 ), { $nnnn,X } { $DC }
		( mn : 'CMP';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $DD }
		( mn : 'DEC';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $DE }
		( mn : 'DECCMP'; by : 3; ad : 3; il : 1 ), { $nnnn,X } { $DF }
		( mn : 'CPX';    by : 2; ad : 2; il : 0 ), { #$nn }    { $E0 }
		( mn : 'SBC';    by : 2; ad :10; il : 0 ), { ($nn,X) } { $E1 }
		( mn : 'NOP2';   by : 2; ad : 2; il : 1 ), { #$nn }    { $E2 }
		( mn : 'INCSBC'; by : 2; ad :10; il : 1 ), { ($nn,X) } { $E3 }
		( mn : 'CPX';    by : 2; ad : 6; il : 0 ), { $nn }     { $E4 }
		( mn : 'SBC';    by : 2; ad : 6; il : 0 ), { $nn }     { $E5 }
		( mn : 'INC';    by : 2; ad : 6; il : 0 ), { $nn }     { $E6 }
		( mn : 'INCSBC'; by : 2; ad : 6; il : 1 ), { $nn }     { $E7 }
		( mn : 'INX';    by : 1; ad : 0; il : 0 ),             { $E8 }
		( mn : 'SBC';    by : 2; ad : 2; il : 0 ), { #$nn }    { $E9 }
		( mn : 'NOP';    by : 1; ad : 0; il : 0 ),             { $EA }
		( mn : 'SBC';    by : 2; ad : 2; il : 0 ), { #$nn }    { $EB }
		( mn : 'CPX';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $EC }
		( mn : 'SBC';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $ED }
		( mn : 'INC';    by : 3; ad : 1; il : 0 ), { $nnnn }   { $EE }
		( mn : 'INCSBC'; by : 3; ad : 1; il : 1 ), { $nnnn }   { $EF }
		( mn : 'BEQ';    by : 2; ad : 4; il : 0 ), { $nnnn }   { $F0 }
		( mn : 'SBC';    by : 2; ad : 9; il : 0 ), { ($nn),y } { $F1 }
		( mn : 'JAM';    by : 1; ad : 0; il : 1 ),             { $F2 }
		( mn : 'INCSBC'; by : 2; ad : 9; il : 1 ), { ($nn),y } { $F3 }
		( mn : 'NOP2';   by : 2; ad : 5; il : 1 ), { $nn,X }   { $F4 }
		( mn : 'SBC';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $F5 }
		( mn : 'INC';    by : 2; ad : 5; il : 0 ), { $nn,X }   { $F6 }
		( mn : 'INCSBC'; by : 2; ad : 5; il : 1 ), { $nn,X }   { $F7 }
		( mn : 'SED';    by : 1; ad : 0; il : 0 ),             { $F8 }
		( mn : 'SBC';    by : 3; ad : 7; il : 0 ), { $nnnn,Y } { $F9 }
		( mn : 'NOP1';   by : 1; ad : 0; il : 1 ),             { $FA }
		( mn : 'INCSBC'; by : 3; ad : 7; il : 1 ), { $nnnn,Y } { $FB }
		( mn : 'NOP3';   by : 3; ad : 3; il : 1 ), { $nnnn,X } { $FC }
		( mn : 'SBC';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $FD }
		( mn : 'INC';    by : 3; ad : 3; il : 0 ), { $nnnn,X } { $FE }
		( mn : 'INCSBC'; by : 3; ad : 3; il : 1 )  { $nnnn,X } { $FF }
	);

implementation

end.
