	org $1001-2
	dw  $1001
	
	dw nextln,0	; second word is line number
	db $9e,"4109",0
nextln	db 0,0

UPSCROLL_ROWS	= 17
UPSCROLL_COLS	= 20	; 32 max

BITMAP_SOURCE	= $4000
BITMAP_COPY1	= $6000
BITMAP_COPY2	= $8000
gfx_offset	= BITMAP_COPY2 + ( (25-UPSCROLL_ROWS)*$140 + ($140-UPSCROLL_COLS*8) >> 1 )

CODE_SIZE	= UPSCROLL_ROWS * UPSCROLL_COLS * 9 + 1  ; code takes rows * cols * 9 bytes
CODE_SIZE_F	= (CODE_SIZE & $FF00) + $0100

move_text1	= BITMAP_COPY2 + $2000
move_text2	= move_text1 + CODE_SIZE_F
scroll_data	= move_text2 + CODE_SIZE_F

us_code_dst	= $D0
us_ptr1		= us_code_dst + 2
us_ptr2		= us_code_dst + 4
us_dest_ptr	= us_code_dst + 6
us_ptr		= us_code_dst + 8

adcw	macro addr,number
	if number < 256
	lda addr
	clc
	adc #number
	sta addr
	bcc *+4
	inc addr+1
	endif
	if number >= 256
	lda addr
	clc
	adc #number & 255
	sta addr
	lda addr+1
	adc #number >> 8
	sta addr+1
	endif
	endm
	
start
	sei
	sta $ff3f
	;
	lda #$FE
	sta $FF0E
	sta $FF0F
	lda #$03
	sta $FF10
	lda #$31
	sta $FF11
	;
	lda $FF12
	and #$FC
	ora #$03
	sta $FF12
	;
	lda #$3B	; turn graphics mode on
	sta $FF06
	;
	lda $FF07	; PAL/NTSC friendly
	and #$40
	ora #$18	; use $18 for multicolor
	sta $FF07
	;
	lda $FF12
	and #$03	; keep lowest 2 bits (sound)	
	ora #(BITMAP_COPY1 >> 10)
	sta $FF12
	;
	lda #$18	; color map at $1800
	sta $FF14
	;
skip1	lda #$00
	sta $FF15
	lda #$00
	sta $FF19
	lda #$77
	sta $FF16
	;
	lda #$77
	ldy #$08
	ldx #$03
	jsr fill
	;
	lda #$11
	ldy #$0C
	ldx #$03
	jsr fill
	;
	; --- clear scrolling text data
	;
	ldy #$00
	sty us_ptr1
	ldx #scroll_data >> 8
	stx us_ptr1+1
	;
	lda #UPSCROLL_COLS
	asl a
	tax
	;
	tya
il1	sta (us_ptr1),y
	iny
	bne il1
	inc us_ptr1+1
	dex
	bpl il1
	;    
	; --- make two copies of the pic
	;
	ldy #$00
	sty us_ptr1
	sty us_ptr2
	lda #BITMAP_SOURCE >> 8
	sta us_ptr1+1
	lda #BITMAP_COPY2 >> 8
	sta us_ptr2+1
	jsr copy_pic
	;
	lda #BITMAP_SOURCE >> 8
	sta us_ptr1+1
	lda #BITMAP_COPY1 >> 8
	sta us_ptr2+1
	jsr copy_pic
	;
	; --- generate code
	;
	ldy #$00				; must be 0 for put_byte
	;
	lda #move_text1 & 255
	sta us_code_dst
	lda #move_text1 >> 8
	sta us_code_dst+1
	lda #BITMAP_COPY1 >> 8
	sta cg_offs+1
	;
	jsr code_gen
	;
	lda #move_text2 & 255
	sta us_code_dst
	lda #move_text2 >> 8
	sta us_code_dst+1
	lda #BITMAP_SOURCE >> 8
	sta cg_offs+1
	;
	jsr code_gen
	;
	;lda #reveal_ptr & 255
	;sta us_ptr1
	;lda #reveal_ptr >> 8
	;sta us_ptr1+1
	;
	;jsr PLAYER_FREQ_INIT
	;jsr digi_init
	asl $FF09
	;
	;lda #get_wasted & 255
	;sta $FFFC
	;lda #get_wasted >> 8
	;sta $FFFD
	;
	lda #irq & 255
	sta $FFFE
	lda #irq >> 8
	sta $FFFF
	;
	cli
	;
	; ---
	;
main	lda #$DC 				; main loop
	cmp $FF1D
	bne *-3
	;
	lda #$7F
	sta $FD30
	sta $FF08
	lda $FF08
	and #$10				; Query keyboard for "Space"
	bne not_pressed
	;
	;jmp get_wasted
	;
not_pressed
	;
	;dec $FF19
	;
	lda $FF12				; switch to next page
	eor #(BITMAP_SOURCE ^ BITMAP_COPY1) >> 10
	sta $FF12
	;
i1	ldy #$00
	ldx #$00
i2	jsr move_text1
	iny
	inx
	cpx #$08
	bne i2
	;
	inc i1+1			; scroll!
	lda i2+2
	eor #(move_text1 >> 8)^(move_text2 >> 8)	; change JSR
	sta i2+2
	;
cnt8	lda #$00
	bne no_write_letters
	;
	;inc $FF19
	jsr write_letters		; call on every 8th instance
	;dec $FF19
	;
	lda #$08
no_write_letters
	sec
	sbc #$01
	sta cnt8+1
	; 
	;inc $FF19
	;
	jmp main
	
irq	asl $FF09
	rti
	
write_letters
	ldx #$00
lc0	txa
	pha
	;
	asl a
	clc
	adc #scroll_data >> 8
	sta lcptr1+2
	clc
	adc #$01
	sta lcptr2+2
	;
txt_ptr	lda upscroll_text,x		; get letter
	tax
	;
	clc
	adc #$08
	sta lcx+1		; +8 is end of loop check
	;
	ldy i1+1
	tya
	sec
	sbc #($100-UPSCROLL_ROWS*8)	; position it to "bottom" of scrolling text
	tay
	;
lc1	lda chars,x		; copy letter into scroll data
lcptr1	sta $0000,y
lcptr2	sta $0000,y
	iny
	inx
lcx	cpx #$00
	bne lc1
	;
	pla
	tax
	inx
	cpx #UPSCROLL_COLS
	bne lc0
	;
	lda txt_ptr+1
	sta txt_pt2+1
	lda txt_ptr+2
	sta txt_pt2+2
	;
	ldy #UPSCROLL_COLS
txt_pt2	lda upscroll_text,y
	cmp #$FF
	beq e1
	;
	lda txt_ptr+1		; move text pointer ahead
	clc
	adc #UPSCROLL_COLS
	sta txt_ptr+1
	bcc *+5
	inc txt_ptr+2
	;
e1	rts
	
	;
	; -----------
	; fills a section of the memory with the same byte
	;
	; A = byte to fill
	; X = pages       
	; Y = high byte of address
	;
	; on exit: Y=$00, X=$FF
	;
fill3	ldx #$03	; common entry: fill 4 pages
fill	sty us_ptr+1
	ldy #$00
	sty us_ptr
	;	
	; enter from this point to continue fill from last place
	;
fillc	sta (us_ptr),y	; unroll the loop a bit to gain speed
	iny
	sta (us_ptr),y
	iny
	sta (us_ptr),y
	iny
	sta (us_ptr),y
	iny
	;
	sta (us_ptr),y
	iny
	sta (us_ptr),y
	iny
	sta (us_ptr),y
	iny
	sta (us_ptr),y
	iny
	;
	bne fillc
	inc us_ptr+1
	dex
	bpl fillc
	;
	rts

copy_line
	ldx #$00
	cpx #$00
	beq copy_empty_line
	cpx #$09
	beq copy_empty_line
	cpx #$0A
	beq gw6
	;
	; --- copy line from bitmap
	;
	ldy #$00
gw1	lda (us_ptr),y
	sta (us_dest_ptr),y
	iny
	bne gw1
	;
	inc us_ptr+1
	inc us_dest_ptr+1
	;
	ldy #$3F
gw2	lda (us_ptr),y
	sta (us_dest_ptr),y
	dey
	bpl gw2
	;
	adcw us_ptr, $40
	adcw us_dest_ptr, $40
	;
	jmp copy_colors
	
copy_empty_line
	ldy #$00
	lda #$FF
gw4	sta (us_dest_ptr),y
	iny
	bne gw4
	;
	inc us_dest_ptr+1
	;
	ldy #$3F
gw5	sta (us_dest_ptr),y
	dey
	bpl gw5
	;
	adcw us_dest_ptr, $40
	;
copy_colors
	ldy #39
gw3	lda #$25
	sta (us_ptr1),y
	lda #$22
	sta (us_ptr2),y
	dey
	bpl gw3
	;
	adcw us_ptr1, 40
	adcw us_ptr2, 40
	;
	inc copy_line+1
	;
	;lda bottom+1				; ?
	;clc
	;adc #$08
	;sta bottom+1
	;
gw6	rts

code_gen
	lda #$00
cg3	pha
	;
	asl a
	asl a
	asl a
	clc
	adc #gfx_offset & 255
	sta us_ptr1
	lda #gfx_offset >> 8
	adc #$00
	sta us_ptr1+1
	;
	lda #$00
	sta us_ptr2
	pla
	pha
	asl a
	clc
	adc #scroll_data >> 8
	sta us_ptr2+1
	;
	lda #$00
cg2	pha
	;
	lda #$BD				; LDA $0000,X opcode
	jsr put_byte
	lda us_ptr1
	jsr put_byte
	lda us_ptr1+1
	jsr put_byte
	;
	lda #$19				; ORA $0000,Y opcode
	jsr put_byte
	lda us_ptr2
	jsr put_byte
	lda us_ptr2+1
	jsr put_byte
	;
	lda #$9D				; STA $0000,X opcode
	jsr put_byte
	lda us_ptr1
	jsr put_byte
	lda us_ptr1+1
	and #$1F
cg_offs	ora #$00
	jsr put_byte
	;
	;--
	lda us_ptr1
	clc
	adc #$40
	sta us_ptr1
	lda us_ptr1+1
	adc #$01
	sta us_ptr1+1
	;
	lda us_ptr2
	clc
	adc #$08
	sta us_ptr2
	;
	pla
	clc
	adc #$01
	cmp #UPSCROLL_ROWS		; UPSCROLL_ROWS
	bne cg2
	;
	pla
	clc
	adc #$01
	cmp #UPSCROLL_COLS		; UPSCROLL_COLS
	bne cg3
	;
	lda #$60			; RTS opcode
	;
put_byte
	sta (us_code_dst),y
	inc us_code_dst
	bne *+4
	inc us_code_dst+1
	rts
	
copy_pic
	ldx #$1F
cp	lda (us_ptr1),y
	sta (us_ptr2),y
	iny
	bne cp
	inc us_ptr1+1
	inc us_ptr2+1
	dex
	bpl cp
	rts
	
	align 256
chars	; 256*8 m none
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $FC,$CC,$CC,$FC,$CC,$CC,$CC,$00
	db $FC,$CC,$CC,$F0,$CC,$CC,$FC,$00
	db $FC,$C0,$C0,$C0,$C0,$C0,$FC,$00
	db $F0,$CC,$CC,$CC,$CC,$CC,$F0,$00
	db $FC,$C0,$C0,$F0,$C0,$C0,$FC,$00
	db $FC,$C0,$C0,$F0,$C0,$C0,$C0,$00
	db $FC,$C0,$C0,$CC,$CC,$CC,$FC,$00
	db $CC,$CC,$CC,$FC,$CC,$CC,$CC,$00
	db $FC,$30,$30,$30,$30,$30,$FC,$00
	db $0C,$0C,$0C,$0C,$0C,$CC,$FC,$00
	db $CC,$CC,$CC,$F0,$CC,$CC,$CC,$00
	db $C0,$C0,$C0,$C0,$C0,$C0,$FC,$00
	db $CC,$FC,$CC,$CC,$CC,$CC,$CC,$00
	db $F0,$CC,$CC,$CC,$CC,$CC,$CC,$00
	db $FC,$CC,$CC,$CC,$CC,$CC,$FC,$00
	db $FC,$CC,$CC,$FC,$C0,$C0,$C0,$00
	db $FC,$CC,$CC,$CC,$CC,$F0,$3C,$00
	db $FC,$CC,$CC,$FC,$F0,$CC,$CC,$00
	db $FC,$C0,$C0,$FC,$0C,$0C,$FC,$00
	db $FC,$30,$30,$30,$30,$30,$30,$00
	db $CC,$CC,$CC,$CC,$CC,$CC,$FC,$00
	db $CC,$CC,$CC,$CC,$CC,$CC,$30,$00
	db $CC,$CC,$CC,$CC,$CC,$FC,$CC,$00
	db $CC,$CC,$CC,$30,$CC,$CC,$CC,$00
	db $CC,$CC,$CC,$30,$30,$30,$30,$00
	db $FC,$0C,$0C,$30,$C0,$C0,$FC,$00
	db $00,$00,$00,$00,$00,$00,$30,$00
	db $00,$00,$00,$00,$00,$00,$30,$C0
	db $00,$30,$30,$00,$30,$30,$00,$00
	db $30,$30,$30,$30,$30,$00,$30,$00
	db $00,$FC,$FC,$FC,$FC,$FC,$00,$00

	cmap " ",$00
	cmap "A",$08
	cmap "B",$10
	cmap "C",$18
	cmap "D",$20
	cmap "E",$28
	cmap "F",$30
	cmap "G",$38
	cmap "H",$40
	cmap "I",$48
	cmap "J",$50
	cmap "K",$58
	cmap "L",$60
	cmap "M",$68
	cmap "N",$70
	cmap "O",$78
	cmap "P",$80
	cmap "Q",$88
	cmap "R",$90
	cmap "S",$98
	cmap "T",$A0
	cmap "U",$A8
	cmap "V",$B0
	cmap "W",$B8
	cmap "X",$C0
	cmap "Y",$C8
	cmap "Z",$D0
	cmap ".",$D8
	cmap ",",$E0
	cmap ":",$E8
	cmap "!",$F0
	cmap "*",$F8
	
	align 256
upscroll_text
	;   -----!!!**!!!-----
	;   012345678901234567
	db "TEST"
	db "******************"
	db "******************"
	db "******************"
	db "******************"
	db "TEST"
	db "******************"
	db "******************"
	db "******************"
	db "******************"
	db "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
	db $FF
	cmap
 
	align $0800
	;include "colors.asm"
	ds $0800
	align $2000
	ds $2000
	;include "the_end_pic_hex.asm"
;eof