timeline_ptr	= $D0
timeline_delay	= $D2

setptr	macro p,addr
	lda #addr & 255
	sta p
	lda #addr >> 8
	sta p+1
	endm
	
pt1	jsr progress_timeline
process_timeline		; *** call this from your IRQ
	lda timeline_delay
	ora timeline_delay+1
	beq pt1
	;
	lda timeline_delay
	sec
	sbc #$01
	sta timeline_delay
	lda timeline_delay+1
	sbc #$00
	sta timeline_delay+1 
timeline_call
	jmp nothing
	
init_timeline			; *** call this one in your init
	setptr timeline_ptr,timeline
	;	
progress_timeline
	ldy #$00		; get 4 bytes from the timeline table
	lda (timeline_ptr),y	; first two bytes: "length" (in frames)
	sta timeline_delay
	iny 
	lda (timeline_ptr),y
	sta timeline_delay+1
	iny
	lda (timeline_ptr),y	; next 2 bytes: function to call
	sta timeline_call+1
	iny 
	lda (timeline_ptr),y
	sta timeline_call+2
	iny
	tya
	clc
	adc timeline_ptr	; advance the pointer
	sta timeline_ptr
	lda timeline_ptr+1
	adc #$00
	sta timeline_ptr+1
	rts

;eof