STANDALONE=0

rv_dst		= $D4
rv_st_addr 	= $D6
rv_col		= $D8
rv_idx		= $D9

colmap		= $1800
bitmap		= $2000		; orig pics, uncompressed here

	if STANDALONE=1
	org $1001-2
	dw  $1001

	dw nextln,0	; second word is line number
	db $9E,"4109",0
nextln	db 0,0
	
	sei
	sta $FF3F
	;
	lda #$00
	sta $FF15
	sta $FF19
	;
	ldx #$CC
	cpx $FF1D
	bne *-3
	;
	lda #$0B			; screen off!
	sta $FF06
	;
	lda #$71
	sta $FF16
	;
	lda $FF07			; PAL/NTSC friendly
	and #$40
	ora #$18			; use $18 for multicolor
	sta $FF07
	;
	lda $FF12
	and #$03			; keep lowest 2 bits (sound)	
	ora #(bitmap) >> 10		; $08 = $2000, $10 = $4000, etc.
	sta $FF12
	;
	lda #colmap >> 8		; set color map
	sta $FF14
	;
	sta rv_dst+1			; pointer to color map
	ldy #$00
	sty rv_dst
	;
	ldx #$03
	lda #$35
l11	sta (rv_dst),y
	iny
	bne l11
	inc rv_dst+1
	dex
	bpl l11
	;
	ldx #$03
	lda #$82
l12	sta (rv_dst),y
	iny
	bne l12
	inc rv_dst+1
	dex
	bpl l12
	;
	; --
	lda #bitmap >> 8
	sta rv_dst+1
	ldx #$1F
	lda #$C9
l13	sta (rv_dst),y
	iny
	bne l13
	inc rv_dst+1
	dex
	bpl l13
	;
	; ---
	;
	lda #$F0			; get ready... sync to $F0
	cmp $FF1D
	bne *-3
	;
	lda #$CC
	sta $FF0B
	;
	ldx #irq1 & 255
	ldy #irq1 >> 8
	stx $FFFE
	sty $FFFF
	;
	asl $FF09
	;
	cli
	;
	lda #$00
	sta rv_idx			; reset reveal index
	;
	lda #$3B			; open the screen
	sta $FF06
	;
	jmp *
	endif
	
	if STANDALONE=1
	;align 256
irq1	pha
	txa
	pha
	tya
	pha
	endif
	;
rv_call	;dec $FF19
	;
	lda #0				; bitmap address
	sta rv_st_addr
	lda #bitmap >> 8
	sta rv_st_addr+1
	;
	; ---
	;
	lda #0				; column loop (start index)
rv_l0	sta rv_col
	;
	clc
	adc rv_idx
	tax
	;
	lda rv_addr_lo,x
	and #$F8
	clc
	adc rv_st_addr
	sta rv_dst
	;
	lda rv_addr_hi,x
	adc rv_st_addr+1
	sta rv_dst+1
	;
	bmi rv_skip
	;
	lda rv_addr_lo,x
	and #$07
	tay
	;
	lda rv_copy_heights,x			; height of area to clear
	tax
	;
	cpy #$05
	bcs rv_l2
	;
	; ---
	;
	lda #$00
rv_l1	sta (rv_dst),y				; short loop - doesn't wrap
	iny
	dex
	bpl rv_l1
	bmi rv_skip
	;
	; ---
	;
rv_l2	lda #$00
rv_l3	sta (rv_dst),y
	;
	iny
	cpy #$08				; over character boundary?
	bne rv_l4
	;
	lda rv_dst				; add $140 (320)
	clc
	adc #$40
	sta rv_dst
	lda rv_dst+1
	adc #$01
	sta rv_dst+1
	;
	cmp #$40
	beq rv_skip
	;
	ldy #$00
	lda #$00
	;	
rv_l4	dex
	bpl rv_l3
	;
rv_skip	lda rv_st_addr
	clc
	adc #$08
	sta rv_st_addr
	bcc *+4
	inc rv_st_addr+1
	;
	lda rv_col				; rv_column loop end
	clc
	adc #$01
	cmp #40					; end index (40 columns)
	bne rv_l0
	;
	; ---
	;
	ldx rv_idx
	cpx #(rv_addr_lo_end-rv_addr_lo)-41
	bne rv_not_done
	;
	db $24
rv_not_done
	inx
	stx rv_idx
	;
	; ---
	;
	;inc $FF19
	;
	if STANDALONE=1
	asl $FF09
	pla
	tay
	pla
	tax
	pla
	rti
	else
	rts
	endif
	
rv_copy_heights
	db 0,0,0,0,0, 0,0,0,0,0
	db 0,0,0,0,0, 0,0,0,0,0
	db 0,0,0,0,0, 0,0,0,0,0
	db 0,0,0,0,0, 0,0,0,0,0
	db 0
	
	db $04,$04,$04,$04,$04, $03,$04,$04,$03,$03
	db $03,$03,$03,$02,$02, $03,$01,$02,$02,$01
	db $01,$01,$00,$01,$00, $00,$00,$00,$00,$00
	db $00,$00,$00,$00,$00, $00,$00,$00,$00,$00
	db $00,$00,$00,$00,$00, $00,$00,$00,$00,$00
	db $01,$01,$00,$02,$01, $01,$02,$01,$02,$02
	db $02,$02,$03,$02,$03, $02,$03,$02,$03,$02
	db $03,$02,$03,$02,$02, $02,$02,$02,$01,$02
	db $01,$01,$00,$01,$00, $00,$00,$00
	
	db 0,0,0,0,0, 0,0,0,0,0
	db 0,0,0,0,0, 0,0,0,0,0
	db 0,0,0,0,0, 0,0,0,0,0
	db 0,0,0,0,0, 0,0,0,0,0
	
rv_addr_lo
	db $80,$80,$80,$80,$80, $80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80, $80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80, $80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80, $80,$80,$80,$80,$80
	;
	db (($C7 & $F8) * 40) & 255 | $C7 & 7
	db (($C2 & $F8) * 40) & 255 | $C2 & 7
	db (($BD & $F8) * 40) & 255 | $BD & 7
	db (($B8 & $F8) * 40) & 255 | $B8 & 7
	db (($B3 & $F8) * 40) & 255 | $B3 & 7
	db (($AE & $F8) * 40) & 255 | $AE & 7
	db (($AA & $F8) * 40) & 255 | $AA & 7
	db (($A5 & $F8) * 40) & 255 | $A5 & 7
	db (($A0 & $F8) * 40) & 255 | $A0 & 7
	db (($9C & $F8) * 40) & 255 | $9C & 7
	db (($98 & $F8) * 40) & 255 | $98 & 7
	db (($94 & $F8) * 40) & 255 | $94 & 7
	db (($90 & $F8) * 40) & 255 | $90 & 7
	db (($8C & $F8) * 40) & 255 | $8C & 7
	db (($89 & $F8) * 40) & 255 | $89 & 7
	db (($86 & $F8) * 40) & 255 | $86 & 7
	db (($82 & $F8) * 40) & 255 | $82 & 7
	db (($80 & $F8) * 40) & 255 | $80 & 7
	db (($7D & $F8) * 40) & 255 | $7D & 7
	db (($7A & $F8) * 40) & 255 | $7A & 7
	db (($78 & $F8) * 40) & 255 | $78 & 7
	db (($76 & $F8) * 40) & 255 | $76 & 7
	db (($74 & $F8) * 40) & 255 | $74 & 7
	db (($73 & $F8) * 40) & 255 | $73 & 7
	db (($71 & $F8) * 40) & 255 | $71 & 7
	db (($70 & $F8) * 40) & 255 | $70 & 7
	db (($6F & $F8) * 40) & 255 | $6F & 7
	db (($6E & $F8) * 40) & 255 | $6E & 7
	db (($6D & $F8) * 40) & 255 | $6D & 7
	db (($6D & $F8) * 40) & 255 | $6D & 7
	db (($6C & $F8) * 40) & 255 | $6C & 7
	db (($6C & $F8) * 40) & 255 | $6C & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6B & $F8) * 40) & 255 | $6B & 7
	db (($6A & $F8) * 40) & 255 | $6A & 7
	db (($6A & $F8) * 40) & 255 | $6A & 7
	db (($6A & $F8) * 40) & 255 | $6A & 7
	db (($6A & $F8) * 40) & 255 | $6A & 7
	db (($69 & $F8) * 40) & 255 | $69 & 7
	db (($69 & $F8) * 40) & 255 | $69 & 7
	db (($68 & $F8) * 40) & 255 | $68 & 7
	db (($67 & $F8) * 40) & 255 | $67 & 7
	db (($66 & $F8) * 40) & 255 | $66 & 7
	db (($65 & $F8) * 40) & 255 | $65 & 7
	db (($64 & $F8) * 40) & 255 | $64 & 7
	db (($63 & $F8) * 40) & 255 | $63 & 7
	db (($61 & $F8) * 40) & 255 | $61 & 7
	db (($5F & $F8) * 40) & 255 | $5F & 7
	db (($5E & $F8) * 40) & 255 | $5E & 7
	db (($5B & $F8) * 40) & 255 | $5B & 7
	db (($59 & $F8) * 40) & 255 | $59 & 7
	db (($57 & $F8) * 40) & 255 | $57 & 7
	db (($54 & $F8) * 40) & 255 | $54 & 7
	db (($52 & $F8) * 40) & 255 | $52 & 7
	db (($4F & $F8) * 40) & 255 | $4F & 7
	db (($4C & $F8) * 40) & 255 | $4C & 7
	db (($49 & $F8) * 40) & 255 | $49 & 7
	db (($46 & $F8) * 40) & 255 | $46 & 7
	db (($42 & $F8) * 40) & 255 | $42 & 7
	db (($3F & $F8) * 40) & 255 | $3F & 7
	db (($3B & $F8) * 40) & 255 | $3B & 7
	db (($38 & $F8) * 40) & 255 | $38 & 7
	db (($34 & $F8) * 40) & 255 | $34 & 7
	db (($31 & $F8) * 40) & 255 | $31 & 7
	db (($2D & $F8) * 40) & 255 | $2D & 7
	db (($2A & $F8) * 40) & 255 | $2A & 7
	db (($26 & $F8) * 40) & 255 | $26 & 7
	db (($23 & $F8) * 40) & 255 | $23 & 7
	db (($1F & $F8) * 40) & 255 | $1F & 7
	db (($1C & $F8) * 40) & 255 | $1C & 7
	db (($19 & $F8) * 40) & 255 | $19 & 7
	db (($16 & $F8) * 40) & 255 | $16 & 7
	db (($13 & $F8) * 40) & 255 | $13 & 7
	db (($10 & $F8) * 40) & 255 | $10 & 7
	db (($0E & $F8) * 40) & 255 | $0E & 7
	db (($0B & $F8) * 40) & 255 | $0B & 7
	db (($09 & $F8) * 40) & 255 | $09 & 7
	db (($07 & $F8) * 40) & 255 | $07 & 7
	db (($06 & $F8) * 40) & 255 | $06 & 7
	db (($04 & $F8) * 40) & 255 | $04 & 7
	db (($03 & $F8) * 40) & 255 | $03 & 7
	db (($02 & $F8) * 40) & 255 | $02 & 7
	db (($01 & $F8) * 40) & 255 | $01 & 7
	db (($00 & $F8) * 40) & 255 | $00 & 7
	;
rv_addr_hi
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
rv_addr_lo_end
	
	db (($C7 & $F8) * 40) >> 8
	db (($C2 & $F8) * 40) >> 8
	db (($BD & $F8) * 40) >> 8
	db (($B8 & $F8) * 40) >> 8
	db (($B3 & $F8) * 40) >> 8
	db (($AE & $F8) * 40) >> 8
	db (($AA & $F8) * 40) >> 8
	db (($A5 & $F8) * 40) >> 8
	db (($A0 & $F8) * 40) >> 8
	db (($9C & $F8) * 40) >> 8
	db (($98 & $F8) * 40) >> 8
	db (($94 & $F8) * 40) >> 8
	db (($90 & $F8) * 40) >> 8
	db (($8C & $F8) * 40) >> 8
	db (($89 & $F8) * 40) >> 8
	db (($86 & $F8) * 40) >> 8
	db (($82 & $F8) * 40) >> 8
	db (($80 & $F8) * 40) >> 8
	db (($7D & $F8) * 40) >> 8
	db (($7A & $F8) * 40) >> 8
	db (($78 & $F8) * 40) >> 8
	db (($76 & $F8) * 40) >> 8
	db (($74 & $F8) * 40) >> 8
	db (($73 & $F8) * 40) >> 8
	db (($71 & $F8) * 40) >> 8
	db (($70 & $F8) * 40) >> 8
	db (($6F & $F8) * 40) >> 8
	db (($6E & $F8) * 40) >> 8
	db (($6D & $F8) * 40) >> 8
	db (($6D & $F8) * 40) >> 8
	db (($6C & $F8) * 40) >> 8
	db (($6C & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6B & $F8) * 40) >> 8
	db (($6A & $F8) * 40) >> 8
	db (($6A & $F8) * 40) >> 8
	db (($6A & $F8) * 40) >> 8
	db (($6A & $F8) * 40) >> 8
	db (($69 & $F8) * 40) >> 8
	db (($69 & $F8) * 40) >> 8
	db (($68 & $F8) * 40) >> 8
	db (($67 & $F8) * 40) >> 8
	db (($66 & $F8) * 40) >> 8
	db (($65 & $F8) * 40) >> 8
	db (($64 & $F8) * 40) >> 8
	db (($63 & $F8) * 40) >> 8
	db (($61 & $F8) * 40) >> 8
	db (($5F & $F8) * 40) >> 8
	db (($5E & $F8) * 40) >> 8
	db (($5B & $F8) * 40) >> 8
	db (($59 & $F8) * 40) >> 8
	db (($57 & $F8) * 40) >> 8
	db (($54 & $F8) * 40) >> 8
	db (($52 & $F8) * 40) >> 8
	db (($4F & $F8) * 40) >> 8
	db (($4C & $F8) * 40) >> 8
	db (($49 & $F8) * 40) >> 8
	db (($46 & $F8) * 40) >> 8
	db (($42 & $F8) * 40) >> 8
	db (($3F & $F8) * 40) >> 8
	db (($3B & $F8) * 40) >> 8
	db (($38 & $F8) * 40) >> 8
	db (($34 & $F8) * 40) >> 8
	db (($31 & $F8) * 40) >> 8
	db (($2D & $F8) * 40) >> 8
	db (($2A & $F8) * 40) >> 8
	db (($26 & $F8) * 40) >> 8
	db (($23 & $F8) * 40) >> 8
	db (($1F & $F8) * 40) >> 8
	db (($1C & $F8) * 40) >> 8
	db (($19 & $F8) * 40) >> 8
	db (($16 & $F8) * 40) >> 8
	db (($13 & $F8) * 40) >> 8
	db (($10 & $F8) * 40) >> 8
	db (($0E & $F8) * 40) >> 8
	db (($0B & $F8) * 40) >> 8
	db (($09 & $F8) * 40) >> 8
	db (($07 & $F8) * 40) >> 8
	db (($06 & $F8) * 40) >> 8
	db (($04 & $F8) * 40) >> 8
	db (($03 & $F8) * 40) >> 8
	db (($02 & $F8) * 40) >> 8
	db (($01 & $F8) * 40) >> 8
	db (($00 & $F8) * 40) >> 8

	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$80,$80,$80,$80
;eof