SBS_BREAKPOINT = $61

sbs_letter_data_ptr	= $DC
sbs_scrolltext_ptr	= $DE
	
;start
;	sei
;	sta $ff3f
;	;
;	lda #$00
;	sta $FF15 
;	;
;	ldx #$00
;il1	txa
;	sta $0C00,x
;	lda #$71
;	sta $0800,x
;	inx
;	bne il1
;	;
;	lda #irq & 255
;	sta $FFFE
;	lda #irq >> 8
;	sta $FFFF
;	;
;	lda #SBS_BREAKPOINT
;	sta $FF0B
;	;
;	lda #letter_space & 255
;	sta sbs_letter_data_ptr
;	lda #letter_space >> 8
;	sta sbs_letter_data_ptr+1
;	;
;	lda #sbs_scrolltext & 255
;	sta sbs_scrolltext_ptr
;	lda #sbs_scrolltext >> 8
;	sta sbs_scrolltext_ptr+1
;	;
;	cli
;	jmp *
;	;
;$101C  --------

; 1 line white raster
; 1 line black padding
; 9 lines text ( |  . . . | . . . | )
; 1 line black padding
; 1 line white raster = 13 lines total

writeline macro	
	asl $02,x
	sta $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19	; each write is 4 cycles
	cmp $FF19
	cmp $FF19
	cmp $FF19
	cmp $02
	endm

	align 256
irq_sbs	pha
	txa
	pha
	tya
	pha
	;
	lda $FF1E
	cmp #$4E	; highest value (only seems to occur on the real iron)
	beq sah_16	; ahread by 16
	cmp #$4A
	beq sah_12	; ahread by 12
	cmp #$46	; one cycle = HC increases by 4
	beq sah_8	; ahread by 8
	cmp #$42
	beq sah_4	; ahread by 4
	cmp #$3E
	beq sah_0	; lowest value
	;
sah_16	bit $24		; move ahread by 3
sah_12	bit $24		;
sah_8	bit $24		;
sah_4	bit $24		;
sah_0			; always horizontally synced
	;
	ldx #$00
	;
	lda #$CA	; close border
	sta $FF1D
	;
	asl $02,x
	ldy #$FF        
	;
	jsr skip103
	jsr skip103
	nop
	;
sbs_color_1
	lda #$00
	sta $FF19
	;
	jsr skip103
	asl $02,x
	asl $02,x
	asl $02,x
	asl $02,x
	;
sbs_color_2
	lda #$00
	sta $FF19
	;
	jsr skip103
	asl $02
	nop
	;
	asl $02,x
	asl $02,x
	asl $02,x
	asl $02,x
	;
	nop
	;
line1
	writeline
line2
	writeline
line3
	writeline
line4
	writeline
line5
	writeline
line6
	writeline
line7
	writeline
line8
	writeline
line9
	writeline
	;
	sta $FF19
	;
	jsr skip103
	asl $02,x
	asl $02,x
	cmp $02
	nop
	;
sbs_color_3
	lda #$00
	sta $FF19
	;
	jsr skip103
	asl $02,x
	asl $02,x
	asl $02,x
	asl $02,x
	;
	lda #$36	; open border again
	sta $FF1D
	lda #$01
	sta $FF1C
	;
	lda #$00
	sta $FF19
	;
	lda #$04
	cmp $FF1D
	bne *-3
	;
	lda #SBS_BREAKPOINT + 21	; restore proper rasterline
	sta $FF1D
	lda #$02
	sta $FF1F
	lda #$20
	sta $FF14
	;
	; --- do scroll
	;
scroll_value
	lda #$FF
	clc
	adc #$01
	sta scroll_value+1
	and #$03
	tax
	lda shift_values_1,x
	sta line1
	sta line2
	sta line3
	sta line4
	sta line5
	sta line6
	sta line7
	sta line8
	sta line9
	lda shift_values_2,x
	sta line1+(2+25*3)
	sta line2+(2+25*3)
	sta line3+(2+25*3)
	sta line4+(2+25*3)
	sta line5+(2+25*3)
	sta line6+(2+25*3)
	sta line7+(2+25*3)
	sta line8+(2+25*3)
	sta line9+(2+25*3)
	;
	cpx #$00
	beq do_move
	jmp no_move
	;
do_move
	ldx #$05
scroll_byte_move_loop
	lda line1+3,x
	sta line1,x
	lda line2+3,x
	sta line2,x
	lda line3+3,x
	sta line3,x
	lda line4+3,x
	sta line4,x
	lda line5+3,x
	sta line5,x
	lda line6+3,x
	sta line6,x
	lda line7+3,x
	sta line7,x
	lda line8+3,x
	sta line8,x
	lda line9+3,x
	sta line9,x
	inx
	inx
	inx
	cpx #2+24*3
	bne scroll_byte_move_loop
	;
	; ---
	;
	ldy #$00
restart_letter
	lda (sbs_letter_data_ptr),y
	bne no_letter_end
	;
read_next_letter
	lda (sbs_scrolltext_ptr),y
	bpl no_scroll_restart
	;
	lda #sbs_scrolltext & 255
	sta sbs_scrolltext_ptr
	lda #sbs_scrolltext >> 8
	sta sbs_scrolltext_ptr+1
	bne read_next_letter	
	;
no_scroll_restart
	tax
	lda sbs_letter_data_ptrs_lo,x
	sta sbs_letter_data_ptr
	lda sbs_letter_data_ptrs_hi,x
	sta sbs_letter_data_ptr+1
	;
	lda sbs_scrolltext_ptr
	clc
	adc #$01
	sta sbs_scrolltext_ptr
	bcc *+4
	inc sbs_scrolltext_ptr+1
	jmp restart_letter
	;
no_letter_end
	sta line1+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line2+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line3+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line4+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line5+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line6+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line7+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line8+2+24*3
	iny
	lda (sbs_letter_data_ptr),y
	sta line9+2+24*3
	iny
	tya
	clc
	adc sbs_letter_data_ptr
	sta sbs_letter_data_ptr
	bcc *+4
	inc sbs_letter_data_ptr+1
	;
no_move	;
	;
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq	
	;
	asl $FF09
	;
	pla
	tay
	pla
	tax
	pla
	rti
	;
	align 256	
skip103
	cmp $02,x	; 14*6 = 84
	cmp $02,x
	cmp $02,x
	cmp $02,x
	cmp $02,x
	;
	cmp $02,x
	cmp $02,x
	cmp $02,x
	cmp $02,x
	cmp $02,x
	;
	cmp $02,x
	cmp $02,x
	cmp $02,x
	cmp $02,x
	cmp $02,x
	;
	asl $02		; +5
	nop		; +2 = 91 (+6 for the JSR + 6 for the RTS = 103)
	rts

	align 256
;timing
;	db $C9	; CMP #$xx - 2 cycles 
;	db $C5	; CMP $xx  - 3 cycles
;	db $D5	; CMP $xx,x- 4 cycles
;	db $06	; ASL $xx  - 5 cycles
;	db $16	; ASL $xx,x- 6 cycles
	
shift_values_1
	db $16
	db $06
	db $D5
	db $C5
shift_values_2
	db $C5
	db $D5
	db $06
	db $16
	
;scroll_letter_data
;	db $8C,$8D,$8E,$CD

sbs_scrolltext
	cmap " ",0
	cmap "A",1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26
	cmap "4",27
	cmap "6",28
	cmap ".",29
	cmap "!",30
	cmap "?",31
	cmap "-",32
	cmap "=",33
	db "          "
	db "SO MANY SMART PEOPLE - HOW COME NOBODY TRIED TO CONVERT THIS GAME FROM C=64?"
	db "          "
	db "THERE MUST BE A REASON... "
	db "          "
	db "          "
	db "          "
	db $FF
	
sbs_letter_data_ptrs_lo
	db letter_space & 255
	db letter_a & 255
	db letter_b & 255
	db letter_c & 255
	db letter_d & 255
	db letter_e & 255
	db letter_f & 255
	db letter_g & 255
	db letter_h & 255
	db letter_i & 255
	db letter_j & 255
	db letter_k & 255
	db letter_l & 255
	db letter_m & 255
	db letter_n & 255
	db letter_o & 255
	db letter_p & 255
	db letter_q & 255
	db letter_r & 255
	db letter_s & 255
	db letter_t & 255
	db letter_u & 255
	db letter_v & 255
	db letter_w & 255
	db letter_x & 255
	db letter_y & 255
	db letter_z & 255
	db number_4 & 255
	db number_6 & 255
	db letter_dot & 255
	db letter_exclamation_mark & 255
	db letter_question_mark & 255
	db letter_dash & 255
	db letter_equals & 255
	
sbs_letter_data_ptrs_hi
	db letter_space >> 8
	db letter_a >> 8
	db letter_b >> 8
	db letter_c >> 8
	db letter_d >> 8
	db letter_e >> 8
	db letter_f >> 8
	db letter_g >> 8
	db letter_h >> 8
	db letter_i >> 8
	db letter_j >> 8
	db letter_k >> 8
	db letter_l >> 8
	db letter_m >> 8
	db letter_n >> 8
	db letter_o >> 8
	db letter_p >> 8
	db letter_q >> 8
	db letter_r >> 8
	db letter_s >> 8
	db letter_t >> 8
	db letter_u >> 8
	db letter_v >> 8
	db letter_w >> 8
	db letter_x >> 8
	db letter_y >> 8
	db letter_z >> 8
	db number_4 >> 8
	db number_6 >> 8
	db letter_dot >> 8
	db letter_exclamation_mark >> 8
	db letter_question_mark >> 8
	db letter_dash >> 8
	db letter_equals >> 8
	
h = $8C
d = $8D
s = $CD

letter_space
	db s,s,s,s,s,s,s,s,s
	db 0	
letter_a
	db h,d,d,d,h,d,d,d,d
	db d,d,d,d,d,d,d,d,d
	db 0
letter_b
	db d,d,d,d,h,d,d,d,h
	db s,s,s,s,d,d,d,d,d
	db 0
letter_c
	db h,d,d,d,d,d,d,d,h
	db d,d,s,s,s,s,s,d,d
	db 0
letter_d
	db s,s,s,s,h,d,d,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_e
	db h,d,d,d,h,d,d,d,h
	db d,d,s,s,d,s,s,d,d
	db 0
letter_f
	db h,d,d,d,h,d,d,d,d
	db d,d,s,s,d,s,s,s,s
	db 0
letter_g
	db h,d,d,d,d,d,d,d,h
	db d,d,s,s,d,d,d,d,d
	db 0
letter_h
	db d,d,d,d,h,d,d,d,d
	db d,d,d,d,d,d,d,d,d
	db 0
letter_i
	db d,d,d,d,d,d,d,d,d
	db 0
letter_j
	db s,s,s,s,s,s,s,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_k
	db d,d,d,d,h,d,d,d,d
	db d,d,d,s,d,s,d,d,d
	db 0
letter_l
	db d,d,d,d,d,d,d,d,h
	db s,s,s,s,s,s,s,d,d
	db 0
letter_m
	db h,d,d,d,d,d,d,d,d
	db h,d,d,d,d,d,d,d,d
	db d,d,d,d,d,d,d,d,d
	db 0
letter_n
	db h,d,d,d,d,d,d,d,d
	db d,d,d,d,d,d,d,d,d
	db 0
letter_o
	db h,d,d,d,d,d,d,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_p
	db h,d,d,d,h,d,d,d,d
	db d,d,d,d,d,s,s,s,s
	db 0
letter_q
	db h,d,d,d,d,d,d,h,s
	db d,d,d,d,d,d,d,d,d
	db 0
letter_r
	db h,d,d,d,d,d,d,d,d
	db d,d,s,s,s,s,s,s,s
	db 0
letter_s
	db h,d,d,d,h,s,s,d,h
	db d,d,s,s,d,d,d,d,d
	db 0
letter_t
	db h,d,s,s,s,s,s,s,s
	db d,d,d,d,d,d,d,d,d
	db 0
letter_u
	db d,d,d,d,d,d,d,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_v
	db d,d,d,d,d,d,d,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_w
	db d,d,d,d,d,d,d,d,h
	db d,d,d,d,d,d,d,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_x
	db d,d,d,s,h,s,d,d,d
	db d,d,d,s,d,s,d,d,d
	db 0
letter_y
	db d,d,d,d,h,s,s,d,h
	db d,d,d,d,d,d,d,d,d
	db 0
letter_z
	db h,d,s,s,h,d,d,d,h
	db d,d,d,d,d,s,s,d,d
	db 0
number_4
	db d,d,d,d,h,s,s,s,s
	db d,d,d,d,d,d,d,d,d
	db 0
number_6
	db h,d,d,d,h,d,d,d,h
	db d,d,s,s,d,d,d,d,d
	db 0
letter_dot
	db s,s,s,s,s,s,s,s,d
	db 0
letter_exclamation_mark
	db d,d,d,d,d,d,d,s,d
	db 0
letter_question_mark
	db h,d,s,s,h,d,d,s,d
	db d,d,d,d,d,s,s,s,s
	db 0
letter_dash
	db s,s,s,s,h,s,s,s,s
	db s,s,s,s,d,s,s,s,s
	db 0
letter_equals
	db s,s,s,h,s,h,s,s,s
	db s,s,s,d,s,d,s,s,s
	db 0
; EOF