;
; LOD Player Version 2
;
F1LO	= $FF0E
F1HI	= $FF12
F2LO	= $FF0F
F2HI	= $FF10

OFF	= $3F
	
; COMMAND BYTES

END_MARK	= $FE
SET_NOTE_ADD	= $FD
FLASH		= $FC
SET_VOLTAB	= $F0
SET_ARP		= $EF
SETINS		= $E0
SETLEN		= $40

; Constants
C0	= base_note + 0
Ci0	= base_note + 1
D0	= base_note + 2
Di0	= base_note + 3
E0	= base_note + 4
F0	= base_note + 5
Fi0	= base_note + 6
G0	= base_note + 7
Gi0	= base_note + 8
A0	= base_note + 9
Ai0	= base_note + 10
B0	= base_note + 11

C1	= base_note + 12
Ci1	= base_note + 13
D1	= base_note + 14
Di1	= base_note + 15
E1	= base_note + 16
F1	= base_note + 17
Fi1	= base_note + 18
G1	= base_note + 19
Gi1	= base_note + 20
A1	= base_note + 21
Ai1	= base_note + 22
B1	= base_note + 23

C2	= base_note + 24
Ci2	= base_note + 25
D2	= base_note + 26
Di2	= base_note + 27
E2	= base_note + 28
F2	= base_note + 29
Fi2	= base_note + 30
G2	= base_note + 31
Gi2	= base_note + 32
A2	= base_note + 33
Ai2	= base_note + 34
B2	= base_note + 35

C3	= base_note + 36
Ci3	= base_note + 37
D3	= base_note + 38
Di3	= base_note + 39
E3	= base_note + 40
F3	= base_note + 41
Fi3	= base_note + 42
G3	= base_note + 43
Gi3	= base_note + 44
A3	= base_note + 45
Ai3	= base_note + 46
B3	= base_note + 47

C4	= base_note + 48
Ci4	= base_note + 49
D4	= base_note + 50
Di4	= base_note + 51
E4	= base_note + 52
F4	= base_note + 53
Fi4	= base_note + 54
G4	= base_note + 55
Gi4	= base_note + 56
A4	= base_note + 57
Ai4	= base_note + 58
B4	= base_note + 59

C5	= base_note + 60
Ci5	= base_note + 61
D5	= base_note + 62

;-----
          
	jmp PLAYER_INIT
PLAYER_CALL
	jmp PLAYER

PLAYER_INIT
	;         
	; *** Freq init
	;
	ldx #(Channel1) & 255
	ldy #(Channel1) >> 8
	stx PCH1_LO
	sty PCH1_HI
	;
	ldx #(Channel2) & 255
	ldy #(Channel2) >> 8
	stx PCH2_LO
	sty PCH2_HI
	;
	ldx #$FF
	stx VOLTAB_CNT
	stx FRAME_CNT
	inx       
	stx NOTE1
	stx NOTE2
	stx VOLUME
	stx note_add+1
	jsr res2
	inx
	stx NOTELEN1
	stx NOTELEN2
	jmp res2

res	txa
	bne res3
	;
	lda #(Channel1_Restart) & 255
	ldy #(Channel1_Restart) >> 8
	sta PCH1_LO
	sty PCH1_HI
	bne res2
	;
res3	lda #(Channel2_Restart) & 255
	ldy #(Channel2_Restart) >> 8
	sta PCH2_LO
	sty PCH2_HI
	;
res2	ldy #$00
	db $2C
	;	
advance	ldy PCH1,x
	;      
	lda PCH1_LO,x
	sta PCH_TEMP
	lda PCH1_HI,x
	sta PCH_TEMP+1
	;
	lda (PCH_TEMP),y	; LO byte
	sta CH1_LO,x
	iny
	lda (PCH_TEMP),y	; HI byte
	beq res
	sta CH1_HI,x
	iny
	sty PCH1,x
ret1	rts
	
	;
	;##################
	;

PLAYER
;	lda $FF19
;	pha
;border_color
;	lda #$32
;	sta $FF19
;	eor #($32 ^ $77)
;	sta border_color+1
;	jsr PLAYER_
;	pla
;	sta $FF19
;	rts
;PLAYER_
	lda $FF07
	and #$40
	beq pal
	;
	ldx FRAME_CNT
	inx
	cpx #12			; count to 12 (6 frames * 2 calls)
	bne *+4
	ldx #$00
	stx FRAME_CNT
	cpx #10			; on NTSC, the last two calls (1 frame) do nothing
	bcs ret1
pal	;
	ldx #$01
channel_loop
	inc NOTE1,x
	;
	lda NOTE1,x
	cmp NOTELEN1,x
	beq next_note
	jmp channel_loop_end
	;
next_note 
	lda CH1_LO,x
	sta CH_TEMP
	lda CH1_HI,x
	sta CH_TEMP+1
	;
	ldy #$00
	sty NOTE1,x		; reset note counter
	;   
	lda (CH_TEMP),y		; get byte
	iny
	;
	cmp #END_MARK		; $FF goes to new pattern
	bne pl_10
	;
	jsr advance
	bne next_note		; should never be zero
	;
pl_10	
	cmp #SET_NOTE_ADD
	bne pl_16
	;
	lda (CH_TEMP),y
	sta note_add+1
	iny
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_16
	cmp #FLASH
	bne pl_18
	;
	inc $FF19
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_18	
	cmp #SET_VOLTAB
	bcc pl_12
	;
	sty pl_11+1		; save y
	and #$0F
	tay
	lda voltab_lo,y
	sta VOL_TAB+1
	lda voltab_hi,y
	sta VOL_TAB+2
	;
	lda #$FF
	sta VOLTAB_CNT
	;
pl_11	ldy #$00
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_12	
	cmp #SET_ARP		; arpeggio set?
	bne pl_13
	;
	lda #$05
	sta INS_TYPE1,x   	; automatically switch to arp instrument
	;
	lda #12
	sta arplen+1
	;
	lda #$FF
	sta ARP_CNT
	;
	lda (CH_TEMP),y		; get arpeggio byte
	lsr a
	lsr a
	lsr a
	lsr a
	sta arpeggio_data+1
	;
	lda (CH_TEMP),y		; get same byte again
	and #$0F
	cmp #$0B
	bne pl_12b
	;
	lda #16
	sta arplen+1
	;
	lda #7
pl_12b	sta arpeggio_data+2
	;
	iny
	;
	lda (CH_TEMP),y		; get byte
	iny
	;
pl_13	
	cmp #SETINS		; instrument change?
	bcc pl_01
	;
	and #$0F		; keep lower 4 bits
	sta INS_TYPE1,x   	; store instrument type
	;
	cmp #$01
	beq pl_15
	cmp #$02
	beq pl_15
	cmp #$03
	beq pl_17
	cmp #$04
	bne pl_14
	;
pl_17	lda #$02
	db $2C
pl_15	lda #$06		; for bassdrum and snare, also set fixed length
	sta NOTELEN1,x
	lda #$00
	beq pl_02
	;
pl_14	lda (CH_TEMP),y		; get byte
	iny
	;
pl_01	cmp #SETLEN		; set note length?
	bcc pl_02
	;
	;SEC			; we know carry is always set
	sbc #$40
	sta NOTELEN1,x
	;
	lda (CH_TEMP),y
	iny
	;
pl_02	; - store note!
	;
	cmp #OFF
	beq pl_03
	clc
note_add
	adc #$00
pl_03	sta TONE1,x
	;
	; --- advance pointer
	;
	tya
	clc
	adc CH1_LO,x
	sta CH1_LO,x
	bcc noi_1
	inc CH1_HI,x
noi_1	;
	;
	; -----------------------------------------------------------------
	;
channel_loop_end
	dex
	bmi pl_50
	jmp channel_loop
	;    
pl_50	
	;
	; --- SOUND PROCESSING
	;
PLAYER_SOUND
	lda #$20
	sta NOISE
	;
	; ---
	;
	ldx #$01		; channel 2
	jsr sound
	;
	sta F1LO_store+1
	sty F1HI_store+1
	;
	
	;
	ldx #$00		; channel 1
	jsr sound
	sta F2LO_store+1
	sty F2HI_store+1
	;
	; ---
	;
	ldy VOLTAB_CNT
	iny
res_v	
VOL_TAB
	lda $FFFF,y
	bpl noi_v		; check for end marker ($80 and higher)
	and #$7F
	tay
	jmp res_v
	;
noi_v	sty VOLTAB_CNT
	clc
	adc VOLUME
	tay
	lda volume_map,y
	ora NOISE
	sta FF11_store+1
	;
	; ---
	;
F1LO_store
	lda #$00
	sta F1LO
	lda F1HI
	and #$FC
F1HI_store
	ora #$00
	sta F1HI
F2LO_store
	lda #$00
	sta F2LO
F2HI_store
	lda #$00
	sta F2HI
	;
	; ---
	;
	lda F1LO
	cmp #$FE
	bne setvol		; not silent
	lda F2LO
	cmp #$FE
	beq sil			; silent: skip setting $FF11 to avoid clicks
	;
setvol	;
FF11_store
	lda #$00
	sta $FF11		; self-mod
	;and #$40
	;beq sil
	;inc $FF19
	;
sil	rts     
	;
inst_table
	dw normal, bassdrum, snare, hihat1, hihat2, arpeggio, vibrato, arpC
	;
sound	lda TONE1,x
	cmp #OFF
	beq lookup
	;
	lda INS_TYPE1,x
	asl a
	tay
	lda inst_table,y
	sta inst_jump+1
	lda inst_table+1,y
	sta inst_jump+2
	;
inst_jump
	jmp $0000
	
	;
	; ---
	;
normal	lda TONE1,x		; normal note
lookup	tax
	lda freqs_lo,x
	ldy freqs_hi,x
	rts
	;
	; ---
	;
;arp5	lda NOTE1,x
;	and #$04
;	beq normal
;	;
;	lda TONE1,x
;	sec
;	sbc #$05
;	bne lookup
	;
arpC	lda NOTE1,x
	and #$02
	beq normal
	;cmp #$04
	;bcc normal
	;cmp #$08
	;bcs normal
	;
	lda TONE1,x
	clc
	adc #$0C
	bne lookup
	;
	; ---
	;
arpeggio
	lda ARP_CNT		; load current arp counter
	clc
	adc #$01
arplen	cmp #12			; auto reset every X frames
	bne *+4
	lda #$00
	sta ARP_CNT
	lsr a			; div
	lsr a
	tay
	lda arpeggio_data,y	; for channel 2 (self-mod)
	clc
	adc TONE1,x
	bne lookup		; always jump
	;
	; ---
	;
vibrato	lda TONE1,x
	cmp #$10
	bcc vib1
	;
	lda NOTE1,x
	and #$0F
	tay
	lda vibrato_data_2,y
	bmi vib_sub1
	bpl vib_add
	;
vib1	lda NOTE1,x
	and #$0F
	tay
	lda vibrato_data_1,y
	bmi vib_sub1
	;
vib_add
	sta vib2+1
	;
	lda TONE1,x
	tax
	ldy freqs_hi,x
	lda freqs_lo,x
	clc
vib2	adc #$01
	bcc *+3
	iny
	rts
	;
vib_sub1
	and #$7F
	;      
	sta vib4+1
	;
	lda TONE1,x
	tax
	ldy freqs_hi,x
	lda freqs_lo,x
	sec
vib4	sbc #$01
	bcs *+3
	dey
	rts
	;
	; ---
	;
hihat1	lda #$40
	sta NOISE
	lda NOTE1,x
	tax
	lda hihat1_freq,x
	ldy #$03
	rts
hihat2	lda #$40
	sta NOISE
	lda NOTE1,x
	tax
	lda hihat2_freq,x
	ldy #$03
	rts
	;
	; ---
	;
snare	
	lda NOTE1,x
	asl a
	tax
	lda snare_data+1,x	; use bits $40 and $20 for noise control
	and #$60
	sta NOISE
	lda snare_data+1,x	; lower 10 bits for freq
	and #$03
	tay
	lda snare_data,x
	rts
	;
	; ---
	;
bassdrum
	lda NOTE1,x
	asl a
	tax
	lda bassdrum_data+1,x	; use bits $40 and $20 for noise control
	and #$60
	sta NOISE
	lda bassdrum_data+1,x	; lower 10 bits for freq
	and #$03
	tay
	lda bassdrum_data,x
	rts

;slidedown
;	txa
;	asl a
;	asl a
;	clc
;	adc NOTE1,x
;	asl a
;	sta sd1+1
;	lda TONE1,x		; normal note
;	tax
;	ldy freqs_hi,x
;	lda freqs_lo,x
;	sec
;sd1	sbc #$00
;	bcs *+3
;	dey
;	rts

vibrato_data_1
	db $00,$01,$02,$03,$03,$03,$02,$01
	db $00,$81,$82,$83,$83,$83,$82,$81
vibrato_data_2
	db $00,$00,$01,$01,$01,$01,$00,$00
	db $00,$00,$81,$81,$81,$81,$00,$00

;[eof]