	org $1001-2
	dw $1001
	
	include "!playerv.asm"
	
	dw $100B
	dw 2021
	db $9E,"4352"
	db 0,0,0
	db 0,0,0
	
	db "TEDMUSIC"
	
	db 0		; ver
	
	dw music_beg-$1001+2	; data offset
	
	dw music_beg	; data address
	
	dw PLAYER_INIT
	
	dw PLAYER
	
	db 1		; songs
	
	db 2		; timing: pal/timer
	
	dw 8867		; timing: 8867
	
	db 0		; flags
	
	ds 26		; reserved
	
	   ;01234567012345670123456701234567
	db "NUR GETRAUMT                    "
	db "CSABO/LOD                       "
	db "2025                            "
	
	db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	db 0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0
	
temp	= $B0	
dest	= $B2
	;
time		= $0D49
max_raster	= time + 47
max_raster_chr	= time + 40
track_info	= $0E17 - 40
regs_info	= $0DC1
volume_info	= $0E82

charput		= $FFD2

PrintTx macro addr
	ldx #$00
	lda addr,x
	beq *+8
	jsr charput
	inx
	bne *-9
	endm

Print16	macro addr
	lda #"$"
	jsr charput
	lda #addr >> 8
	jsr print_byte
	;
	lda #addr & 255
	jsr print_byte
	endm
	
start	
	lda #$93
	jsr charput
	ldx #$00
	lda $1040,x		; title
	jsr charput
	inx
	cpx #32
	bne *-9
	;
	lda #$0D
	jsr charput
	;
	ldx #32
fe1	dex
	lda $105F,x
	cmp #$20
	beq fe1
	;
	ldy #$00
wr2	lda $1060,y
	jsr charput
	iny
	dex
	bpl wr2
	;
	ldx #32
fe2	dex
	lda $1080,x
	cmp #$20
	beq fe2
	;
	ldy #$00
wr3	lda $1080,y
	jsr charput
	iny
	dex
	bpl wr3
	;
	PrintTx txt1
	PrintTx txt2
	Print16 music_beg
        PrintTx txt3
	Print16 music_end
	PrintTx txt4
	;
	sei
	sta $FF3F
	;
	; ---
	;
	lda #$41
	sta $FF19
	lda #$51
	sta $FF15
	;
	; ---
	;
restart_song
	ldy #$00
	sty $FF11
	;
	ldx #$00
delay	inx
	bne delay
	iny
	bne delay
	;
song_index
	lda #$00			; self-mod
	jsr PLAYER_INIT
	;
	lda #$30			; "0"
	sta time
	sta time+1
	sta time+3
	sta time+4
	;
	lda #$00
	sta time+7
	sta max_raster
	sta vol_down+1
	;
	; ----------
	;
main
	lda #$10
	cmp $FF1D
	bne *-3
	;
sync0	lda #$BF			; check keyboard for "cursor right"
	sta $FD30
	sta $FF08
	lda $FF08
	and #$08
	bne sync1
	;
	inc $FF19			; fast forward
	jsr PLAYER
	jsr PLAYER
	jsr inc_timer
	dec $FF19
	;
sync1	lda $FF1D
	cmp #$28
	bcc sync0
	;
;ntsc_counter
;	lda #$FF
;	clc
;	adc #$01
;	cmp #$06
;	bne *+4
;	lda #$00
;	sta ntsc_counter+1
;	cmp #$05
;	beq main
	;
	; ---
	;
	dec $FF19
	lda $FF1D
	sta r_start+1
	;
	jsr PLAYER			; normal call
	;
	inc $FF19
	;
	lda $FF1D
	sec
r_start	sbc #$00
	cmp max_raster
	bcc not_larger
	;
	sta max_raster
	;
	and #$0F
	tax
	lda hex_char,x
	sta max_raster_chr+1
	;
	lda max_raster
	lsr a
	lsr a
	lsr a
	lsr a
	tax
	lda hex_char,x
	sta max_raster_chr
	;
not_larger
	;
vol_down
	lda #$00
	beq no_vol_down
	;
vol_delay
	lda #$00
	clc
	adc #$01
	and #$0F
	sta vol_delay+1
	bne no_vol_down
	;
	lda VOLUME
	clc
	adc #$09
	cmp #21*9
	bne do_vol_down
	;
	ldx #$51
	stx $FF15
	lda #20*9
	;
do_vol_down
	sta VOLUME
no_vol_down
	;
	jsr inc_timer
	jsr dump_volume
	jsr dump_registers
	jsr dump_track_info
	;
	; ---
	;
sync0b	lda #$BF			; check keyboard for "cursor right"
	sta $FD30
	sta $FF08
	lda $FF08
	and #$08
	bne sync1b
	;
	inc $FF19			; fast forward
	jsr PLAYER
	jsr PLAYER
	jsr inc_timer
	dec $FF19
	;
sync1b	lda $FF1D
	cmp #$CC
	bcc sync0b
	;
	dec $FF19
	jsr PLAYER			; 2nd call
	inc $FF19
	;
kdelay	ldy #$00
	beq kcheck
	dey 
	jmp kend
	
kcheck	lda #$7F			; check keyboard for "space"
	sta $FD30
	sta $FF08
	lda $FF08
	cmp #$EF
	bne check_left
	;
	lda #$31
	sta $FF15
	sta vol_down+1
	;
check_left
	lda #$BF			; check keyboard for "left"
	sta $FD30
	sta $FF08
	lda $FF08
	cmp #$FE
	bne check_numbers
	;
	lda song_index+1
	clc
	adc #$01
	cmp #$03
	bne *+4
	lda #$00
	sta song_index+1
	jmp restart_song
	;
check_numbers
;	lda #$7F			; check for "1"
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	cmp #$FE
;	bne *+6
;	;
;	lda #$01
;	sta FX
;	;
;	lda #$7F			; check for "2"
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	cmp #$F7
;	bne *+6
;	;
;	lda #$02
;	sta FX
;	;
;	lda #$FD			; check for "3"
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	cmp #$FE
;	bne *+6
;	;
;	lda #$03
;	sta FX
;	;
;	lda #$FD			; check for "4"
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	cmp #$F7
;	bne *+6
;	;
;	lda #$04
;	sta FX
	;
;	lda #$FB			; check for "5"
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	cmp #$FE
;	bne *+6
;	;
;	lda #$05
;	sta FX
;	;
;	lda #$FB			; check for "6"
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	cmp #$F7
;	bne *+6
;	;
;	lda #$06
;	sta FX
	;
	ldy #$04
kend	sty kdelay+1
	;
	jmp main
	;
	
inc_timer
	lda time+7
	clc
	adc #$01
	cmp #50
	bne inc1
	;
	ldx #$05
inc2	dex 
	cpx #$02
	beq inc2
	lda time,x
	clc
	adc #$01
	cmp time_end,x
	bne inc3
	lda #$30
inc3	sta time,x
	cmp #$30
	beq inc2
	;
	lda #$00
inc1	sta time+7
	;
	rts
time_end
	db $3A,$3A,$3A,$36,$3A
hex_char
	db "0123456789",1,2,3,4,5,6
	
dump_track_info
	lda #track_info & 255
	sta dest
	lda #track_info >> 8
	sta dest+1
	;
	ldx #$00
dt2	stx x_save+1
	lda CH1_LO,x
	sta temp
	lda CH1_HI,x
	sta temp+1
	;
	ldx temp
	jsr write_word
	jsr add_dest_1
	;
	ldy #$00
dt1	lda (temp),y
	jsr write_byte
	jsr add_dest_1
	iny
	cpy #$07			; number of bytes / channel
	bne dt1
	;
	lda #(40-5-7*3)
	jsr add_dest
	;
x_save	ldx #$00
	inx
	cpx #$03			; number of channels
	bne dt2
	;
	rts
	
dump_volume
	ldx #$00
dv1	lda volume_info+0*40+1,x
	sta volume_info+0*40+0,x
	lda volume_info+1*40+1,x
	sta volume_info+1*40+0,x
	lda volume_info+2*40+1,x
	sta volume_info+2*40+0,x
	lda volume_info+3*40+1,x
	sta volume_info+3*40+0,x
	lda volume_info+4*40+1,x
	sta volume_info+4*40+0,x
	lda volume_info+5*40+1,x
	sta volume_info+5*40+0,x
	lda volume_info+6*40+1,x
	sta volume_info+6*40+0,x
	lda volume_info+7*40+1,x
	sta volume_info+7*40+0,x
	lda volume_info+8*40+1,x
	sta volume_info+8*40+0,x
	inx
	cpx #$25
	bne dv1
	;
	lda #volume_info+$25 & 255
	sta vol_ptr+1
	lda #volume_info+$25 >> 8
	sta vol_ptr+2
	;
	ldx #$08
dv4	ldy #$2D
	stx dv2+1
	lda $FF11
	and #$0F
dv2	cmp #$00
	bne dv3
	;
	lda F1LO
	cmp #$FE
	bne dv5
	lda F2LO
	cmp #$FE
	bne dv5
	ldy #$3A
	db $2C
dv5	ldy #$51
dv3	tya
vol_ptr	sta $1000
	;
	lda vol_ptr+1
	clc
	adc #40
	sta vol_ptr+1
	lda vol_ptr+2
	adc #00
	sta vol_ptr+2
	;
	dex
	bpl dv4
	rts

dump_registers
	lda #(regs_info + 0*40 & 255)
	sta dest
	lda #(regs_info + 0*40 >> 8)
	sta dest+1
	;
	ldx $FF0E
	lda $FF12
	and #$03
	jsr write_word
	;
	lda #(regs_info + 1*40 & 255)
	sta dest
	lda #(regs_info + 1*40 >> 8)
	sta dest+1
	;
	ldx $FF0F
	lda $FF10
	and #$03
	jsr write_word
	;
	lda #(regs_info + 2*40 & 255)
	sta dest
	lda #(regs_info + 2*40 >> 8)
	sta dest+1
	;
	lda $FF11
	and #$0F
	jsr write_byte
	;
	lda #(regs_info + 3*40 & 255)
	sta dest
	lda #(regs_info + 3*40 >> 8)
	sta dest+1
	;
	lda $FF11
	and #$40
	jsr write_byte
	;
	;ldx #$26
	;ldy #$0C
	;stx dest
	;sty dest+1
	;lda FX
	;jsr write_byte
	;
	rts	
	;
	; A,X = hex value to print (hi,lo)
	;
write_word
	stx x_sav2+1
	jsr write_byte
x_sav2	lda #$00
	;
	; A = hex value to print
	;
write_byte
	sty y_save+1
	pha
	lsr a
	lsr a
	lsr a
	lsr a
	tax
	lda hex_char,x
	ldy #$00
	sta (dest),y
	pla
	and #$0F
	tax
	lda hex_char,x
	iny
	sta (dest),y
	;
	lda #$02
	jsr add_dest
y_save	ldy #$00
	rts

add_dest_1
	lda #$01
add_dest
	clc
	adc dest
	sta dest
	bcc *+4
	inc dest+1
	rts
	
print_byte
	pha
	lsr a
	lsr a
	lsr a
	lsr a
	jsr print_digit
	;
	pla
	and #$0F
	;
print_digit
	tax
	lda hex_char,x
	cmp #7
	bcs pd1
	clc
	adc #$40
pd1	jmp charput

txt1	
	db $0D,$0D
	;db "PRESS ",$9A,"[1-6]  ",$90," FOR SOUND EFFECTS",$0D
	db $0D
	db "PRESS ",$9A,"[LEFT] ",$90," TO SWITCH SONGS",$0D
	db 0
	
txt2	db "PRESS ",$9A,"[RIGHT]",$90," TO FAST FORWARD",$0D
	db "PRESS ",$9A,"[SPACE]",$90," TO FADE OUT",$0D,$0D
	;
	db "TIME   : 00:00 ( )",$0D
	db "RASTER :       ( )",$0D
	db "MUSIC  : "
	db 0

txt3
	db " - ",0
	
txt4
	;db " ($CEFF)"
	db $0D
	db "FREQ 1 : ",$0D
	db "FREQ 2 : ",$0D
	db "VOLUME : ",$0D
	db "NOISE  : ",$0D,$0D
	;
	db "8:",$0D
	db "7:",$0D
	db "6:",$0D
	db "5:",$0D
	db "4:",$0D
	db "3:",$0D
	db "2:",$0D
	db "1:",$0D
	db "0:"
	db 0
	
	;org $A800
	;align $1000
	align 256
base_note = 0
music_beg
	include "!player.asm"
	include "!player_data.asm"
	include "music.asm"
music_end
;[eof]