	org $1001-2
	dw  $1001
	
	include "music/!playerv.asm"
	
	dw nextln,0	; second word is line number
	db $9E,"4109",0
nextln	db 0,0

MAP_BACKGROUND_COLOR	= $56
LUMMAP			= magazine_gfx
BITMAP			= LUMMAP + $0800
DYCP_FONT		= BITMAP

sine_bit		= $0200
sine_lo			= $0300
sine_hi			= $0400

		; 02-24: music
		; 60-62: jmp main (return point after Exo)
		; 70-7F: chars5x10

c64_map_src	= $A0
map_scroll_x	= $A2
twinkle_ptr	= $A4

ptr		= $B0
src_ptr		= $B2
dst_ptr		= $B4
col_dst		= $B6

small_txt_src	= $B8
big_txt_src	= $BA

txt_2x2_src	= $C0
pen_color	= $C2

area_width	= $C4
area_height	= $C5

fld_tmp		= $C6

names_scroll_x1 = $C7
names_scroll_x2 = $C8
names_colidx	= $C9
names_idx	= $CA
pixel_char	= $CB

dycp_chr_ptr	= $CC
dycp_scroll_x	= $CE

k_index		= $CF
		; timeline  = $D0/$D2
		; sine_wipe = $D4/$D9
		; bigscroll = $DA
		; sbs       = $DC/$DF
	
RL_IRQ_BOTTOM	= $CC

set16	macro zpvar, adr
	lda #adr & 255
	sta zpvar
	lda #adr >> 8
	sta zpvar+1
	endm

add16	macro zpvar, value
	lda zpvar
	clc
	adc value
	sta zpvar
	bcc *+4
	inc zpvar+1
	endm

trigger	macro subroutine
	lda #subroutine & 255
	sta main_program_call+1
	lda #subroutine >> 8
	sta main_program_call+2
	endm

set_irq_a	macro rasterline, addr
	lda #rasterline
	sta $FF0B
	lda #addr & 255
	sta $FFFE
	lda #addr >> 8
	sta $FFFF
	endm

	;
	; one-time init
	;
	sei
	sta $ff3f
	;
	;
	lda #$0B
	sta $FF06
	;
	lda #$4C
	sta $60
	lda #main & 255
	sta $61
	lda #main >> 8
	sta $62
	;
	lda $FF07
	and #$40
	beq pal_01
	;
	ldx #$00
ntsc_01	lda speech_wave,x			; overwrite PAL values
	ora #$40
	sta speech_wave,x
	inx
	bne ntsc_01
	;
	ldx #$10
ntsc_02	lda twinkle_data,x
	ora #$40
	sta twinkle_data,x
	dex
	bpl ntsc_02
	;
	lda #kefrens_bottom_ntsc & 255
	sta kefrens_bottom_call+1
	lda #kefrens_bottom_ntsc >> 8
	sta kefrens_bottom_call+2
	;
pal_01	ldx #$07
	ldy #$08
	lda #$00
	jsr fill
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
	lda $FF12
	and #$03
	sta $FF12
	lda #charset >> 8
	sta $FF13
	;
	lda #$00
	sta $FF15
	lda #$31
	sta $FF16
	lda #$51
	sta $FF17
	;
	jsr set_irq1
	;
	jsr PLAYER_INIT
	;
	jsr init_timeline
	;
	jsr c5_init
	;
	set16 small_txt_src, small_txt
	set16 txt_2x2_src, txt_2x2
	set16 big_txt_src, big_txt
	;
fade_loop
	lda $FF19
	and #$7F
	sec
	sbc #$10
	bpl *+4
	lda #$00
	tay
	;
	ldx #$FF
	lda $FF07
	and #$40
	beq pal1
	ldx #$F8
pal1	cpx $FF1D
	bne *-3
	cpx $FF1D
	beq *-3
	;
	sty $FF19
	tya
	bne fade_loop
	;
	lda #$1B
	sta $FF06
	;
	cli
	;
	jmp main

draw_magazine_border
	ldx #$00
	;
	cpx #$00
	bne dmb_01
	;
	set16 dst_ptr, $0C00 + 1 * 40 + 0
	;
	lda #$B8
	sta $0C00
	;
dmb_01	inc draw_magazine_border+1
	;
	txa
	and #$01
	bne dmb_02
	;
	lda $FF15
	cmp #$F1
	beq dmb_05
	cmp #$80
	bne dmb_04
	lda #$F1
dmb_04	clc
	adc #$10
dmb_05	sta $FF15
	;
dmb_02	ldy #0
	lda #$B4
	sta (dst_ptr),y
	ldy #39
	lda #$B5
	sta (dst_ptr),y
	add16 dst_ptr, #40
	;
	cpx #18
	bne dmb_06
	;
	lda #$B9
	sta $0C27
	;
dmb_06	txa
	asl a
	tax
	cpx #37
	bcs dmb_03
	;
	lda #$B6
	sta $0C00 + 0 * 40 + 1,x
	sta $0C00 + 0 * 40 + 2,x
	lda #$B7
	sta $0C00 + 3 * 40 + 1,x
	sta $0C00 + 3 * 40 + 2,x
	;
dmb_03	rts

write_magazine_entry
	jsr write_small
	;
	ldx #4
	ldy #26
wme_01	lda #$C0				; top/left
	sta (dst_ptr),y
	lda #$32				; red star
	sta (col_dst),y
	iny
	lda #$C1				; top/right
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	tya
	clc
	adc #39
	tay
	lda #$C2
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	iny
	lda #$C3
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	;
	tya
	sec
	sbc #39
	tay
	;
	dex
	bpl wme_01
	;
	rts

fade_magazine_entry_star_1
	lda #$00
	inc fade_magazine_entry_star_1+1
	and #$01
	beq fme_ret
	jsr fade_magazine_entry
	jsr draw_mag_star_1
fme_ret	rts

fade_magazine_entry_star_2
	lda #$00
	inc fade_magazine_entry_star_2+1
	and #$01
	beq fme_ret
	jsr fade_magazine_entry
	jsr draw_mag_star_2
	rts

fade_magazine_entry_star_3
	lda #$00
	inc fade_magazine_entry_star_3+1
	and #$01
	beq fme_ret
	jsr fade_magazine_entry
	jsr draw_mag_star_3
	rts

fade_magazine_entry
	ldy #24
fme_01	lda (col_dst),y
	sec
	sbc #$10
	sta (col_dst),y
	dey
	bpl fme_01
	;
	rts

draw_mag_star_1					; draw "full" star
	ldy #24
dms_11	iny
	iny
	lda (dst_ptr),y
	bne dms_11
	;
	lda #$C0				; top/left
	sta (dst_ptr),y
	lda #$32				; red star
	sta (col_dst),y
	iny
	lda #$C1				; top/right
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	tya
	clc
	adc #39
	tay
	lda #$C2
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	iny
	lda #$C3
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	rts

draw_mag_star_2					; draw a half-full star
	ldy #24
dms_21	iny
	iny
	lda (dst_ptr),y
	bne dms_21
	;
	lda #$C0				; top/left
	sta (dst_ptr),y
	lda #$32				; red star
	sta (col_dst),y
	iny
	lda #$C5				; top/right
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	tya
	clc
	adc #39
	tay
	lda #$C2
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	iny
	lda #$C7
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	rts

draw_mag_star_3					; draw an empty star
	ldy #24
dms_31	iny
	iny
	lda (dst_ptr),y
	bne dms_31
	;
	lda #$C4				; top/left
	sta (dst_ptr),y
	lda #$32				; red star
	sta (col_dst),y
	iny
	lda #$C5				; top/right
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	tya
	clc
	adc #39
	tay
	lda #$C6
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	iny
	lda #$C7
	sta (dst_ptr),y
	lda #$32
	sta (col_dst),y
	rts

scroll_left_and_fade_prep
	lda $0800 + 8 * 40 + 21
	ldx #66
slap_03	sta $0800 + 8 * 40 + 4,x
	dex
	bpl slap_03
	;
	lda $0800 +10 * 40 + 21
	ldx #66
slap_04	sta $0800 +10 * 40 + 4,x
	dex
	bpl slap_04
	;
	lda $0800 +12 * 40 + 21
	ldx #66
slap_05	sta $0800 +12 * 40 + 4,x
	dex
	bpl slap_05
	;
	lda $0800 +14 * 40 + 21
	ldx #66
slap_06	sta $0800 +14 * 40 + 4,x
	dex
	bpl slap_06
	;
	rts

scroll_left_and_fade
	lda $FF07
	and #$07
	beq slaf_01
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
	lda $0800 + 8 * 40 + 21
	sec
	sbc #$10
	bpl *+4
	lda #$00
	ldx #66
slaf_03	sta $0800 + 8 * 40 + 4,x
	dex
	bpl slaf_03
	;
	lda $0800 +10 * 40 + 21
	sec
	sbc #$10
	bpl *+4
	lda #$00
	ldx #66
slaf_04	sta $0800 +10 * 40 + 4,x
	dex
	bpl slaf_04
	;
	lda $0800 +12 * 40 + 21
	sec
	sbc #$10
	bpl *+4
	lda #$00
	ldx #66
slaf_05	sta $0800 +12 * 40 + 4,x
	dex
	bpl slaf_05
	;
	lda $0800 +14 * 40 + 21
	sec
	sbc #$10
	bpl *+4
	lda #$00
	ldx #66
slaf_06	sta $0800 +14 * 40 + 4,x
	dex
	bpl slaf_06
	;
	rts
	;
slaf_01	lda $FF07
	and #$40
	ora #$84
	sta $FF07
	;
	ldx #$00
slaf_02	lda $0C00 + 8 * 40 +  5,x
	sta $0C00 + 8 * 40 +  4,x
	lda $0C00 + 9 * 40 +  5,x
	sta $0C00 + 9 * 40 +  4,x
	lda $0C00 +10 * 40 +  5,x
	sta $0C00 +10 * 40 +  4,x
	lda $0C00 +11 * 40 +  5,x
	sta $0C00 +11 * 40 +  4,x
	lda $0C00 +12 * 40 +  5,x
	sta $0C00 +12 * 40 +  4,x
	lda $0C00 +13 * 40 +  5,x
	sta $0C00 +13 * 40 +  4,x
	lda $0C00 +14 * 40 +  5,x
	sta $0C00 +14 * 40 +  4,x
	lda $0C00 +15 * 40 +  5,x
	sta $0C00 +15 * 40 +  4,x
	inx
	cpx #26
	bne slaf_02
	;
	rts

show_thai_boxing
	trigger thai_unpack
	;
	lda #$0B
	sta $FF06
	;
	lda #($1000) >> 8			; thai charset
	sta $FF13
	;
	lda #$01
	ldx #irq_thai1 & 255
	ldy #irq_thai1 >> 8
	jmp set_irq1_next

mag_reveal_1
	ldx #$00
	lda #$57
	sta $1800 + 0 * 40 + 17,x
	lda #$11
	sta $1C00 + 0 * 40 + 17,x
	;
	cpx #3
	beq mr1_02
	cpx #2
	bne mr1_01
	;
mr1_02	sta $1C00 + 1 * 40 + 17,x
	lda #$57
	sta $1800 + 1 * 40 + 17,x
	;
	lda #$FF
	sta BITMAP + 486
	;
mr1_01	inc mag_reveal_1+1
	rts

mag_reveal_2
	ldx #$00
	lda #$50
	sta $1800 + 1 * 40 + 9,x
	sta $1800 + 2 * 40 + 9,x
	lda #$D1
	sta $1C00 + 1 * 40 + 9,x
	sta $1C00 + 2 * 40 + 9,x
	;
	cpx #2
	bcc mr2_02
	cpx #4
	bcc mr2_03
	;
	cpx #11
	bne mr2_01
	;
	lda #$A5
	sta BITMAP + 486
	bne mr2_01
	;
mr2_03	lda #$21
	sta $1C00 + 2 * 40 + 9,x
	bne mr2_01
	;
mr2_02	sta $1C00 + 0 * 40 + 9,x
	sta $1C00 + 3 * 40 + 9,x
	lda #$50
	sta $1800 + 0 * 40 + 9,x
	sta $1800 + 3 * 40 + 9,x
	;
mr2_01	inc mag_reveal_2+1
	rts

mag_reveal_3
	ldx #$00
	lda #$50
	sta $1800 + 3 * 40 + 13,x
	sta $1800 + 4 * 40 + 13,x
	lda #$D1
	sta $1C00 + 3 * 40 + 13,x
	sta $1C00 + 4 * 40 + 13,x
	;
	cpx #5
	bne mr3_01
	;
	sta $1C00 + 5 * 40 + 13,x
	lda #$50
	sta $1800 + 5 * 40 + 13,x
	;
	lda #$FF
	sta BITMAP + 1750
	;
mr3_01	inc mag_reveal_3+1
	rts

mag_reveal_4
	ldx #$00
	lda #$50
	sta $1800 + 5 * 40 + 10,x
	sta $1800 + 6 * 40 + 10,x
	lda #$D1
	sta $1C00 + 5 * 40 + 10,x
	sta $1C00 + 6 * 40 + 10,x
	;
	cpx #8
	bne mr4_01
	;
	lda #$EF
	sta BITMAP + 1750
	;
mr4_01	inc mag_reveal_4+1
	rts

	include "flamingo_charset.asm"

copy_flamingo_chars
	ldx #$47
cfc_01	lda flamingo_charset,x
	sta charset + $0700,x
	lda flamingo_charset + $48,x
	sta charset + $0748,x
	dex
	bpl cfc_01
	rts

draw_1_flamingo
	ldy #$00
	lda flamingo_pos,y
	sta dst_ptr
	sta col_dst
	lda flamingo_pos + 1,y
	sta dst_ptr+1
	sec					; the normal AND #$FB doesn't work here
	sbc #$04				; because some screen positions are before $0C00
	sta col_dst+1
	lda flamingo_pos + 2,y
	sta d1f_04+1
	;
	lda draw_1_flamingo+1
	clc
	adc #3
	sta draw_1_flamingo+1
	;
	set16 src_ptr, flamingo_charmap
	;
d1f_02	ldy #$04
d1f_04	ldx #$04
d1f_01	cpx #$05
	bcs d1f_03
	lda (src_ptr),y
	sta (dst_ptr),y
	lda #$2B
	sta (col_dst),y
d1f_03	dex
	dey
	bpl d1f_01
	;
	add16 src_ptr, #5
	add16 dst_ptr, #40
	add16 col_dst, #40
	;
	lda src_ptr
	cmp #(flamingo_charmap + 5 * 6) & 255
	bne d1f_02
	;
	rts

flamingo_pos
	dw $0C00 + 18 * 40
	db 4
	dw $0C00 + 12 * 40 - 4
	db 0
	;
	dw $0C00 + 18 * 40 + 8
	db 4
	dw $0C00 + 12 * 40 + 4
	db 4
	dw $0C00 + 6 * 40 + 0
	db 4
	dw $0C00 + 0 * 40 - 4
	db 0
	;
	dw $0C00 + 18 * 40 + 16
	db 4
	dw $0C00 + 12 * 40 + 12
	db 4
	dw $0C00 + 6 * 40 + 8
	db 4
	dw $0C00 + 0 * 40 + 4
	db 4
	;
	dw $0C00 + 18 * 40 + 24
	db 4
	dw $0C00 + 12 * 40 + 20
	db 4
	dw $0C00 + 6 * 40 + 16
	db 4
	dw $0C00 + 0 * 40 + 12
	db 4
	;
	dw $0C00 + 18 * 40 + 32
	db 4
	dw $0C00 + 12 * 40 + 28
	db 4
	dw $0C00 + 6 * 40 + 24
	db 4
	dw $0C00 + 0 * 40 + 20
	db 4
	;
	dw $0C00 + 12 * 40 + 36
	db 5
	dw $0C00 + 6 * 40 + 32
	db 4
	dw $0C00 + 0 * 40 + 28
	db 4
	;
	dw $0C00 + 0 * 40 + 36
	db 5

	org $1800
	include "magazine_gfx.asm"
	
	;
	; *******************************************
	;
	align 256
kefrens_offset
	db $00,$00,$00,$00,$00,$00,$00,$00, $08,$08,$08,$08,$08,$08,$08,$08
	db $10,$10,$10,$10,$10,$10,$10,$10, $18,$18,$18,$18,$18,$18,$18,$18
	db $20,$20,$20,$20,$20,$20,$20,$20, $28,$28,$28,$28,$28,$28,$28,$28
	db $30,$30,$30,$30,$30,$30,$30,$30, $38,$38,$38,$38,$38,$38,$38,$38
	db $40,$40,$40,$40,$40,$40,$40,$40, $48,$48,$48,$48,$48,$48,$48,$48
	db $50,$50,$50,$50,$50,$50,$50,$50, $58,$58,$58,$58,$58,$58,$58,$58
	db $60,$60,$60,$60,$60,$60,$60,$60, $68,$68,$68,$68,$68,$68,$68,$68
	db $70,$70,$70,$70,$70,$70,$70,$70, $78,$78,$78,$78,$78,$78,$78,$78
	db $80,$80,$80,$80,$80,$80,$80,$80, $88,$88,$88,$88,$88,$88,$88,$88
	db $90,$90,$90,$90,$90,$90,$90,$90, $98,$98,$98,$98,$98,$98,$98,$98
	db $A0,$A0,$A0,$A0,$A0,$A0,$A0,$A0, $A8,$A8,$A8,$A8,$A8,$A8,$A8,$A8
	db $B0,$B0,$B0,$B0,$B0,$B0,$B0,$B0, $B8,$B8,$B8,$B8,$B8,$B8,$B8,$B8
	db $C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0, $C8,$C8,$C8,$C8,$C8,$C8,$C8,$C8
	db $D0,$D0,$D0,$D0,$D0,$D0,$D0,$D0, $D8,$D8,$D8,$D8,$D8,$D8,$D8,$D8
	db $E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0, $E8,$E8,$E8,$E8,$E8,$E8,$E8,$E8
	db $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0, $F8,$F8,$F8,$F8,$F8,$F8,$F8,$F8
kefrens_left_and
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
kefrens_left_or
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
kefrens_right_and
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
kefrens_right_or
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9

	align 256
kefrens_sine
	ds 256

	align 256
k_sine1
; 101,70,0,0 
	db $46,$4A,$4F,$53,$57,$5B,$60,$64,$67,$6B,$6F,$72,$76,$79,$7C,$7E
	db $81,$83,$85,$87,$88,$8A,$8B,$8B,$8C,$8C,$8C,$8C,$8B,$8A,$89,$88
	db $86,$84,$82,$80,$7D,$7A,$77,$74,$71,$6D,$69,$65,$62,$5D,$59,$55
	db $51,$4D,$48,$44,$3F,$3B,$37,$33,$2F,$2A,$27,$23,$1F,$1B,$18,$15
	db $12,$0F,$0C,$0A,$08,$06,$04,$03,$02,$01,$00,$00,$00,$00,$01,$01
	db $02,$04,$05,$07,$09,$0B,$0E,$10,$13,$16,$1A,$1D,$21,$25,$28,$2C
	db $31,$35,$39,$3D,$42
	db $46,$4A,$4F,$53,$57,$5B,$60,$64,$67,$6B,$6F,$72,$76,$79,$7C,$7E
	db $81,$83,$85,$87,$88,$8A,$8B,$8B,$8C,$8C,$8C,$8C,$8B,$8A,$89,$88
	db $86,$84,$82,$80,$7D,$7A,$77,$74,$71,$6D,$69,$65,$62,$5D,$59,$55
	db $51,$4D,$48,$44,$3F,$3B,$37,$33,$2F,$2A,$27,$23,$1F,$1B,$18,$15
	db $12,$0F,$0C,$0A,$08,$06,$04,$03,$02,$01,$00,$00,$00,$00,$01,$01
	db $02,$04,$05,$07,$09,$0B,$0E,$10,$13,$16,$1A,$1D,$21,$25,$28,$2C
	db $31,$35,$39,$3D,$42
	db $46,$4A,$4F,$53,$57,$5B,$60,$64,$67,$6B,$6F,$72,$76,$79,$7C,$7E
	db $81,$83,$85,$87,$88,$8A,$8B,$8B,$8C,$8C,$8C,$8C,$8B,$8A,$89,$88
	db $86,$84,$82,$80,$7D,$7A,$77,$74,$71,$6D,$69,$65,$62,$5D,$59,$55
	db $51,$4D,$48,$44,$3F,$3B

	align 256
k_sine2
; 71,50,0,0
	db $32,$36,$3B,$3F,$43,$47,$4B,$4F,$53,$56,$59,$5B,$5E,$60,$61,$63
	db $63,$64,$64,$64,$63,$62,$61,$5F,$5D,$5A,$57,$54,$51,$4D,$49,$45
	db $41,$3D,$39,$34,$30,$2B,$27,$23,$1F,$1B,$17,$13,$10,$0D,$0A,$07
	db $05,$03,$02,$01,$00,$00,$00,$01,$01,$03,$04,$06,$09,$0B,$0E,$11
	db $15,$19,$1D,$21,$25,$29,$2E
	db $32,$36,$3B,$3F,$43,$47,$4B,$4F,$53,$56,$59,$5B,$5E,$60,$61,$63
	db $63,$64,$64,$64,$63,$62,$61,$5F,$5D,$5A,$57,$54,$51,$4D,$49,$45
	db $41,$3D,$39,$34,$30,$2B,$27,$23,$1F,$1B,$17,$13,$10,$0D,$0A,$07
	db $05,$03,$02,$01,$00,$00,$00,$01,$01,$03,$04,$06,$09,$0B,$0E,$11
	db $15,$19,$1D,$21,$25,$29,$2E
	db $32,$36,$3B,$3F,$43,$47,$4B,$4F,$53,$56,$59,$5B,$5E,$60,$61,$63
	db $63,$64,$64,$64,$63,$62,$61,$5F,$5D,$5A,$57,$54,$51,$4D,$49,$45
	db $41,$3D,$39,$34,$30,$2B,$27,$23,$1F,$1B,$17,$13,$10,$0D,$0A,$07
	db $05,$03,$02,$01,$00,$00,$00,$01,$01,$03,$04,$06,$09,$0B,$0E,$11
	db $15,$19,$1D,$21,$25,$29,$2E
	
kef1	macro offs
	ldx k_index				; 3
	lda kefrens_sine+offs,x			; 4
	tay					; 2
	db $BF					; 4 LAX $nnnn,Y
	dw kefrens_offset
	;
	lda charset+$0700+(offs & 7),x		; 4
	and kefrens_left_and,y			; 4
	ora kefrens_left_or,y			; 4
	sta charset+$0700+(offs & 7),x		; 5 = 17
	;
	lda charset+$0708+(offs & 7),x		; 4
	and kefrens_right_and,y			; 4
	ora kefrens_right_or,y			; 4
	sta charset+$0708+(offs & 7),x		; 5 = 17 = 42 total
	endm

	align 256
irq_kefrens
	pha
	txa
	pha
	tya
	pha
	;
	lda $FF1E
	cmp #$4E				; ...
	beq ah16				; ahead by 16
	cmp #$4A
	beq ah12				; ahead by 12
	cmp #$46				; one cycle = HC increases by 4
	beq ah08				; ahead by 8
	cmp #$42
	beq ah04				; ahead by 4
	cmp #$3E
	beq ah00				; lowest value
	;
ah16	bit $24
ah12	bit $24
ah08	bit $24					; add 3 cycles
ah04	bit $24					; each
ah00						; nothing added
	;
	lda #$00
	sta k_index
	;
	; 6 * 63 + 44 = 422 (needed)
	; 8 * 42 - 86 to waste
k_loop	;
	kef1 0
	kef1 1
	kef1 2
	kef1 3
	kef1 4
	kef1 5
	kef1 6
	kef1 7
	;
	asl $02 ; 86
	asl $02
	asl $02
	asl $02
	asl $02
	asl $02
	asl $02
	nop
	nop
	nop
	;
	lda k_index	; 3
	clc		; 2
	adc #$08	; 2
	sta k_index	; 3
	cmp #$80	; 2
	beq k_loop_exit	; not taken - 2
	jmp k_loop	; 3
	;      
k_loop_exit
	lda #RL_IRQ_BOTTOM - $06		; raise bottom IRQ a bit (to make it fit on NTSC)
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

kefrens_screen_setup
	lda #$2C				; BIT $nnnn opcode
	sta black_screen_at_bottom		; disable changing the screen background
	sta reset_ff16_at_bottom		; disable changing $FF16 (from mag)
	;
	trigger kefrens_screen_setup_call
	rts

kefrens_screen_setup_call
	lda #$04
	sta dst_ptr
	lda #$0C
	sta dst_ptr+1
	;
	ldx #24
k_il1	ldy #$00
k_il2	tya
	ora #$E0
	sta (dst_ptr),y
	iny
	cpy #32
	bne k_il2
	;
	add16 dst_ptr, #40
	dex
	bpl k_il1
	;
	rts

kefrens_fade_in
	lda #$00
	tax
	inc kefrens_fade_in+1
	and #$01
	beq kfi_ret
	;
k_fade	txa
	lsr a
	tax
	lda kefrens_fade_in_colors_1,x
	sta k_color+1
	;
	lda kefrens_fade_in_colors_2,x
	sta $FF17
	lda kefrens_fade_in_colors_3,x
	sta $FF16
	;
	trigger kefrens_set_colors
	;
kfi_ret	rts

kefrens_fade_out
	lda #18
	tax
	dec kefrens_fade_out+1
	and #$01
	beq kfi_ret
	bne k_fade

kefrens_set_colors
	;dec $FF19
k_color	lda #$00
	ldx #31
k_il3	sta $0800 + 0 * 40 + 4,x
	sta $0800 + 1 * 40 + 4,x
	sta $0800 + 2 * 40 + 4,x
	sta $0800 + 3 * 40 + 4,x
	sta $0800 + 4 * 40 + 4,x
	sta $0800 + 5 * 40 + 4,x
	sta $0800 + 6 * 40 + 4,x
	sta $0800 + 7 * 40 + 4,x
	sta $0800 + 8 * 40 + 4,x
	sta $0800 + 9 * 40 + 4,x
	sta $0800 +10 * 40 + 4,x
	sta $0800 +11 * 40 + 4,x
	sta $0800 +12 * 40 + 4,x
	sta $0800 +13 * 40 + 4,x
	sta $0800 +14 * 40 + 4,x
	sta $0800 +15 * 40 + 4,x
	sta $0800 +16 * 40 + 4,x
	sta $0800 +17 * 40 + 4,x
	sta $0800 +18 * 40 + 4,x
	sta $0800 +19 * 40 + 4,x
	sta $0800 +20 * 40 + 4,x
	sta $0800 +21 * 40 + 4,x
	sta $0800 +22 * 40 + 4,x
	sta $0800 +23 * 40 + 4,x
	sta $0800 +24 * 40 + 4,x
	dex
	bpl k_il3
	;inc $FF19
	;
	rts

kefrens_text_clear
	lda #$00
	inc kefrens_text_clear+1
	and #$01
	bne ktc_01
ktc_index
	ldx #0
	txa
	jmp kefrens_text_clear_column
	;
ktc_01	lda #31
	sec
	sbc ktc_index+1
	inc ktc_index+1
	tax
	;
kefrens_text_clear_column
	ora #$E0
	sta $0C00 + 9 * 40 + 4,x
	sta $0C00 +10 * 40 + 4,x
	sta $0C00 +11 * 40 + 4,x
	sta $0C00 +12 * 40 + 4,x
	sta $0C00 +13 * 40 + 4,x
	sta $0C00 +14 * 40 + 4,x
	sta $0C00 +15 * 40 + 4,x
	sta $0C00 +16 * 40 + 4,x
	;
	lda #$7F
	sta $0800 + 9 * 40 + 4,x
	sta $0800 +10 * 40 + 4,x
	sta $0800 +11 * 40 + 4,x
	sta $0800 +12 * 40 + 4,x
	sta $0800 +13 * 40 + 4,x
	sta $0800 +14 * 40 + 4,x
	sta $0800 +15 * 40 + 4,x
	sta $0800 +16 * 40 + 4,x
	rts

kefrens_bottom_pal
	;dec $FF19
	;
	ldx #$3F
	lda #$00
k_cl1	sta charset+$0700,x
	sta charset+$0740,x
	sta charset+$0780,x
	sta charset+$07C0,x
	dex
	bpl k_cl1
	;
	ldx #$7F
k_sn1	lda k_sine1,x
	clc
k_sn2	adc k_sine2,x
	sta kefrens_sine,x
	dex
	bpl k_sn1
	;
	lda k_sn1+1
	clc
	adc #1
	cmp #102
	bne *+4
	lda #0
	sta k_sn1+1 
	;
	lda k_sn2+1
	sec
	sbc #1
	bpl *+4
	lda #70
	sta k_sn2+1 
	;
	;inc $FF19
	;
	rts

kefrens_bottom_ntsc
	;dec $FF19
	;
	ldx #$1F
	lda #$00
k_cl2	sta charset+$0700,x
	sta charset+$0720,x
	sta charset+$0740,x
	sta charset+$0760,x
	sta charset+$0780,x
	sta charset+$07A0,x
	sta charset+$07C0,x
	sta charset+$07E0,x
	dex
	bpl k_cl2
	;
	ldx #$00
k_sn3	lda k_sine1,x
	clc
k_sn4	adc k_sine2,x
	sta kefrens_sine,x
	sta kefrens_sine+1,x
	sta kefrens_sine+2,x
	sta kefrens_sine+3,x
	inx
	inx
	inx
	inx
	bpl k_sn3
	;
	lda k_sn3+1
	clc
	adc #1
	cmp #102
	bne *+4
	lda #0
	sta k_sn3+1 
	;
	lda k_sn4+1
	sec
	sbc #1
	bpl *+4
	lda #70
	sta k_sn4+1 
	;
	;inc $FF19
	;
	rts

	;
	; *************************************
	;	
thai_comp_start
	include "thai_comp_hex.asm"
thai_comp_end

gb_comp_start
	include "gb_comp_hex.asm"
gb_comp_end

	include "dxycp.asm"

trigger_dxycp_prep
	trigger dxycp_prep
	rts

	;
	; *************************************
	;
draw_excl_1
	lda #$20				; JSR opcode
	sta wait_bottom_call			; enable
	;
	ldx #($0C00 + 2 * 40 + 2) & 255
	lda #($0C00 + 2 * 40 + 2) >> 8 
	bne draw_excl
	;
draw_excl_2
	ldx #($0C00 + 6 * 40 +34) & 255
	lda #($0C00 + 6 * 40 +34) >> 8 
	bne draw_excl
	;
draw_excl_3
	ldx #($0C00 +19 * 40 +15) & 255
	lda #($0C00 +19 * 40 +15) >> 8 
	bne draw_excl
	;
draw_excl_4
	ldx #($0C00 + 1 * 40 +18) & 255
	lda #($0C00 + 1 * 40 +18) >> 8 
	bne draw_excl
	;
draw_excl_5
	ldx #($0C00 +21 * 40 +31) & 255
	lda #($0C00 +21 * 40 +31) >> 8 
	bne draw_excl
	;
draw_excl_6
	ldx #($0C00 + 7 * 40 + 0) & 255
	lda #($0C00 + 7 * 40 + 0) >> 8 
	bne draw_excl
	;
draw_excl
	stx dst_ptr
	sta dst_ptr+1
	;
	stx col_dst
	and #$FB
	sta col_dst+1
	;
	ldy #$04
	jsr draw_random_excl_row
	;
	add16 dst_ptr, #35
	add16 col_dst, #35
	;
	ldy #$09
draw_random_excl_row
	ldx #$04
dre_01	lda excl_chars,y
	sta (dst_ptr),y
	lda excl_colors,x
	sta (col_dst),y
	dey
	dex
	bpl dre_01
	rts

wb1	macro addr
	sta addr
	sta addr+1
	sta addr+40
	sta addr+41
	endm

wbe	macro addr
	wb1 addr
	wb1 addr+3
	endm

wait_bottom
	lda #$00
	inc wait_bottom+1
	and #$07
	beq wb_01
	rts
wb_01	lda $0800 + 2 * 40 + 2
	eor #$61
	wbe $0800 + 2 * 40 + 2
	wbe $0800 + 6 * 40 +34
	wbe $0800 +19 * 40 +15
	wbe $0800 + 1 * 40 +18
	wbe $0800 +21 * 40 +31
	wbe $0800 + 7 * 40 + 0
	rts

stop_wait
	lda #$2C
	sta wait_bottom_call
	;
	jmp clear_chars_set_24_rows
	
	include "beret_charset.asm"
	include "beret2_charset.asm"

copy_beret_chars
	ldx #$57
cbc_01	lda beret_charset,x
	sta charset + $0700,x
	lda beret_charset + $58,x
	sta charset + $0758,x
	lda beret2_charset,x
	sta charset + $0600,x
	lda beret2_charset + $58,x
	sta charset + $0658,x
	dex
	bpl cbc_01
	rts

draw_1_beret
	ldy #$00
	lda beret_pos,y
	sta dst_ptr
	sta col_dst
	lda beret_pos + 1,y
	sta dst_ptr+1
	sec					; the normal AND #$FB doesn't work here
	sbc #$04				; because some screen positions are before $0C00
	sta col_dst+1
	;
	lda draw_1_beret+1
	clc
	adc #2
	sta draw_1_beret+1
	;
	set16 src_ptr, beret_charmap
	;
d1b_02	ldy #$05
d1b_01	lda (src_ptr),y
	sta (dst_ptr),y
	lda #$15				; beret color (dark green)
	sta (col_dst),y
	dey
	bpl d1b_01
	;
	add16 src_ptr, #6
	add16 dst_ptr, #40
	add16 col_dst, #40
	;
	lda src_ptr
	cmp #(beret_charmap + 6 * 4) & 255
	bne d1b_02
	;
	rts

beret_pos
	dw $0C00 + 20 * 40 + 8
	dw $0C00 + 16 * 40 + 0
	;
	dw $0C00 + 20 * 40 + 24
	dw $0C00 + 16 * 40 + 16
	dw $0C00 + 12 * 40 + 8
	dw $0C00 +  8 * 40 + 0
	;
	dw $0C00 + 16 * 40 + 32
	dw $0C00 + 12 * 40 + 24
	dw $0C00 +  8 * 40 + 16
	dw $0C00 +  4 * 40 + 8
	dw $0C00 +  0 * 40 + 0
	;
	dw $0C00 +  8 * 40 + 32
	dw $0C00 +  4 * 40 + 24
	dw $0C00 +  0 * 40 + 16
	;
	dw $0C00 +  0 * 40 + 32

draw_beret2
	set16 src_ptr, beret2_charmap
	;
	set16 dst_ptr, $0C00 + 13 * 40 + 32
	set16 col_dst, $0800 + 13 * 40 + 32
	;
	ldx #$05				; 6x6 size
db2_01	ldy #$05
db2_02	lda (src_ptr),y
	beq db2_03				; skip spaces
	sta (dst_ptr),y
	cpx #$00				; for the last line,
	beq db2_03				; don't set color
	lda #$35
	sta (col_dst),y				; same color as last line
db2_03	dey
	bpl db2_02
	;
	add16 src_ptr, #6
	add16 dst_ptr, #40
	add16 col_dst, #40
	;
	dex
	bpl db2_01
	rts

wipe8_1
	set16 dst_ptr, $0C00
	ldx #7
w81_01	ldy #$00
	lda #$00
	sta (dst_ptr),y
	iny
	sta (dst_ptr),y
	add16 dst_ptr, #40
	dex
	bpl w81_01
	;
	lda w81_01+1
	clc
	adc #$2
	sta w81_01+1
	rts

wipe8_2
	set16 dst_ptr, $0C00 + 8 * 40
	ldx #7
w82_01	ldy #38
	lda #$00
	sta (dst_ptr),y
	iny
	sta (dst_ptr),y
	add16 dst_ptr, #40
	dex
	bpl w82_01
	;
	lda w82_01+1
	sec
	sbc #$2
	sta w82_01+1
	rts

wipe8_3
	set16 dst_ptr, $0C00 + 16 * 40
	ldx #7
w83_01	ldy #$00
	lda #$00
	sta (dst_ptr),y
	iny
	sta (dst_ptr),y
	add16 dst_ptr, #40
	dex
	bpl w83_01
	;
	lda w83_01+1
	clc
	adc #$2
	sta w83_01+1
	rts

gb_fade_in_colors
	ldx #00
	;
	ldy #$FF
	lda $FF07
	and #$40
	beq *+4
	ldy #$F7
	;
	lda gb_fade_colors,x
	cpy $FF1D
	bne *-3
	sta $FF19
	;
	inc gb_fade_in_colors+1
	rts

gb_fade_out_colors
	ldx #14
	;
	ldy #$FF
	lda $FF07
	and #$40
	beq *+4
	ldy #$F7
	;
	lda gb_fade_colors,x
	cpy $FF1D
	bne *-3
	sta $FF19
	;
	dec gb_fade_out_colors+1
	;
	lda #$0B
	sta $FF06
	rts

double_curtain_close
dcc_01	lda #$00
	jsr curtain_close_two_columns
	;
	lda #38
	sec
	sbc dcc_01+1
	jsr curtain_close_two_columns
	;
	lda dcc_01+1
	clc
	adc #2
	sta dcc_01+1
	rts

curtain_close_two_columns
	sta dst_ptr
	;
	lda #$0C
	sta dst_ptr+1
	;
	ldx #24-9
cctc_01	ldy #$00
	lda #$00
	sta (dst_ptr),y
	iny
	sta (dst_ptr),y
	;
	cpx #12
	bne cctc_02
	;
	lda dst_ptr
	clc
	adc #(9*40) & 255
	sta dst_ptr
	lda dst_ptr+1
	adc #(9*40) >> 8
	sta dst_ptr+1
cctc_02	;
	add16 dst_ptr, #40
	dex
	bpl cctc_01
	;
	rts
	
	;
	; ***
	;
render_2x2
	trigger render_2x2_call
	rts

render_2x2_call
	lda #($0C00 + 7 * 40 + 4) & 255
	ldx #($0C00 + 7 * 40 + 4) >> 8
	sta src_ptr
	stx src_ptr+1
	;
	clc					; move down by 5 lines for next call
	adc #(5 * 40)
	sta render_2x2_call+1
	bcc *+5
	inc render_2x2_call+3
	;
	set16 dst_ptr, charset + $0600
	;
	jsr render_2x2_copy
	;
	add16 src_ptr, #40
	;
	jsr render_2x2_copy
	;
	; ---
	;
	ldx #7
r2_01	txa
	tay
r2_02	lsr charset + $0600,x
	ror charset + $0608,x
	ror charset + $0610,x
	ror charset + $0618,x
	ror charset + $0620,x
	ror charset + $0628,x
	ror charset + $0630,x
	ror charset + $0638,x
	ror charset + $0640,x
	ror charset + $0648,x
	ror charset + $0650,x
	ror charset + $0658,x
	ror charset + $0660,x
	ror charset + $0668,x
	ror charset + $0670,x
	ror charset + $0678,x
	;
	ror charset + $0680,x
	ror charset + $0688,x
	ror charset + $0690,x
	ror charset + $0698,x
	ror charset + $06A0,x
	ror charset + $06A8,x
	ror charset + $06B0,x
	ror charset + $06B8,x
	ror charset + $06C0,x
	ror charset + $06C8,x
	ror charset + $06D0,x
	ror charset + $06D8,x
	ror charset + $06E0,x
	ror charset + $06E8,x
	ror charset + $06F0,x
	ror charset + $06F8,x
	dey
	bpl r2_02
	dex
	bpl r2_01
	;
	ldx #7
r2_03	txa
	tay
r2_04	lsr charset + $0700,x
	ror charset + $0708,x
	ror charset + $0710,x
	ror charset + $0718,x
	ror charset + $0720,x
	ror charset + $0728,x
	ror charset + $0730,x
	ror charset + $0738,x
	ror charset + $0740,x
	ror charset + $0748,x
	ror charset + $0750,x
	ror charset + $0758,x
	ror charset + $0760,x
	ror charset + $0768,x
	ror charset + $0770,x
	ror charset + $0778,x
	;
	ror charset + $0780,x
	ror charset + $0788,x
	ror charset + $0790,x
	ror charset + $0798,x
	ror charset + $07A0,x
	ror charset + $07A8,x
	ror charset + $07B0,x
	ror charset + $07B8,x
	ror charset + $07C0,x
	ror charset + $07C8,x
	ror charset + $07D0,x
	ror charset + $07D8,x
	ror charset + $07E0,x
	ror charset + $07E8,x
	ror charset + $07F0,x
	ror charset + $07F8,x
	dey
	bpl r2_04
	dex
	bpl r2_03
	;
	; ---
	;
	lda #$CC
	cmp $FF1D
	bcs *-3
	;
	lda src_ptr
	sec
	sbc #40
	sta twinkle_ptr
	lda src_ptr+1
	sbc #0
	sta twinkle_ptr+1
	;
	ldy #$00
r2_05	tya
	ora #$C0
	sta (twinkle_ptr),y
	ora #$20
	sta (src_ptr),y
	iny
	cpy #32
	bne r2_05
	;
	lda twinkle_ptr+1
	and #$FB
	sta twinkle_ptr+1
	;
	lda twinkle_ptr
	sec
	sbc #10
	sta twinkle_ptr
	ldy #$00
	lda (twinkle_ptr),y			; grab color from line above
	pha
	lda twinkle_ptr
	clc
	adc #10
	sta twinkle_ptr
	pla
	clc
	adc #$10				; lighter color 
	;
	ldy #80
r2_06	sta (twinkle_ptr),y
	dey
	bpl r2_06
	;
	rts

render_2x2_copy
	ldx #$00
r2c_01	txa
	tay
	lda (src_ptr),y
	sta ptr
	lda #charset >> 11
	sta ptr+1
	;
	asl ptr
	rol ptr+1
	asl ptr
	rol ptr+1
	asl ptr
	rol ptr+1
	;
	ldy #$07
r2c_02	lda (ptr),y
	sta (dst_ptr),y
	dey
	bpl r2c_02
	;
	add16 dst_ptr, #8
	;
	inx
	cpx #32
	bne r2c_01
	;
	rts

show_twinkle_init
	ldy #$03
	db $2C
show_twinkle
	ldy #$03
	jsr show_twinkle_1
	;
	tya
	clc
	adc #42
	tay
	jsr show_twinkle_1
	;
	tya
	sec
	sbc #$23
	sta show_twinkle+1
	rts

show_twinkle_1
	lda (twinkle_ptr),y
	pha
	lda #$71
	dey
	sta (twinkle_ptr),y
	dey
	sta (twinkle_ptr),y
	dey
	pla
	sta (twinkle_ptr),y
	rts

remove_twinkle
	jsr default_irq				; stop the irq
	;
	lda twinkle_ptr+1
	ora #$04
	sta twinkle_ptr+1
	;
	ldy #80
	lda #$00
rt_01	sta (twinkle_ptr),y			; erase old text (to remove extra chars)
	dey
	bpl rt_01
	;
	jmp write_2x2_text

wipe_upwards_init
	lda #($0C00 + 24 * 40) & 255
	ldx #($0C00 + 24 * 40) >> 8
	bne wu_02
	;
wipe_upwards
	lda #($0C00 + 24 * 40) & 255
	ldx #($0C00 + 24 * 40) >> 8
wu_02	sta dst_ptr
	stx dst_ptr+1
	;
	sec
	sbc #40
	sta wipe_upwards+1
	bcs *+5
	dec wipe_upwards+3 
	;
	ldy #39
	lda #00
wu_01	sta (dst_ptr),y
	dey
	bpl wu_01
	;
	rts

setup_world
	jsr set_24_rows				; 24 rows
	lda $FF07				; multicolor
	and #$40
	ora #$98
	sta $FF07
	lda #$55
	sta $FF17				; green landmass
	trigger copy_world_call
	rts

copy_world_call
	ldx #$00
cwc_01	lda world_charset,x
	sta charset + $0600,x
	lda world_charset + $0100,x
	sta charset + $0700,x
	inx
	bne cwc_01
	rts

draw_world_o
	ldx #$07
dwo_01	lda world_charmap + 0 * 8,x
	sta $0C00 + 16 * 40 + 8,x
	lda world_charmap + 1 * 8,x
	sta $0C00 + 17 * 40 + 8,x
	lda world_charmap + 2 * 8,x
	sta $0C00 + 18 * 40 + 8,x
	lda world_charmap + 3 * 8,x
	sta $0C00 + 19 * 40 + 8,x
	lda world_charmap + 4 * 8,x
	sta $0C00 + 20 * 40 + 8,x
	lda world_charmap + 5 * 8,x
	sta $0C00 + 21 * 40 + 8,x
	lda world_charmap + 6 * 8,x
	sta $0C00 + 22 * 40 + 8,x
	lda world_charmap + 7 * 8,x
	sta $0C00 + 23 * 40 + 8,x
	;
	lda #$4E
	sta $0800 + 16 * 40 + 8,x
	sta $0800 + 17 * 40 + 8,x
	sta $0800 + 18 * 40 + 8,x
	sta $0800 + 19 * 40 + 8,x
	sta $0800 + 20 * 40 + 8,x
	sta $0800 + 21 * 40 + 8,x
	sta $0800 + 22 * 40 + 8,x
	sta $0800 + 23 * 40 + 8,x
	dex
	bpl dwo_01
	rts

write_2x2_text_awesome
	jsr write_2x2_text
	;
	ldx #$70
	stx $0C00 + 2 * 40 + 0
	inx
	stx $0C00 + 2 * 40 + 1
	inx
	stx $0C00 + 3 * 40 + 0
	inx
	stx $0C00 + 3 * 40 + 1
	;
	inx
	stx $0C00 + 2 * 40 + 18
	inx
	stx $0C00 + 2 * 40 + 19
	inx
	stx $0C00 + 3 * 40 + 18
	inx
	stx $0C00 + 3 * 40 + 19
	;
	lda #$71
	sta $0800 + 2 * 40 + 0
	sta $0800 + 2 * 40 + 1
	sta $0800 + 3 * 40 + 0
	sta $0800 + 3 * 40 + 1
	sta $0800 + 2 * 40 + 18
	sta $0800 + 2 * 40 + 19
	sta $0800 + 3 * 40 + 18
	sta $0800 + 3 * 40 + 19
	;
	rts
	
copy_mini_mag_gfx
	ldx #$00
cmmg_01	lda mini_mag_gfx,x
	sta charset + $0680,x
	inx
	bne cmmg_01
	rts

draw_mini_mag_bg
	ldx #39
	lda #$5F
dmmb_01	sta $0C00 + 18 * 40,x
	sta $0C00 + 19 * 40,x
	sta $0C00 + 20 * 40,x
	sta $0C00 + 21 * 40,x
	sta $0C00 + 22 * 40,x
	sta $0C00 + 23 * 40,x
	sta $0C00 + 24 * 40,x
	dex
	bpl dmmb_01
	rts

fade_out_mini_mag
	lda mini_mag_color+1
	sec
	sbc #$10
	bpl *+4
	lda #$00
	sta mini_mag_color+1
	;
	lda $0800 + 19*40 + 18
	sec
	sbc #$10
	bpl *+4
	lda #$00
	ldx #3
fomm_01	sta $0800 + 19*40 + 18,x
	sta $0800 + 20*40 + 18,x
	sta $0800 + 21*40 + 18,x
	sta $0800 + 22*40 + 18,x
	sta $0800 + 23*40 + 18,x
	dex
	bpl fomm_01
	;
	lda $0800 + 19*40 + 18+4
	sec
	sbc #$10
	bpl *+4
	lda #$00
	sta $0800 + 19*40 + 18+4
	sta $0800 + 20*40 + 18+4
	sta $0800 + 21*40 + 18+4
	sta $0800 + 22*40 + 18+4
	sta $0800 + 23*40 + 18+4
	;
	rts	

draw_mini_magazine
	set16 dst_ptr, $0C00 + 19*40 + 18
	set16 col_dst, $0800 + 19*40 + 18
	;
	ldx #0
dmm_03	txa
	asl a
	asl a
	clc
	adc #$D0
	ldy #$00
dmm_01	sta (dst_ptr),y
	clc
	adc #$01
	iny
	cpy #4
	bne dmm_01
	lda #$00
	sta (dst_ptr),y
	;
	ldy #$04
	lda #$45				; green checkmarks
	sta (col_dst),y
	dey
	lda #$11				; dark gray text
dmm_02	sta (col_dst),y
	dey
	bpl dmm_02
	;
	add16 dst_ptr, #40
	add16 col_dst, #40
	;
	lda #$00
	sta $0C00 + 24*40+18,x
	;
	inx
	cpx #5
	bne dmm_03
	;
	ldx #39
	lda #$67
dmm_04	sta $0800 + 6 * 40,x
	sta $0800 + 7 * 40,x
	sta $0800 +11 * 40,x
	sta $0800 +12 * 40,x
	dex
	bpl dmm_04
	;
	rts

add_mini_checkmark
	ldx #$E5
	ldy #19
	lda txt_line_ptr_lo,y
	sta dst_ptr
	lda txt_line_ptr_hi,y
	sta dst_ptr+1
	txa
	ldy #22
	sta (dst_ptr),y
	;
	cpx #$E5
	bne amc_01
	;
	dec add_mini_checkmark+1
	rts
	;
amc_01	inc add_mini_checkmark+1
	inc add_mini_checkmark+3
	rts

thai_unpack
	set16 dst_ptr, $1001
	set16 src_ptr, thai_comp_start
	ldx #(thai_comp_end - thai_comp_start) >> 8
	ldy #$00
tu_01	lda (src_ptr),y
	sta (dst_ptr),y
	iny
	bne tu_01
	inc src_ptr+1
	inc dst_ptr+1
	dex
	bpl tu_01
	jmp $100D

scroll_in_names_init_last
	lda #$FF
	sta sin_fade_out_enable_disable+1
	bne scroll_in_names_init
	;
scroll_in_names_init_first
	lda #0
	db $2C
	;
scroll_in_names_init
	lda #6
	sta sin_fade_in_enable_disable+1
	;
	lda #$00
	sta names_scroll_x1
	sta names_idx
	eor #$07
	sta names_scroll_x2
	;
	ldx #39
	stx names_colidx
	;
	jmp write_2x2_text			; only 1 line fits into the rastertime on NTSC

scroll_in_names
	ldx names_idx
	lda names_table,x
	clc
	adc names_scroll_x1
	cmp #16					; moved 2 chars?
	bcc sin_02
	;
	pha
	;
	ldx #37
sin_01	lda $0C00 + 6 * 40 + 0,x
	sta $0C00 + 6 * 40 + 2,x      		; scroll 2 chars
	lda $0C00 + 7 * 40 + 0,x
	sta $0C00 + 7 * 40 + 2,x
	dex
	bpl sin_01
	;
	ldx #0
sin_01b	lda $0C00 + 11 * 40 + 2,x
	sta $0C00 + 11 * 40 + 0,x
	lda $0C00 + 12 * 40 + 2,x
	sta $0C00 + 12 * 40 + 0,x
	inx
	cpx #38
	bne sin_01b
	;
	ldx names_colidx
	lda $0C00 + 0 * 40, x			; scroll in new text on left
	sta $0C00 + 6 * 40 + 1
	lda $0C00 + 1 * 40, x
	sta $0C00 + 7 * 40 + 1
	;
	lda #39
	sec
	sbc names_colidx
	tax
	lda $0C00 +16 * 40, x			; scroll in new text on right
	sta $0C00 +11 * 40+38
	lda $0C00 +17 * 40, x
	sta $0C00 +12 * 40+38
	;
	dec names_colidx
	jmp sin_04
	;
sin_02	cmp #8					; moved 1 char?
	bcc sin_05
	;
	pha
	;
	ldx #38
sin_03	lda $0C00 + 6 * 40 + 0,x
	sta $0C00 + 6 * 40 + 1,x		; scroll 1 char
	lda $0C00 + 7 * 40 + 0,x
	sta $0C00 + 7 * 40 + 1,x
	dex
	bpl sin_03
	;
	ldx #0
sin_03b	lda $0C00 + 11 * 40 + 1,x
	sta $0C00 + 11 * 40 + 0,x
	lda $0C00 + 12 * 40 + 1,x
	sta $0C00 + 12 * 40 + 0,x
	inx
	cpx #39
	bne sin_03b
	;
sin_04	ldx names_colidx
	lda $0C00 + 0 * 40, x			; scroll in new text on left
	sta $0C00 + 6 * 40
	lda $0C00 + 1 * 40, x
	sta $0C00 + 7 * 40
	;
	lda #39
	sec
	sbc names_colidx
	tax
	lda $0C00 +16 * 40, x			; scroll in new text on right
	sta $0C00 +11 * 40+39
	lda $0C00 +17 * 40, x
	sta $0C00 +12 * 40+39
	;
	dec names_colidx
	;
	pla
	and #$07
	;
sin_05	sta names_scroll_x1
	;
	eor #$07
	sta names_scroll_x2
	;
	ldx names_idx
sin_fade_in_enable_disable
	cpx #6
	bcc sin_07a
sin_fade_out_enable_disable
	cpx #32-5
	bcc sin_08
	;
	txa					; fade out
	sec
	sbc #32-6
	jmp sin_07b
sin_07a	lda #5					; fade in
	sec
	sbc names_idx
sin_07b	tax
	lda names_mid_fade_in,x 
	ldx #11
sin_07	sta $0800 + 9*40 + 14,x			; fade middle "converted by text"
	dex
	bpl sin_07
	;
sin_08	inc names_idx
	rts

scroll_names_cleanup
	ldx #39
	lda #0
snc_01	sta $0C00 + 0 * 40,x
	sta $0C00 + 1 * 40,x
	sta $0C00 +16 * 40,x
	sta $0C00 +17 * 40,x
	dex
	bpl snc_01
	rts

THAI_SRC = $1000 + ($36+$0F) * 8
THAI_POS = $0C00 + 14 * 40 + 14

thai_draw_stand
	ldy #23
	db $2C
thai_draw_kick
	ldy #3
	ldx #$03
tdk_01	lda THAI_SRC + 0 * 4,y
	sta THAI_POS + 0 * 40,x
	lda THAI_SRC + 1 * 4,y
	sta THAI_POS + 1 * 40,x
	lda THAI_SRC + 2 * 4,y
	sta THAI_POS + 2 * 40,x
	lda THAI_SRC + 3 * 4,y
	sta THAI_POS + 3 * 40,x
	lda THAI_SRC + 4 * 4,y
	sta THAI_POS + 4 * 40,x
	dey
	dex
	bpl tdk_01
	;
	jmp dxycp_render_letter

draw_speech_bubble
	set16 dst_ptr, $0C00 + 9 * 40 + 10
	;
	ldy #18
	lda #$61
dsb_01	sta (dst_ptr),y
	dey
	bne dsb_01
	;
	lda #$68
	sta (dst_ptr),y
	ldy #19
	lda #$69
	sta (dst_ptr),y
	;
	ldx #4
dsb_02	;
	add16 dst_ptr, #40
	;
	ldy #18
	lda #$5F
dsb_03	sta (dst_ptr),y
	dey
	bne dsb_03
	;
	lda #$63
	sta (dst_ptr),y
	ldy #19
	lda #$64
	sta (dst_ptr),y
	;
	dex
	bpl dsb_02
	;
	ldy #18
	lda #$66
dsb_04	sta (dst_ptr),y
	dey
	bne dsb_04
	;
	lda #$6A
	sta (dst_ptr),y
	ldy #19
	lda #$6B
	sta (dst_ptr),y
	;
	ldy #42
	sta (dst_ptr),y
	ldy #2
	lda #$5F
	sta (dst_ptr),y 
	rts

fade_in_speech_bubble
	lda #$00
	inc fade_in_speech_bubble+1
	and #$01
	beq fsb_03
	;
fsb_04	;
	set16 col_dst, $0800 + 9 * 40 + 10
	;
fsb_index
	ldx #$00
	inc fsb_index+1
	lda speech_bubble_fade_colors,x
	;
	ldx #6
fsb_01	ldy #19
fsb_02	sta (col_dst),y
	dey
	bpl fsb_02
	tay
	add16 col_dst, #40
	tya
	dex
	bpl fsb_01
	;
fsb_03	rts

fade_out_speech_bubble
	lda #$00
	inc fade_out_speech_bubble+1
	and #$01
	beq fsb_03
	;
	dec fsb_index+1
	jsr fsb_04
	dec fsb_index+1
	rts

pixel_small_text
	;
pixel_pos
	ldx #$00
	bne pst_04
	;
	ldy #$00
pst_01	lda (small_txt_src),y
	bne pst_01a				; space?
	;
	add16 dst_ptr, #1			; skip
	iny
	bne pst_01
	;
pst_01a	cmp #$FF				; set position flag?
	bne pst_02
	;
	iny
	lda (small_txt_src),y
	sta dst_ptr				; get lo byte
	iny
	lda (small_txt_src),y
	sta dst_ptr+1				; get hi byte
	iny
	bne pst_01
	;
pst_02	sta src_ptr
	sta pixel_char
	;
	iny
	tya
	clc
	adc small_txt_src
	sta small_txt_src 
	bcc *+4
	inc small_txt_src+1
	;
	ldy #$00
	lda #$FF
	sta (dst_ptr),y
	;
	lda #$00
	sta src_ptr+1
	;
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	;
	lda src_ptr+1
	ora #charset >> 8
	sta src_ptr+1
	;
pst_04	cpx #$03
	bne pst_05
	;
	ldy #$00
	lda pixel_char
	sta (dst_ptr),y
	sty pixel_pos+1
	;
	add16 dst_ptr, #1
	;
	rts
	;
pst_05	ldy #$07
pst_03	lda (src_ptr),y
	and pixel_and,x
	ora pixel_ora,x
	sta charset + $07F8,y
	dey
	bpl pst_03
	;
	inc pixel_pos+1
	;
	rts

sprites_fade_in_next
	ldx #5
	lda sfi_pos+1
	cmp #17
	bne sfi_03
	;
	clc
	adc #2
	ldx #1					; exception for letter "I"
	bne sfi_04
	;
sfi_03	clc
	adc #6
	;
sfi_04	sta sfi_pos+1
	stx sfi_width+1
	;	
sprites_fade_in
	ldy sfi_pos+1
	lda $0800 + 3 * 40 + 1,y
	bne sfi_01
	lda #$F3
sfi_01	clc
	adc #$10
	;
sfi_width
	ldx #5
sfi_pos	ldy #5
	;
sfi_02	sta $0800 + 3 * 40 + 1,y
	sta $0800 + 4 * 40 + 1,y
	sta $0800 + 5 * 40 + 1,y
	sta $0800 + 6 * 40 + 1,y
	sta $0800 + 7 * 40 + 1,y
	sta $0800 + 8 * 40 + 1,y
	sta $0800 + 9 * 40 + 1,y
	sta $0800 +10 * 40 + 1,y
	dey
	dex
	bpl sfi_02
	rts

sprites_fade_out_next
	ldx #5
	lda sfi_pos+1
	cmp #$25
	bne sfo_02
	;
	lda #$FF
	;
sfo_02	cmp #17
	bne sfo_03
	;
	clc
	adc #2
	ldx #1					; exception for letter "I"
	bne sfo_04
	;
sfo_03	clc
	adc #6
	;
sfo_04	sta sfi_pos+1
	stx sfi_width+1
	;	
sprites_fade_out
	ldy sfi_pos+1
	lda $0800 + 3 * 40 + 1,y
	sec
	sbc #$10
	bpl sfi_width
	lda #$00
	beq sfi_width
	
	include "world_charset.asm"
	
	include "butwhy_charset.asm"
	
copy_butwhy_chars
	ldx #$57
cbwc_01	lda butwhy_charset,x
	sta charset + $0700,x
	lda butwhy_charset + $58,x
	sta charset + $0758,x
	dex
	bpl cbwc_01
	rts

draw_butwhy
	set16 src_ptr, butwhy_charmap
	;
	set16 dst_ptr, $0C00 + 2 * 40 + 1
	set16 col_dst, $0800 + 2 * 40 + 1
	;
	ldx #$05				; 5x6 size
dbw_01	ldy #$04
dbw_02	lda (src_ptr),y
	beq dbw_03				; skip spaces
	sta (dst_ptr),y
dbw_03	dey
	bpl dbw_02
	;
	add16 src_ptr, #5
	add16 dst_ptr, #40
	add16 col_dst, #40
	;
	dex
	bpl dbw_01
	rts

fade_in_area
	lda #$00
	bne fade_out_area
	;
	ldy #$00
	lda (col_dst),y
	bne *+4
	lda pen_color
	clc
	adc #$10
	sta pen_color
	;
	ldx area_height
fia_01	ldy area_width
	lda pen_color
fia_02	sta (col_dst),y
	dey
	bpl fia_02
	;
	add16 col_dst, #40
	dex
	bpl fia_01
	rts

fade_out_area
	ldy #$00
	lda (col_dst),y
	sec
	sbc #$10
	bpl *+4
	lda #$00
	sta pen_color
	;
	ldx area_height
foa_01	ldy area_width
	lda pen_color
foa_02	sta (col_dst),y
	dey
	bpl foa_02
	;
	add16 col_dst, #40
	dex
	bpl foa_01
	rts
	
do_fade_in_area	macro	addr, color, width, height
	lda #addr & 255
	sta col_dst
	lda #addr >> 8
	sta col_dst+1
	lda #color
	sta pen_color
	lda #width-1
	sta area_width
	lda #height-1
	sta area_height
	jmp fade_in_area
	endm

fade_in_butwhy
	do_fade_in_area $0800 + 2 * 40 + 1, $F1, 5, 6

fade_in_but
	do_fade_in_area $0800 + 1 * 40 + 10, $FF, 7+7+6, 8

fade_in_why
	do_fade_in_area $2000 + 2 * 40 + 5, $FF, 8+8+8+6, 8

start_butwhy_fadeout
	dec fade_in_area+1
	rts

	;
	; *************************************
	;
	align $0800
	include "charset.asm"
	
	align $0800
	include "c64_font.asm"
	;
	; *************************************
	;
	align 256
main	lda #$00				; main!
	sta main_program_call+2
main_l	lda main_program_call+2
	beq main_l
main_program_call
	jsr $0000				; one-time main program calls
	jmp main

wait_for_completion
	lda main_program_call+2			; check if main program call completed
	bne wfc_01
	;
	jmp timeline_delay_to_zero		; done waiting
	;
wfc_01	rts

clear_screen_call
	ldx #$00
	lda #$00
cs_01	sta $0800,x
	sta $0C00,x
	inx
	bne cs_01
	;
cs_02	sta $0900,x
	sta $0D00,x
	inx
	bne cs_02
	;
cs_03	sta $0A00,x
	sta $0E00,x
	inx
	bne cs_03
	;
cs_04	sta $0B00,x
	sta $0F00,x
	inx
	bne cs_04
	;	
	rts

fill
	;dec $FF19
	sty ptr+1
	ldy #$00
	sty ptr
fl	sta (ptr),y
	iny
	bne fl
	inc ptr+1
	dex
	bpl fl
	;inc $FF19
	rts

irq1
	pha
	txa
	pha
	tya
	pha
	;
;	lda $FF01				; frame drop detection
;	cmp #$3A
;	beq timer_ok
;	;
;	lda #$32
;timer_wrong
;	bit $FF19
;	jmp timer_set
;	;
;timer_ok
;	lda #$8D
;	sta timer_wrong
;	;
;timer_set
;	lda #$F0
;	sta $FF00
;	lda #$74				; PAL: 57 * 312 ($45xx), NTSC: 57 * 262 $3Axx
;	sta $FF01
	;
	;dec $FF19
player_call_1
	jsr PLAYER
	;inc $FF19
	;
irq1_next
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

irq_mag	pha
	;
	lda #$61
	sta $FF16
	;
	set_irq_a RL_IRQ_BOTTOM, irq_bottom
	;
	asl $FF09
	pla
	rti

irq_twinkle_1
	pha
	txa
	pha
	tya
	pha
	;
	ldx #2*8
	ldy #$A8
it1	lda twinkle_data,x
	cpy $FF1E
	bcs *-3
	sta $FF07
	sta $FF20
	dex
	bpl it1
	;
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

irq_names_1
	pha
	;
	lda $FF07
	and #$40
	ora names_scroll_x1
	sta $FF07
	;
	set_irq_a $44, irq_names_2
	;
	asl $FF09
	pla
	rti

irq_names_2
	pha
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
	set_irq_a $5A, irq_names_3
	;
	asl $FF09
	pla
	rti

irq_names_3
	pha
	;
	lda $FF07
	and #$40
	ora names_scroll_x2
	sta $FF07
	;
	set_irq_a $9A, irq_names_4
	;
	asl $FF09
	pla
	rti

irq_names_4
	pha
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
mini_mag_color
	lda #$71
	sta $FF15
	;
	set_irq_a RL_IRQ_BOTTOM, irq_bottom
	;
	asl $FF09
	pla
	rti

irq_gb_1
	pha
	;
	lda #DYCP_FONT >> 8			; set charset
	sta $FF13
	lda $FF07
	and #$40
	ora #$80
	ora dycp_scroll_x
	sta $FF07				; dycp fine scroll
	;
	set_irq_a $6D, irq_gb_2
	;
	asl $FF09
	pla
	rti

irq_gb_2
	pha
	;
	lda #($1000) >> 8			; gb charset
	sta $FF13				; switch back after DYCP
	lda $FF07
	and #$40
	ora #$88
	sta $FF07				; no scrolling
	;
	set_irq_a RL_IRQ_BOTTOM, irq_bottom
	;
	asl $FF09
	pla
	rti

irq_map_1
	pha
	txa
	pha
	tya
	pha
	;
	lda #charset >> 8
	sta $FF13
	lda #MAP_BACKGROUND_COLOR
	sta $FF15
	;
	lda #$53
	ldx #irq_map_2 & 255
	ldy #irq_map_2 >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

irq_map_2
	pha
	txa
	pha
	tya
	pha
	;
	lda $FF07
	and #$40
	ora map_scroll_x
	ora #$90
	sta $FF07
	;
	lda #c64_font >> 8
	sta $FF13
	lda #$00
	sta $FF15
	;
	lda #$C9
	ldx #irq_map_3 & 255
	ldy #irq_map_3 >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

irq_map_3
	pha
	txa
	pha
	tya
	pha
	;
	lda $FF07
	and #$40
	ora #$90
	sta $FF07
	;
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti
	
;irq2
;	pha
;	txa
;	pha
;	tya
;	pha
;	;
;;	ldx #8*8-1
;;	ldy #$A8
;;raster_color_ptr
;;r2	lda raster_colors-64,x
;;	cpy $FF1E
;;	bcs *-3
;;	sta $FF16
;;	eor #$60
;;	sta $FF17
;;	dex
;;	bpl r2
;	;
;	lda #$52
;	ldx #irq3 & 255
;	ldy #irq3 >> 8
;	jsr set_irq
;	;
;	pla
;	tay
;	pla
;	tax
;	pla
;	rti
;	
;irq3
;	pha
;	txa
;	pha
;	tya
;	pha
;	;
;	ldx #$0A
;i3	dex
;	bpl i3
;	;
;	lda #font2x2 >> 8
;	sta $FF13
;	;
;	lda $FF07
;	and #$40
;	ora #$88
;	sta $FF07
;	;
;	lda #RL_IRQ_BOTTOM
;	ldx #irq_bottom & 255
;	ldy #irq_bottom >> 8
;	jsr set_irq
;	;
;	pla
;	tay
;	pla
;	tax
;	pla
;	rti

irq_speech
	pha
	txa
	pha
	tya
	pha
	;
	ldx #7*8-1
	ldy #$A8
is1	lda speech_wave,x
	cpy $FF1E
	bcs *-3
	sta $FF07
	sta $FF20
	dex
	bpl is1
	;
	lda is1+1
	clc
	adc #$01
	and #$3F
	sta is1+1
	;
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

irq_thai1
	pha
	txa
	pha
	tya
	pha
	;
	lda #$46
	sta $FF15
	;
	lda #$63
	ldx #irq_thai2 & 255
	ldy #irq_thai2 >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

irq_thai2
	pha
	;
	lda #$77
	sta $FF15
	;
	txa
	pha
	tya
	pha
	;
irq_thai2_rl
	lda #RL_IRQ_BOTTOM-$28			; move bottom up for NTSC DXYCP effect
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti
	
irq_bottom
	pha					; irq_bottom!
	txa
	pha
	tya
	pha
	;
	lda #$00 
black_screen_at_bottom
	bit $FF15
	;
	lda #$71
reset_ff16_at_bottom
	sta $FF16
	;
	lda #$08
reset_ff14_at_bottom
	bit $FF14
	;
	lda #$1B
reset_ff06_at_bottom
	bit $FF06
	;
vol_down_call
	bit vol_down 
	;
	;dec $FF19
player_call_2
	jsr PLAYER
	;inc $FF19
	;
	lda #$7F
	sta $FD30
	sta $FF08
	lda $FF08
	and #$20				; Query keyboard for "C="
	beq commodore_pressed			; skip processing timeline, which "pauses" the demo
	;
	;dec $FF19
	jsr process_timeline
	;inc $FF19
commodore_pressed
	;
	;dec $FF19
kefrens_bottom_call
	bit kefrens_bottom_pal
	;inc $FF19
	;
	;dec $FF19
wait_bottom_call
	bit wait_bottom
	;inc $FF19
	;
	jsr set_irq1
	;
	pla
	tay
	pla
	tax
	pla
	rti

set_irq1
	lda $FF07
	and #$40
	beq set_i2
	;
	lda #$FE
	ldx #irq1 & 255
	ldy #irq1 >> 8
	bne set_irq
	;
set_i2	lda #$30
	ldx #irq1 & 255
	ldy #irq1 >> 8
	;
	sta $FF0B
	stx $FFFE
	sty $FFFF
	;
	lda #$A3
	bne set_i1
	;
set_irq
	sta $FF0B
	stx $FFFE
	sty $FFFF
	;
	lda #$A2
set_i1	sta $FF0A
	;
	asl $FF09
	;
	rts
 
irqfld
	pha
	txa
	pha
	tya
	pha
	;
fld_sine_index
	ldx #$FF
	inx
	cpx #(fld_sine_end - fld_sine)
	bne *+4
	ldx #$00
	stx fld_sine_index+1
	lda fld_sine,x
	tax					; x = fld gap
	;
	lda #$13
	cmp $FF1D
	bne *-3
	;
	ldy #$07
fld1	lda $FF1D
	and #$07
	ora #$10
	sty $FF1F
	sta $FF06
	dex
	bpl fld1
	;
	ldy #$04
delay2	ldx #$D8
delay1	dex
	bne delay1
	dey 
	bne delay2
	;
	; ---
	;
	ldx #$07
fld2	lda $FF1D
	tay
	and #$07
	ora #$18
	sty fld_tmp
	ldy #$07
	sty $FF1F
fld3	ldy fld_tmp
	cpy $FF1D
	beq fld3
	;
	sta $FF06
	dey
	bpl fld2
	;
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti

	;-----------------------
	
write_small
	ldy #$00
	lda (small_txt_src),y
	sta dst_ptr
	sta col_dst
	iny
	lda (small_txt_src),y
	sta dst_ptr+1
	and #$FB
	sta col_dst+1
	;
	iny
	lda (small_txt_src),y
	sta pen_color
	;
	iny
	tya
	clc
	adc small_txt_src
	sta small_txt_src
	bcc *+4
	inc small_txt_src+1
	;
	ldy #$00
ws_01	lda (small_txt_src),y
	cmp #$FF
	beq ws_09
	sta (dst_ptr),y
	lda pen_color
	sta (col_dst),y
	iny
	bne ws_01
	;
ws_09	iny
	tya
	clc
	adc small_txt_src
	sta small_txt_src
	bcc *+4
	inc small_txt_src+1
	rts

write_big_letter_x3
	jsr write_big_letter
	;
write_big_letter_x2
	jsr write_big_letter
	;
write_big_letter
	ldy #$00
	lda (big_txt_src),y
	sta dst_ptr
	sta col_dst
	iny
	lda (big_txt_src),y
	sta dst_ptr+1
	and #$FB
	sta col_dst+1
	;
	iny
	lda (big_txt_src),y
	sta pen_color
	iny
	;
	iny
	lda (big_txt_src),y
	sta src_ptr
	iny
	lda (big_txt_src),y
	sta src_ptr+1
	;
	iny
	tya
	clc
	adc big_txt_src
	sta big_txt_src
	bcc *+4
	inc big_txt_src+1
	;
	ldy #$00
	lda (src_ptr),y
	sta area_width
	iny
	lda (src_ptr),y
	sta area_height
	iny
	tya
	clc
	adc src_ptr
	sta src_ptr
	bcc *+4
	inc src_ptr+1
	;
	ldx area_height
	;
wbl_01	ldy #$00
wbl_02	lda (src_ptr),y
big_letter_erase
	beq wbl_03 				; skip spaces
	sta (dst_ptr),y
	lda pen_color
	sta (col_dst),y
wbl_03	iny
	cpy area_width
	bne wbl_02
	;
	add16 src_ptr, area_width
	add16 dst_ptr, #40
	add16 col_dst, #40
	;
	dex
	bne wbl_01
	;
	rts

clear_screen_25_rows_hires
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
	lda #$08
	sta $FF14
	;
	bne clear_screen_25_rows
	;
reset_after_thai
	jsr default_irq
	;
	lda #charset >> 8
	sta $FF13
	;
clear_screen_and_black_screen
	lda #$00
	sta $FF15
	;
clear_screen_25_rows
	lda #$1B
	sta $FF06
	;
clear_screen
	trigger clear_screen_call
	rts

clear_colors
	ldx #$03
	ldy #$08
	lda #$00
	jmp fill

clear_chars_set_24_rows
	jsr set_24_rows
clear_chars
	trigger clear_chars_call
	rts
	
clear_chars_call
	ldx #$03
	ldy #$0C
	lda #$00
	jmp fill

clear_chars_and_set_defaults
	jsr default_irq
	;
	jsr clear_chars
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
	lda #charset >> 8
	sta $FF13
	;
	rts

set_txt_2x2_magazine
	set16 txt_2x2_src, txt_2x2_magazine
	rts

set_txt_oldies
	set16 small_txt_src, small_txt_oldies
	set16 txt_2x2_src, txt_2x2_oldies
	rts

set_txt_2x2_converted
	set16 txt_2x2_src, txt_2x2_converted
	;set16 small_txt_src, small_txt_converted
	rts

set_txt_2x2_map
	set16 txt_2x2_src, txt_2x2_map
	rts

screen_on
	lda #$1B
	sta $FF06
	rts
	
set_24_rows
	lda #$17
	db $2C
set_25_rows
	lda #$1B
	sta $FF06
	rts

clear_map_colors
	lda #$0B
	sta $FF06
	trigger clear_map_colors_call
	rts

clear_map_colors_call
	ldx #$00
	ldy #$08
	lda #$46
	jsr fill
	;
	ldx #$02
	ldy #$09
	lda #$79
	jmp fill

clear_map_chars
	trigger clear_map_chars_call
	rts

clear_map_chars_call
	ldx #$00
	ldy #$0C
	lda #$00
	jsr fill
	;
	ldx #$02
	ldy #$0D
	lda #$21
	jsr fill
	;
	ldx #39
cmc_01	lda #$FB
	sta $0C00 + 24 * 40,x
	lda #$5F
	sta $0C00 +  3 * 40,x
	lda #MAP_BACKGROUND_COLOR
	sta $0800 +  3 * 40,x
	;
	lda #$00
	sta $0C00 +  6 * 40,x
	sta $0C00 +  7 * 40,x
	sta $0C00 +  8 * 40,x
	sta $0C00 +  9 * 40,x
	dex
	bpl cmc_01
	;
	rts

draw_map_status
	ldx #39
dms_01	lda #$71
	sta $0800 +  0 * 40,x
	sta $0800 +  1 * 40,x
	sta $0800 +  2 * 40,x
	lda map_status_bar,x
	sta $0C00 +  0 * 40,x
	lda map_status_bar + 40,x
	sta $0C00 +  1 * 40,x
	lda #$00
	sta $0C00 +  2 * 40,x
	dex
	bpl dms_01
	rts

setup_map
	lda #$1B
	sta $FF06
	;
	lda $FF07
	and #$40
	ora #$90				; 38 column mode
	sta $FF07
	;
	lda #c64_font >> 8
	sta $FF13
	;
	lda #$00
	sta $FF15
	;
	lda #$41
	sta $FF16
	lda #MAP_BACKGROUND_COLOR
	sta $FF17
	;
	lda #$1C
	ldx #irq_map_1 & 255
	ldy #irq_map_1 >> 8
	jsr set_irq1_next
	;
	lda #$2C				; BIT $nnnn opcode
	sta reset_ff14_at_bottom		; disable
	;
	set16 c64_map_src, c64_map
	;
	lda #$16
	sta pen_color
	;
	rts

start_twinkle_irq
	lda #$3A
	pha
	clc
	adc #$28				; move down by 5 character lines for next IRQ
	sta start_twinkle_irq+1
	pla
	;
	ldx #irq_twinkle_1 & 255
	ldy #irq_twinkle_1 >> 8
	bne set_irq1_next	

start_names_irq
	lda #$00
	sta names_scroll_x1			; ensure $FF07 gets set properly
	eor #$07
	sta names_scroll_x2
	;
	lda #$8D				; STA $nnnn opcode
	sta black_screen_at_bottom		; enable switching back the screen background to black in the bottom IRQ call
	;
	lda #$32
	ldx #irq_names_1 & 255
	ldy #irq_names_1 >> 8
	bne set_irq1_next
	;
stop_kefrens_irq
	lda #$2C				; BIT opcode
	sta kefrens_bottom_call			; disable call
	bne default_irq
	;
start_kefrens_irq
	lda #$20				; JSR opcode
	sta kefrens_bottom_call			; enable call
	;
	lda $FF07
	ora #$10				; turn on multicolor
	sta $FF07
	;
	lda #$01
	ldx #irq_kefrens & 255
	ldy #irq_kefrens >> 8
	bne set_irq1_next
	;
start_fld_irq
	lda #$8D				; STA $nnnn opcode
	sta reset_ff06_at_bottom		; enable
	;
	lda #$11
	ldx #irqfld & 255
	ldy #irqfld >> 8
	bne set_irq1_next
	;
default_irq
	lda #RL_IRQ_BOTTOM
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
set_irq1_next
	sta irq1_next+1
	stx irq1_next+3
	sty irq1_next+5
	rts

curtain_close_init_thai
	lda #RL_IRQ_BOTTOM
	sta irq_thai2_rl+1
	;
	lda #$04
	sta ccoc_char+1
curtain_close_init
	lda #$00
	sta curtain_close+1
curtain_close
	lda #$00
	jsr curtain_close_one_column
	;
	lda #39
	sec
	sbc curtain_close+1 
	inc curtain_close+1
	;
curtain_close_one_column
	sta dst_ptr
	sta col_dst
	;
	lda #$0C
	sta dst_ptr+1
	and #$FB
	sta col_dst+1
	;
	ldx #24
	ldy #$00
ccoc_01	lda #$00
	sta (col_dst),y
ccoc_char
	lda #$5F
	sta (dst_ptr),y
	;
	add16 col_dst, #40
	add16 dst_ptr, #40
	dex
	bpl ccoc_01
	;
	rts

set_color_32
	trigger set_color_32_call
	rts

set_color_32_call
	ldx #$03
	ldy #$08
	lda #$32
	jmp fill

draw_big_no
	trigger draw_big_no_call
	lda #$0B
	sta $FF06
	rts
	
draw_big_no_call
	;dec $FF19
	ldy #$09
dbo_01	lda big_no_vert,y
	sta $0C00 + 2 * 40 + 35,y
	sta $0C00 + 3 * 40 + 15,y
	sta $0C00 + 3 * 40 + 35,y
	sta $0C00 + 4 * 40 + 15,y
	sta $0C00 + 4 * 40 + 35,y
	sta $0C00 + 5 * 40 + 15,y
	sta $0C00 + 5 * 40 + 35,y
	sta $0C00 + 6 * 40 + 15,y
	sta $0C00 + 6 * 40 + 35,y
	sta $0C00 + 7 * 40 + 15,y
	sta $0C00 + 7 * 40 + 35,y
	sta $0C00 + 8 * 40 + 15,y
	sta $0C00 + 8 * 40 + 35,y
	sta $0C00 + 9 * 40 + 15,y
	sta $0C00 + 9 * 40 + 35,y
	sta $0C00 +10 * 40 + 15,y
	sta $0C00 +10 * 40 + 35,y
	sta $0C00 +11 * 40 + 15,y
	sta $0C00 +11 * 40 + 35,y
	sta $0C00 +12 * 40 + 15,y
	sta $0C00 +12 * 40 + 35,y
	sta $0C00 +13 * 40 + 15,y
	sta $0C00 +13 * 40 + 35,y
	sta $0C00 +14 * 40 + 15,y
	sta $0C00 +14 * 40 + 35,y
	sta $0C00 +15 * 40 + 15,y
	sta $0C00 +15 * 40 + 35,y
	sta $0C00 +16 * 40 + 15,y
	sta $0C00 +16 * 40 + 35,y
	sta $0C00 +17 * 40 + 15,y
	sta $0C00 +17 * 40 + 35,y
	sta $0C00 +18 * 40 + 15,y
	sta $0C00 +18 * 40 + 35,y
	sta $0C00 +19 * 40 + 15,y
	sta $0C00 +19 * 40 + 35,y
	sta $0C00 +20 * 40 + 15,y
	sta $0C00 +20 * 40 + 35,y
	sta $0C00 +21 * 40 + 15,y
	sta $0C00 +21 * 40 + 35,y
	sta $0C00 +22 * 40 + 15,y
	sta $0C00 +22 * 40 + 35,y
	sta $0C00 +23 * 40 + 15,y
	sta $0C00 +23 * 40 + 35,y
	;
	lda #$61
	sta $0C00 + 0 * 40 +  5,y
	sta $0C00 + 0 * 40 + 25,y
	sta $0C00 +20 * 40 + 25,y
	lda #$5F
	sta $0C00 + 1 * 40 +  5,y
	sta $0C00 + 1 * 40 + 25,y
	sta $0C00 +21 * 40 + 25,y
	sta $0C00 + 2 * 40 +  5,y
	sta $0C00 + 2 * 40 + 25,y
	sta $0C00 +22 * 40 + 25,y
	sta $0C00 + 3 * 40 +  5,y
	sta $0C00 + 3 * 40 + 25,y
	sta $0C00 +23 * 40 + 25,y
	lda #$66
	sta $0C00 + 4 * 40 +  5,y
	sta $0C00 + 4 * 40 + 25,y
	sta $0C00 +24 * 40 + 25,y
	;
	dey
	bmi dbo_02
	jmp dbo_01
dbo_02	;
	ldy #$04
dbo_03	lda big_no_bottom,y
	sta $0C00 +24 * 40 +  0,y
	sta $0C00 +24 * 40 + 15,y
	dey
	bpl dbo_03
	;
	jsr write_big_letter
	jsr write_big_letter
	jsr write_big_letter
	;
	jsr write_big_letter
	jsr write_big_letter
	jsr write_big_letter
	;
	;inc $FF19
	;
	rts

scroll_map
	lda scroll_speed+1
	eor #$03
	sta scroll_speed+1
	; 
	lda map_scroll_x
	sec
scroll_speed
	sbc #1
	bmi sm_03
	sta map_scroll_x
	rts
	;
sm_03	clc
	adc #8
	sta map_scroll_x 
	;
	trigger scroll_map_call
	;
	rts

scroll_map_call
	ldx #0
sm_01	lda $0800 + 12 * 40 + 1,x
	sta $0800 + 12 * 40 + 0,x
	lda $0800 + 13 * 40 + 1,x
	sta $0800 + 13 * 40 + 0,x
	lda $0800 + 14 * 40 + 1,x
	sta $0800 + 14 * 40 + 0,x
	lda $0800 + 15 * 40 + 1,x
	sta $0800 + 15 * 40 + 0,x
	lda $0800 + 16 * 40 + 1,x
	sta $0800 + 16 * 40 + 0,x
	lda $0800 + 17 * 40 + 1,x
	sta $0800 + 17 * 40 + 0,x
	lda $0800 + 18 * 40 + 1,x
	sta $0800 + 18 * 40 + 0,x
	lda $0800 + 19 * 40 + 1,x
	sta $0800 + 19 * 40 + 0,x
	lda $0800 + 20 * 40 + 1,x
	sta $0800 + 20 * 40 + 0,x
	lda $0800 + 21 * 40 + 1,x
	sta $0800 + 21 * 40 + 0,x
	lda $0800 + 22 * 40 + 1,x
	sta $0800 + 22 * 40 + 0,x
	lda $0800 + 23 * 40 + 1,x
	sta $0800 + 23 * 40 + 0,x
	;
	lda $0C00 + 12 * 40 + 1,x
	sta $0C00 + 12 * 40 + 0,x
	lda $0C00 + 13 * 40 + 1,x
	sta $0C00 + 13 * 40 + 0,x
	lda $0C00 + 14 * 40 + 1,x
	sta $0C00 + 14 * 40 + 0,x
	lda $0C00 + 15 * 40 + 1,x
	sta $0C00 + 15 * 40 + 0,x
	lda $0C00 + 16 * 40 + 1,x
	sta $0C00 + 16 * 40 + 0,x
	lda $0C00 + 17 * 40 + 1,x
	sta $0C00 + 17 * 40 + 0,x
	lda $0C00 + 18 * 40 + 1,x
	sta $0C00 + 18 * 40 + 0,x
	lda $0C00 + 19 * 40 + 1,x
	sta $0C00 + 19 * 40 + 0,x
	lda $0C00 + 20 * 40 + 1,x
	sta $0C00 + 20 * 40 + 0,x
	lda $0C00 + 21 * 40 + 1,x
	sta $0C00 + 21 * 40 + 0,x
	lda $0C00 + 22 * 40 + 1,x
	sta $0C00 + 22 * 40 + 0,x
	lda $0C00 + 23 * 40 + 1,x
	sta $0C00 + 23 * 40 + 0,x
	inx
	cpx #39
	beq sm_02
	jmp sm_01
	;
sm_02	ldy #0
	lda (c64_map_src),y
	sta $0C00 + 12 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 13 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 14 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 15 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 16 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 17 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 18 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 19 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 20 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 21 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 22 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0C00 + 23 * 40 + 39
	;
	iny
	lda (c64_map_src),y
	sta $0800 + 12 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 13 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 14 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 15 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 16 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 17 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 18 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 19 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 20 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 21 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 22 * 40 + 39
	iny
	lda (c64_map_src),y
	sta $0800 + 23 * 40 + 39
	;
	add16 c64_map_src, #24
	;
	; check if wrapped
	;
	lda c64_map_src
	cmp #c64_map_end & 255
	bne sm_04
	lda c64_map_src+1
	cmp #c64_map_end >> 8
	bne sm_04
	;
	set16 c64_map_src, c64_map_loop
	;
sm_04	rts 

scroll_map_write_2x2_letter
	jsr scroll_map
	;
	inc smwl_delay+1
smwl_delay
	lda #$00
	and #$01
	bne sm_04
	;
write_single_2x2_letter
	ldy #$00
smwl_02	lda (txt_2x2_src),y
	bpl smwl_01
	;
	cmp #$FF
	beq smwl_03
	;
	iny
	and #$7F
	sta pen_color
	jmp smwl_02
	;
smwl_03	iny
	lda (txt_2x2_src),y
	sta dst_ptr
	sta col_dst
	iny
	lda (txt_2x2_src),y
	sta dst_ptr+1
	and #$FB
	sta col_dst+1
	iny
	bne smwl_02
	;
smwl_01	tax
	;
	iny
	tya
	clc
	adc txt_2x2_src
	sta txt_2x2_src 
	bcc *+4
	inc txt_2x2_src+1
	;
	ldy #$00
	jmp write_2x2_letter

start_speech_irq
	lda #$4B
	ldx #irq_speech & 255
	ldy #irq_speech >> 8
	jmp set_irq1_next

invert_small_font
	trigger invert_small_font_call
	rts

invert_small_font_call
	ldx #$00
isfc_01	lda charset + $0400,x
	eor #$FF
	sta charset + $0400,x
	lda charset + $0480,x
	eor #$FF
	sta charset + $0480,x
	lda charset + $0500,x
	eor #$FF
	sta charset + $0500,x
	inx
	bpl isfc_01
	rts

start_draw_gb
	trigger gb_unpack
	;
	lda #$0B				; screen off
	sta $FF06
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07				; reset $FF07 after wave
	;
	lda #($1000) >> 8			; gb charset
	sta $FF13
	;
	lda #$6D
	sta $FF15
	;
	jmp default_irq

gb_unpack
	set16 dst_ptr, $1001
	set16 src_ptr, gb_comp_start
	ldx #(gb_comp_end - gb_comp_start) >> 8
	ldy #$00
gu_01	lda (src_ptr),y
	sta (dst_ptr),y
	iny
	bne gu_01
	inc src_ptr+1
	inc dst_ptr+1
	dex
	bpl gu_01
	jmp $100D

scroll_map_fade_text
	jsr scroll_map
	;
	inc smft_delay+1
smft_delay
	lda #$00
	and #$03
	bne smft_02
	;
	lda $0800 + 5*40 + 20
	clc
	adc #$10
	
	ldx #39
smft_01	sta $0800 + 5*40,x
	sta $0800 + 6*40,x 
	sta $0800 + 7*40,x
	sta $0800 + 8*40,x
	dex
	bpl smft_01
smft_02	rts

show_magazine_gfx
	lda #$3B				; turn graphics mode on (and restore 25 rows)
	sta $FF06
	;
	lda $FF07				; PAL/NTSC friendly
	and #$40
	ora #$18				; $18 = multicolor
	sta $FF07
	;
	lda $FF12
	and #$03				; keep lowest 2 bits (sound)	
	ora #(BITMAP) >> 10			; bitmap address
	sta $FF12
	;
	lda #(magazine_gfx) >> 8		; color map address
	sta $FF14
	;
	lda #$71
	sta $FF16
	;
	lda #$43
	ldx #irq_mag & 255
	ldy #irq_mag >> 8
	jmp set_irq1_next

show_map_bitmap
	lda #$3B				; turn graphics mode on
	sta $FF06
	;
	lda $FF07				; PAL/NTSC friendly
	and #$40
	ora #$18				; $18 = multicolor
	sta $FF07
	;
	lda $FF12
	and #$03				; keep lowest 2 bits (sound)	
	ora #(BITMAP) >> 10			; bitmap address
	sta $FF12
	;
	lda #(magazine_gfx) >> 8		; color map address
	sta $FF14
	;
	lda #$71
	sta $FF16
	rts

graphics_off_24_rows
	lda #$17
	sta $FF06
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	lda #$08
	sta $FF14
	rts

stop_fld_clear_bitmap
	lda #$2C
	sta reset_ff06_at_bottom		; disable
	;
	jsr default_irq
	;
	trigger clear_bitmap_call
	rts

clear_bitmap_call
	ldx #$03
	ldy #LUMMAP >> 8
	lda #(MAP_BACKGROUND_COLOR & $F0) >> 4
	jsr fill
	;
	ldx #$03
	ldy #(LUMMAP >> 8) + 4
	lda #(MAP_BACKGROUND_COLOR & $0F) << 4
	jsr fill
	;
	ldx #$1F
	ldy #BITMAP >> 8
	lda #$55
	jmp fill

map_to_bitmap_and_wol
	jsr map_to_bitmap
	jmp c5_write_one_letter

map_to_bitmap_init
	set16 c64_map_src, c64_map_loop
	set16 dst_ptr, BITMAP + 12 * $140
	set16 col_dst, LUMMAP + 12 * 40
	;
map_to_bitmap
	;
	; 12 chars
	lda #0
	sta area_height
	;
mtb_02	ldy area_height
	lda (c64_map_src),y
	sta src_ptr
	lda #c64_font >> (8+3)
	sta src_ptr+1
	;
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	;
	ldy #$07
	db $B3, src_ptr 			; LAX ($nn),Y opcode
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 			; LAX ($nn),Y opcode
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 
	lda bit_swap_table,x 
	sta (dst_ptr),y
	dey
	db $B3, src_ptr 
	lda bit_swap_table,x 
	sta (dst_ptr),y
	;
	lda dst_ptr
	clc
	adc #$40
	sta dst_ptr
	lda dst_ptr+1
	adc #$01
	sta dst_ptr+1
	;
	inc area_height
	lda area_height
	cmp #12
	bne mtb_02
	;
	; ---
	;
	add16 c64_map_src, #12
	;
	ldx #$00
mtb_05	txa
	tay
	lda (c64_map_src),y
	pha
	and #$F0
	ora #((MAP_BACKGROUND_COLOR & $F0) >> 4)
	ldy #$00
	sta (col_dst),y
	lda col_dst+1
	ora #$04
	sta col_dst+1
	pla
	and #$07
	ora #((MAP_BACKGROUND_COLOR & $0F) << 4)
	sta (col_dst),y
	lda col_dst+1
	and #$FB
	sta col_dst+1
	;
	add16 col_dst, #40
	;
	inx
	cpx #12
	bne mtb_05
	;
	lda col_dst
	sec
	sbc #(12*40-1) & 255
	sta col_dst
	lda col_dst+1
	sbc #(12*40-1) >> 8
	sta col_dst+1
	;
	; ---
	;
	add16 c64_map_src, #12
	;
	lda c64_map_src
	cmp #c64_map_end & 255
	bne mtb_04
	lda c64_map_src+1
	cmp #c64_map_end >> 8
	bne mtb_04
	;
	set16 c64_map_src, c64_map_loop
	;
mtb_04	; ---
	;
	ldy #$00
	lda #$FF
	sta (dst_ptr),y
	iny
	sta (dst_ptr),y
	iny
	lda #$00
mtb_08	sta (dst_ptr),y
	iny
	cpy #8
	bne mtb_08
	;
	; ---
	;
	lda dst_ptr
	sec
	sbc #$F8
	sta dst_ptr
	lda dst_ptr+1
	sbc #$0E
	sta dst_ptr+1
	;
	rts

stop
	sei
	sta $FF3E
	lda #$00
	sta $FF11
	jmp $f445
	
	;
	; **************************************
	;
	include "sine_wipe.asm"

init_sine_wipe
	lda #RL_IRQ_BOTTOM - 8			; "pull up" bottom IRQ
	sta irq1_next+1				; otherwise the effect wouldn't fit into NTSC rastertime
	;
	lda #$00
	sta rv_idx
do_sine_wipe
	jmp rv_call
	
	include "sbs_raster.asm"

	include "timeline.asm"
	
nothing
	lda #$BF				; "fast forward" function
	sta $FD30
	sta $FF08
	lda $FF08
	and #$08				; Query keyboard for Cursor Right
	bne cursor_right_not_pressed
	;
	lda timeline_delay			; if timeline delay not on zero
	ora timeline_delay+1
	beq cursor_right_not_pressed
	;
timeline_delay_to_zero
	lda #$00				; then set it to zero            
	sta timeline_delay
	sta timeline_delay+1
	;
cursor_right_not_pressed
	rts
	
prepare_dycp_font
	trigger prepare_dycp_font_call
	rts

prepare_dycp_font_call
	;dec $FF19
	set16 dst_ptr, DYCP_FONT
	ldx #$07
	ldy #$00
	tya
pdfc_01	sta (dst_ptr),y
	iny
	bne pdfc_01
	inc dst_ptr+1
	dex
	bpl pdfc_01
	;
	set16 dst_ptr, DYCP_FONT
	ldx #$00
pdfc_03	lda dycp_letters,x
	sta src_ptr
	lda #$00
	sta src_ptr+1
	;
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	;
	lda src_ptr+1
	ora #charset >> 8
	sta src_ptr+1
	;
	ldy #$07
pdfc_02	lda (src_ptr),y
	sta (dst_ptr),y
	dey
	bpl pdfc_02
	;
	add16 dst_ptr, #8
	;
	inx
	cpx #$10
	bne pdfc_03
	;
	; ---
	;
	set16 dst_ptr, DYCP_FONT + $80 + 1
	set16 col_dst, DYCP_FONT + $480 - 7
	lda #7
pdfc_07	sta area_height
	;
	set16 src_ptr, DYCP_FONT
	;
	ldx #$0F
pdfc_06	ldy #$00
pdfc_04	lda (src_ptr),y
	sta (dst_ptr),y
	iny
	cpy area_height
	bne pdfc_04
	;
pdfc_05	lda (src_ptr),y
	sta (col_dst),y
	iny
	cpy #$08
	bne pdfc_05
	;
	add16 src_ptr, #8
	add16 dst_ptr, #8
	add16 col_dst, #8
	dex
	bpl pdfc_06
	;
	add16 dst_ptr, #1
	add16 col_dst, #1
	;
	lda area_height
	sec
	sbc #$01
	bne pdfc_07
	;
	;inc $FF19
	;
	rts

	; ---------------------------------------
dycp_init
	trigger dycp_init_call
	rts

dycp_init_call
;	ldx #(dycp_sine_end-dycp_sine_orig)
;dil2	lda dycp_sine_orig,x
;	sta dycp_sine_end,x
;	dex
;	bpl dil2
	;
	ldx #$00
dil1	lda dycp_sine_orig,x
	and #$07
	asl a
	asl a
	asl a
	asl a
	sta sine_bit,x
	lda dycp_sine_orig,x
	and #$F8
	sta m8+1
	sta src_ptr
	lda #$00
	sta src_ptr+1
	;
	asl src_ptr
	rol src_ptr+1
	asl src_ptr
	rol src_ptr+1
	;
	lda src_ptr
	clc
m8	adc #$00
	sta src_ptr
	;
	lda src_ptr+1
	adc #$00
	sta src_ptr+1
	;
	lda src_ptr				; dycp screen top addr
	adc #($0C00 + 3 * 40) & 255
	sta sine_lo,x
	lda #($0C00 + 3 * 40) >> 8
	adc src_ptr+1
	sta sine_hi,x
	inx
	bne dil1
	;
	lda #$00
	sta dycp_scroll_x
	;
	rts

;set_dycp_colors
;	ldx #39
;dpr_2	lda #$6B
;	sta $0800 + 1 * 40,x
;	lda #$62
;	sta $0800 + 2 * 40,x
;	sta $0800 + 3 * 40,x
;	lda #$68
;	sta $0800 + 4 * 40,x
;	sta $0800 + 5 * 40,x
;	lda #$69
;	sta $0800 + 6 * 40,x
;	sta $0800 + 7 * 40,x
;	lda #$67
;	sta $0800 + 8 * 40,x
;	sta $0800 + 9 * 40,x
;	dex
;	bpl dpr_2
;	;
;	rts
	;
	; ---
	;
dycp_render_speedup
	lda #$05
	sta dycp_speed+1
dycp_render
	lda dycp_speed+1
	eor #$03
	sta dycp_speed+1
	;
	lda dycp_scroll_x
	sec
dycp_speed
	sbc #$01
	bpl no_dycp_step
	;
	inc dycp_text_ptr+1
	;
	and #$07
	;
no_dycp_step
	sta dycp_scroll_x
	;
	lda sine1+1
	clc
	adc #$01
	cmp #(dycp_sine_end-dycp_sine_orig)
	bne *+4
	lda #$00
	sta sine1+1
	sta sine2+1
	sta sine3+1
	;
	ldx #39
dycp_loop
	txa
	clc
sine1	adc sine_lo,x
	sta dycp_chr_ptr
sine2	lda sine_hi,x
	adc #$00
	sta dycp_chr_ptr+1
	;
	ldy #0
	lda #$80				; space char (in the dycp font)
	sta (dycp_chr_ptr),y
	ldy #120
	sta (dycp_chr_ptr),y
	;
dycp_text_ptr
	lda dycp_text,x
	bmi dycp_space
	;
	ldy #40
	clc
sine3	adc sine_bit,x
	sta (dycp_chr_ptr),y
	;
	ldy #80
	ora #$80
	sta (dycp_chr_ptr),y
	;
	dex
	bpl dycp_loop
	bmi dycp_loop_end
	;
dycp_space
	ldy #40
	lda #$80				; space char (in the dycp font)
	sta (dycp_chr_ptr),y 
	ldy #80
	sta (dycp_chr_ptr),y 
	;
	dex
	bpl dycp_loop 
	;
	; ---
	;
dycp_loop_end
	;
	rts

start_gb_irq
	lda #$22
	ldx #irq_gb_1 & 255
	ldy #irq_gb_1 >> 8
	jmp set_irq1_next

	;
	; **************************************
	;
sbs_prep
	jsr default_irq
	;
	lda #$0B				; screen off
	sta $FF06
	;
	lda #charset >> 8			; reset charset
	sta $FF13
	;
	lda #$00				; background to black
	sta $FF15
	;
	rts

sbs_init
	lda #SBS_BREAKPOINT
	ldx #irq_sbs & 255
	ldy #irq_sbs >> 8
	jsr set_irq1_next
	;
	lda #letter_space & 255
	sta sbs_letter_data_ptr
	lda #letter_space >> 8
	sta sbs_letter_data_ptr+1
	;
	lda #sbs_scrolltext & 255
	sta sbs_scrolltext_ptr
	lda #sbs_scrolltext >> 8
	sta sbs_scrolltext_ptr+1
	;
	lda #$8D				; STA $nnnn opcode
	sta reset_ff14_at_bottom		; enable
	;
	lda #$1B
	sta $FF06				; screen on
	;
	rts

sbs_raster_fade_in
	ldx #$00
	inc sbs_raster_fade_in+1
	lda sbs_fade_colors,x
	cpx #16
	bcs srfi_01
	sta sbs_color_1+1
	sta sbs_color_3+1
srfi_01	sta sbs_color_2+1
	;
	rts

sbs_raster_fade_out
	ldx #29
	dec sbs_raster_fade_out+1
	lda sbs_fade_colors,x
	cpx #16
	bcs srfo_01
	sta sbs_color_1+1
	sta sbs_color_3+1
srfo_01	sta sbs_color_2+1
	;
	rts


copy_why
	trigger copy_why_call
	rts

copy_why_call
	ldx #$00
cw_01	lda $0C00,x
	sta $2400,x
	lda $0D00,x
	sta $2500,x
	lda #$00
	sta $0C00,x
	sta $0D00,x
	sta $2000,x
	sta $2100,x 
	inx
	bne cw_01
	rts

	;
	; *************************************
	;
bigscroll_unpack
	lda #$0B
	sta $FF06
	trigger bigscroll_unpack_call
	rts

bigscroll_unpack_call
	set16 dst_ptr, $1001
	set16 src_ptr, bigscroll_comp_start
	ldx #(bigscroll_comp_end - bigscroll_comp_start) >> 8
	ldy #$00
bu_01	lda (src_ptr),y
	sta (dst_ptr),y
	iny
	bne bu_01
	inc src_ptr+1
	inc dst_ptr+1
	dex
	bpl bu_01
	jmp $100D

bigscroll_start
	lda #$3B
	sta $FF06
	;
	lda $FF07
	and #$40
	ora #$18
	sta $FF07
	;
	lda $FF12
	and #$03
	ora #(BITMAP >> 10)
	sta $FF12
	;
	lda #$00
	sta $DA					; big scroll pos. init
	;
	trigger $4100
	;
	rts

set_last_page
	set16 small_txt_src, small_last
	set16 txt_2x2_src, txt_2x2_last
	set16 big_txt_src, big_last
	rts

save_charset
	trigger save_charset_call
	rts

restore_charset
	trigger restore_charset_call
	rts

restore_charset_call
	set16 src_ptr, $2000
	set16 dst_ptr, charset
	jmp scc_02

save_charset_call
	set16 src_ptr, charset
	set16 dst_ptr, $2000
	;	
scc_02	ldx #$07
scc_01	lda (src_ptr),y
	sta (dst_ptr),y
	iny
	bne scc_01
	;
	inc src_ptr+1
	inc dst_ptr+1
	dex
	bpl scc_01
	;
	rts

dither_fade_prep
	lda #RL_IRQ_BOTTOM - 16			; "pull up" bottom IRQ
	sta irq1_next+1				; otherwise the effect wouldn't fit into NTSC rastertime
	;
	ldx #$00
	db $2C
	;
dither_fade
	ldx #$00
	lda dither_fade_table,x
	tay
	inx
	lda dither_fade_table,x
	eor #$FF
	sta df_01+1
	inx
	stx dither_fade+1
	;
	set16 dst_ptr, charset
	;
df_03	ldx #$1F
df_02	lda (dst_ptr),y
df_01	and #$00
	sta (dst_ptr),y
	tya
	clc
	adc #8
	tay
	dex
	bpl df_02
	;
	inc dst_ptr+1
	lda dst_ptr+1
	cmp #(charset >> 8) + 6
	bne df_03
	;
	rts

CROSS_OUT_POS = $0C00 + 16 * 40 + 8
CROSS_OUT_WIDTH = 24
cross_out
	lda #$60
	sta CROSS_OUT_POS
	lda #$65
	sta CROSS_OUT_POS + 40
	ldx #CROSS_OUT_WIDTH - 2
co_01	lda #$61
	sta CROSS_OUT_POS + 1,x
	lda #$66
	sta CROSS_OUT_POS + 41,x
	dex
	bpl co_01
	lda #$62
	sta CROSS_OUT_POS + CROSS_OUT_WIDTH - 1
	lda #$67
	sta CROSS_OUT_POS + 40 + CROSS_OUT_WIDTH - 1
	;
	lda #$32
	ldx #CROSS_OUT_WIDTH - 1
co_02	sta CROSS_OUT_POS - $0400,x
	sta CROSS_OUT_POS - $0400 + 40,x
	dex
	bpl co_02
	rts

enable_big_letter_erase
	lda #$24				; BIT $00 opcode
	sta big_letter_erase			; force spaces being written				
	rts

enable_vol_down
	lda #$20
	sta vol_down_call
	rts

vol_down
	lda #$00
	inc vol_down+1
	and #$0F
	bne vd_01
	;
	lda VOLUME
	clc
	adc #9
	sta VOLUME
	;
vd_01	rts

	include "klaxon.asm"

start_klaxon
	lda #0
	sta klaxon_index
	lda #2
	sta klaxon_count
	;
	lda #$2C
	sta player_call_1
	sta player_call_2
	;
	lda #play_sounds & 255
	sta vol_down_call+1
	lda #play_sounds >> 8
	sta vol_down_call+2
	;
	rts 

	include "chars2x2.asm" 
	include "chars5x10.asm"
	
	ds $100
	align 256
	;
	; **************************************
	; DATA
	;
	cmap " ",0
	cmap "A",$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,$90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A
	cmap "!",$9B
	cmap "'",$9C
	cmap "(",$9D
	cmap ")",$9E
	cmap "/",$9F
	cmap ",",$A0
	cmap "-",$A1
	cmap ".",$A2
	cmap "_",$A3
	cmap "0",$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD
	cmap ":",$AE
	cmap "&",$AF
small_txt
	;   0123456789012345678901234567890123456789
	dw $0C00 + 4*40 + 2
	db $71,"IMPOSSIBLE MISSION (1984)",$FF
	dw $0C00 + 6*40 + 2
	db $71,"TIR NA NOG (1985)",$FF
	dw $0C00 + 8*40 + 2
	db $71,"HEAD OVER HEELS (1987)",$FF
	dw $0C00 +10*40 + 2
	db $71,"STUNT CAR RACER (1989)",$FF
	dw $0C00 +12*40 + 2
	db $71,"BARD'S TALE (1985)",$FF
	dw $0C00 +14*40 + 2
	db $71,"ARKANOID (1987)",$FF
	dw $0C00 +16*40 + 2
	db $71,"LASER SQUAD (1989)",$FF
	dw $0C00 +18*40 + 2
	db $71,"DIZZY II (1989)",$FF
	dw $0C00 +20*40 + 2
	db $71,"ONE ON ONE (1984)",$FF
	dw $0C00 +22*40 + 2
	db $71,"GREEN BERET (1986)",$FF
	
	dw $0C00 +21*40 +20
	db $38,"(C16 & PLUS4 OWNERS)",$FF

small_txt_oldies
	;       0123456789012345678901234567890123456789
	dw $0C00 + 1*40 + 9
	db $31,"IT WAS NOT ALL BAD...",$FF
	dw $0C00 + 2*40 + 6
	db $31,"WE DID HAVE SOME REAL GEMS:",$FF
	dw $0C00 + 6*40 + 0
	db $48,"TOM THUMB,",$FF
	dw $0C00 + 6*40 + 11
	db $48,"SUMMER EVENTS,",$FF
	dw $0C00 + 6*40 + 26
	db $48,"WINTER EVENTS",$FF
	dw $0C00 +11*40 + 0
	db $49,"ICICLE WORKS,",$FF
	dw $0C00 +11*40 + 14
	db $49,"FINGERS MALONE,",$FF
	dw $0C00 +11*40 + 30
	db $49,"PROS.PETE",$FF
	dw $0C00 +16*40 + 1
	db $47,"BANDITS AT ZERO,",$FF
	dw $0C00 +16*40 + 18
	db $47,"KIKSTART,",$FF
	dw $0C00 +16*40 + 28
	db $47,"TRAILBLAZER",$FF
	dw $0C00 +21*40 + 0
	db $4A,"RESCUE F.ZYLON,",$FF
	dw $0C00 +21*40 + 16
	db $4A,"MAGICIAN'S CURSE,",$FF
	dw $0C00 +21*40 + 34
	db $4A,"ENIGMA",$FF
	
small_txt_converted
	dw $0C00 + 9*40 + 14
	db $00,"CONVERTED BY",$FF
	
	;  |012345678901234567|
	db $FF
	dw $0C00 + 10 * 40 + 13
	db "UMM, ACTUALLY"
	db $FF
	dw $0C00 + 11 * 40 + 14
	db "GREEN BERET"
	db $FF
	dw $0C00 + 12 * 40 + 13
	db "ALREADY EXISTS"
	db $FF
	dw $0C00 + 13 * 40 + 11
	db "FOR THE C16/PLUS4."

	;
	dw $0C00 + 0*40 + 4
	db $33,"THE BIG PROBLEM IS OBVIOUSLY....",$FF
	
small_last
	dw $0C00 + 2*40 + 16
	db $3D,"IN FACT,",$FF
	dw $0C00 + 3*40 + 12
	db $36,"THIS IS TRUE FOR",$FF
	dw $0C00 + 4*40 + 8
	db $3E,"ALL PARTS OF THE GAME...",$FF
	dw $0C00 +22*40 +15
	db $3E,"IS USEFUL.",$FF
	
	dw $0C00 + 3*40 + 15
	db $46,"PERHAPS  A",$FF
	dw $0C00 + 4*40 + 14
	db $4D,"SIMILAR GAME",$FF
	dw $0C00 + 5*40 + 13
	db $43,"COULD BE CODED",$FF
	dw $0C00 + 6*40 + 14
	db $4C,"FROM SCRATCH,",$FF
	cmap
	
dycp_letters
	;  'a','b','e','f','g','h','i','k','l','n','o','r','s','t','y','.'
	db $81,$82,$85,$86,$87,$88,$89,$8B,$8C,$8E,$8F,$92,$93,$94,$99,$A2

	cmap " ", $80
	cmap "a", 0,1
	cmap "e", 2,3,4,5,6
	cmap "k", 7,8
	cmap "n", 9,10
	cmap "r", 11,12,13
	cmap "y", 14
	cmap ".", 15
	align 256
dycp_text
	db "          "
	db "          "
	db "          "
	db "          "
	db "oh no..."
	db "          "
	db "          "
	db "this looks really terrible."
	db "          "
	db "          "
	db "it is best forgotten..."
	db "          "
	db "          "
	db "          "
	db "          "
	cmap

	cmap " ",0
	cmap "A",1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26
	cmap "!",27
	cmap "'",28
	cmap "(",29
	cmap ")",30
	cmap "*",31
	cmap "+",32
	cmap ",",33
	cmap "-",34
	cmap ".",35
	cmap "/",36
	cmap "0",37,38,39,40,41,42,43,44,45,46
	cmap ":",47
	cmap "?",48
txt_2x2
	db  8,$32,"           YOU",$FF
	db  8,$32,"                   MIGHT",$FF
	db 10,$4B,"           HAVE",$FF
	db 10,$4B,"                     SEEN",$FF
	db 12,$54,"           SOME",$FF
	db 12,$54,"                    THING",$FF
	db 14,$6E,"            LIKE",$FF
	db 14,$6E,"                    THIS:",$FF
txt_2x2_magazine
	db  1,$31,"        GAME CHARTS !",$FF
	
	db  0,$46,"   SO MANY",$FF
	db  2,$56,"  AWESOME",$FF
	db  4,$46,"    GAMES!",$FF
	db 19,$48,"                        CAN WE",$FF
	db 22,$48,"                    PLAY THEM?",$FF

txt_2x2_oldies	
	db  7,$00,"          UDO GERTZ",$FF
	db  7,$58,"           UDO GERTZ",$FF
	db 12,$00,"        DOUG TURNER",$FF
	db 12,$59,"         DOUG TURNER",$FF
	db 17,$00,"     SHAUN SOUTHERN",$FF
	db 17,$57,"      SHAUN SOUTHERN",$FF
	db 22,$00,"      MARK J. MOORE",$FF
	db 22,$5A,"       MARK J. MOORE",$FF
	
	db  0,$47,"                  IN",$FF
	db  2,$57,"                2025",$FF
	db  4,$67,"            HOWEVER...",$FF
	db  6,$67,"    IT'S A COMPLETELY",$FF

txt_2x2_converted
	db  0,$00,"   IMPOSSIBLE  MISSION",$FF
	db 16,$00,"               TCFS",$FF
	db  0,$00,"           TIR NA NOG",$FF
	db 16,$00,"              PIGMY",$FF
	db  0,$00,"      HEAD OVER HEELS",$FF
	db 16,$00,"              MUCSI",$FF
	db  0,$00,"      STUNT CAR RACER",$FF
	db 16,$00,"             COBBPG",$FF
	db  0,$00,"          BARD'S TALE",$FF
	db 16,$00,"              CSORY",$FF
	db  0,$00,"            ARKANOID",$FF
	db 16,$00,"              KICHY",$FF
	db  0,$00,"         LASER  SQUAD",$FF
	db 16,$00,"              TGMS",$FF
	db  0,$00,"              DIZZY II",$FF
	db 16,$00,"         ULYSSES777",$FF
	db  0,$00,"           ONE ON ONE",$FF
	db 16,$00,"             CROWN",$FF
	db  0,$00," ",$FF

	db $FF
	dw $0C00 + 9 * 40 + 8
	db $32+$80
	db "IT'S PARADISE !"
	db $FF
	dw $0C00 + 11 * 40 + 10
	db $42+$80
	db "WE CAN NOW"
	db $FF
	dw $0C00 + 13 * 40 + 7
	db $54+$80
	db "PLAY ALL THOSE"
	db $FF
	dw $0C00 + 15 * 40 + 10
	db $64+$80
	db "C64 GAMES !"
	
	db  8,$32,"              WAIT A",$FF
	db 10,$32,"             MINUTE!",$FF
	db 12,$52,"              DID WE",$FF
	db 14,$52,"           MISS ONE?",$FF
	
txt_2x2_map
	db $FF
	dw $0C00 + 5 * 40 + 11
	db "WOULD YOU"
	db $FF
	dw $0C00 + 7 * 40 + 7
	db "LOOK AT THAT!..." 
	db $FF
	dw $0C00 + 5 * 40 + 7
	db "WE'RE HALFWAY"
	db $FF
	dw $0C00 + 7 * 40 + 8
	db "THERE,  RIGHT?"

txt_2x2_last
	db 6,$44,"     ASIDE FROM A FEW",$FF
	db 8,$4B,"     GRAPHICAL ASSETS,",$FF
	db 18,$4B,"    FROM THE ORIGINAL",$FF
	db 20,$44,"            C64 GAME",$FF

	db 7,$55,"           BUT NO ONE",$FF
	db 9,$5F,"      IS  CRAZY ENOUGH",$FF
	db 11,$5A,"    TO ATTEMPT THAT...",$FF

	align 2
big_txt
	dw ($0C00 + 0 * 40 + 0), $41, big_if
	;
	dw ($0C00 + 0 * 40 +10), $51, big_y_10x8
	dw ($0C00 + 0 * 40 +20), $51, big_o_10x8
	dw ($0C00 + 0 * 40 +30), $51, big_u_10x8
	;
	; opened
	dw ($0C00 + 8 * 40 + 0), $58, big_o_7x8
	dw ($0C00 + 8 * 40 + 7), $58, big_p_7x8
	dw ($0C00 + 8 * 40 +14), $58, big_e_6x8
	dw ($0C00 + 8 * 40 +20), $58, big_n_7x8
	dw ($0C00 + 8 * 40 +27), $58, big_e_6x8
	dw ($0C00 + 8 * 40 +33), $58, big_d_7x8
	;
	dw ($0C00 +16 * 40 +13), $68, big_u_7x8
	dw ($0C00 +16 * 40 +20), $68, big_p_7x8
	;
	; big no (#1)
	dw ($0C00 + 0 * 40 + 0), $32, big_no_tl
	dw ($0C00 + 0 * 40 +20), $32, big_no_tl
	dw ($0C00 + 0 * 40 +15), $32, big_no_tr
	dw ($0C00 + 0 * 40 +35), $32, big_no_tr
	dw ($0C00 +20 * 40 +20), $32, big_no_bl
	dw ($0C00 +20 * 40 +35), $32, big_no_br
	;
	; different
	dw ($0C00 + 8 * 40 + 0), $56, big_d_6x8	; 6
	dw ($0C00 + 8 * 40 + 6), $56, big_i	; 2
	dw ($0C00 + 8 * 40 + 8), $56, big_f_4x8	; 4
	dw ($0C00 + 8 * 40 +12), $56, big_f_4x8	; 4
	dw ($0C00 + 8 * 40 +16), $56, big_e_4x8 ; 4
	dw ($0C00 + 8 * 40 +20), $56, big_r_6x8	; 6
	dw ($0C00 + 8 * 40 +26), $56, big_e_4x8 ; 4
	dw ($0C00 + 8 * 40 +30), $56, big_n_6x8	; 6
	dw ($0C00 + 8 * 40 +36), $56, big_t_4x8	; 4
	;
	; world
	dw ($0C00 +16 * 40 + 0), $46, big_w_8x8
	dw ($0C00 +16 * 40 +16), $46, big_r_8x8
	dw ($0C00 +16 * 40 +24), $46, big_l_8x8
	dw ($0C00 +16 * 40 +32), $46, big_d_8x8
	;
	; where
	dw ($0C00 + 0 * 40 + 0), $41, big_w_8x8
	dw ($0C00 + 0 * 40 + 8), $41, big_h_8x8
	dw ($0C00 + 0 * 40 +16), $41, big_e_8x8
	dw ($0C00 + 0 * 40 +24), $41, big_r_8x8
	dw ($0C00 + 0 * 40 +32), $41, big_e_8x8
	; is my
	dw ($0C00 + 8 * 40 + 5), $31, big_i
	dw ($0C00 + 8 * 40 + 7), $31, big_s_8x8
	dw ($0C00 + 8 * 40 +19), $31, big_m_8x8
	dw ($0C00 + 8 * 40 +27), $31, big_y_8x8
	; beret?
	dw ($0C00 +16 * 40 + 0), $35, big_b_7x8
	dw ($0C00 +16 * 40 + 7), $35, big_e_7x8
	dw ($0C00 +16 * 40 +14), $35, big_r_7x8
	dw ($0C00 +16 * 40 +21), $35, big_e_7x8
	dw ($0C00 +16 * 40 +28), $35, big_t_6x8
	dw ($0C00 +16 * 40 +34), $35, big_question_mark
	;
	; why?
	dw ($0C00 + 2 * 40 + 5), $00, big_w_8x8
	dw ($0C00 + 2 * 40 +13), $00, big_h_8x8
	dw ($0C00 + 2 * 40 +21), $00, big_y_8x8
	dw ($0C00 + 2 * 40 +29), $00, big_question_mark
	; but
	dw ($0C00 + 1 * 40 +10), $00, big_b_7x8
	dw ($0C00 + 1 * 40 +17), $00, big_u_7x8
	dw ($0C00 + 1 * 40 +24), $00, big_t_6x8
	
	; big no (#2)
	dw ($0C00 + 0 * 40 + 0), $32, big_no_tl
	dw ($0C00 + 0 * 40 +20), $32, big_no_tl
	dw ($0C00 + 0 * 40 +15), $32, big_no_tr
	dw ($0C00 + 0 * 40 +35), $32, big_no_tr
	dw ($0C00 +20 * 40 +20), $32, big_no_bl
	dw ($0C00 +20 * 40 +35), $32, big_no_br

	; sprites
	dw ($0C00 + 3 * 40 + 1), $00, big_s_6x8
	dw ($0C00 + 3 * 40 + 7), $00, big_p_6x8
	dw ($0C00 + 3 * 40 +13), $00, big_r_6x8
	dw ($0C00 + 3 * 40 +19), $00, big_i
	dw ($0C00 + 3 * 40 +21), $00, big_t_6x8
	dw ($0C00 + 3 * 40 +27), $00, big_e_6x8
	dw ($0C00 + 3 * 40 +33), $00, big_s_6x8
	
big_last
	; nothing
	dw ($0C00 +10 * 40 + 1), $52, big_n_6x8
	dw ($0C00 +10 * 40 + 7), $52, big_o_6x8
	dw ($0C00 +10 * 40 +13), $52, big_t_6x8
	dw ($0C00 +10 * 40 +19), $52, big_h_6x8
	dw ($0C00 +10 * 40 +25), $52, big_i
	dw ($0C00 +10 * 40 +27), $52, big_n_6x8
	dw ($0C00 +10 * 40 +33), $52, big_g_6x8
	
	; left?
	dw ($0C00 +13 * 40 + 9), $61, big_l_4x8 ; 4
	dw ($0C00 +13 * 40 +13), $61, big_e_4x8 ; 4
	dw ($0C00 +13 * 40 +17), $61, big_f_4x8	; 4
	dw ($0C00 +13 * 40 +21), $61, big_t_4x8	; 4
	dw ($0C00 +13 * 40 +25), $61, big_question_mark
	
	; right?
	dw ($0C00 +13 * 40 + 4), $67, big_r_6x8
	dw ($0C00 +13 * 40 +10), $67, big_i
	dw ($0C00 +13 * 40 +12), $67, big_g_6x8
	dw ($0C00 +13 * 40 +18), $67, big_h_6x8
	dw ($0C00 +13 * 40 +24), $67, big_t_6x8
	dw ($0C00 +13 * 40 +30), $67, big_question_mark

big_no_vert
	db $63,$5F,$5F,$5F,$64,$63,$5F,$5F,$5F,$64
big_no_bottom
	db $65,$66,$66,$66,$67
big_no_tl
	db 5,5
	db $68,$61,$61,$61,$61
	db $63,$5F,$5F,$5F,$5F
	db $63,$5F,$5F,$5F,$5F
	db $63,$5F,$5F,$5F,$5F
	db $63,$5F,$5F,$5F,$5F
big_no_tr
	db 5,5
	db $61,$61,$61,$61,$69
	db $5F,$5F,$5F,$5F,$64
	db $5F,$5F,$5F,$5F,$64
	db $5F,$5F,$5F,$5F,$64
	db $5F,$5F,$5F,$5F,$64
big_no_bl
	db 5,5
	db $63,$5F,$5F,$5F,$5F
	db $63,$5F,$5F,$5F,$5F
	db $63,$5F,$5F,$5F,$5F
	db $63,$5F,$5F,$5F,$5F
	db $6A,$66,$66,$66,$66
big_no_br
	db 5,5
	db $5F,$5F,$5F,$5F,$64
	db $5F,$5F,$5F,$5F,$64
	db $5F,$5F,$5F,$5F,$64
	db $5F,$5F,$5F,$5F,$64
	db $66,$66,$66,$66,$6B

big_if
	db 10,8
	db $60,$62,$00,$00,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$60,$62,$00,$00,$00,$00
	db $63,$64,$00,$00,$63,$64,$00,$00,$00,$00
	db $63,$6C,$61,$61,$6D,$6C,$61,$61,$61,$62
	db $65,$66,$66,$66,$66,$66,$66,$66,$66,$67
	db $60,$61,$61,$61,$61,$61,$61,$61,$61,$62
	db $65,$66,$66,$66,$66,$66,$66,$66,$66,$67

big_b_7x8
	db 7,8
	db $60,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$6B
	db $63,$6E,$66,$66,$66,$6F,$69
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$64
	db $65,$66,$66,$66,$66,$66,$6B
big_d_6x8
	db 6,8
	db $60,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$6C,$61,$61,$6D,$64
	db $65,$66,$66,$66,$66,$6B
big_d_7x8
	db 7,8
	db $60,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$64
	db $65,$66,$66,$66,$66,$66,$6B
big_d_8x8
	db 8,8
	db $60,$61,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$6D,$64
	db $65,$66,$66,$66,$66,$66,$66,$6B
big_e_4x8
	db 4,8
	db $60,$61,$61,$62
	db $63,$6E,$66,$67
	db $63,$64,$00,$00
	db $63,$6C,$62,$00
	db $63,$6E,$67,$00
	db $63,$64,$00,$00
	db $63,$6C,$61,$62
	db $65,$66,$66,$67
big_e_6x8
	db 6,8
	db $60,$61,$61,$61,$61,$62
	db $63,$6E,$66,$66,$66,$67
	db $63,$64,$00,$00,$00,$00
	db $63,$6C,$61,$61,$62,$00
	db $63,$6E,$66,$66,$67,$00
	db $63,$64,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$62
	db $65,$66,$66,$66,$66,$67
big_e_7x8
	db 7,8
	db $60,$61,$61,$61,$61,$61,$62
	db $63,$6E,$66,$66,$66,$66,$67
	db $63,$64,$00,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$62,$00
	db $63,$6E,$66,$66,$66,$67,$00
	db $63,$64,$00,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$61,$62
	db $65,$66,$66,$66,$66,$66,$67
big_e_8x8
	db 8,8
	db $60,$61,$61,$61,$61,$61,$61,$62
	db $63,$6E,$66,$66,$66,$66,$66,$67
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$61,$62,$00
	db $63,$6E,$66,$66,$66,$66,$67,$00
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$61,$61,$62
	db $65,$66,$66,$66,$66,$66,$66,$67
big_f_4x8
	db 4,8
	db $60,$61,$61,$62
	db $63,$6E,$66,$67
	db $63,$64,$00,$00
	db $63,$6C,$62,$00
	db $63,$6E,$67,$00
	db $63,$64,$00,$00
	db $63,$64,$00,$00
	db $65,$67,$00,$00
big_g_6x8
	db 6,8
	db $68,$61,$61,$61,$61,$62
	db $63,$6E,$66,$66,$66,$67
	db $63,$64,$00,$00,$00,$00
	db $63,$64,$00,$60,$61,$62
	db $63,$64,$00,$65,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$6C,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$6B
big_h_6x8
	db 6,8
	db $60,$62,$00,$00,$60,$62
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$6C,$61,$61,$6D,$64
	db $63,$6E,$66,$66,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $65,$67,$00,$00,$65,$67
big_h_8x8
	db 8,8
	db $60,$62,$00,$00,$00,$00,$60,$62
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$6D,$64
	db $63,$6E,$66,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $65,$67,$00,$00,$00,$00,$65,$67
big_i
	db 2,8
	db $60,$62
	db $63,$64
	db $63,$64
	db $63,$64
	db $63,$64
	db $63,$64
	db $63,$64
	db $65,$67
big_l_4x8
	db 4,8
	db $60,$62,$00,$00
	db $63,$64,$00,$00
	db $63,$64,$00,$00
	db $63,$64,$00,$00
	db $63,$64,$00,$00
	db $63,$64,$00,$00
	db $63,$6C,$61,$62
	db $65,$66,$66,$67
big_l_8x8
	db 8,8
	db $60,$62,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$61,$61,$62
	db $65,$66,$66,$66,$66,$66,$66,$67
big_m_8x8
	db 8,8
	db $68,$61,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$6F,$6E,$66,$6F,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $65,$67,$00,$65,$67,$00,$65,$67
big_n_6x8
	db 6,8
	db $68,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $65,$67,$00,$00,$65,$67
big_n_7x8
	db 7,8
	db $68,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $65,$67,$00,$00,$00,$65,$67
big_o_6x8
	db 6,8
	db $68,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$6C,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$6B
big_o_7x8
	db 7,8
	db $68,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$66,$6B
big_o_10x8
	db 10,8
	db $68,$61,$61,$61,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$66,$66,$66,$66,$6B
big_p_6x8
	db 6,8
	db $60,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$6C,$61,$61,$6D,$64
	db $63,$6E,$66,$66,$66,$6B
	db $63,$64,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00
	db $65,$67,$00,$00,$00,$00
big_p_7x8
	db 7,8
	db $60,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$64
	db $63,$6E,$66,$66,$66,$66,$6B
	db $63,$64,$00,$00,$00,$00,$00
	db $63,$64,$00,$00,$00,$00,$00
	db $65,$67,$00,$00,$00,$00,$00
big_r_6x8
	db 6,8
	db $60,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$6F,$64
	db $63,$64,$00,$00,$63,$64
	db $63,$6C,$61,$61,$6D,$6B
	db $63,$6E,$66,$66,$6F,$69
	db $63,$64,$00,$00,$63,$64
	db $63,$64,$00,$00,$63,$64
	db $65,$67,$00,$00,$65,$67
big_r_7x8
	db 7,8
	db $60,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$6B
	db $63,$6E,$66,$66,$66,$6F,$69
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $65,$67,$00,$00,$00,$65,$67
big_r_8x8
	db 8,8
	db $60,$61,$61,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$66,$66,$6F,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$6D,$6B
	db $63,$6E,$66,$66,$66,$66,$6F,$69
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $65,$67,$00,$00,$00,$00,$65,$67
big_s_6x8
	db 6,8
	db $68,$61,$61,$61,$61,$62
	db $63,$6E,$66,$66,$66,$67
	db $63,$64,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$69
	db $6A,$66,$66,$66,$6F,$64
	db $00,$00,$00,$00,$63,$64
	db $60,$61,$61,$61,$6D,$64
	db $65,$66,$66,$66,$66,$6B
big_s_8x8
	db 8,8
	db $68,$61,$61,$61,$61,$61,$61,$62
	db $63,$6E,$66,$66,$66,$66,$66,$67
	db $63,$64,$00,$00,$00,$00,$00,$00
	db $63,$6C,$61,$61,$61,$61,$61,$69
	db $6A,$66,$66,$66,$66,$66,$6F,$64
	db $00,$00,$00,$00,$00,$00,$63,$64
	db $60,$61,$61,$61,$61,$61,$6D,$64
	db $65,$66,$66,$66,$66,$66,$66,$6B
big_t_4x8
	db 4,8
	db $60,$61,$61,$62
	db $65,$6F,$6E,$67
	db $00,$63,$64,$00
	db $00,$63,$64,$00
	db $00,$63,$64,$00
	db $00,$63,$64,$00
	db $00,$63,$64,$00
	db $00,$65,$67,$00
big_t_6x8
	db 6,8
	db $60,$61,$61,$61,$61,$62
	db $65,$66,$6F,$6E,$66,$67
	db $00,$00,$63,$64,$00,$00
	db $00,$00,$63,$64,$00,$00
	db $00,$00,$63,$64,$00,$00
	db $00,$00,$63,$64,$00,$00
	db $00,$00,$63,$64,$00,$00
	db $00,$00,$65,$67,$00,$00
big_u_7x8
	db 7,8
	db $60,$62,$00,$00,$00,$60,$62
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$66,$6B
big_u_10x8
	db 10,8
	db $60,$62,$00,$00,$00,$00,$00,$00,$60,$62
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$66,$66,$66,$66,$6B
big_w_8x8
	db 8,8
	db $60,$62,$00,$60,$62,$00,$60,$62
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$64,$00,$63,$64,$00,$63,$64
	db $63,$6C,$61,$6D,$6C,$61,$6D,$64
	db $6A,$66,$66,$66,$66,$66,$66,$6B
big_y_10x8
	db 10,8
	db $60,$62,$00,$00,$00,$00,$00,$00,$60,$62
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$61,$61,$6D,$64
	db $6A,$66,$66,$66,$6F,$6E,$66,$66,$66,$6B
	db $00,$00,$00,$00,$63,$64,$00,$00,$00,$00
	db $00,$00,$00,$00,$63,$64,$00,$00,$00,$00
	db $00,$00,$00,$00,$65,$67,$00,$00,$00,$00
big_y_8x8
	db 8,8
	db $60,$62,$00,$00,$00,$00,$60,$62
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$64,$00,$00,$00,$00,$63,$64
	db $63,$6C,$61,$61,$61,$61,$6D,$64
	db $6A,$66,$66,$6F,$6E,$66,$66,$6B
	db $00,$00,$00,$63,$64,$00,$00,$00
	db $00,$00,$00,$63,$64,$00,$00,$00
	db $00,$00,$00,$65,$67,$00,$00,$00
big_question_mark
	db 6,8
	db $68,$61,$61,$61,$61,$69
	db $63,$6E,$66,$66,$6F,$64
	db $65,$67,$00,$00,$63,$64
	db $00,$00,$68,$61,$6D,$64
	db $00,$00,$63,$6E,$66,$6B
	db $00,$00,$65,$67,$00,$00
	db $00,$00,$60,$62,$00,$00
	db $00,$00,$65,$67,$00,$00

twinkle_data
	db $88,$89,$8A,$8B,$8C,$8D,$8E,$8F
	db $88,$89,$8A,$8B,$8C,$8D,$8E,$8F
	db $88

names_table
	db  2, 4, 8,12, 16,16,16,15
	db 15,15,14,14, 14,13,13,13
	db 12,12,11,11, 10,10, 9, 9
	db  8, 7, 6, 5,  4, 3, 2, 1

names_mid_fade_in
	db $00,$07,$17,$27,$37,$47

mini_mag_gfx
	db $00,$00,$2E,$2A,$00,$00,$2B,$2A
	db $00,$00,$F5,$BA,$00,$00,$36,$12
	db $00,$00,$AE,$AA,$00,$00,$6D,$2D
	db $00,$00,$98,$B0,$00,$00,$00,$80
	db $00,$00,$2B,$2D,$00,$00,$1E,$27
	db $00,$00,$46,$66,$00,$00,$F2,$53
	db $00,$00,$AC,$F8,$00,$00,$D9,$51
	db $00,$00,$EA,$BC,$00,$00,$AA,$78
	db $00,$00,$2D,$35,$00,$00,$3E,$2B
	db $00,$00,$A9,$70,$00,$00,$7B,$53
	db $00,$00,$94,$B6,$00,$00,$48,$58
	db $00,$00,$C0,$80,$00,$00,$00,$00
	db $00,$00,$22,$37,$00,$00,$25,$34
	db $00,$00,$A6,$34,$00,$00,$26,$92
	db $00,$00,$3B,$59,$00,$00,$50,$50
	db $00,$00,$28,$6C,$00,$00,$00,$00

	db $00,$00,$36,$32,$00,$00,$26,$34
	db $00,$00,$8D,$CC,$00,$00,$93,$D9
	db $00,$00,$9B,$99,$00,$00,$24,$36
	db $00,$00,$40,$60,$00,$00,$D6,$9A
	db $00,$06,$2C,$18,$00,$06,$2C,$18
	db $00,$06,$2C,$18,$00,$00,$00,$00

kefrens_fade_in_colors_1
	db $00,$0F,$1F,$2F,$3F,$4F,$5F,$6F,$7F
kefrens_fade_in_colors_2
	db $00,$00,$01,$07,$17,$27,$37,$47,$57
kefrens_fade_in_colors_3
	db $00,$00,$00,$01,$07,$17,$17,$27,$37

excl_chars
	db $70,$71,$0D,$74,$75
	db $72,$73,$45,$76,$77
excl_colors
	db $61,$61,$32,$61,$61

pixel_and
	db $C0,$F0,$FC,$FF
pixel_ora
	db $3F,$0F,$03,$00
	
speech_bubble_fade_colors
	db $00,$02,$12,$22,$38,$48,$59,$67,$71

dither_fade_table
	db $00, $80
	db $04, $08
	db $00, $08
	db $04, $80
	db $02, $20
	db $06, $02
	db $02, $02
	db $06, $20
	db $00, $20
	db $04, $02
	db $00, $02
	db $04, $20
	db $02, $80
	db $06, $08
	db $02, $08
	db $06, $80
	db $01, $40
	db $05, $04
	db $01, $04
	db $05, $40
	db $03, $10
	db $07, $01
	db $03, $01
	db $07, $10
	db $01, $10
	db $05, $01
	db $01, $01
	db $05, $10
	db $03, $40
	db $07, $04
	db $03, $04
	db $07, $40
	db $00, $40
	db $04, $04
	db $00, $04
	db $04, $40
	db $02, $10
	db $06, $01
	db $02, $01
	db $06, $10
	db $00, $10
	db $04, $01
	db $00, $01
	db $04, $10
	db $02, $40
	db $06, $04
	db $02, $04
	db $06, $40
	db $01, $80
	db $05, $08
	db $01, $08
	db $05, $80
	db $03, $20
	db $07, $02
	db $03, $02
	db $07, $20
	db $01, $20
	db $05, $02
	db $01, $02
	db $05, $20
	db $03, $80
	db $07, $08
	db $03, $08
	db $07, $80
	
	align 256
speech_wave
; 64,3.5,0,0
	db $84,$84,$84,$85,$85,$85,$85,$86,$86,$86,$86,$87,$87,$87,$87,$87
	db $87,$87,$87,$87,$87,$87,$86,$86,$86,$86,$85,$85,$85,$85,$84,$84
	db $84,$83,$83,$82,$82,$82,$82,$81,$81,$81,$81,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$81,$81,$81,$81,$82,$82,$82,$82,$83,$83
	;
	db $84,$84,$84,$85,$85,$85,$85,$86,$86,$86,$86,$87,$87,$87,$87,$87
	db $87,$87,$87,$87,$87,$87,$86,$86,$86,$86,$85,$85,$85,$85,$84,$84
	db $84,$83,$83,$82,$82,$82,$82,$81,$81,$81,$81,$80,$80,$80,$80,$80
	db $80,$80,$80,$80,$80,$80,$81,$81,$81,$81,$82,$82,$82,$82,$83,$83

	align 256
dycp_sine_orig
;80,31.5,0,60
	db $00,$00,$00,$01,$02,$02,$03,$05,$06,$08,$09,$0B,$0D,$0F,$11,$13
	db $16,$18,$1B,$1D,$1F,$22,$24,$27,$29,$2C,$2E,$30,$32,$34,$36,$37
	db $39,$3A,$3C,$3D,$3D,$3E,$3F,$3F,$3F,$3F,$3F,$3E,$3D,$3D,$3C,$3A
	db $39,$37,$36,$34,$32,$30,$2E,$2C,$29,$27,$24,$22,$20,$1D,$1B,$18
	db $16,$13,$11,$0F,$0D,$0B,$09,$08,$06,$05,$03,$02,$02,$01,$00,$00
;48,31.5,0,36	
	db $00,$00,$01,$02,$04,$07,$09,$0C,$10,$13,$17,$1B,$1F,$24,$28,$2C
	db $2F,$33,$36,$38,$3B,$3D,$3E,$3F,$3F,$3F,$3E,$3D,$3B,$38,$36,$33
	db $2F,$2C,$28,$24,$20,$1B,$17,$13,$10,$0C,$09,$07,$04,$02,$01,$00
dycp_sine_end
	; values duplicated once
	db $00,$00,$00,$01,$02,$02,$03,$05,$06,$08,$09,$0B,$0D,$0F,$11,$13
	db $16,$18,$1B,$1D,$1F,$22,$24,$27,$29,$2C,$2E,$30,$32,$34,$36,$37
	db $39,$3A,$3C,$3D,$3D,$3E,$3F,$3F,$3F,$3F,$3F,$3E,$3D,$3D,$3C,$3A
	db $39,$37,$36,$34,$32,$30,$2E,$2C,$29,$27,$24,$22,$20,$1D,$1B,$18
	db $16,$13,$11,$0F,$0D,$0B,$09,$08,$06,$05,$03,$02,$02,$01,$00,$00
	db $00,$00,$01,$02,$04,$07,$09,$0C,$10,$13,$17,$1B,$1F,$24,$28,$2C
	db $2F,$33,$36,$38,$3B,$3D,$3E,$3F,$3F,$3F,$3E,$3D,$3B,$38,$36,$33
	db $2F,$2C,$28,$24,$20,$1B,$17,$13,$10,$0C,$09,$07,$04,$02,$01,$00

gb_fade_colors
	db $00,$01,$0D,$11,$1D,$21,$2D,$31,$3D,$41,$4D,$51,$5D,$61,$6D

sbs_fade_colors
	db $00,$01,$07,$11,$1A,$21,$2A,$31,$3F,$41,$4F,$51,$5F,$61,$6F,$71
	db $73,$63,$6C,$5C,$55,$45,$4F,$3F,$31,$2F,$21,$1F,$11,$0F

	;c64: screen: $4000
	;     font  : $7800
	;     color : $D800 bank default
	include "c64_map.asm"

	cmap "0",$60,$61,$62,$63
	cmap "5",$64
	cmap "A",$65
	cmap "C",$66
	cmap "E",$67
	cmap "G",$68,$69,$6A
	cmap "L",$6B
	cmap "O",$60
	cmap "R",$6C,$6D,$6E
	cmap "V",$6F
map_status_bar
	;  |0123456789012345678901234567890123456789|
	db "  LIVES 2   SCORE   HI  SCORE  STAGE 1  "
	db "           0000250   0003550            "
	cmap
	
	align 256
	include "bit_swap_table.asm"
	
	align 256
fld_sine
; 100,60,0,75
	db $00,$00,$00,$01,$02,$03,$04,$06,$07,$09,$0B,$0E,$10,$13,$16,$19
	db $1C,$1F,$22,$26,$29,$2D,$31,$34,$38,$3C,$40,$44,$47,$4B,$4F,$52
	db $56,$59,$5C,$5F,$62,$65,$68,$6A,$6D,$6F,$71,$72,$74,$75,$76,$77
	db $78,$78,$78,$78,$78,$77,$76,$75,$74,$72,$71,$6F,$6D,$6A,$68,$65
	db $62,$5F,$5C,$59,$56,$52,$4F,$4B,$47,$44,$40,$3C,$38,$34,$31,$2D
	db $29,$26,$22,$1F,$1C,$19,$16,$13,$10,$0E,$0B,$09,$07,$06,$04,$03
	db $02,$01,$00,$00
fld_sine_end

	;
	; *******************************************
	;
base_note = 0
	include "music/!player.asm"
	include "music/!player_data.asm"
	include "music/music.asm"
	
TEST_DELAY = 50
timeline
	dw 1, set_24_rows
	dw 1, write_big_letter			; if
	dw TEST_DELAY, nothing
	dw 3, write_big_letter			; you
	dw TEST_DELAY, nothing
	dw 6, write_big_letter			; opened
	dw TEST_DELAY, nothing
	dw 2, write_big_letter			; up
	dw TEST_DELAY, nothing
	;
	dw 1, show_magazine_gfx
	dw TEST_DELAY, nothing
	dw 7, mag_reveal_1
	dw 20, nothing
	dw 22, mag_reveal_2
	dw 20, nothing
	dw 14, mag_reveal_3   
	dw 20, nothing
	dw 21, mag_reveal_4
	dw TEST_DELAY * 2, nothing
	;
	dw 1, clear_screen
	dw 1, graphics_off_24_rows
	dw 1, write_2x2_text			; you might have seen
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw TEST_DELAY * 2, nothing
	dw 1, scroll_left_and_fade_prep
	dw 14, scroll_left_and_fade
	;
	dw 1, clear_screen_25_rows
	dw 24, draw_magazine_border
	dw 1, set_txt_2x2_magazine
	dw 1, write_2x2_text			; game charts !
	;
	dw 1, write_small
	dw 10, fade_magazine_entry_star_1
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 10, fade_magazine_entry_star_1
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 10, fade_magazine_entry_star_1
	dw TEST_DELAY, nothing
	;
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_2
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_2
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_2
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_2
	dw TEST_DELAY, nothing
	;
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_3
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_3
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw 8, fade_magazine_entry_star_1
	dw 2, fade_magazine_entry_star_3
	dw TEST_DELAY, nothing
	;
	dw TEST_DELAY, nothing
	dw 1, curtain_close_init
	dw 19, curtain_close
	;
	dw 1, clear_screen_and_black_screen
	dw 1, set_24_rows
	dw 1, copy_flamingo_chars
	dw 22, draw_1_flamingo
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 1, write_2x2_text_awesome
	dw 1, write_2x2_text
	dw TEST_DELAY * 2, nothing
	dw 1, write_2x2_text
	dw 1, write_small
	dw 1, write_2x2_text
	dw TEST_DELAY * 3, nothing
	;
	dw 1, clear_screen
	dw 1, draw_big_no
	dw 1, set_color_32
	dw 1, screen_on
	;
	dw TEST_DELAY * 3, nothing
	;
	dw 1, show_thai_boxing
	dw 1000, wait_for_completion		; wait for unpack to finish
	dw 1, screen_on
	;              
	dw 1, trigger_dxycp_prep
	dw 1000, wait_for_completion		; wait for prep to finish
	;
	dw 60, dxycp_render_letter
	dw 1, thai_draw_kick
	dw 60, dxycp_render_letter
	dw 1, thai_draw_stand
	dw 60, dxycp_render_letter
	dw 1, thai_draw_kick
	dw 60, dxycp_render_letter
	dw 1, thai_draw_stand
	dw 60, dxycp_render_letter
	dw 1, thai_draw_kick
	dw 60, dxycp_render_letter
	;
	dw 1, curtain_close_init_thai
	dw 19, curtain_close
	dw 1, reset_after_thai
	;
	dw 1, set_txt_oldies
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	;
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 1, start_twinkle_irq
	dw 1, render_2x2
	dw 1000, wait_for_completion		; wait for render to finish
	dw 1, show_twinkle_init
	dw 31, show_twinkle
	dw 1, remove_twinkle			; stop irq and replace text
	dw TEST_DELAY, nothing
	;
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 1, start_twinkle_irq
	dw 1, render_2x2
	dw 1000, wait_for_completion		; wait for render to finish
	dw 1, show_twinkle_init
	dw 31, show_twinkle
	dw 1, remove_twinkle			; stop irq and replace text
	dw TEST_DELAY, nothing
	;
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 1, start_twinkle_irq
	dw 1, render_2x2
	dw 1000, wait_for_completion		; wait for render to finish
	dw 1, show_twinkle_init
	dw 31, show_twinkle
	dw 1, remove_twinkle			; stop irq and replace text
	dw TEST_DELAY, nothing
	;
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 1, start_twinkle_irq
	dw 1, render_2x2
	dw 1000, wait_for_completion		; wait for render to finish
	dw 1, show_twinkle_init
	dw 31, show_twinkle
	dw 1, remove_twinkle			; stop irq and replace text
	dw TEST_DELAY, nothing
	dw 1, wipe_upwards_init
	dw 24, wipe_upwards
	;
	dw 1, setup_world
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 1, write_2x2_text
	dw TEST_DELAY * 2, nothing
	dw 1, write_2x2_text
	dw 10, nothing
	dw 9, write_big_letter 			; different
	dw 1, write_big_letter 			; world
	dw 1, draw_world_o
	dw 3, write_big_letter
	dw TEST_DELAY * 3, nothing
	dw 1, wipe_upwards_init
	dw 24, wipe_upwards
	;
	dw 1, set_txt_2x2_converted
	dw 1, clear_screen_25_rows
	dw 1, copy_mini_mag_gfx
	dw 1, draw_mini_mag_bg
	dw 1, start_names_irq
	dw 1, draw_mini_magazine
	dw 1, write_small
	;
	dw 1, scroll_in_names_init_first
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing  
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init
	dw 1, write_2x2_text
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 10, nothing
	dw 1, add_mini_checkmark
	dw TEST_DELAY, nothing
	;
	dw 1, scroll_in_names_init_last		; scroll out last name
	dw 32, scroll_in_names
	dw 1, scroll_names_cleanup
	dw 8, fade_out_mini_mag
	;
	dw 1, default_irq
	dw 1, clear_screen
	dw 1, kefrens_screen_setup
	dw 1, start_kefrens_irq
	dw 18, kefrens_fade_in
	dw 1, nothing
	dw 15, write_single_2x2_letter		; paradise
	dw 20, nothing
	dw 10, write_single_2x2_letter
	dw 20, nothing
	dw 14, write_single_2x2_letter
	dw 20, nothing
	dw 11, write_single_2x2_letter
	dw TEST_DELAY * 3, nothing
	dw 32, kefrens_text_clear
	dw 18, kefrens_fade_out
	dw 1, stop_kefrens_irq
	;
	dw 1, clear_chars_set_24_rows
	dw 2, write_2x2_text			; wait a minute
	dw 16, nothing
	dw 1, draw_excl_1
	dw 15, nothing
	dw 1, draw_excl_2
	dw 15, nothing
	dw 1, draw_excl_3
	dw 15+32, nothing
	dw 2, write_2x2_text			; did we miss one?
	dw 30, nothing
	dw 1, draw_excl_4
	dw 15, nothing
	dw 1, draw_excl_5
	dw 15, nothing
	dw 1, draw_excl_6
	dw TEST_DELAY * 2, nothing
	;
	dw 1, stop_wait
	dw 1, copy_beret_chars
	dw 15, draw_1_beret
	dw TEST_DELAY, nothing
	dw 5, write_big_letter			; where
	dw TEST_DELAY, nothing
	dw 4, write_big_letter			; is my
	dw TEST_DELAY, nothing
	dw 6, write_big_letter			; beret?
	dw TEST_DELAY * 2, nothing
	dw 1, draw_beret2
	dw TEST_DELAY * 2, nothing
	;
	dw 20, wipe8_1
	dw 20, wipe8_2
	dw 20, wipe8_3
	;
	dw 1, clear_screen
	dw 1, start_speech_irq
	dw 1, invert_small_font
	dw 1, draw_speech_bubble
	dw 18, fade_in_speech_bubble
	dw 51*4, pixel_small_text
	dw TEST_DELAY, nothing
	dw 18, fade_out_speech_bubble
	dw 1, invert_small_font
	;
	dw 1, start_draw_gb
	dw 1000, wait_for_completion		; wait for unpack to finish
	dw 1, prepare_dycp_font
	dw 1000, wait_for_completion		; wait for preparation to finish
	dw 1, dycp_init
	dw 1000, wait_for_completion		; wait for init to finish
	dw 15, gb_fade_in_colors
	dw 1, start_gb_irq
	dw 1, screen_on
	dw 550, dycp_render
	dw 1, dycp_render_speedup
	dw 48, dycp_render
	dw 10, double_curtain_close
	dw 15, gb_fade_out_colors
	;
	dw 1, sbs_prep
	dw 1, clear_screen
	dw 1, copy_butwhy_chars
	dw 4, write_big_letter			; why?
	dw 1, copy_why
	dw 1000, wait_for_completion		; wait for copy to finish
	dw 1, draw_butwhy
	dw 3, write_big_letter
	dw 1, sbs_init				; screen on
	dw 8, fade_in_butwhy
	dw 4, fade_in_but
	dw 5, fade_in_why
	dw 30, sbs_raster_fade_in
	dw 832, nothing
	dw 30, sbs_raster_fade_out
	dw 1, start_butwhy_fadeout
	dw 5, fade_in_why			; fade out
	dw 4, fade_in_but
	dw 8, fade_in_butwhy
	dw 1, default_irq
	;
	dw 1, clear_chars
	dw 1, bigscroll_unpack
	dw 1000, wait_for_completion		; wait for unpack to finish
	dw 1, bigscroll_start
	dw 1000, wait_for_completion		; wait for scroll to finish
	;
	dw 1, set_txt_2x2_map
	dw 1, clear_map_colors			; screen off
	dw 1, clear_map_chars
	dw 1, draw_map_status
	dw 1, setup_map				; screen on
	;
	dw 10, scroll_map
	dw 50, scroll_map_write_2x2_letter	; would you
	dw 150, scroll_map
	dw 16, scroll_map_fade_text
	dw 10, scroll_map
	dw 54, scroll_map_write_2x2_letter	; halfway there
	dw 150, scroll_map
	;
	dw 1, clear_chars_and_set_defaults
	dw 1, draw_big_no
	dw 1, set_color_32
	dw 1, screen_on
	dw TEST_DELAY, nothing
	;
	dw 1, clear_chars_and_set_defaults
	dw 1, start_fld_irq
	dw 1, write_small
	dw 7, write_big_letter 			; sprites
	dw 4, sprites_fade_in
	dw 1, sprites_fade_in_next
	dw 4, sprites_fade_in
	dw 1, sprites_fade_in_next
	dw 5, sprites_fade_in
	dw 1, sprites_fade_in_next
	dw 6, sprites_fade_in
	dw 1, sprites_fade_in_next
	dw 5, sprites_fade_in
	dw 1, sprites_fade_in_next
	dw 4, sprites_fade_in
	dw 1, sprites_fade_in_next
	dw 3, sprites_fade_in
	dw TEST_DELAY * 4, nothing
	dw 1, sprites_fade_out_next
	dw 3, sprites_fade_out
	dw 1, sprites_fade_out_next
	dw 4, sprites_fade_out
	dw 1, sprites_fade_out_next
	dw 5, sprites_fade_out
	dw 1, sprites_fade_out_next
	dw 6, sprites_fade_out
	dw 1, sprites_fade_out_next
	dw 5, sprites_fade_out
	dw 1, sprites_fade_out_next
	dw 4, sprites_fade_out
	dw 1, sprites_fade_out_next
	dw 3, sprites_fade_out
	;
	dw 1, stop_fld_clear_bitmap
	dw 5, nothing				; wait for bitmap to clear
	dw 1, show_map_bitmap
	dw 1, map_to_bitmap_init
	dw 39, map_to_bitmap_and_wol
	dw 35, c5_write_one_letter
	dw 140, nothing
	dw 34, c5_write_one_letter 
	dw 140, nothing
	dw 44, c5_write_one_letter
	dw 140, nothing
	;
	dw 1, init_sine_wipe
	dw 128, do_sine_wipe
	;
	dw 1, clear_screen_25_rows_hires	; turn graphics off, reset character map
	dw 1, set_last_page
	dw 1, write_small
	dw 25, nothing
	dw 1, write_small
	dw 25, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 7, write_big_letter
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 1, write_small
	dw 1, save_charset
	dw TEST_DELAY * 4, nothing
	dw 1, dither_fade_prep
	dw 63, dither_fade
	;
	dw 1, clear_chars
	dw 2, nothing
	dw 1, restore_charset
	dw 2, nothing
	;
	dw 1, write_small
	dw 25, nothing
	dw 1, write_small
	dw 25, nothing
	dw 1, write_small
	dw 25, nothing
	dw 1, write_small
	dw TEST_DELAY, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 1, write_2x2_text
	dw 25, nothing
	dw 5, write_big_letter
	dw TEST_DELAY, nothing
	dw 1, cross_out
	dw TEST_DELAY, nothing
	dw 1, enable_big_letter_erase
	dw 6, write_big_letter
	dw 1, save_charset
	dw TEST_DELAY * 4, nothing
	dw 1, dither_fade_prep
	dw 63, dither_fade
	;
	dw 1, enable_vol_down
	dw 20*16, nothing
	dw 1, start_klaxon
	dw 10*50, nothing
	dw 1, $FFF6
	
bigscroll_comp_start
	include "bigscroll_comp_hex.asm"
bigscroll_comp_end

	include "charmap.asm"
;eof