k_index		= $CF
	
;start
;	sei
;	sta $ff3f
;	;
;	lda $FF07
;	and #$40
;	ora #$98
;	sta $FF07
;	;
;	lda #$C0
;	sta $FF12
;	lda #k_charset >> 8
;	sta $FF13
;	;
;	lda #$01
;	sta $FF15
;	;
;	lda #$3E
;	sta $FF16
;	lda #$5E
;	sta $FF17
;	;
;	lda #$00
;	sta $FF19
;	;
;	lda #$01
;	ldx #irq1 & 255
;	ldy #irq1 >> 8
;	sta $FF0B
;	stx $FFFE
;	sty $FFFF
;	;
;	ldx #$00
;k_il3	lda #$00
;	sta $0800,x
;	sta $0900,x
;	sta $0A00,x
;	sta $0B00,x
;	lda #$FF
;	sta $0C00,x
;	sta $0D00,x
;	sta $0E00,x
;	sta $0F00,x
;	inx
;	bne k_il3
;	;
kefrens_screen_setup
	lda #$04
	sta dst_ptr
	sta col_dst
	lda #$0C
	sta dst_ptr+1
	lda #$08
	sta col_dst+1
	;
	ldx #24
k_il2	ldy #$00
k_il1	tya
	sta (dst_ptr),y
	lda #$79
	sta (col_dst),y
	iny
	cpy #32
	bne k_il1
	;
	lda dst_ptr
	clc
	adc #40
	sta dst_ptr
	sta col_dst
	bcc *+6
	inc dst_ptr+1
	inc col_dst+1
	dex
	bpl k_il2
	;
	rts

kef1	macro offs
	ldx k_index			; 3
	lda kefrens_sine+offs,x		; 4
	tay				; 2
	db $BF				; 4 LAX $nnnn,Y
	dw kefrens_offset
	;
	lda k_charset+(offs & 7),x	; 4
	and kefrens_left_and,y		; 4
	ora kefrens_left_or,y		; 4
	sta k_charset+(offs & 7),x	; 5 = 17
	;
	lda k_charset+8+(offs & 7),x	; 4
	and kefrens_right_and,y		; 4
	ora kefrens_right_or,y		; 4
	sta k_charset+8+(offs & 7),x	; 5 = 17 = 42 total
	endm

	align 256
irq_kefrens
	pha
	txa
	pha
	tya
	pha
	;
	lda $FF1E
	cmp #$4E			; ...
	beq ah16			; ahead by 16
	cmp #$4A
	beq ah12			; ahead by 12
	cmp #$46			; one cycle = HC increases by 4
	beq ah08			; ahead by 8
	cmp #$42
	beq ah04			; ahead by 4
	cmp #$3E
	beq ah00			; lowest value
	;
ah16	bit $24
ah12	bit $24
ah08	bit $24				; add 3 cycles
ah04	bit $24				; each
ah00					; nothing added
	;
	lda #$00
	sta k_index
	;
	; 6 * 63 + 44 = 422 (needed)
	; 8 * 42 - 86 to waste
k_loop	;
	kef1 0
	kef1 1
	kef1 2
	kef1 3
	kef1 4
	kef1 5
	kef1 6
	kef1 7
	;
	lda #$32
	sta $FF19
	;
	asl $02 ; 86
	asl $02
	asl $02
	asl $02
	asl $02
	nop
	nop
	;
	lda #$00
	sta $FF19
	;
	lda k_index	; 3
	clc		; 2
	adc #$08	; 2
	sta k_index	; 3
	cmp #$80	; 2
	beq k_loop_exit	; not taken - 2
	jmp k_loop	; 3
	;      
k_loop_exit
	lda #$CC
	ldx #irq_bottom & 255
	ldy #irq_bottom >> 8
	jsr set_irq
	;
	pla
	tay
	pla
	tax
	pla
	rti
	
kefrens_bottom
	dec $FF19
	;
	ldx #$3F
	lda #$00
k_cl1	sta k_charset+$00,x
	sta k_charset+$40,x
	sta k_charset+$80,x
	sta k_charset+$C0,x
	dex
	bpl k_cl1
	;
	ldx #$7F
k_sn1	lda k_sine1,x
	clc
k_sn2	adc k_sine2,x
	sta kefrens_sine,x
	dex
	bpl k_sn1
	;
	lda k_sn1+1
	clc
	adc #1
	cmp #102
	bne *+4
	lda #0
	sta k_sn1+1 
	;
	lda k_sn2+1
	sec
	sbc #1
	bpl *+4
	lda #70
	sta k_sn2+1 
	;
	inc $FF19
	;
	rts

	align 256
kefrens_sine
	ds 256

	align 256
k_sine1
; 101,70,0,0 
	db $46,$4A,$4F,$53,$57,$5B,$60,$64,$67,$6B,$6F,$72,$76,$79,$7C,$7E
	db $81,$83,$85,$87,$88,$8A,$8B,$8B,$8C,$8C,$8C,$8C,$8B,$8A,$89,$88
	db $86,$84,$82,$80,$7D,$7A,$77,$74,$71,$6D,$69,$65,$62,$5D,$59,$55
	db $51,$4D,$48,$44,$3F,$3B,$37,$33,$2F,$2A,$27,$23,$1F,$1B,$18,$15
	db $12,$0F,$0C,$0A,$08,$06,$04,$03,$02,$01,$00,$00,$00,$00,$01,$01
	db $02,$04,$05,$07,$09,$0B,$0E,$10,$13,$16,$1A,$1D,$21,$25,$28,$2C
	db $31,$35,$39,$3D,$42
	db $46,$4A,$4F,$53,$57,$5B,$60,$64,$67,$6B,$6F,$72,$76,$79,$7C,$7E
	db $81,$83,$85,$87,$88,$8A,$8B,$8B,$8C,$8C,$8C,$8C,$8B,$8A,$89,$88
	db $86,$84,$82,$80,$7D,$7A,$77,$74,$71,$6D,$69,$65,$62,$5D,$59,$55
	db $51,$4D,$48,$44,$3F,$3B,$37,$33,$2F,$2A,$27,$23,$1F,$1B,$18,$15
	db $12,$0F,$0C,$0A,$08,$06,$04,$03,$02,$01,$00,$00,$00,$00,$01,$01
	db $02,$04,$05,$07,$09,$0B,$0E,$10,$13,$16,$1A,$1D,$21,$25,$28,$2C
	db $31,$35,$39,$3D,$42
	db $46,$4A,$4F,$53,$57,$5B,$60,$64,$67,$6B,$6F,$72,$76,$79,$7C,$7E
	db $81,$83,$85,$87,$88,$8A,$8B,$8B,$8C,$8C,$8C,$8C,$8B,$8A,$89,$88
	db $86,$84,$82,$80,$7D,$7A,$77,$74,$71,$6D,$69,$65,$62,$5D,$59,$55
	db $51,$4D,$48,$44,$3F,$3B

	align 256
k_sine2
; 71,50,0,0
	db $32,$36,$3B,$3F,$43,$47,$4B,$4F,$53,$56,$59,$5B,$5E,$60,$61,$63
	db $63,$64,$64,$64,$63,$62,$61,$5F,$5D,$5A,$57,$54,$51,$4D,$49,$45
	db $41,$3D,$39,$34,$30,$2B,$27,$23,$1F,$1B,$17,$13,$10,$0D,$0A,$07
	db $05,$03,$02,$01,$00,$00,$00,$01,$01,$03,$04,$06,$09,$0B,$0E,$11
	db $15,$19,$1D,$21,$25,$29,$2E
	db $32,$36,$3B,$3F,$43,$47,$4B,$4F,$53,$56,$59,$5B,$5E,$60,$61,$63
	db $63,$64,$64,$64,$63,$62,$61,$5F,$5D,$5A,$57,$54,$51,$4D,$49,$45
	db $41,$3D,$39,$34,$30,$2B,$27,$23,$1F,$1B,$17,$13,$10,$0D,$0A,$07
	db $05,$03,$02,$01,$00,$00,$00,$01,$01,$03,$04,$06,$09,$0B,$0E,$11
	db $15,$19,$1D,$21,$25,$29,$2E
	db $32,$36,$3B,$3F,$43,$47,$4B,$4F,$53,$56,$59,$5B,$5E,$60,$61,$63
	db $63,$64,$64,$64,$63,$62,$61,$5F,$5D,$5A,$57,$54,$51,$4D,$49,$45
	db $41,$3D,$39,$34,$30,$2B,$27,$23,$1F,$1B,$17,$13,$10,$0D,$0A,$07
	db $05,$03,$02,$01,$00,$00,$00,$01,$01,$03,$04,$06,$09,$0B,$0E,$11
	db $15,$19,$1D,$21,$25,$29,$2E

	align 256
kefrens_offset
	db $00,$00,$00,$00,$00,$00,$00,$00, $08,$08,$08,$08,$08,$08,$08,$08
	db $10,$10,$10,$10,$10,$10,$10,$10, $18,$18,$18,$18,$18,$18,$18,$18
	db $20,$20,$20,$20,$20,$20,$20,$20, $28,$28,$28,$28,$28,$28,$28,$28
	db $30,$30,$30,$30,$30,$30,$30,$30, $38,$38,$38,$38,$38,$38,$38,$38
	db $40,$40,$40,$40,$40,$40,$40,$40, $48,$48,$48,$48,$48,$48,$48,$48
	db $50,$50,$50,$50,$50,$50,$50,$50, $58,$58,$58,$58,$58,$58,$58,$58
	db $60,$60,$60,$60,$60,$60,$60,$60, $68,$68,$68,$68,$68,$68,$68,$68
	db $70,$70,$70,$70,$70,$70,$70,$70, $78,$78,$78,$78,$78,$78,$78,$78
	db $80,$80,$80,$80,$80,$80,$80,$80, $88,$88,$88,$88,$88,$88,$88,$88
	db $90,$90,$90,$90,$90,$90,$90,$90, $98,$98,$98,$98,$98,$98,$98,$98
	db $A0,$A0,$A0,$A0,$A0,$A0,$A0,$A0, $A8,$A8,$A8,$A8,$A8,$A8,$A8,$A8
	db $B0,$B0,$B0,$B0,$B0,$B0,$B0,$B0, $B8,$B8,$B8,$B8,$B8,$B8,$B8,$B8
	db $C0,$C0,$C0,$C0,$C0,$C0,$C0,$C0, $C8,$C8,$C8,$C8,$C8,$C8,$C8,$C8
	db $D0,$D0,$D0,$D0,$D0,$D0,$D0,$D0, $D8,$D8,$D8,$D8,$D8,$D8,$D8,$D8
	db $E0,$E0,$E0,$E0,$E0,$E0,$E0,$E0, $E8,$E8,$E8,$E8,$E8,$E8,$E8,$E8
	db $F0,$F0,$F0,$F0,$F0,$F0,$F0,$F0, $F8,$F8,$F8,$F8,$F8,$F8,$F8,$F8
kefrens_left_and
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
	db $00,$00,$C0,$C0,$F0,$F0,$FC,$FC, $00,$00,$C0,$C0,$F0,$F0,$FC,$FC
kefrens_left_or
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
	db $6E,$6E,$1B,$1B,$06,$06,$01,$01, $6E,$6E,$1B,$1B,$06,$06,$01,$01
kefrens_right_and
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
	db $3F,$3F,$0F,$0F,$03,$03,$00,$00, $3F,$3F,$0F,$0F,$03,$03,$00,$00
kefrens_right_or
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	db $40,$40,$90,$90,$E4,$E4,$B9,$B9, $40,$40,$90,$90,$E4,$E4,$B9,$B9
	
	align $0800
k_charset
	ds $0800
;eof