DXYCP_DATA = $2000
DXYCP_POS = $0C00 + 13 * 40 + 24
DXYCP_DST = $1400
DXYCP_PTRS = $2800
DXYCP_LETTERS = $2A00
DXYCP_INDEX = $2B00
DYXCP_LETTER_COUNT = 16

dxycp_text_ptr = $CC

dxycp_prep
	ldx #$00
dxpr_01	lda dxycp_font,x
	sta DXYCP_DATA,x
	inx
	bne dxpr_01
	;  
	lda #DXYCP_DATA & 255
	sta ptr
	clc
	adc #$80
	sta ptr+2
	sta dst_ptr+2
	lda #DXYCP_DATA >> 8
	sta ptr+1
	sta ptr+2+1
	;
	ldx #$06			; create 7 more versions of the font
	;
dxpr_02	lda ptr
	sta dst_ptr
	lda ptr+1
	clc
	adc #$01
	sta dst_ptr+1
	sta dst_ptr+2+1
	;
	ldy #$00
dxpr_03	lda (ptr),y
	lsr a				; 16 bit shift right
	sta (dst_ptr),y
	;
	lda (ptr+2),y
	ror a
	sta (dst_ptr+2),y
	;
	iny
	bpl dxpr_03
	;
	inc ptr+1
	inc ptr+2+1
	;
	dex
	bpl dxpr_02
	;
	; ---
	;
dxycp_clear_dest_area
	ldx #$00
	lda #$00
dxda_01	sta DXYCP_DST,x
	sta DXYCP_DST+$100,x
	sta DXYCP_DST+$200,x
	sta DXYCP_DST+$300,x
	inx
	bne dxda_01
	;
	ldx #$00
dxda_02	lda #DXYCP_DST & 255
	sta DXYCP_PTRS,x
	lda #DXYCP_DST >> 8
	sta DXYCP_PTRS + $0100,x
	inx
	bne dxda_02 
	;
	; ---
	; 
dxycp_draw_char_matrix
	lda #DXYCP_POS & 255
	sta dst_ptr
	sta dst_ptr+2
	lda #DXYCP_POS >> 8
	sta dst_ptr+1
	and #$FB
	sta dst_ptr+2+1
	;
	ldx #$00
dxcm_01	txa
	ora #$80
	ldy #$00
dxcm_02	sta (dst_ptr),y
	pha
	lda #$17
	sta (dst_ptr+2),y
	pla
	clc
	adc #$08
	iny
	cpy #16
	bne dxcm_02
	;
	lda dst_ptr
	clc
	adc #40
	sta dst_ptr
	sta dst_ptr+2
	bcc *+6
	inc dst_ptr+1
	inc dst_ptr+2+1
	;
	inx
	cpx #7
	bne dxcm_01
	;
	; --- set up text
	;
	set16 dxycp_text_ptr, dxycp_text
	;
	ldx #0
	ldy #63
dxcm_03	lda #0					; space char
	sta DXYCP_LETTERS,x
	tya
	sta DXYCP_INDEX,x
	sec
	sbc #4
	tay
	inx
	cpx #DYXCP_LETTER_COUNT
	bne dxcm_03 
	;
	rts

dxycp_render_letter
	;dec $FF19
	;
	; --- clear
	;
	ldx #$00				; letter index
	;
dxrl_01	lda DXYCP_PTRS,x
	sta dst_ptr
	lda DXYCP_PTRS+$100,x
	sta dst_ptr+1
	;
	lda dst_ptr
	clc
	adc #$40
	sta dst_ptr+2
	lda dst_ptr+1
	adc #$00
	sta dst_ptr+2+1
	;
	ldy #$00
	lda #$00
	sta (dst_ptr),y
	sta (dst_ptr+2),y
	iny
	sta (dst_ptr),y
	sta (dst_ptr+2),y
	iny
	sta (dst_ptr),y
	sta (dst_ptr+2),y
	iny
	sta (dst_ptr),y
	sta (dst_ptr+2),y
	iny
	sta (dst_ptr),y
	sta (dst_ptr+2),y
	;
	inx
	cpx #DYXCP_LETTER_COUNT
	bne dxrl_01
	;
	; --- draw
	;
	ldx #$00
	;
dxrl_02	lda DXYCP_LETTERS,x
	sta ptr
	;
	lda DXYCP_INDEX,x
	tay
	lda dxycp_x_sine_src_hi,y
	sta ptr+1
	;
	lda dxycp_x_sine_dst_lo,y
	clc
	adc dxycp_y_sine,y
	sta dst_ptr
	lda dxycp_x_sine_dst_hi,y
	adc #DXYCP_DST >> 8
	sta dst_ptr+1
	;
	lda ptr
	ora #$80
	sta ptr+2
	lda ptr+1
	sta ptr+2+1
	;
	lda dst_ptr
	clc
	adc #$40
	sta dst_ptr+2
	lda dst_ptr+1
	adc #$00
	sta dst_ptr+2+1
	;
	lda dst_ptr
	sta DXYCP_PTRS,x
	lda dst_ptr+1
	sta DXYCP_PTRS + $100,x
	;
	ldy #$00
	lda (ptr),y			; row 0
	ora (dst_ptr),y
	sta (dst_ptr),y
	lda (ptr+2),y
	ora (dst_ptr+2),y
	sta (dst_ptr+2),y
	iny
	lda (ptr),y			; row 1
	ora (dst_ptr),y
	sta (dst_ptr),y
	lda (ptr+2),y
	ora (dst_ptr+2),y
	sta (dst_ptr+2),y
	iny
	lda (ptr),y			; row 2
	ora (dst_ptr),y
	sta (dst_ptr),y
	lda (ptr+2),y
	ora (dst_ptr+2),y
	sta (dst_ptr+2),y
	iny
	lda (ptr),y			; row 3
	ora (dst_ptr),y
	sta (dst_ptr),y
	lda (ptr+2),y
	ora (dst_ptr+2),y
	sta (dst_ptr+2),y
	iny
	lda (ptr),y			; row 4
	ora (dst_ptr),y
	sta (dst_ptr),y
	lda (ptr+2),y
	ora (dst_ptr+2),y
	sta (dst_ptr+2),y
	;
	; ---
	;
	lda DXYCP_INDEX,x
	clc
	adc #$01
	cmp #64
	bne dxrl_04
	;
	ldy #$00
	lda (dxycp_text_ptr),y
	sta DXYCP_LETTERS,x
	;
	add16 dxycp_text_ptr, #1
	;
	lda #$00
dxrl_04	sta DXYCP_INDEX,x
	; 
	inx
	cpx #DYXCP_LETTER_COUNT
	beq dxrl_03
	jmp dxrl_02
	;
dxrl_03	; 
	;
	;inc $FF19
	;
	rts

	cmap " ",0
	cmap "A",005,010,015,020,025,030,035,040,045,050,055,060,065,070,075,080,075,085,090,095,100,100,105,110,115
	cmap ".",120
dxycp_text
	db "MAYBE..."
	db "        "
	db "YOU CAN PLAY WITH THAI BOXING INSTEAD..."
	db "        "
	db "UMM..."
	db "        "
	cmap
	
	align 256
dxycp_x_sine
;128,60,0,32
	db $78,$78,$78,$77,$77,$76,$75,$74,$73,$72,$71,$6F,$6E,$6C,$6A,$68
	db $66,$64,$62,$60,$5D,$5B,$58,$56,$53,$50,$4D,$4B,$48,$45,$42,$3F
	db $3C,$39,$36,$33,$30,$2D,$2B,$28,$25,$22,$20,$1D,$1B,$18,$16,$14
	db $12,$10,$0E,$0C,$0A,$09,$07,$06,$05,$04,$03,$02,$01,$01,$00,$00

dxycp_x_sine_src_hi
	db ($78 & 7)|(DXYCP_DATA >> 8),($78 & 7)|(DXYCP_DATA >> 8),($78 & 7)|(DXYCP_DATA >> 8),($77 & 7)|(DXYCP_DATA >> 8)
	db ($77 & 7)|(DXYCP_DATA >> 8),($76 & 7)|(DXYCP_DATA >> 8),($75 & 7)|(DXYCP_DATA >> 8),($74 & 7)|(DXYCP_DATA >> 8)
	db ($73 & 7)|(DXYCP_DATA >> 8),($72 & 7)|(DXYCP_DATA >> 8),($71 & 7)|(DXYCP_DATA >> 8),($6F & 7)|(DXYCP_DATA >> 8)
	db ($6E & 7)|(DXYCP_DATA >> 8),($6C & 7)|(DXYCP_DATA >> 8),($6A & 7)|(DXYCP_DATA >> 8),($68 & 7)|(DXYCP_DATA >> 8)
	db ($66 & 7)|(DXYCP_DATA >> 8),($64 & 7)|(DXYCP_DATA >> 8),($62 & 7)|(DXYCP_DATA >> 8),($60 & 7)|(DXYCP_DATA >> 8)
	db ($5D & 7)|(DXYCP_DATA >> 8),($5B & 7)|(DXYCP_DATA >> 8),($58 & 7)|(DXYCP_DATA >> 8),($56 & 7)|(DXYCP_DATA >> 8)
	db ($53 & 7)|(DXYCP_DATA >> 8),($50 & 7)|(DXYCP_DATA >> 8),($4D & 7)|(DXYCP_DATA >> 8),($4B & 7)|(DXYCP_DATA >> 8)
	db ($48 & 7)|(DXYCP_DATA >> 8),($45 & 7)|(DXYCP_DATA >> 8),($42 & 7)|(DXYCP_DATA >> 8),($3F & 7)|(DXYCP_DATA >> 8)
	db ($3C & 7)|(DXYCP_DATA >> 8),($39 & 7)|(DXYCP_DATA >> 8),($36 & 7)|(DXYCP_DATA >> 8),($33 & 7)|(DXYCP_DATA >> 8)
	db ($30 & 7)|(DXYCP_DATA >> 8),($2D & 7)|(DXYCP_DATA >> 8),($2B & 7)|(DXYCP_DATA >> 8),($28 & 7)|(DXYCP_DATA >> 8)
	db ($25 & 7)|(DXYCP_DATA >> 8),($22 & 7)|(DXYCP_DATA >> 8),($20 & 7)|(DXYCP_DATA >> 8),($1D & 7)|(DXYCP_DATA >> 8)
	db ($1B & 7)|(DXYCP_DATA >> 8),($18 & 7)|(DXYCP_DATA >> 8),($16 & 7)|(DXYCP_DATA >> 8),($14 & 7)|(DXYCP_DATA >> 8)
	db ($12 & 7)|(DXYCP_DATA >> 8),($10 & 7)|(DXYCP_DATA >> 8),($0E & 7)|(DXYCP_DATA >> 8),($0C & 7)|(DXYCP_DATA >> 8)
	db ($0A & 7)|(DXYCP_DATA >> 8),($09 & 7)|(DXYCP_DATA >> 8),($07 & 7)|(DXYCP_DATA >> 8),($06 & 7)|(DXYCP_DATA >> 8)
	db ($05 & 7)|(DXYCP_DATA >> 8),($04 & 7)|(DXYCP_DATA >> 8),($03 & 7)|(DXYCP_DATA >> 8),($02 & 7)|(DXYCP_DATA >> 8)
	db ($01 & 7)|(DXYCP_DATA >> 8),($01 & 7)|(DXYCP_DATA >> 8),($00 & 7)|(DXYCP_DATA >> 8),($00 & 7)|(DXYCP_DATA >> 8)

dxycp_x_sine_dst_lo
	db (($78 & $F8)<<3) & 255,(($78 & $F8)<<3) & 255,(($78 & $F8)<<3) & 255,(($77 & $F8)<<3) & 255
	db (($77 & $F8)<<3) & 255,(($76 & $F8)<<3) & 255,(($75 & $F8)<<3) & 255,(($74 & $F8)<<3) & 255
	db (($73 & $F8)<<3) & 255,(($72 & $F8)<<3) & 255,(($71 & $F8)<<3) & 255,(($6F & $F8)<<3) & 255
	db (($6E & $F8)<<3) & 255,(($6C & $F8)<<3) & 255,(($6A & $F8)<<3) & 255,(($68 & $F8)<<3) & 255
	db (($66 & $F8)<<3) & 255,(($64 & $F8)<<3) & 255,(($62 & $F8)<<3) & 255,(($60 & $F8)<<3) & 255
	db (($5D & $F8)<<3) & 255,(($5B & $F8)<<3) & 255,(($58 & $F8)<<3) & 255,(($56 & $F8)<<3) & 255
	db (($53 & $F8)<<3) & 255,(($50 & $F8)<<3) & 255,(($4D & $F8)<<3) & 255,(($4B & $F8)<<3) & 255
	db (($48 & $F8)<<3) & 255,(($45 & $F8)<<3) & 255,(($42 & $F8)<<3) & 255,(($3F & $F8)<<3) & 255
	db (($3C & $F8)<<3) & 255,(($39 & $F8)<<3) & 255,(($36 & $F8)<<3) & 255,(($33 & $F8)<<3) & 255
	db (($30 & $F8)<<3) & 255,(($2D & $F8)<<3) & 255,(($2B & $F8)<<3) & 255,(($28 & $F8)<<3) & 255
	db (($25 & $F8)<<3) & 255,(($22 & $F8)<<3) & 255,(($20 & $F8)<<3) & 255,(($1D & $F8)<<3) & 255
	db (($1B & $F8)<<3) & 255,(($18 & $F8)<<3) & 255,(($16 & $F8)<<3) & 255,(($14 & $F8)<<3) & 255
	db (($12 & $F8)<<3) & 255,(($10 & $F8)<<3) & 255,(($0E & $F8)<<3) & 255,(($0C & $F8)<<3) & 255
	db (($0A & $F8)<<3) & 255,(($09 & $F8)<<3) & 255,(($07 & $F8)<<3) & 255,(($06 & $F8)<<3) & 255
	db (($05 & $F8)<<3) & 255,(($04 & $F8)<<3) & 255,(($03 & $F8)<<3) & 255,(($02 & $F8)<<3) & 255
	db (($01 & $F8)<<3) & 255,(($01 & $F8)<<3) & 255,(($00 & $F8)<<3) & 255,(($00 & $F8)<<3) & 255

dxycp_x_sine_dst_hi
	db (($78 & $F8)<<3) >> 8,(($78 & $F8)<<3) >> 8,(($78 & $F8)<<3) >> 8,(($77 & $F8)<<3) >> 8
	db (($77 & $F8)<<3) >> 8,(($76 & $F8)<<3) >> 8,(($75 & $F8)<<3) >> 8,(($74 & $F8)<<3) >> 8
	db (($73 & $F8)<<3) >> 8,(($72 & $F8)<<3) >> 8,(($71 & $F8)<<3) >> 8,(($6F & $F8)<<3) >> 8
	db (($6E & $F8)<<3) >> 8,(($6C & $F8)<<3) >> 8,(($6A & $F8)<<3) >> 8,(($68 & $F8)<<3) >> 8
	db (($66 & $F8)<<3) >> 8,(($64 & $F8)<<3) >> 8,(($62 & $F8)<<3) >> 8,(($60 & $F8)<<3) >> 8
	db (($5D & $F8)<<3) >> 8,(($5B & $F8)<<3) >> 8,(($58 & $F8)<<3) >> 8,(($56 & $F8)<<3) >> 8
	db (($53 & $F8)<<3) >> 8,(($50 & $F8)<<3) >> 8,(($4D & $F8)<<3) >> 8,(($4B & $F8)<<3) >> 8
	db (($48 & $F8)<<3) >> 8,(($45 & $F8)<<3) >> 8,(($42 & $F8)<<3) >> 8,(($3F & $F8)<<3) >> 8
	db (($3C & $F8)<<3) >> 8,(($39 & $F8)<<3) >> 8,(($36 & $F8)<<3) >> 8,(($33 & $F8)<<3) >> 8
	db (($30 & $F8)<<3) >> 8,(($2D & $F8)<<3) >> 8,(($2B & $F8)<<3) >> 8,(($28 & $F8)<<3) >> 8
	db (($25 & $F8)<<3) >> 8,(($22 & $F8)<<3) >> 8,(($20 & $F8)<<3) >> 8,(($1D & $F8)<<3) >> 8
	db (($1B & $F8)<<3) >> 8,(($18 & $F8)<<3) >> 8,(($16 & $F8)<<3) >> 8,(($14 & $F8)<<3) >> 8
	db (($12 & $F8)<<3) >> 8,(($10 & $F8)<<3) >> 8,(($0E & $F8)<<3) >> 8,(($0C & $F8)<<3) >> 8
	db (($0A & $F8)<<3) >> 8,(($09 & $F8)<<3) >> 8,(($07 & $F8)<<3) >> 8,(($06 & $F8)<<3) >> 8
	db (($05 & $F8)<<3) >> 8,(($04 & $F8)<<3) >> 8,(($03 & $F8)<<3) >> 8,(($02 & $F8)<<3) >> 8
	db (($01 & $F8)<<3) >> 8,(($01 & $F8)<<3) >> 8,(($00 & $F8)<<3) >> 8,(($00 & $F8)<<3) >> 8

dxycp_y_sine
;128,56,0,32
	db $38,$35,$33,$30,$2D,$2A,$28,$25,$23,$20,$1E,$1B,$19,$17,$14,$12
	db $10,$0F,$0D,$0B,$09,$08,$07,$05,$04,$03,$02,$02,$01,$01,$00,$00
	db $00,$00,$00,$01,$01,$02,$02,$03,$04,$05,$07,$08,$09,$0B,$0D,$0F
	db $10,$12,$14,$17,$19,$1B,$1E,$20,$23,$25,$28,$2A,$2D,$30,$33,$35

	align 256
dxycp_font	; 128*24 h none
	db $00,$00,$00,$00,$00
	db $7E,$C3,$FF,$C3,$C3
	db $FE,$C3,$FE,$C3,$FE
	db $7E,$C3,$C0,$C3,$7E
	db $FC,$C6,$C3,$C6,$FC
	db $FF,$C0,$FC,$C0,$FF
	db $FF,$C0,$FC,$C0,$C0
	db $7F,$C0,$CF,$C3,$7F
	db $C3,$C3,$FF,$C3,$C3
	db $18,$18,$18,$18,$18
	db $03,$03,$03,$C3,$7E
	db $C3,$C6,$FC,$C6,$C3
	db $C0,$C0,$C0,$C0,$FF
	db $C3,$E7,$FF,$DB,$C3
	db $E3,$F3,$DB,$CF,$C7
	db $7E,$C3,$C3,$C3,$7E
	db $FE,$C3,$FE,$C0,$C0
	db $FE,$C3,$FE,$CC,$C7
	db $7E,$C0,$7E,$03,$FE
	db $FF,$18,$18,$18,$18
	db $C3,$C3,$C3,$C3,$7E
	db $C3,$DB,$FF,$E7,$C3
	db $C3,$66,$3C,$66,$C3
	db $C3,$C3,$7E,$18,$18
	db $00,$00,$00,$00,$18
	db $00,$00,$00
	ds 128
;eof