c5_txt_ptr	= $70
c5_x_bit_pos	= c5_txt_ptr + 2
c5_font_src_ptr	= c5_txt_ptr + 4
c5_mask_src_ptr	= c5_txt_ptr + 6
c5_dst_ptr	= c5_txt_ptr + 8
c5_cnt		= c5_txt_ptr + 10
c5_tmp		= c5_txt_ptr + 11

C5_BITMAP	= $2000

; Common macros
c5_set16	macro zp, addr
	lda #addr & 255
	sta zp
	lda #addr >> 8
	sta zp+1
	endm
	
c5_add16	macro zp, addvalue
	if addvalue >= 256
	inc zp+1
	lda zp
	clc
	adc #(addvalue & 255)
	sta zp
	bcc *+4
	inc zp+1
	else
	lda zp
	clc
	adc #addvalue
	sta zp
	bcc *+4
	inc zp+1
	endif
	endm
	
c5_sub16	macro zp, subvalue
	if subvalue >= 256
	lda zp
	sec
	sbc #(subvalue & 255)
	sta zp
	lda zp+1
	sbc #subvalue >> 8
	sta zp+1
	else
	lda zp
	sec
	sbc #subvalue
	sta zp
	bcs *+4
	dec zp+1
	endif
	endm

c5_init
	;
	; --- prepare shifted font
	;                         
	c5_set16 c5_font_src_ptr, c5_font
	c5_set16 c5_dst_ptr, c5_font2
	;
	ldx #(c5_font2 - c5_font) >> 8
	ldy #$00
prep3	lda (c5_font_src_ptr),y
	sta (c5_dst_ptr),y
	iny
	bne prep3
	inc c5_font_src_ptr+1
	inc c5_dst_ptr+1
	dex
	bpl prep3
	;
	lda #$18				; clc opcode
	sta rp2
	;
	lda #$00
ror_font2
	sta c5_cnt
	clc
	adc #c5_font2 >> 8
	jsr c5_ror_page
	jsr c5_ror_page_again
	jsr c5_ror_page_again
	jsr c5_ror_page_again
	lda c5_cnt
	clc
	adc #$01
	cmp #(c5_font2 - c5_font) >> 8
	bne ror_font2
	;
	; --- prepare mask
	;
	c5_set16 c5_font_src_ptr, c5_font
	c5_set16 c5_dst_ptr, c5_mask
	;
prep1	ldy #$00
	lda #$FF
	sta (c5_dst_ptr),y
	iny
	sta (c5_dst_ptr),y
	;
	c5_add16 c5_dst_ptr, 2
	;
	ldy #$1F
prep2	lda (c5_font_src_ptr),y
	eor #$FF
	sta (c5_dst_ptr),y
	dey
	bpl prep2
	;
	; ---
	ldy #6+8
	lda (c5_dst_ptr),y
	pha
	iny
	lda (c5_dst_ptr),y
	pha
	;
	lda #$FF
	sta (c5_dst_ptr),y
	dey
	sta (c5_dst_ptr),y 
	;
	tya
	clc
	adc #$09
	tay
	;
	pla
	sta (c5_dst_ptr),y
	dey
	pla
	sta (c5_dst_ptr),y
	;
	; ---
	ldy #6
	lda (c5_dst_ptr),y
	pha
	iny
	lda (c5_dst_ptr),y
	pha
	;
	lda #$FF
	sta (c5_dst_ptr),y
	dey
	sta (c5_dst_ptr),y 
	;
	tya
	clc
	adc #$09
	tay
	;
	pla
	sta (c5_dst_ptr),y
	dey
	pla
	sta (c5_dst_ptr),y
	;
	; ---
	;
	c5_add16 c5_font_src_ptr, 32
	c5_add16 c5_dst_ptr, 30
	;
	lda c5_font_src_ptr+1
	cmp #c5_mask >> 8
	bne prep1
	;
	; ff, ff,  0, 1, 2, 3, 4, 5
	; ff, ff,  8, 9,10,11,12,13
	; 6,  7,  16,17,18,19,20,21
	; 14,15,  24,25,26,27,28,29
	;
	; ---
	;
	lda #$38				; sec opcode
	sta rp2
	;
	lda #$00
ror_mask
	sta c5_cnt
	clc
	adc #c5_mask >> 8
	jsr c5_ror_page
	jsr c5_ror_page_again
	lda c5_cnt
	clc
	adc #$01
	cmp #(c5_mask - c5_font) >> 8
	bne ror_mask
	;
	; -------------------------------------
	;
	c5_set16 c5_txt_ptr, c5_txt
	c5_set16 c5_dst_ptr, C5_BITMAP + 8 * 8 + 21 * 320
	lda #$00
	sta c5_x_bit_pos
	;
	rts
	;
	; ---
	; fade prep: fill with white
;	c5_set16 c5_dst_ptr, color_dst_2
;	ldy #$00
;	ldx #$03
;	lda #$77				; lum
;fl01	sta (c5_dst_ptr),y 
;	iny
;	bne fl01
;	inc c5_dst_ptr+1
;	dex
;	bpl fl01
;	;
;	ldx #$03
;	lda #$11				; col
;fl02	sta (c5_dst_ptr),y 
;	iny
;	bne fl02
;	inc c5_dst_ptr+1
;	dex
;	bpl fl02
;	;
;	lda #colormap >> 8			; color map
;	sta $FF14
;	;
;	; ---
;	;
;;	lda #$00
;;	jsr PLAYER_INIT
;	;
;	lda #$CC
;	cmp $FF1D
;	bne *-3
;	;
;	lda #$3B				; turn graphics mode on
;	sta $FF06
;	;
;	lda #DEFAULT_FF15
;	sta $FF15
;	lda #DEFAULT_FF16
;	sta $FF16
	;
;	jsr fade_init
;	;
;	; --- main
;	;
;fade_loop
;	lda #$CC
;	cmp $FF1D
;	bcs *-3
;	;
;	jsr fade_in
;	;
;	bcs main_loop
;	;
;	lda #$CC
;	cmp $FF1D
;	bcc *-3
;	;
;	jmp fade_loop
	
;main_loop
;;sync1	lda $FF1D
;;	cmp #$A4
;;	bcc sync1
;;	
;;	lda #$71
;;	sta $FF16
;;	lda #$00
;;	sta $FF15
;	;
;sync2	lda $FF1D
;	cmp #$CC
;	bcc sync2
;	;
;	;dec $FF19
;	jsr c5_write_one_letter
;	;inc $FF19
;	;
;sync3	lda $FF1D
;	cmp #$CC
;	bcs sync3
;	;
;	lda #$7F
;	sta $FD30
;	sta $FF08
;	lda $FF08
;	and #$10				; Query keyboard for "Space"
;	bne main_loop
;	;
;	jmp $fff6

	;
	; ---
	;
c5_ror_page
	sta rp_a1+2				; set hi byte
	sta rp_a2+2
	;
c5_ror_page_again 
	ldx #$00
rp1	ldy #$07				; 8 bytes at a time
rp2	sec
rp_a1	ror $1000,x
rp_a2	ror $1008,x
	inx
	dey
	bpl rp2
	;
	txa
	clc
	adc #$08				; +10
	tax
	bne rp1
	rts
	
	;include "fullscreen_fade.asm"

;	align $0800
;colormap
;	include "colors.asm"
;pic
;	include "the_end_pic_hex.asm"

	;include "!player.asm"
	;include "!player_data.asm"
	;include "music.asm"

and16	macro
	ldy #$0f
	lda (c5_dst_ptr),y
	and (c5_mask_src_ptr),y
	ora (c5_font_src_ptr),y
	sta (c5_dst_ptr),y
	dey
	bpl *-9
	endm

or16	macro
	ldy #$0f
	lda (c5_dst_ptr),y
	ora (c5_font_src_ptr),y
	sta (c5_dst_ptr),y
	dey
	bpl *-7
	endm
	
c5_wolX	rts	
c5_wol3	iny
	lda (c5_txt_ptr),y
	sta c5_dst_ptr
	iny
	lda (c5_txt_ptr),y
	sta c5_dst_ptr+1
	iny
	lda (c5_txt_ptr),y
	sta c5_x_bit_pos
	;
	c5_add16 c5_txt_ptr, 4
	;
c5_write_one_letter
	ldy #$00
	lda (c5_txt_ptr),y
	cmp #$FE
	beq c5_wol3
	cmp #$FF
	beq c5_wolX
	;
	tax
	lda c5_letter_ptr_lo,x
	sta c5_font_src_ptr
	sta c5_mask_src_ptr
	lda c5_letter_ptr_hi,x
	clc
	adc c5_x_bit_pos
	sta c5_font_src_ptr+1
	clc
	adc #(c5_mask-c5_font) >> 8
	sta c5_mask_src_ptr+1
	; 
	; --- copy masked C5_BITMAP to screen
	and16
	c5_add16 c5_dst_ptr, 320
	c5_add16 c5_font_src_ptr, 16
	c5_add16 c5_mask_src_ptr, 16
	and16
	;
	c5_sub16 c5_dst_ptr, 320-16
	;
	lda c5_x_bit_pos
	bne c5_wol1
	;
	c5_sub16 c5_dst_ptr, 8
	;
c5_wol1	ldy #$00
	lda (c5_txt_ptr),y
	cmp #$05
	bcs c5_wol2
	;
	c5_sub16 c5_dst_ptr, 8
	;
c5_wol2	;
	c5_add16 c5_txt_ptr, 1
	;
	lda c5_x_bit_pos
	eor #(c5_font2-c5_font) >> 8
	sta c5_x_bit_pos
	;
	rts
	
c5_letter_ptr_lo
	db (c5_font + 0 * $20) & 255
	db (c5_font + 1 * $20) & 255
	db (c5_font + 2 * $20) & 255
	db (c5_font + 3 * $20) & 255
	db (c5_font + 4 * $20) & 255
	db (c5_font + 5 * $20) & 255
	db (c5_font + 6 * $20) & 255
	db (c5_font + 7 * $20) & 255
	db (c5_font + 8 * $20) & 255
	db (c5_font + 9 * $20) & 255
	db (c5_font + 10 * $20) & 255
	db (c5_font + 11 * $20) & 255
	db (c5_font + 12 * $20) & 255
	db (c5_font + 13 * $20) & 255
	db (c5_font + 14 * $20) & 255
	db (c5_font + 15 * $20) & 255
	db (c5_font + 16 * $20) & 255
	db (c5_font + 17 * $20) & 255
	db (c5_font + 18 * $20) & 255
	db (c5_font + 19 * $20) & 255
	db (c5_font + 20 * $20) & 255
	db (c5_font + 21 * $20) & 255
	db (c5_font + 22 * $20) & 255
	db (c5_font + 23 * $20) & 255
	db (c5_font + 24 * $20) & 255
	db (c5_font + 25 * $20) & 255
	db (c5_font + 26 * $20) & 255
	db (c5_font + 27 * $20) & 255
	db (c5_font + 28 * $20) & 255
	db (c5_font + 29 * $20) & 255
	db (c5_font + 30 * $20) & 255
	db (c5_font + 31 * $20) & 255
	db (c5_font + 32 * $20) & 255
	db (c5_font + 33 * $20) & 255
	db (c5_font + 34 * $20) & 255
	db (c5_font + 35 * $20) & 255
	db (c5_font + 36 * $20) & 255
	db (c5_font + 37 * $20) & 255
	db (c5_font + 38 * $20) & 255
	db (c5_font + 39 * $20) & 255
c5_letter_ptr_hi
	db (c5_font + 0 * $20) >> 8
	db (c5_font + 1 * $20) >> 8
	db (c5_font + 2 * $20) >> 8
	db (c5_font + 3 * $20) >> 8
	db (c5_font + 4 * $20) >> 8
	db (c5_font + 5 * $20) >> 8
	db (c5_font + 6 * $20) >> 8
	db (c5_font + 7 * $20) >> 8
	db (c5_font + 8 * $20) >> 8
	db (c5_font + 9 * $20) >> 8
	db (c5_font + 10 * $20) >> 8
	db (c5_font + 11 * $20) >> 8
	db (c5_font + 12 * $20) >> 8
	db (c5_font + 13 * $20) >> 8
	db (c5_font + 14 * $20) >> 8
	db (c5_font + 15 * $20) >> 8
	db (c5_font + 16 * $20) >> 8
	db (c5_font + 17 * $20) >> 8
	db (c5_font + 18 * $20) >> 8
	db (c5_font + 19 * $20) >> 8
	db (c5_font + 20 * $20) >> 8
	db (c5_font + 21 * $20) >> 8
	db (c5_font + 22 * $20) >> 8
	db (c5_font + 23 * $20) >> 8
	db (c5_font + 24 * $20) >> 8
	db (c5_font + 25 * $20) >> 8
	db (c5_font + 26 * $20) >> 8
	db (c5_font + 27 * $20) >> 8
	db (c5_font + 28 * $20) >> 8
	db (c5_font + 29 * $20) >> 8
	db (c5_font + 30 * $20) >> 8
	db (c5_font + 31 * $20) >> 8
	db (c5_font + 32 * $20) >> 8
	db (c5_font + 33 * $20) >> 8
	db (c5_font + 34 * $20) >> 8
	db (c5_font + 35 * $20) >> 8
	db (c5_font + 36 * $20) >> 8
	db (c5_font + 37 * $20) >> 8
	db (c5_font + 38 * $20) >> 8
	db (c5_font + 39 * $20) >> 8

c5_txt
	cmap " ",0
	cmap "!",1
	cmap ".",2
	cmap ":",3
	cmap "I",4
	cmap "A",5,6,7,8,9,10,11,12
	cmap "J",13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29
	cmap "0",30,31,32,33,34,35,36,37,38,39
	; A(B)CDEFGHI(J)(K)L(M)NOP(Q)RSTUV(W)(X)Y(Z)
	; 0123456789
	; !.:
	
;to use software sprites
;we have to reserve about
;half of the 256 characters
;used by the C=64 map.
;we also can't mix
;hires and multi.
;and the colors must
;be completely rethought.
	db $FE
	dw C5_BITMAP + 1 * 8 + 4 * 320
	db 0
	db "TO USE SOFTWARE SPRITES"
	db $FE
	dw C5_BITMAP + 1 * 8 + 6 * 320
	db 0
	db "WE HAVE TO RESERVE ABOUT"
	db $FE
	dw C5_BITMAP + 1 * 8 + 8 * 320
	db 0
	db "HALF OF THE 256 CHARACTERS."
	
	db $FE
	dw C5_BITMAP + 1 * 8 + 11 * 320
	db 0
	db "WE ALSO CANNOT MIX"
	db $FE
	dw C5_BITMAP + 1 * 8 + 13 * 320
	db 0
	db "HIRES AND MULTI."
	
	db $FE
	dw C5_BITMAP + 1 * 8 + 16 * 320
	db 0
	db "PLUS THE COLORS MUST"
	db $FE
	dw C5_BITMAP + 1 * 8 + 18 * 320
	db 0
	db "BE COMPLETELY RETHOUGHT."
	db $FF
	cmap
	
	align 256
	include "chars5x10_font.asm"

	align 256
c5_font2	;
	ds (c5_font2-c5_font)
	
	align 256
c5_mask	;
	ds (c5_mask-c5_font)
	
;	align $0800
;color_dst_1
;	db 0
;color_dst_2 = color_dst_1 + $0800
;eof