write_2x2_text
	ldy #$00
	lda (txt_2x2_src),y			; first byte is line (row) index
	tax
	lda txt_line_ptr_lo,x
	sta dst_ptr
	sta col_dst
	lda txt_line_ptr_hi,x
	sta dst_ptr+1
	and #$FB
	sta col_dst+1
	;
	iny
	lda (txt_2x2_src),y			; second byte is char (pen) color
	sta pen_color
	;
	lda txt_2x2_src
	clc
	adc #$02
	sta txt_2x2_src
	bcc *+4
	inc txt_2x2_src+1
	;
	;;---
	;if debug=1
	;jsr write_position_debug
	;endif
	;---
	;
	ldy #$00
w2_01	lda (txt_2x2_src),y
	;
	inc txt_2x2_src
	bne *+4
	inc txt_2x2_src+1
	;
	tax
	bmi w2_04				; exit on >$80
	;
	jsr write_2x2_letter
	beq w2_01
	;
w2_04	rts

	;
	; --- x = char to write
	;     dst_ptr/col_dst = destination
	;
write_2x2_letter
	lda charset_ptrs_lo,x
	sta src_ptr
	lda charset_ptrs_hi,x
	sta src_ptr+1
	lda charset_lengths,x			; x = width (loop counter)
	tax
	;
w2_02	lda (src_ptr),y
	beq w2_03				; skip spaces
	sta (dst_ptr),y
	lda pen_color
	sta (col_dst),y
	;
w2_03	inc src_ptr+1
	;
	lda (src_ptr),y
	beq w2_05				; skip spaces
	ldy #40
	sta (dst_ptr),y
	lda pen_color
	sta (col_dst),y
w2_05	ldy #0
	;
	dec src_ptr+1
	;
	inc src_ptr
	bne *+4
	inc src_ptr+1
	;
	inc dst_ptr
	bne *+4
	inc dst_ptr+1
	;
	inc col_dst
	bne *+4
	inc col_dst+1
	;
	dex
	bne w2_02
	rts

txt_line_ptr_lo
	db ($0C00 + 0 * 40) & 255
	db ($0C00 + 1 * 40) & 255
	db ($0C00 + 2 * 40) & 255
	db ($0C00 + 3 * 40) & 255
	db ($0C00 + 4 * 40) & 255
	db ($0C00 + 5 * 40) & 255
	db ($0C00 + 6 * 40) & 255
	db ($0C00 + 7 * 40) & 255
	db ($0C00 + 8 * 40) & 255
	db ($0C00 + 9 * 40) & 255
	db ($0C00 + 10 * 40) & 255
	db ($0C00 + 11 * 40) & 255
	db ($0C00 + 12 * 40) & 255
	db ($0C00 + 13 * 40) & 255
	db ($0C00 + 14 * 40) & 255
	db ($0C00 + 15 * 40) & 255
	db ($0C00 + 16 * 40) & 255
	db ($0C00 + 17 * 40) & 255
	db ($0C00 + 18 * 40) & 255
	db ($0C00 + 19 * 40) & 255
	db ($0C00 + 20 * 40) & 255
	db ($0C00 + 21 * 40) & 255
	db ($0C00 + 22 * 40) & 255
	db ($0C00 + 23 * 40) & 255
	db ($0C00 + 24 * 40) & 255

txt_line_ptr_hi
	db ($0C00 + 0 * 40) >> 8
	db ($0C00 + 1 * 40) >> 8
	db ($0C00 + 2 * 40) >> 8
	db ($0C00 + 3 * 40) >> 8
	db ($0C00 + 4 * 40) >> 8
	db ($0C00 + 5 * 40) >> 8
	db ($0C00 + 6 * 40) >> 8
	db ($0C00 + 7 * 40) >> 8
	db ($0C00 + 8 * 40) >> 8
	db ($0C00 + 9 * 40) >> 8
	db ($0C00 + 10 * 40) >> 8
	db ($0C00 + 11 * 40) >> 8
	db ($0C00 + 12 * 40) >> 8
	db ($0C00 + 13 * 40) >> 8
	db ($0C00 + 14 * 40) >> 8
	db ($0C00 + 15 * 40) >> 8
	db ($0C00 + 16 * 40) >> 8
	db ($0C00 + 17 * 40) >> 8
	db ($0C00 + 18 * 40) >> 8
	db ($0C00 + 19 * 40) >> 8
	db ($0C00 + 20 * 40) >> 8
	db ($0C00 + 21 * 40) >> 8
	db ($0C00 + 22 * 40) >> 8
	db ($0C00 + 23 * 40) >> 8
	db ($0C00 + 24 * 40) >> 8

charset_lengths
	db 1			; space
	db 2,2,2,2,2,2,2,2
	db 1			; i
	db 2,2,2
	db 3			; m
	db 2,2,2,2,2,2,2,2,2
	db 3			; w
	db 2,2,2
	db 1,1,1,1		; !'()
	db 2,2			; *+
	db 1			; ,
	db 2			; -
	db 1			; .
	db 2			; /
	db 2,1,2,2,2,2,2,2,2,2	; 0-9
	db 1			; :
	db 2			; ?
	
charset_ptrs_lo
	db (charmap + 0) & 255
	db (charmap + 2) & 255		; a
	db (charmap + 4) & 255		; b
	db (charmap + 6) & 255		; c
	db (charmap + 8) & 255		; d
	db (charmap + 10) & 255		; e
	db (charmap + 12) & 255		; f
	db (charmap + 14) & 255		; g
	db (charmap + 16) & 255		; h
	db (charmap + 18) & 255		; i
	db (charmap + 19) & 255		; j
	db (charmap + 21) & 255		; k
	db (charmap + 23) & 255		; l
	db (charmap + 25) & 255		; m
	db (charmap + 28) & 255		; n
	db (charmap + 30) & 255		; o
	db (charmap + 32) & 255		; p
	db (charmap + 34) & 255		; q
	db (charmap + 36) & 255		; r
	db (charmap + 38) & 255		; s
	db (charmap + 40) & 255		; t
	db (charmap + 42) & 255		; u
	db (charmap + 44) & 255		; v                          
	db (charmap + 46) & 255		; w
	db (charmap + 49) & 255		; x
	db (charmap + 51) & 255		; y
	db (charmap + 53) & 255		; z
	db (charmap + 55) & 255		; !
	db (charmap + 56) & 255		; '
	db (charmap + 57) & 255		; (
	db (charmap + 58) & 255		; )
	db (charmap + 59) & 255		; *
	db (charmap + 61) & 255		; +
	db (charmap + 63) & 255		; ,
	db (charmap + 64) & 255		; -
	db (charmap + 66) & 255		; .
	db (charmap + 67) & 255		; /
	db (charmap + 69) & 255		; 0
	db (charmap + 71) & 255		; 1
	db (charmap + 72) & 255		; 2
	db (charmap + 74) & 255		; 3
	db (charmap + 76) & 255		; 4
	db (charmap + 78) & 255		; 5
	db (charmap + 80) & 255		; 6
	db (charmap + 82) & 255		; 7
	db (charmap + 84) & 255		; 8
	db (charmap + 86) & 255		; 9
	db (charmap + 88) & 255		; :
	db (charmap + 89) & 255		; ?
	
charset_ptrs_hi
	db (charmap + 0) >> 8
	db (charmap + 2) >> 8		; a
	db (charmap + 4) >> 8		; b
	db (charmap + 6) >> 8		; c
	db (charmap + 8) >> 8		; d
	db (charmap + 10) >> 8		; e
	db (charmap + 12) >> 8		; f
	db (charmap + 14) >> 8		; g
	db (charmap + 16) >> 8		; h
	db (charmap + 18) >> 8		; i
	db (charmap + 19) >> 8		; j
	db (charmap + 21) >> 8		; k
	db (charmap + 23) >> 8		; l
	db (charmap + 25) >> 8		; m
	db (charmap + 28) >> 8		; n
	db (charmap + 30) >> 8		; o
	db (charmap + 32) >> 8		; p
	db (charmap + 34) >> 8		; q
	db (charmap + 36) >> 8		; r
	db (charmap + 38) >> 8		; s
	db (charmap + 40) >> 8		; t
	db (charmap + 42) >> 8		; u
	db (charmap + 44) >> 8		; v
	db (charmap + 46) >> 8		; w
	db (charmap + 49) >> 8		; x
	db (charmap + 51) >> 8		; y
	db (charmap + 53) >> 8		; z
	db (charmap + 55) >> 8		; !
	db (charmap + 56) >> 8		; '
	db (charmap + 57) >> 8		; (
	db (charmap + 58) >> 8		; )
	db (charmap + 59) >> 8		; *
	db (charmap + 61) >> 8		; +
	db (charmap + 63) >> 8		; ,
	db (charmap + 64) >> 8		; -
	db (charmap + 66) >> 8		; .
	db (charmap + 67) >> 8		; /
	db (charmap + 69) >> 8		; 0
	db (charmap + 71) >> 8		; 1
	db (charmap + 72) >> 8		; 2
	db (charmap + 74) >> 8		; 3
	db (charmap + 76) >> 8		; 4
	db (charmap + 78) >> 8		; 5
	db (charmap + 80) >> 8		; 6
	db (charmap + 82) >> 8		; 7
	db (charmap + 84) >> 8		; 8
	db (charmap + 86) >> 8		; 9
	db (charmap + 88) >> 8		; :
	db (charmap + 89) >> 8		; ?
;eof