	;
	; This routine takes a character screen
	; and "converts" it into a graphics screen.
	; This allows a seamless transition to graphics mode,
	; and then manipulating the graphics.
	;
	; Things taken into consideration:
	; - any ROM/RAM charset ($FF12/13)
	; - any color map ($FF14)
	; - any colors (but not flash)
	; - 128/256 char mode
	; - any background color
	; - FF06/FF07 values (as much as possible)
	;
	; Things that are not converted:
	; - flashing colors
	; - multicolor or ECM mode
	; - some FF06/FF07 shifts
	;

;	ORG $1001-2
;	DW  $1001
;	
;	DW nextln,0		; second word is line number
;	DB $9E
;	IF start > 9999
;	DB "0"+start/10000
;	ENDIF
;	DB "0"+(start/1000)%10,"0"+(start/100)%10,"0"+(start/10)%10,"0"+start%10,0
;nextln	DB 0,0

screen_col	= $D0
screen_chr	= $D2
lum		= $D4
col		= $D6
bitmap_dst	= $D8
char_source	= $DA

ctg_colmap	= $7800
ctg_bitmap	= $8000
	
;start
;	JSR $FF4F		; some testing code
;	DB $96,"HELLO THERE!",$0D,$12,"TEST",0
;	;
;	LDA #$00
;	STA $FF07
;	LDA #$17
;	STA $FF06
;	;LDA #$00
;	;STA $FF12
;	;LDA #$80
;	;STA $FF13
;	;
;	LDA #$44
;	STA $FF15
;	;
;	LDX #$00
;x1	LDA $FF00
;	EOR $FF02
;	STA $0F00,x
;	STA $0A00,x
;	INX
;	BNE x1
	;
	SEI
	STA $FF3E		; by default, charset are in the ROM
	;
	LDA $FF12		; check if charset is in RAM
	AND #$04
	BNE ctg_rom
	;
	STA $FF3F		; yes, page in RAM
	;
ctg_rom	LDY #$00		; init all pointers
	STY screen_col
	STY screen_chr
	STY lum
	STY col
	STY bitmap_dst
	;
	LDA $FF14
	AND #$F8
	STA screen_col+1
	ORA #$04
	STA screen_chr+1
	;
	LDA #ctg_colmap>>8	; dest: $1800
	STA lum+1
	ORA #$04
	STA col+1
	LDA #ctg_bitmap>>8	; and $2000
	STA bitmap_dst+1
	;
	LDA $FF15		; pre-read $FF15
	AND #$F0
	STA ctg2+1
	LDA $FF15
	AND #$0F
	STA ctg3+1
	;
ctg1	LDA (screen_col),y
	TAX
	LSR a
	LSR a
	LSR a
	LSR a
ctg2	ORA #$70		; luminance
	STA (lum),y
	;
	TXA
	ASL a 
	ASL a
	ASL a
	ASL a
ctg3	ORA #$01		; color
	STA (col),y
	;
	LDA (screen_chr),y	; get the current character from the screen
	TAX
	STA char_source
	LDA #$00
	STA char_source+1
	;
	ASL char_source		; 16 bit * 8
	ROL char_source+1
	ASL char_source
	ROL char_source+1
	ASL char_source
	ROL char_source+1
	;
	LDA $FF13		; add the base of the charset to get to the source gfx of this char
	AND #$FC
	CLC
	ADC char_source+1
	STA char_source+1
	;
	; reverse
	;  
	TXA			; if char is <80, we don't have to worry about invert
	BPL ctg_no_rev 
	;
	LDA $FF07		; if 256 chars mode is set, same
	BMI ctg_no_rev
	;
	LDA char_source+1	; source = source - $400
	SEC
	SBC #$04
	STA char_source+1
	LDX #$FF		; and invert char
	DB $2C
ctg_no_rev
	LDX #$00
	STX ctg_rev+1
	;
	STY ctg_tmp+1		; save y
	;
	LDY #$07
ctg4	LDA (char_source),y	; copy
ctg_rev	EOR #$00		; (and possibly invert)
	STA (bitmap_dst),y	; character
	DEY
	BPL ctg4
	;
	LDA bitmap_dst		; bitmap destination: next character
	CLC
	ADC #$08
	STA bitmap_dst
	BCC *+4
	INC bitmap_dst+1
	;
ctg_tmp	LDY #$00
	;
	; ---
	;
	INY
	BNE ctg1
	;
	INC lum+1		; next page
	INC col+1
	INC screen_col+1
	INC screen_chr+1
	LDA screen_chr+1
	AND #$07		; stop at $0800 boundary
	BNE ctg1
	;
	; --- post processing
	;
	LDA $FF19		; pre-calculate border color and luminance
	AND #$F0
	STA screen_col
	LSR a
	LSR a
	LSR a
	LSR a
	ORA screen_col
	STA screen_col
	;
	LDA $FF19
	AND #$0F
	STA screen_col+1
	ASL a
	ASL a
	ASL a
	ASL a
	ORA screen_col+1
	STA screen_col+1
	;
	LDA $FF07
	AND #$08
	BNE cc_40_mode                    
	;
	; we're in 38 columns mode, paint two colums border color
	;
	LDY #$00
	STY lum
	STY col
	STY bitmap_dst
	LDA #ctg_colmap>>8	; dest: $1800
	STA lum+1
	ORA #$04
	STA col+1
	LDA #ctg_bitmap>>8	; and $2000
	STA bitmap_dst+1
	;
	LDX #24
	;
ctg5	LDY #$07
	LDA #$FF
ctg6	STA (bitmap_dst),y	; left side
	DEY
	BPL ctg6
	;
	LDA bitmap_dst
	CLC
	ADC #$38
	STA bitmap_dst
	LDA bitmap_dst+1
	ADC #$01
	STA bitmap_dst+1
	;
	LDY #$07
	LDA #$FF
ctg7	STA (bitmap_dst),y	; right side
	DEY
	BPL ctg7
	;
	LDA bitmap_dst		; bitmap destination: next character
	CLC
	ADC #$08
	STA bitmap_dst
	BCC *+4
	INC bitmap_dst+1
	;
	INY
	LDA screen_col		; lum
	STA (lum),y		; left side
	LDY #39
	STA (lum),y		; right side
	;
	LDA screen_col+1	; col
	STA (col),y		; right side
	LDY #$00
	STA (col),y		; left side
	;
	LDA lum			; next line
	CLC
	ADC #$28
	STA lum
	STA col
	BCC *+6
	INC lum+1
	INC col+1
	;
	DEX
	BPL ctg5
	;
cc_40_mode
	;
;not_pressed
;	LDA #$7F
;	STA $FD30
;	STA $FF08
;	LDA $FF08
;	AND #$10		; Query keyboard for "Space"
;	BNE not_pressed
	;
	LDA #$CC
ctg_sync1
	CMP $FF1D
	BNE ctg_sync1
	;
	LDA $FF06
	ORA #$38		; turn graphics mode on
	STA $FF06
	;
	LDA $FF07		; PAL/NTSC friendly
	AND #$47
	ORA #$08		; use $18 for multicolor
	STA $FF07
	;
	LDA $FF12
	AND #$03		; keep lowest 2 bits (sound)	
	ORA #ctg_bitmap>>10	; $08 = $2000, $10 = $4000, etc.
	STA $FF12
	;
	LDA #ctg_colmap>>8	; color map at $1800
	STA $FF14
	;
;	JMP *
	;
;[eof]	