	org $1001-2
	dw  $1001
	
	dw nextln,0	; second word is line number
	db $9E,"4109",0
nextln	db 0,0

LOGO_COLORS = $0800 + 7 * 40	
TIMER_SCREEN_POS = $0EC9
	
start
	sei
	sta $ff3f
	;
	ldy #$00
	ldx #$FF
	lda $FF07
	and #$40
	beq *+4
	ldx #$F8
	cpx $FF1D
	bne *-3
	;
	sty $FF15
	sty $FF19
	;
il_01	lda #$0C
	sta $0800,y
	sta $0900,y
	lda #$4C
	sta $0A00,y
	lda loader_code,y
	sta $0B00,y
	lda #$20
	sta $0C00,y
	sta $0D00,y
	sta $0E00,y
	sta $0F00,y
	iny
	bne il_01
	;
unpack_start
	lda #(data_start-1) & 255
	sta $10
	lda #(data_start-1) >> 8
	sta $11
	;
	lda #$18
	sta $12
	lda #$0D
	sta $13
	;
loop	inc $10
	bne *+4
	inc $11 
	;
	lda ($10),y
	beq comp1	; *** flag 1: # bytes
	;
	cmp #$02	; *** flag 2: 3 bytes
	bne onebyte
	;
	ldx #$03
	bne comp2
	;
comp1	inc $10
	bne *+4
	inc $11
	;
	lda ($10),y
	tax
	;
comp2	inc $10
	bne *+4
	inc $11
	;
	lda ($10),y
	;
	db $2C
onebyte	ldx #$01
	;
putloop
	sta ($12),y
	;
	inc $12
	bne *+4
	inc $13
	;
	dex
	bne putloop
	;
	lda $13
	cmp #$0F	; unpack end address
	bne loop
	;
	ldx #39
il_02	lda #$40
	sta $0C00 + 6 * 40,x
	sta $0C00 + 18 * 40,x
	lda #$23
	sta $0800 + 6 * 40,x
	sta $0800 + 18 * 40,x
	lda colors,x
	sta $0800 +  7 * 40 + 6,x
	sta $0800 +  8 * 40 + 5,x
	sta $0800 +  9 * 40 + 4,x
	sta $0800 + 10 * 40 + 3,x
	sta $0800 + 11 * 40 + 2,x
	sta $0800 + 12 * 40 + 1,x
	sta $0800 + 13 * 40 + 0,x
	dex
	bpl il_02
	;
	jmp $0B00
colors
	db $0C,$0C,$0C,$0C, $0C,$0C,$0C,$0C
	db $1C,$1C,$2C,$2C, $3C,$3C,$4C,$4C
	db $5C,$5C,$6C,$6C, $6C,$6C,$5C,$5C
	db $4C,$4C,$3C,$3C, $2C,$2C,$1C,$1C
	db $0C,$0C,$0C,$0C, $0C,$0C,$0C,$0C

loader_code
	ldx #$00
	stx $AB 			; no filename
	inx
	stx $AD 			; leave screen on
	;
	lda $065E
	cmp #$78
	bne skip
	;
	jsr $065E 			; start loader
	;
loop1	lda $A6
	beq loop1 			; wait for the loader to become ready
	;
skip	lda #$00
	sta TIMER_SCREEN_POS+5-$0400
	;
	ldx #50
	lda $FF07
	and #$40
	beq *+4
	ldx #60
	stx TIMER_SCREEN_POS+5
	stx timer_hi - (loader_code - $0B00)+5
	;
loop2	lda #$CB
	cmp $FF1D
	bcs *-3
	;
	ldx #$05
tmr2	dec TIMER_SCREEN_POS,x
	lda TIMER_SCREEN_POS,x
	cmp timer_lo - (loader_code - $0B00),x
	bne tmr1
	;
	lda timer_hi - (loader_code - $0B00),x
	sta TIMER_SCREEN_POS,x
	dex
	bpl tmr2
tmr1	;
	ldx #$06
	ldy #$00
cl_01	lda LOGO_COLORS + 0 * 40 + 39,y
	sta $10,x
	tya
	clc
	adc #40
	tay
	dex
	bpl cl_01
	;
	ldx #38
mv1	lda LOGO_COLORS + 0 * 40 + 0,x
	sta LOGO_COLORS + 0 * 40 + 1,x
	lda LOGO_COLORS + 1 * 40 + 0,x
	sta LOGO_COLORS + 1 * 40 + 1,x
	lda LOGO_COLORS + 2 * 40 + 0,x
	sta LOGO_COLORS + 2 * 40 + 1,x
	lda LOGO_COLORS + 3 * 40 + 0,x
	sta LOGO_COLORS + 3 * 40 + 1,x
	lda LOGO_COLORS + 4 * 40 + 0,x
	sta LOGO_COLORS + 4 * 40 + 1,x
	lda LOGO_COLORS + 5 * 40 + 0,x
	sta LOGO_COLORS + 5 * 40 + 1,x
	lda LOGO_COLORS + 6 * 40 + 0,x
	sta LOGO_COLORS + 6 * 40 + 1,x
	dex
	bpl mv1
	;
	ldx #$06
	ldy #$00
cl_02	lda $10,x
	sta LOGO_COLORS + 0 * 40 + 0,y
	tya
	clc
	adc #40
	tay
	dex
	bpl cl_02
	;
	lda #$CB
	cmp $FF1D
	bcc *-3
	;
	bcs loop2
	;
timer_lo
	db $30-1,$30-1,$3A-1,$30-1,$30-1,$FF
timer_hi
	db "99:59",50
	;
data_start
	include "screen_comp.asm"
; EOF