SHOW_END_SEQUENCE = 0
SHOW_FREE_SPACE = 0

	org $0800 - 2
	dw  $0800

	include "music/!playerv.asm"

src_ptr		= $02
chr_ptr		= $04
col_ptr		= $06

VAR_MAP_Y	= $10
VAR_MAP_X	= $11
VAR_PLAYER_X	= $12
VAR_PLAYER_Y	= $13

VAR_SHOT_DELAY	= $14
VAR_SHOOTING	= $15
VAR_SHOT_X	= $16
VAR_SHOT_Y	= $17

VAR_MOVE_UP			= $18
VAR_MOVE_DOWN			= $19
VAR_MOVE_LEFT			= $1A
VAR_MOVE_RIGHT			= $1B
VAR_FIRE			= $1C
VAR_LIVES			= $1D
VAR_FRAME_DELAY			= $1E
VAR_WALL_ANIMATION_DELAY	= $1F
VAR_DIFFICULTY			= $20
VAR_ENEMY_EXPLOSION_DELAY	= $21

VAR_BLOCK_INDEX	= $22
VAR_WALL_POS_X	= $23
VAR_WALL_POS_Y	= $24
VAR_WALL_LENGTH	= $25
LOOP_WALLS_HORIZ= $26
LOOP_WALLS_VERT	= $27

wall_chr_ptr	= $28			; 16 bit
wall_col_ptr	= $2A			; 16 bit
wall_ds_chr_ptr	= $2C			; 16 bit
wall_ds_col_ptr	= $2E			; 16 bit

VAR_SCORE	= $30			; 3 bytes
VAR_HIGH	= $33			; 3 bytes

VAR_SHOT_LEFT	= $36
VAR_SHOT_RIGHT	= $37
VAR_SHOT_UP	= $38
VAR_SHOT_DOWN	= $39

VAR_ENEMY_MOVE_LEFT	= $3A
VAR_ENEMY_MOVE_RIGHT	= $3B
VAR_ENEMY_MOVE_UP	= $3C
VAR_ENEMY_MOVE_DOWN	= $3D

VAR_ENEMY_FLAGS		= $3E
VAR_ENEMY_X		= $3F
VAR_ENEMY_Y		= $40

VAR_PLAYER_FACING	= $41
VAR_PLAYER_FACING_TMP	= $42
VAR_PLAYER_MOVE_TMP	= $43

VAR_HAT_TMP		= $44

VAR_MAX_ENEMIES		= $45
VAR_ENEMY_DELAY		= $46
VAR_CURRENT_ENEMY_DELAY	= $47
VAR_ENEMIES_IN_ROOM	= $48
TMP_INDEX		= $49
VAR_LAST_MOVED_ENEMY	= $4A
TMP_SAVE_X		= $4B
TMP_SAVE_Y		= $4C

TMP_SAVE_Y2		= $4E

VAR_PLAYER_ENTER_X	= $4F
VAR_PLAYER_ENTER_Y	= $50
VAR_ESC			= $51

VAR_RANDOM		= $52 ; 2*5 bytes
VAR_EXPLOSION_COUNTS	= $60 ; 16 bytes
VAR_ZODIAC_FOUND	= $70
VAR_ZODIAC_PLACED	= $71
VAR_ZODIAC_FLAG		= $72 ; 12 bytes

VAR_CURRENT_POWERUP	= $80
VAR_POWERUP_TIMER_LO	= $81
VAR_POWERUP_TIMER_HI	= $82
VAR_M_HELD		= $83
VAR_VOLUME_TIMER	= $84
VAR_VOLUME_ADD		= $85
VAR_CURRENT_ZODIAC	= $86
VAR_HELP_SELECT		= $87

; ---
FLAG_PLAYER_DIES	= $90
FLAG_NEW_SCREEN		= $91
FLAG_ZODIAC_CARRIED	= $92
FLAG_PICKED_ZODIAC	= $93
FLAG_ENEMY_MOVE		= $94
FLAG_IN_TIME_VAULTS	= $95
FLAG_TIME_VAULTS_CLOSED	= $96
FLAG_RASTERS		= $97
FLAG_MAP_MODE		= $98

; const
DEMON_COUNT_ZODIAC_FLAG	= $0100
CHARSET			= $0400
SCREEN			= $0800
SCORE_POS		= 1 * 40 + 7
LIVES_POS		= 1 * 40 + 22
HIGH_POS		= 1 * 40 + 32

; SNES controller support
BIT_CLOCK 		= 1 << 7
BIT_LATCH 		= 1 << 6
BIT_P1_DATA0 		= 1 << 1
BIT_P2_DATA0 		= 1 << 0
BITS_INPUT 		= BIT_P1_DATA0 | BIT_P2_DATA0    ; Userport bits that must always be kept HIGH (so that they act as INPUTs)
USERPORT 		= $FD10

	include "logo_charset.asm"
	align 256
	include "charset.asm"
	
	if SHOW_FREE_SPACE = 1
	org $0F00
	ldx #$00
	stx $FF15
sfs_01	lda #$20
	sta $0800,x
	sta $0900,x
	sta $0B00,x
	sta $0E00,x
	lda #$41
	sta $0A00,x
	inx
	bne sfs_01
	;
	lda #"$"
	sta SCREEN + $0400 + 13 * 40 + 0
	lda #(map_chars_charset - code_end) >> 8
	jsr conv_hex_byte
	sty SCREEN + $0400 + 13 * 40 + 1
	sta SCREEN + $0400 + 13 * 40 + 2
	lda #(map_chars_charset - code_end) & 255
	jsr conv_hex_byte
	sty SCREEN + $0400 + 13 * 40 + 3
	sta SCREEN + $0400 + 13 * 40 + 4
	jmp *

conv_hex_byte
	tax
	lsr a
	lsr a
	lsr a
	lsr a
	jsr conv_hex
	tay
	txa
	and #$0F
conv_hex
	cmp #$0A
	bcs conv_hex_1
	ora #$30
	rts
conv_hex_1
	sbc #$09
	rts
	endif

	org $0FE8
	if SHOW_FREE_SPACE = 1
	jmp $0F00
	else
	sei
	sta $FF3F
	;
	ldx #$02
	lda #$00
il01	sta $00,x
	sta $0100,x
	inx
	bne il01
	;
	jmp start
	endif

	; ---
	; variables
	align 256
DAT_GAME_MAP
	db $06,$00,$0A,$0C, $00,$0C,$00,$0A, $00,$00,$0A,$04
	db $08,$04,$05,$0C, $04,$06,$00,$11, $06,$04,$0F,$07
	db $0F,$0B,$00,$04, $05,$02,$04,$01, $0F,$07,$05,$07
	db $08,$03,$06,$0B, $0A,$0B,$07,$0D, $05,$02,$00,$11
	
	db $0D,$06,$09,$03, $05,$02,$03,$05, $00,$03,$06,$07
	db $08,$09,$00,$0A, $00,$09,$0A,$00, $0A,$0A,$07,$01
	db $05,$0A,$04,$08, $04,$06,$02,$00, $02,$02,$0B,$03
	db $06,$02,$03,$0D, $08,$03,$0D,$06, $03,$05,$0E,$04
	
	db $05,$09,$04,$01, $05,$00,$07,$0D, $06,$00,$04,$01
	db $06,$04,$01,$08, $12,$06,$03,$0D, $0F,$12,$0F,$07
	db $01,$01,$0D,$0F, $0C,$02,$0A,$07, $05,$00,$02,$03
	db $05,$09,$03,$05, $00,$03,$05,$09, $00,$00,$09,$10

	; room layouts
VAR_ROOM_LAYOUT
	db $00,$00,$00,$02,$02,$02,$00,$00,$00	; $00 ($00)
	db $00,$03,$00,$00,$03,$00,$00,$03,$00	; $09 ($01)
	db $00,$03,$00,$02,$1B,$02,$00,$03,$00	; $12 ($02)
	db $00,$03,$00,$02,$16,$00,$00,$00,$00	; $1B ($03)
	db $00,$00,$00,$02,$11,$00,$00,$03,$00	; $24 ($04)
	db $00,$03,$00,$00,$15,$02,$00,$00,$00	; $2D ($05)
	db $00,$00,$00,$00,$01,$02,$00,$03,$00	; $36 ($06)
	db $00,$03,$00,$02,$09,$00,$00,$03,$00	; $3F ($07)
	db $00,$03,$00,$00,$0A,$02,$00,$03,$00	; $48 ($08)
	db $00,$03,$00,$02,$0D,$02,$00,$00,$00	; $51 ($09)
	db $00,$00,$00,$02,$04,$02,$00,$03,$00	; $5A ($0A)
	db $05,$1A,$06,$0E,$03,$0F,$07,$0A,$08	; $63 ($0B) edited (movel wall)
	db $05,$02,$06,$1F,$10,$0F,$00,$07,$08	; $6C ($0C) edited (added block)
	db $05,$17,$06,$05,$18,$0B,$07,$03,$08	; $75 ($0D) edited (movel wall)
	db $05,$17,$06,$0C,$1C,$0A,$07,$1D,$19	; $7E ($0E)
	db $00,$14,$06,$05,$07,$12,$07,$13,$08	; $87 ($0F) edited (added block)
	db $05,$20,$06,$0E,$1E,$0B,$07,$1D,$08	; $90 ($10) edited (moved middle lines)
	db $05,$17,$06,$1F,$13,$08,$00,$03,$00	; $99 ($11) new!
	db $00,$00,$00,$02,$11,$00,$00,$19,$00	; $A2 ($12) new!

	;org $1577
VAR_LINE_DATA_PTRS
	dw VAR_LINE_DATA_PTRS
	
	; $01
	; #############
	; #............
	; #............
	; #............
	; #............
	; #............
	; #...........#
	dw DAT_ELEMENT_01
	
	; $02
	; #############
	; .............
	; .............
	; .............
	; .............
	; .............
	; ############# 
	dw DAT_ELEMENT_02
	
	; $03
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	dw DAT_ELEMENT_03
	
	; $04
	; #############
	; .............
	; .............
	; .............
	; .............
	; .............
	; #...........#
	dw DAT_ELEMENT_04
	
	; $05
	; #############
	; #............
	; #............
	; #............
	; #............
	; #............
	; #............
	dw DAT_ELEMENT_05
	
	; $06
	; #############
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	dw DAT_ELEMENT_06
	
	; $07
	; #............
	; #............
	; #............
	; #............
	; #............
	; #............
	; #############
	dw DAT_ELEMENT_07
	
	; $08
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; #############
	dw DAT_ELEMENT_08
	
	; $09
	; #...........#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; #...........#
	dw DAT_ELEMENT_09
	
	; $0A
	; #...........#
	; #............
	; #............
	; #............
	; #............
	; #............
	; #...........#
	dw DAT_ELEMENT_0A
	
	; $0B
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	dw DAT_ELEMENT_0B
	
	; $0C
	; #############
	; .............
	; .............
	; .............
	; .............
	; .............
	; #............
	dw DAT_ELEMENT_0C
	
	; $0D
	; #...........#
	; .............
	; .............
	; .............
	; .............
	; .............
	; #############
	dw DAT_ELEMENT_0D
	
	; $0E
	; #............
	; .............
	; .............
	; .............
	; .............
	; .............
	; #............
	dw DAT_ELEMENT_0E
	
	; $0F
	; ............#
	; .............
	; .............
	; .............
	; .............
	; .............
	; ............#
	dw DAT_ELEMENT_0F
	
	; $10
	; #............
	; #............
	; #............
	; #............
	; #............
	; #............
	; #............
	dw DAT_ELEMENT_10
	
	; $11
	; #############
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; #...........#
	dw DAT_ELEMENT_11
	
	; $12
	; ............#
	; .............
	; .............
	; .............
	; .............
	; .............
	; #############
	dw DAT_ELEMENT_12
	
	; $13
	; .............
	; .............
	; .............
	; .............
	; .............
	; .............
	; #...........#
	dw DAT_ELEMENT_13
	
	; $14
	; #...........#
	; #............
	; #............
	; #............
	; #............
	; #............
	; #............
	dw DAT_ELEMENT_14
	
	; $15
	; #...........#
	; #............
	; #............
	; #............
	; #............
	; #............
	; #############
	dw DAT_ELEMENT_15
	
	; $16
	; #...........#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; #############
	dw DAT_ELEMENT_16
	
	; $17
	; #...........#
	; .............
	; .............
	; .............
	; .............
	; .............
	; .............
	dw DAT_ELEMENT_17
	
	; $18
	; #########....
	; .............
	; .............
	; .............
	; ............#
	; ............#
	; ............#
	dw DAT_ELEMENT_18
	
	; $19
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	; #...........#
	; #############
	dw DAT_ELEMENT_19
	
	; $1A
	; #...........#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	; ............#
	dw DAT_ELEMENT_1A
	
	; $1B
	; #...........#
	; .............
	; .............
	; .............
	; .............
	; .............
	; #...........#
	dw DAT_ELEMENT_1B
	
	; $1C
	; #############
	; .............
	; .............
	; .............
	; .............
	; .............
	; .............
	dw DAT_ELEMENT_1C
	
	; $1D
	; .............
	; .............
	; .............
	; .............
	; .............
	; .............
	; #############
	dw DAT_ELEMENT_1D
	
	; $1E
	; .............
	; .............
	; .............
	; .............
	; .............
	; ...#######...
	; .............
	dw DAT_ELEMENT_1E
	
	; $1F
	; #............
	; .............
	; .............
	; .............
	; .............
	; .............
	; #############
	dw DAT_ELEMENT_1F
	
	; $20
	; #############
	; .............
	; .............
	; .............
	; .............
	; .............
	; ...#######...
	dw DAT_ELEMENT_20

DAT_ELEMENT_01	db $02				; number of horiz walls
	db $00,$00,$0D				; 0,0  width=13
	db $06,$0C,$01				; 6,12 width=1
	db $01					; number of vert walls
	db $01,$00,$06				; 1,0; height = 6
	
DAT_ELEMENT_02	db $02
	db $00,$00,$0D
	db $06,$00,$0D
	db $00
	
DAT_ELEMENT_03	db $00
	db $02
	db $00,$00,$07
	db $00,$0C,$07
	
DAT_ELEMENT_04	db $03
	db $00,$00,$0D
	db $06,$00,$01
	db $06,$0C,$01
	db $00
	
DAT_ELEMENT_05	db $01
	db $00,$00,$0D
	db $01
	db $01,$00,$06
	
DAT_ELEMENT_06	db $01
	db $00,$00,$0D
	db $01
	db $01,$0C,$06
	
DAT_ELEMENT_07	db $01
	db $06,$00,$0D
	db $01
	db $00,$00,$06
	
DAT_ELEMENT_08	db $01
	db $06,$00,$0D
	db $01
	db $00,$0C,$06
	
DAT_ELEMENT_09	db $00
	db $03
	db $00,$00,$01
	db $00,$0C,$07
	db $06,$00,$01
	
DAT_ELEMENT_0A	db $00
	db $03
	db $00,$00,$07
	db $00,$0C,$01
	db $06,$0C,$01
	
DAT_ELEMENT_0B	db $00
	db $01
	db $00,$0C,$07
	
DAT_ELEMENT_0C	db $01
	db $00,$00,$0D
	db $01
	db $06,$00,$01
	
DAT_ELEMENT_0D	db $03
	db $00,$00,$01
	db $00,$0C,$01
	db $06,$00,$0D
	db $00
	
DAT_ELEMENT_0E	db $00
	db $02
	db $00,$00,$01
	db $06,$00,$01
	
DAT_ELEMENT_0F	db $00
	db $02
	db $00,$0C,$01
	db $06,$0C,$01
	
DAT_ELEMENT_10	db $00
	db $01
	db $00,$00,$07
	
DAT_ELEMENT_11	db $02
	db $00,$00,$0D
	db $06,$00,$01
	db $01
	db $01,$0C,$06
	
DAT_ELEMENT_12	db $01
	db $06,$00,$0D
	db $01
	db $00,$0C,$01
	
DAT_ELEMENT_13	db $02
	db $06,$00,$01
	db $06,$0C,$01
	db $00
	
DAT_ELEMENT_14	db $01
	db $00,$0C,$01
	db $01
	db $00,$00,$07
	
DAT_ELEMENT_15	db $02
	db $00,$0C,$01
	db $06,$00,$0D
	db $01
	db $00,$00,$06
	
DAT_ELEMENT_16	db $02
	db $00,$00,$01
	db $06,$00,$0D
	db $01
	db $00,$0C,$06
	
DAT_ELEMENT_17	db $02
	db $00,$00,$01
	db $00,$0C,$01
	db $00
	
DAT_ELEMENT_18	db $01
	db $00,$00,$08
	db $01
	db $04,$0C,$03

DAT_ELEMENT_19	db $01
	db $06,$00,$0D
	db $02
	db $00,$00,$06
	db $00,$0C,$06
	
DAT_ELEMENT_1A	db $01
	db $00,$00,$01
	db $01
	db $00,$0C,$07
	
DAT_ELEMENT_1B	db $04
	db $00,$00,$01
	db $00,$0C,$01
	db $06,$00,$01
	db $06,$0C,$01
	db $00
	
DAT_ELEMENT_1C	db $01
	db $00,$00,$0D
	db $00
	
DAT_ELEMENT_1D	db $01
	db $06,$00,$0D
	db $00
	
DAT_ELEMENT_1E
	db $01
	db $05,$03,$07
	db $00

DAT_ELEMENT_1F
	db $02
	db $00,$00,$01
	db $06,$00,$0D
	db $00

DAT_ELEMENT_20
	db $02
	db $00,$00,$0D
	db $06,$03,$07
	db $00

	;
	; ---
	;
VAR_BLOCK_COLORS
	db $21,$31,$41,$51,$57,$47,$37,$27
	db $22,$32,$42,$52,$64,$54,$44,$34
	db $24,$26,$36,$46,$56,$66,$71

VAR_DEFAULT_DEMON_COUNTS
	db $00,$04,$04,$05,$05,$05,$06,$06		; first room is empty
	db $06,$07,$07,$08,$08,$09,$09,$0A
	db $0A,$0B,$0C,$0D,$0E,$0F,$05			; final room has 5

VAR_X_ORDER
	db 0,1,2,3,4,5,6,7,8,9,10,11
	;
	; ---
	;
VAR_BEHIND_PLAYER
	db $00,$00,$00,$00,$00
	
VAR_SAVE_BUFFER
	db $00,$00,$00,$00
	db $00,$00,$00,$00
	db $00,$00,$00,$00

	; y, x, flags
VAR_ENEMY_DATA
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00
	db $00,$00,$00

VAR_SCREEN_PTRS_LO
	db $0CA0 & 255
	db $0CC8 & 255
	db $0CF0 & 255
	db $0D18 & 255
	db $0D40 & 255
	db $0D68 & 255
	db $0D90 & 255
	db $0DB8 & 255
	db $0DE0 & 255
	db $0E08 & 255
	db $0E30 & 255
	db $0E58 & 255
	db $0E80 & 255
	db $0EA8 & 255
	db $0ED0 & 255
	db $0EF8 & 255
	db $0F20 & 255
	db $0F48 & 255
	db $0F70 & 255
	db $0F98 & 255
	db $0FC0 & 255

VAR_SCREEN_PTRS_HI
	db $0CA0 >> 8
	db $0CC8 >> 8
	db $0CF0 >> 8
	db $0D18 >> 8
	db $0D40 >> 8
	db $0D68 >> 8
	db $0D90 >> 8
	db $0DB8 >> 8
	db $0DE0 >> 8
	db $0E08 >> 8
	db $0E30 >> 8
	db $0E58 >> 8
	db $0E80 >> 8
	db $0EA8 >> 8
	db $0ED0 >> 8
	db $0EF8 >> 8
	db $0F20 >> 8
	db $0F48 >> 8
	db $0F70 >> 8
	db $0F98 >> 8
	db $0FC0 >> 8

CONST_MAP_SIZE	= 12
VAR_MAP_ROWS	 ; 12*12 can be indexed with a single byte
	db 0 * CONST_MAP_SIZE & 255
	db 1 * CONST_MAP_SIZE & 255
	db 2 * CONST_MAP_SIZE & 255
	db 3 * CONST_MAP_SIZE & 255
	db 4 * CONST_MAP_SIZE & 255
	db 5 * CONST_MAP_SIZE & 255
	db 6 * CONST_MAP_SIZE & 255
	db 7 * CONST_MAP_SIZE & 255
	db 8 * CONST_MAP_SIZE & 255
	db 9 * CONST_MAP_SIZE & 255
	db 10 * CONST_MAP_SIZE & 255
	db 11 * CONST_MAP_SIZE & 255
	;
	; screen positions of 13x7 blocks
	;
VAR_BLOCK_SCREEN_PTR_LO
	db $0CA0 & 255
	db $0CAD & 255
	db $0CBA & 255
	db $0DB8 & 255
	db $0DC5 & 255
	db $0DD2 & 255
	db $0ED0 & 255
	db $0EDD & 255
	db $0EEA & 255
VAR_BLOCK_SCREEN_PTR_HI
	db $0CA0 >> 8
	db $0CAD >> 8
	db $0CBA >> 8
	db $0DB8 >> 8
	db $0DC5 >> 8
	db $0DD2 >> 8
	db $0ED0 >> 8
	db $0EDD >> 8
	db $0EEA >> 8

VAR_MUL_40_LO
	db (0 * 40) & 255
	db (1 * 40) & 255
	db (2 * 40) & 255
	db (3 * 40) & 255
	db (4 * 40) & 255
	db (5 * 40) & 255
	db (6 * 40) & 255
VAR_MUL_40_HI
	db (0 * 40) >> 8
	db (1 * 40) >> 8
	db (2 * 40) >> 8
	db (3 * 40) >> 8
	db (4 * 40) >> 8
	db (5 * 40) >> 8
	db (6 * 40) >> 8

VAR_MUL_3
	db 0
	db 0 * 3
	db 1 * 3
	db 2 * 3
	db 3 * 3
	db 4 * 3
	db 5 * 3
	db 6 * 3
	db 7 * 3
	db 8 * 3
	db 9 * 3
	db 10 * 3
	db 11 * 3
	db 12 * 3

	;
	; --- constants
	;

CONST_SPACE_CHAR	= $00
CONST_BLOCK_CHAR	= $01
CONST_WALL_CHAR_1	= $02
CONST_WALL_CHAR_2	= $03
CONST_GATE_CHAR		= $2D
CONST_GATE_COLOR	= $5D

CONST_SHOT_CHAR		= $2E
CONST_SHOT_DELAY	= $02
CONST_POWER_SHOT_DELAY	= $01

CONST_WALL_ANIM_SPEED	= $04
CONST_EXPLOSION_DELAY	= $08
CONST_SHOT_COLOR	= $37
CONST_POWER_SHOT_COLOR	= $77

CONST_WALL_COLOR	= $2E
CONST_PLAYER_COLOR	= $4B
CONST_ZODIAC_COLOR	= $63			; zodiac sign color
CONST_FOUND_ZODIAC_COLOR= $53
CONST_PLACED_ZODIAC_COLOR= $71
CONST_TIME_VAULTS_TEXT_COLOR = $56

CONST_ENEMY_CHAR_FIRST	= $16
CONST_ENEMY_CHAR_LAST	= $25

CONST_ZODIAC_CHAR_FIRST	= $60			; changed
CONST_ZODIAC_CHAR_LAST	= $77

CONST_PLAYER_CHAR_FIRST	= $04
CONST_PLAYER_CHAR_LAST	= $15
CONST_FALLING_HAT_CHAR	= $26

CONST_EXPLOSION_CHAR_FIRST	= $78
CONST_EXPLOSION_CHAR_LAST	= $7F

CONST_ERASE_ENEMY_INDEX	= $08

TAB_MOVE_1
	db $00,$01,$02,$03
	db $2B,$53
	db $7B,$7A,$79,$78,$50
TAB_MOVE_2
	db $28,$02
TAB_MOVE_3
	db $05,$07,$01,$00,$04,$04,$01,$00,$0A,$07,$0A

VAR_PLAYER_CHARS
	db $04,$05,$06,$07
	db $04,$05,$08,$09
	db $0A,$0B,$0C,$0D
	db $0A,$0B,$0E,$0F
	db $10,$11,$12,$13
	db $10,$11,$14,$15
	db $00,$00,$00,$00

DAT_ZODIAC_CHARS_LO
	db $00
	db $60
	db $62
	db $64
	db $66
	db $68
	db $6A
	db $6C
	db $6E
	db $70
	db $72
	db $74
	db $76

DAT_ZODIAC_POSITIONS_X
	db 0
	db 18					; positions of zodiacs in Time Vault
	db 27					; arranged in a circle
	db 33
	db 35
	db 33
	db 27
	db 18
	db 9 
	db 4
	db 2
	db 4
	db 9 

DAT_ZODIAC_POSITIONS_Y
	db 0
	db 2					; positions of zodiacs in Time Vault
	db 3					; arranged in a circle
	db 5
	db 9
	db 13
	db 15
	db 16
	db 15
	db 13
	db 9
	db 5
	db 3
	
VAR_ENEMY_CHARS
	db $16,$17				; skull
	db $18,$19
	
	db $1A,$1B				; scissor
	db $1C,$1D
	
	db $1E,$1F				; ufo
	db $20,$21
	
	db $22,$23				; demon
	db $24,$25
	
	db $00,$00

VAR_ENEMY_COLORS
	db $46,$33,$67,$71,$00

VAR_ENEMY_SPEEDS
	db $12,$12,$12,$0C,$09,$07,$06,$05,$05,$05
	;
TAB_OFFS_1
	db $05,$06,$01,$00,$04,$05,$02,$00,$09,$07,$00
TAB_OFFS_2
	db $00,$01,$02,$03,$2B,$53,$52,$51,$50
TAB_SHOT_X
	db $28,$01,$01,$00,$03,$03,$03,$00,$00,$00
TAB_SHOT_Y
	db $00,$03,$00,$00,$01,$03,$00,$00,$01,$03,$00

raster_colors
	db $00,$38,$12,$48,$58,$77,$68,$48
	db $3C,$3C,$3C,$3C,$3C,$3C,$3C,$3C
	db $3C,$3C,$3C,$3C,$3C,$3C,$1C,$1C
	db $00,$38,$12,$48,$58,$77,$68,$48
	db $00

DAT_SCORE_ADD_LO
	db $50,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$20,$00,$00
DAT_SCORE_ADD_HI
	db $00,$01,$02,$03,$04,$05,$06,$07,$08,$09,$10,$11,$12,$00,$50,$50

falling_hat_gfx
	db $00,$04,$45,$55
	db $00,$40,$44,$54
	db $00,$01,$11,$15
	db $00,$10,$51,$55

VAR_EXPLOSION_CHARS
	db $00,$00,$7E,$7F,$7C,$7D,$7A,$7B,$78,$79,$00,$00
VAR_EXPLOSION_COLORS
	db $00,$00,$41,$41,$31,$31,$21,$21,$01,$01,$00,$00
	
time_vaults_door_close
	db 0 * 40
	db 4 * 40
	db 1 * 40
	db 3 * 40
	db 2 * 40

tab_title_lum_1
	db $20,$20,$30,$30,$30,$40,$40,$40
	db $40,$40,$40,$30,$30,$30,$20,$20
tab_title_lum_2
	db $30,$40,$40,$50,$50,$50,$60,$60
	db $60,$60,$50,$50,$50,$40,$40,$30

flashing_zodiac_colors
	db $73,$63,$53,$46,$36,$26
	db $06,$26,$36,$46,$53,$63

tab_powerups
	db 0,1,2,3,4,1,2,3,4,1,2,3,4

	cmap "-",$3D
	cmap "/",$3E
	cmap " ",$40
	
TXT_SCORE
	db "SCORE "
TXT_LIVES
	db "LIVES "
TXT_HIGH
	db "HIGH  "

TXT_CUBIC_GATE_CLOSED
	db " CUBIC GATE CLOSED "
TXT_CUBIC_GATE_OPEN
	db "  CUBIC GATE OPEN  "
TXT_TIME_VAULTS
	db "TIME VAULTS"
	;         
TXT_GAME_OVER
	db " GAME OVER "

TXT_SIGNS
	db "ARIES"
	db "TAURUS"
	db "GEMINI"
	db "CANCER"
	db "LEO"
	db "VIRGO"
	db "LIBRA"
	db "SCORPIO"
	db "SAGITTARIUS"
	db "CAPRICORN"
	db "AQUARIUS"
	db "PISCES"
TXT_SIGNS_LENGTHS
	db 0
	db 5, 6, 6, 6, 3, 5, 5, 7, 11, 9, 8, 6
TXT_SIGNS_OFFSETS
	db 0
	db 0, 5, 11, 17, 23, 26, 31, 36, 43, 54, 63, 71, 77

TXT_POWERUPS
	db "EXTRA LIFE      "
	db "DEMONS FROZEN   "
	db "LIGHTNING SHOT  "
	db "INVULNERABILITY "

TXT_END
	;  |01234567890123456789012345
	db "     CONGRATULATIONS      "
	db " YOU COLLECTED ALL SIGNS  "
	db "      OF THE ZODIAC       "
	db "AND DEFEATED  THE MASTERS "
	
	cmap " ",$C0
	cmap "0",$B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9
	cmap "A",$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF
	cmap "P",$D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB
	cmap ":",$BA
	cmap "+",$BC
	cmap "-",$BD
	cmap "/",$BE
	cmap "?",$BF
TXT_TITLE
	db "     DELUXE     "
	db "ORIGINAL GAME BY"
	db "ROBERT HENDERSON"
	db " DELUXE VERSION "
	db "  CSABO OF LOD  "
	db " GFX AND DESIGN "
	db "     KICHY      "

TXT_CONTROLS
	db "PRESS FIRE -- FOR JOYSTICK"
	db "PRESS SPACE - FOR KEYBOARD"
	db "CURSOR DOWN - CURSOR+SPACE"
	db "  PRESS START - FOR SNES  "
	db "    HIGH SCORE: "
title_screen_high_score
	db "000000    "
	cmap

mul_26	db 0, 26, 26*2, 26*3, 26*4

	include "logo_charmap.asm"

irq1	pha
	txa
	pha
	tya
	pha
	;
	ldy #$A8
	lda FLAG_RASTERS
	beq skip_rasters
	nop
	nop
	nop
	nop
	nop
	nop
	;
	ldx #$20
raster_loop
	lda raster_colors,x
	cpy $FF1E
	bcs *-3
	sta $FF19
	sta $FF15 
	dex
	bpl raster_loop
	;
skip_rasters
	jsr PLAYER
	;
	asl $FF09
	;
	lda #irq2 & 255
	sta $FFFE
	lda #irq2 >> 8
	sta $FFFF
	lda #$CC
	sta $FF0B
	;
	pla
	tay
	pla
	tax
	pla
	;
	rti
	
irq2	pha
	txa
	pha
	tya
	pha
	;
	jsr PLAYER
	;
	dec VAR_FRAME_DELAY
	dec VAR_WALL_ANIMATION_DELAY
	dec VAR_ENEMY_DELAY
	dec VAR_SHOT_DELAY
	dec VAR_ENEMY_EXPLOSION_DELAY
	;
	lda FLAG_MAP_MODE			; in map mode, powerups stop
	bne no_powerup
	;
	lda VAR_CURRENT_POWERUP
	beq no_powerup
	;
	dec VAR_POWERUP_TIMER_LO
	bpl no_powerup
	;
	jsr set_powerup_lo
	;
	sed
	lda VAR_POWERUP_TIMER_HI
	sec
	sbc #$01
	sta VAR_POWERUP_TIMER_HI
	cld
	bpl update_powerup_timer
	;
	jsr clear_powerup
	jmp no_powerup
	;
update_powerup_timer
	lda VAR_CURRENT_POWERUP			; exception for extra life:
	cmp #1					; don't show countdown
	beq no_powerup
	;
	lda VAR_POWERUP_TIMER_HI
	lsr a
	lsr a
	lsr a
	lsr a
	ora #$30
	sta SCREEN + $0400 + 2 * 40 + 35
	lda VAR_POWERUP_TIMER_HI
	and #$0F
	ora #$30
	sta SCREEN + $0400 + 2 * 40 + 36
	;
no_powerup
	;
	; handle volume
	;
	inc VAR_VOLUME_TIMER
	lda VAR_VOLUME_TIMER
	and #$0F
	bne vol1
	;
	lda VAR_VOLUME_ADD
	clc
	adc VOLUME				; adjust
	cmp #$F7				; arrived?
	beq vol1
	cmp #21*9
	beq vol1
	;
	sta VOLUME				; no, store
	;
	;
vol1	lda #$EF
	sta $FD30 
	lda #$FF
	sta $FF08
	lda $FF08
	and #$10				; Query keyboard for "M"
	bne m_not_pressed
	;
	ldx VAR_M_HELD
	bne vol3
	inc VAR_M_HELD
	;
	lda VAR_VOLUME_ADD
	eor #($09 ^ $F7)
	sta VAR_VOLUME_ADD
	bne vol3
	;
m_not_pressed
	ldx VAR_M_HELD
	beq vol3
	dec VAR_M_HELD 
	;
vol3	; ---
	;
	asl $FF09				; acknowledge IRQ
	;
	lda #irq1 & 255
	sta $FFFE
	lda #irq1 >> 8
	sta $FFFF
	lda #$02
	sta $FF0B
	;
	pla
	tay
	pla
	tax
	pla
	;
	rti
	;
	; *** Start ***
	;
start	ldx #$FF				; empty the stack
	txs
	;
	jsr SUB_INIT_RANDOM
	;
	ldy #$00
	lda $FF07
	and #$40
	beq *+4
	ldx #$F7
	cpx $FF1D
	bne *-3
	;
	sty $FF15				; Black background color and
	sty $FF19				; border Color
	;
	lda #$0B				; Screen off
	sta $FF06
	;
	lda $FF12				; Sound1 Freq Hi / Gfx
	and #$FB
	sta $FF12				; Sound1 Freq Hi / Gfx
	lda $FF13
	and #$0F
	ora #CHARSET >> 8			; Set charset
	sta $FF13
	;
	lda #$38
	sta $FF16				; Multi Color 1
	lda #$69
	sta $FF17				; Multi Color 2
	;
	ldx #$00
	stx VAR_HIGH				; clear high score
	stx VAR_HIGH+1
	stx VAR_HIGH+2
	;
	stx VAR_M_HELD
	stx VAR_VOLUME_TIMER
	lda #$F7
	sta VAR_VOLUME_ADD
	;
	dex					; x = $FF
	stx $FF0C				; hide cursor
	stx $FF0D
	;
	lda #(BIT_CLOCK | BITS_INPUT)   	; Set things up in order to be able to poll NES/SNES controllers
	sta USERPORT				; Start with latch low
	;
	ldx #$00
il02	lda $0800,x
	sta $0200,x
	lda $0900,x
	sta $0300,x
	lda $0A00,x
	sta $0400,x
	lda $0B00,x
	sta $0500,x
	lda $0C00,x
	sta $0600,x
	lda $0D00,x
	sta $0700,x
	inx
	bne il02
	;
	jsr PLAYER_INIT
	;
	lda #irq1 & 255
	sta $FFFE
	lda #irq1 >> 8
	sta $FFFF
	lda #$02
	sta $FF0B
	;
	cli
	;
LAB_TITLE_SCREEN
	lda #$00				; init powerup variables
	sta VAR_CURRENT_POWERUP
	sta VAR_POWERUP_TIMER_LO
	sta VAR_POWERUP_TIMER_HI
	sta FLAG_MAP_MODE
	;
	jsr screen_off_clear
	;
	; ---
	;
	ldx #$0F
	;
SWT_01	lda TXT_TITLE + 0 * 16,x
	sta SCREEN + $0400 + 11 * 40 + 12,x
	lda #$32
	sta SCREEN + 11 * 40 + 12,x
	;
	lda TXT_TITLE + 1 * 16,x
	sta SCREEN + $0400 + 14 * 40 + 12,x
	lda tab_title_lum_1,x
	ora #$0B
	sta SCREEN + 14 * 40 + 12,x
	lda TXT_TITLE + 2 * 16,x
	sta SCREEN + $0400 + 15 * 40 + 12,x
	lda tab_title_lum_2,x
	ora #$0B
	sta SCREEN + 15 * 40 + 12,x
	;
	lda TXT_TITLE + 3 * 16,x
	sta SCREEN + $0400 + 17 * 40 + 12,x
	lda tab_title_lum_1,x
	ora #$0D
	sta SCREEN + 17 * 40 + 12,x
	lda TXT_TITLE + 4 * 16,x
	sta SCREEN + $0400 + 18 * 40 + 12,x
	lda tab_title_lum_2,x
	ora #$0D
	sta SCREEN + 18 * 40 + 12,x
	;
	lda TXT_TITLE + 5 * 16,x
	sta SCREEN + $0400 + 20 * 40 + 12,x
	lda tab_title_lum_1,x
	ora #$0A
	sta SCREEN + 20 * 40 + 12,x
	lda TXT_TITLE + 6 * 16,x
	sta SCREEN + $0400 + 21 * 40 + 12,x
	lda tab_title_lum_2,x
	ora #$0A
	sta SCREEN + 21 * 40 + 12,x
	;
	dex
	bpl SWT_01
	;
	ldx #29
SWT_02	lda logo_charmap   + 0 * 30,x
	sta SCREEN + $0400 + 0 * 40 + 5,x
	lda logo_charmap   + 1 * 30,x
	sta SCREEN + $0400 + 1 * 40 + 5,x
	lda logo_charmap   + 2 * 30,x
	sta SCREEN + $0400 + 2 * 40 + 5,x
	lda logo_charmap   + 3 * 30,x
	sta SCREEN + $0400 + 3 * 40 + 5,x
	lda logo_charmap   + 4 * 30,x
	sta SCREEN + $0400 + 4 * 40 + 5,x
	lda logo_charmap   + 5 * 30,x
	sta SCREEN + $0400 + 5 * 40 + 5,x
	lda logo_charmap   + 6 * 30,x
	sta SCREEN + $0400 + 6 * 40 + 5,x
	lda logo_charmap   + 7 * 30,x
	sta SCREEN + $0400 + 7 * 40 + 5,x
	lda logo_charmap   + 8 * 30,x
	sta SCREEN + $0400 + 8 * 40 + 5,x
	lda logo_charmap   + 9 * 30,x
	sta SCREEN + $0400 + 9 * 40 + 5,x
	dex
	bpl SWT_02
	;
	; --- logo gradient
	;
	ldx #39
SWT_03	lda #103
	sta SCREEN + 0 * 40,x
	lda #103
	sta SCREEN + 1 * 40,x
	lda #103 
	sta SCREEN + 2 * 40,x
	lda #89
	sta SCREEN + 3 * 40,x
	lda #88
	sta SCREEN + 4 * 40,x
	lda #72
	sta SCREEN + 5 * 40,x
	lda #50 
	sta SCREEN + 6 * 40,x
	lda #34
	sta SCREEN + 7 * 40,x
	lda #18
	sta SCREEN + 8 * 40,x
	lda #2
	sta SCREEN + 9 * 40,x
	dex          
	bpl SWT_03
	;
	; ---
	;
	lda #$00				; charset to $0000
	sta $FF13
	;
	lda $FF07				; hires, 256 char mode
	and #$40
	ora #$88
	sta $FF07
	;
	ldx #$1B
	jsr screen_on_off
	;
	lda #0
	sta TMP_INDEX
	;
	lda #26
	db $2C
	;
TTL_02	lda #4*50+26
	sta VAR_FRAME_DELAY
	;
	ldx TMP_INDEX
	lda #TXT_CONTROLS & 255
	clc
	adc mul_26,x
	sta src_ptr
	lda #TXT_CONTROLS >> 8
	adc #0
	sta src_ptr+1
	;
title_loop
	ldy VAR_FRAME_DELAY
	cpy #26
	bcs TTL_01
	;
	dey
	bmi TTL_03
	;
	lda #$80				; space char on title screen
	sta SCREEN + $0400 + 24 * 40 + 7,y
	;
TTL_03	iny
	lda (src_ptr),y
	sta SCREEN + $0400 + 24 * 40 + 7,y
	lda #$45
	sta SCREEN + 24 * 40 + 7,y
	;
	tya
	bne TTL_01
	;
	ldx TMP_INDEX
	inx
	cpx #5					; 5 lines of text
	bne *+4
	ldx #0
	stx TMP_INDEX
	jmp TTL_02
	;
TTL_01	;
	if SHOW_END_SEQUENCE=1
	ldx #$00
	else
	;
	lda #$DF
	sta $FD30
	lda #$FF
	sta $FF08
	lda $FF08
	and #$01
	beq use_cursor
	;
	jsr check_fire
	bcc title_loop
	endif
	;
	cpx #$00
	beq use_joystick_1
	;
	cpx #$01
	beq use_joystick_2
	;
	cpx #$02
	beq use_keyboard
	;
	cpx #$03
	beq use_snes

use_joystick_1
	lda #SUB_POLL_JOYSTICK_1 & 255
	ldx #SUB_POLL_JOYSTICK_1 >> 8
	bne set_controls_call
	;
use_joystick_2
	lda #SUB_POLL_JOYSTICK_2 & 255
	ldx #SUB_POLL_JOYSTICK_2 >> 8
	bne set_controls_call
	;
use_keyboard
	lda #SUB_POLL_KEYBOARD & 255
	ldx #SUB_POLL_KEYBOARD >> 8
	bne set_controls_call
	;
use_snes
	lda #SUB_POLL_SNES & 255
	ldx #SUB_POLL_SNES >> 8
	bne set_controls_call
	;
use_cursor
	lda #SUB_POLL_CURSOR & 255
	ldx #SUB_POLL_CURSOR >> 8
	;
set_controls_call
	sta controls_call+1
	stx controls_call+2
	;
	; ---
	;
	jsr game_screen_off
	;
LAB_START_GAME
	lda #$00				; zero score
	sta VAR_SCORE
	sta VAR_SCORE+1
	sta VAR_SCORE+2
	;
	sta VAR_DIFFICULTY			; zero difficulty
	;
	lda #$05				; initial number of lives
	sta VAR_LIVES
	;
	jsr game_init_screen
	;
LAB_RESTART
	;
	; ---
	;
	lda #$00
	sta VAR_ZODIAC_FOUND			; zero collected
	sta VAR_ZODIAC_PLACED
	sta FLAG_ZODIAC_CARRIED
	sta FLAG_TIME_VAULTS_CLOSED
	sta FLAG_IN_TIME_VAULTS			; must clear this flag for status to be correctly drawn below
	tax
il03	sta VAR_ZODIAC_FLAG,x			; clear all 12 zodiac flags
	inx
	cpx #12
	bne il03
	;
	jsr clear_powerup			; also draws zodiac status
	;
	; ---
	;    
	lda #$05				; number of demons in last room
	clc
	adc VAR_DIFFICULTY
	cmp #13					; max 13
	bcc LR_01
	lda #13
LR_01	sta VAR_DEFAULT_DEMON_COUNTS+$16	; set
	;
	; ---
	;
	jsr SUB_RANDOMLY_PLACE_ZODIACS		; place zodiacs in maze
	;
	; ---
	;
	if SHOW_END_SEQUENCE = 1
	lda #11
	else
	lda #0
	endif
	sta VAR_MAP_X				; starting room (map position)
	if SHOW_END_SEQUENCE = 1
	lda #11
	else
	lda #0
	endif
	sta VAR_MAP_Y
	;
	lda #$00
	sta VAR_PLAYER_FACING
	lda #$0A
	sta VAR_PLAYER_Y
	lda #$12
	sta VAR_PLAYER_X
	;
LAB_NEW_ROOM
	lda #$00
	sta FLAG_PLAYER_DIES			; clear flags
	sta FLAG_NEW_SCREEN
	;
	tax
LNR_00	sta VAR_EXPLOSION_COUNTS,x		; inlined, init explosion counts
	inx
	cpx #$10
	bne LNR_00
	;
	lda VAR_MAP_X				; for each room, look up block color
	clc
	adc VAR_MAP_Y
	tax
	lda VAR_BLOCK_COLORS,x
	sta BLOCK_COLOR+1
	;
	; ---
	ldx VAR_MAP_Y				; for each room, get the current number of demons
	lda VAR_MAP_ROWS,x
	clc
	adc VAR_MAP_X 
	tax
	lda DEMON_COUNT_ZODIAC_FLAG,x
	and #$0F				; low nibble only
	sta VAR_MAX_ENEMIES
	sta VAR_ENEMIES_IN_ROOM
	; ---
	;
	jsr SUB_DRAW_ROOM
	;
	lda #$00
	ldx #CONST_MAP_SIZE-1
	cpx VAR_MAP_X
	bne not_in_time_vaults
	cpx VAR_MAP_Y
	bne not_in_time_vaults
	lda #$01
not_in_time_vaults
	sta FLAG_IN_TIME_VAULTS			; set time vaults flag
	;
	; ---
	;
	tax
	beq LNR_01
	;
	jsr clear_powerup			; no powers in Time Vaults
	lda #$01				; force player away from wall
	sta VAR_PLAYER_X
	jsr time_vaults_close_anim
	;
LNR_01	;
	;
	; ---
	;
	jsr SUB_PLACE_ENEMIES
	;
	lda VAR_PLAYER_X			; save room entry positions
	sta VAR_PLAYER_ENTER_X
	lda VAR_PLAYER_Y
	sta VAR_PLAYER_ENTER_Y
	;
LAB_ROOM_DRAWN
	lda #$00
	sta VAR_SHOOTING
	sta VAR_ESC
	sta FLAG_MAP_MODE
	;
	lda VAR_PLAYER_FACING
	jsr SUB_DRAW_PLAYER
	;
	jsr SUB_DRAW_ALL_ENEMIES
	;
	lda #$00
	sta VAR_WALL_ANIMATION_DELAY
	jsr SUB_ANIMATE_WALL_IMMEDIATELY
	;
	ldx FLAG_IN_TIME_VAULTS
	beq LRD_02
	;
	lda #$09				; default speed in Time Vaults (9)
	sec
	sbc VAR_DIFFICULTY
	cmp #$01				; max 1 (since there's always multiple enemies)
	bcs LRD_01
	lda #$01
	bne LRD_01
	;
LRD_02	lda #$10				; default enemy speed (delay): 16 frames
	sec
	sbc VAR_DIFFICULTY
	cmp #$06
	bcs LRD_01
	lda #$06				; never faster than 6 frames (player's speed)
LRD_01	sta VAR_CURRENT_ENEMY_DELAY
	sta VAR_ENEMY_DELAY
	;
	lda #CONST_EXPLOSION_DELAY
	sta VAR_ENEMY_EXPLOSION_DELAY
	;
	lda #$00
	sta VAR_LAST_MOVED_ENEMY
	;
	lda FLAG_IN_TIME_VAULTS
	beq LNR_03
	;
	lda FLAG_ZODIAC_CARRIED			; if player already has it...
	bne GAME_LOOP_OUTER			; then skip drawing
	;
	jsr SUB_DRAW_ZODIAC_2			; in Time Vault
	;
	jmp GAME_LOOP_OUTER
	;
LNR_03	jsr SUB_GET_ZODIAC_INDEX_FROM_MAP	; in regular rooms
	jsr SUB_DRAW_ZODIAC_1
	;
GAME_LOOP_OUTER	
	lda #$06				; fixed run speed (equivalent of 1 from the original)
	sta VAR_FRAME_DELAY
	;
	lda FLAG_IN_TIME_VAULTS			; if NOT in time vaults
	beq LNR_04				; skip
	;
	lda FLAG_ZODIAC_CARRIED			; if player already has it...
	bne LNR_04				; then also skip
	;
	jsr SUB_DRAW_ZODIAC_2			; keep redrawing Zodiac in Time Vaults (to avoid enemy covering it)
LNR_04	;
	; ---
	;
	ldx VAR_ESC
	inx
	;
	lda #$BF
	sta $FD30
	lda #$FF
	sta $FF08
	lda $FF08
	and #$10				; Query keyboard for "ESC"
	beq esc_pressed
	; 
	ldx #$00				; esc is not pressed, reset counter
esc_pressed
	stx VAR_ESC
	cpx #(75/6)
	bcc esc_not_held 
	;
	jmp SUB_GAME_OVER			; esc has been held for a second: game over
	;
esc_not_held
	;
	; ---
	;
	lda VAR_HELP_SELECT
	bne select_pressed
	;
	lda #$FE
	sta $FD30
	lda #$FF
	sta $FF08
	lda $FF08
	and #$08				; Query keyboard for "Help"
	bne help_not_pressed
	;
;	lda VAR_ZODIAC_FOUND			; testing code
;	bne zz1
;	;
;	lda #12
;	sta VAR_ZODIAC_FOUND
;	lda #11
;	sta VAR_ZODIAC_PLACED
;	lda #11
;	sta VAR_MAP_X
;	sta VAR_MAP_Y
;	jmp LAB_NEW_ROOM
;	;
;zz1	jmp end_sequence
	;
select_pressed
	jmp draw_map
	;
help_not_pressed
	jsr SUB_CLEAR_CONTROLS
controls_call
	jsr SUB_POLL_JOYSTICK_1
	;
	jsr SUB_CHECK_LEAVING_SCREEN
	;
	lda FLAG_NEW_SCREEN
	bne B_2321
	;
	lda VAR_PLAYER_Y
	jsr SUB_GET_SCREEN_PTRS
	;
	; ---
	;
	lda chr_ptr				; inlined
	sec
	sbc #$29
	sta chr_ptr
	lda chr_ptr+1
	sbc #$00
	sta chr_ptr+1
	;
	ldx #$00
GL_03	lda TAB_MOVE_1,x
	clc
	adc VAR_PLAYER_X
	tay
	lda (chr_ptr),y
	sta VAR_SAVE_BUFFER,x
	inx
	cpx #$0C
	bne GL_03
	;
	; ---
	;
	jsr S_2345
	;
	lda FLAG_PLAYER_DIES
	bne B_2321
	;
	jsr SUB_PLAYER_MOVE
	jsr SUB_PLAYER_SHOOT
	;
	; ---	
	;
B_2321	lda FLAG_IN_TIME_VAULTS
	beq GAME_LOOP_INNER
	;
	jsr SUB_CHECK_ZODIAC_PLACED
	;
GAME_LOOP_INNER	
	jsr SUB_ANIMATE_EXPLOSIONS
	;
	lda VAR_CURRENT_POWERUP			; powerup #2: demons frozen
	cmp #2
	beq GLI_01				; skip moving enemies
	;
	jsr SUB_MOVE_ENEMIES
	;
GLI_01	jsr S_2973
	jsr SUB_ANIMATE_WALL
	;
	lda FLAG_NEW_SCREEN
	beq B_1FC7
	;
;	inc VAR_SCREEN_VISIT_COUNTER
;	lda VAR_SCREEN_VISIT_COUNTER
;	cmp #$07				; every 6 rooms...
;	bne B_1FC4
;	lda #$01
;	sta VAR_SCREEN_VISIT_COUNTER
;	;
;	lda VAR_MAX_ENEMIES
;	cmp #16					; max number of enemies (16)
;	beq B_1FC4
;	;
;	inc VAR_MAX_ENEMIES			; skip count by two
;	inc VAR_MAX_ENEMIES
;	;
;B_1FC4	;	
	jmp LAB_NEW_ROOM
	;
B_1FC7	lda FLAG_PLAYER_DIES
	beq player_not_dead
	;
	jsr clear_powerup 
	;
	sed
	lda VAR_LIVES
	sec
	sbc #$01
	sta VAR_LIVES
	cld
	;
	jsr SUB_PRINT_LIVES
	;
	lda #$06
	jsr SUB_DRAW_PLAYER
	;
	jsr SUB_HAT_FALL			; animation + sound
	;
	lda VAR_LIVES				; zero lives?
	bne not_game_over			; no, continue
	;
	jmp SUB_GAME_OVER			; game over
	;
not_game_over
	lda VAR_PLAYER_ENTER_X			; move player back to where they entered the screen
	sta VAR_PLAYER_X
	lda VAR_PLAYER_ENTER_Y
	sta VAR_PLAYER_Y
	;	
	jmp LAB_NEW_ROOM
	;
player_not_dead
	lda VAR_ZODIAC_PLACED
	if SHOW_END_SEQUENCE = 1
	cmp #0
	else
	cmp #12
	endif
	bcs end_sequence
	;
GL_01	lda VAR_FRAME_DELAY
	beq GL_02
	;
	jmp GAME_LOOP_INNER
	;
GL_02	jmp GAME_LOOP_OUTER

end_sequence
	ldx #$00
esq_01	stx TMP_INDEX
	lda #$01
	sta VAR_EXPLOSION_COUNTS,x
	lda VAR_MUL_3+1,x
	tay
	lda #$86
	sta VAR_ENEMY_DATA+2,y
	;
esq_02	jsr SUB_ANIMATE_EXPLOSIONS
	;
	ldx TMP_INDEX
	lda VAR_EXPLOSION_COUNTS,x
	bne esq_02
	;
	inx
	cpx VAR_MAX_ENEMIES
	bne esq_01
	;
	; ---
	;
	lda #0
	sta TMP_INDEX
	sta VAR_PLAYER_FACING
	sta TMP_SAVE_X
	;
esq_10	lda #3*50+26
	sta VAR_FRAME_DELAY
	;
esq_03	jsr frame_sync
	;
	jsr check_fire
	bcs esq_done
	;
	ldx TMP_SAVE_X
	lda #TXT_END & 255
	clc
	adc mul_26,x
	sta src_ptr
	lda #TXT_END >> 8
	adc #0
	sta src_ptr+1
	;
	ldy VAR_FRAME_DELAY
	cpy #26
	bcs esq_08
	;
	dey
	bmi esq_09
	;
	lda #$00
	sta SCREEN + $0400 + 23 * 40 + 7,y
	;
esq_09	iny
	lda (src_ptr),y
	sta SCREEN + $0400 + 23 * 40 + 7,y
	lda #CONST_TIME_VAULTS_TEXT_COLOR
	sta SCREEN + 23 * 40 + 7,y
	;
	tya
	bne esq_08
	;
	ldx TMP_SAVE_X
	inx
	cpx #4
	bne *+4
	ldx #0
	stx TMP_SAVE_X
	jmp esq_10
	;
esq_08	lda VAR_FRAME_DELAY
	and #$03
	bne esq_03
	;
	lda VAR_PLAYER_FACING
	jsr SUB_DRAW_PLAYER
	; 
	ldx #0
esq_05	stx VAR_ZODIAC_PLACED
	jsr SUB_DRAW_ZODIAC_2
	lda VAR_ZODIAC_PLACED
	clc
	adc TMP_INDEX
	cmp #12
	bcc esq_06
	sbc #12
esq_06	tax
	lda flashing_zodiac_colors,x
	sta (col_ptr),y
	iny
	sta (col_ptr),y
	ldx VAR_ZODIAC_PLACED
	inx
	cpx #12
	bne esq_05
	;
	ldx TMP_INDEX
	inx
	cpx #12
	bne esq_07
	;
	lda VAR_PLAYER_FACING
	eor #$01
	sta VAR_PLAYER_FACING 
	;
	ldx #$00
esq_07	stx TMP_INDEX 
	;
	jmp esq_03
	;
esq_done
	inc VAR_DIFFICULTY
	;
	jmp LAB_RESTART	
	;
	; ***
	;	
frame_sync
	lda #$CB
	cmp $FF1D
	bne *-3
	rts

screen_on_off
	jsr frame_sync
	stx $FF06
	rts

screen_off_clear
	ldx #$0B
	jsr screen_on_off
	;
	lda #$00
	sta FLAG_RASTERS
	;
SUB_CLEAR_SCREEN
	ldx #$00
	lda #$40
SCS_01	sta SCREEN + $0000,x			; screen char mem
	sta SCREEN + $0100,x			; screen char mem
	sta SCREEN + $0200,x			; screen char mem
	sta SCREEN + $0300,x			; screen char mem
	sta SCREEN + $0400,x			; screen char mem
	sta SCREEN + $0500,x			; screen char mem
	sta SCREEN + $0600,x			; screen char mem
	sta SCREEN + $0700,x			; screen char mem
	inx
	bne SCS_01
	rts

pause_wait_for_fire
	lda #50
	sta VAR_FRAME_DELAY
	;
pw_01	lda VAR_FRAME_DELAY
	bne pw_01
	;
pw_02	jsr frame_sync				; wait for fire
	;
	jsr check_fire
	bcc pw_02
	;
pw_03	jsr frame_sync				; wait until release
	;
	jsr check_fire
	bcs pw_03
	;
	rts

check_fire
	jsr SUB_CLEAR_CONTROLS
	;
	ldx #$00
	jsr SUB_POLL_JOYSTICK_1
	lda VAR_FIRE
	bne cf_01
	;
	inx
	jsr SUB_POLL_JOYSTICK_2
	lda VAR_FIRE
	bne cf_01
	;
	inx
	jsr SUB_POLL_KEYBOARD
	lda VAR_FIRE
	bne cf_01
	;
	inx
	jsr SUB_POLL_SNES
	lda VAR_FIRE
	bne cf_01
	;
	clc
	rts
	;
cf_01	sec
	rts
	
game_screen_off
	ldx #$0B
	jsr screen_on_off
	;
	lda #$04				; font to $0400
	sta $FF13
	;
	lda $FF07				; multi, 128 char mode, 4 pixel shifted
	and #$40
	ora #$1C
	sta $FF07
	;
	rts

game_init_screen
	jsr SUB_CLEAR_SCREEN
	;
	; --- status bar
	;
	ldx #$05
status_bar_loop
	lda TXT_SCORE,x
	sta SCREEN + $0400 + 1 * 40 + 1,x
	lda TXT_LIVES,x
	sta SCREEN + $0400 + 1 * 40 + 16,x
	lda TXT_HIGH,x
	sta SCREEN + $0400 + 1 * 40 + 27,x
	;
	lda #$67
	sta SCREEN + 1 * 40 + 1,x
	sta SCREEN + 1 * 40 + 16,x
	sta SCREEN + 1 * 40 + 27,x
	;
	lda #$62
	sta SCREEN + SCORE_POS,x
	sta SCREEN + LIVES_POS,x
	sta SCREEN + HIGH_POS,x
	;
	dex
	bpl status_bar_loop
	;
	lda VAR_CURRENT_POWERUP
	beq st_01
	;
	jsr draw_powerup_status
	jmp st_02
	;
st_01	jsr draw_zodiac_status
	;
st_02	jsr SUB_PRINT_LIVES
	jsr SUB_PRINT_SCORE
	jsr SUB_PRINT_HIGH
	;
	; ---
	;
	ldx #$1B
	jsr screen_on_off
	;
	lda #$01
	sta FLAG_RASTERS
	;
	rts

draw_powerup_status
	ldx VAR_CURRENT_ZODIAC
	lda DAT_ZODIAC_CHARS_LO,x
	sta SCREEN + $0400 + 2 * 40 + 2
	clc
	adc #$01
	sta SCREEN + $0400 + 2 * 40 + 3
	;
	lda TXT_SIGNS_OFFSETS,x
	tay
	lda TXT_SIGNS_LENGTHS,x
	sta TMP_SAVE_X
	ldx #$00
SZP_03	lda TXT_SIGNS,y
	sta SCREEN + $0400 + 2 * 40 + 5,x
	iny
	inx
	cpx TMP_SAVE_X
	bne SZP_03
	;
	lda #$3A
	sta SCREEN + $0400 + 2 * 40 + 5,x
	lda #CONST_SPACE_CHAR
	sta SCREEN + $0400 + 2 * 40 + 6,x
	;
	lda VAR_CURRENT_POWERUP
	sec
	sbc #$01
	asl a
	asl a
	asl a
	asl a
	tay
SZP_04	lda TXT_POWERUPS,y
	sta SCREEN + $0400 + 2 * 40 + 7,x
	inx
	iny
	tya
	and #$0F
	bne SZP_04
	;
	lda #CONST_SPACE_CHAR
SZP_05	sta SCREEN + $0400 + 2 * 40 + 7,x
	inx
	cpx #30
	bne SZP_05
	;
	ldx #38
	lda #$63
SZP_02	sta SCREEN + 2 * 40,x
	dex
	bpl SZP_02
	;
	rts

clear_powerup
	lda #$00				; init powerup variables
	sta VAR_CURRENT_POWERUP
	sta VAR_POWERUP_TIMER_LO
	sta VAR_POWERUP_TIMER_HI 		; and continue, redraw status bar
	;
draw_zodiac_status
	ldx #$01
status_bar_loop_2
	lda VAR_MUL_3,x				; screen pos
	tay
	;
	lda DAT_ZODIAC_CHARS_LO,x		; chars (symbol)
	sta SCREEN + $0400 + 2 * 40 + 2,y
	clc
	adc #$01
	sta SCREEN + $0400 + 2 * 40 + 3,y
	lda #CONST_SPACE_CHAR
	sta SCREEN + $0400 + 2 * 40 + 4,y
	;
	lda FLAG_IN_TIME_VAULTS			; in Time Vaults
	beq SB_02
	;
	lda #$71
	cpx VAR_ZODIAC_PLACED
	beq SB_03
	bcc SB_03
	lda #CONST_FOUND_ZODIAC_COLOR 
	bne SB_03
	;
SB_02	lda VAR_ZODIAC_FOUND,x
	beq SB_01
	;
	lda #CONST_FOUND_ZODIAC_COLOR
	db $2C
SB_01	lda #$13
SB_03	sta SCREEN + 2 * 40 + 2,y
	sta SCREEN + 2 * 40 + 3,y
	;
	inx
	cpx #13
	bne status_bar_loop_2 
	rts

time_vaults_close_anim
	lda FLAG_TIME_VAULTS_CLOSED
	beq tvca_03
	;
	ldy #$00
	ldx #$04
tvca_04	jsr draw_vault_door
	tya
	clc
	adc #40
	tay
	dex
	bpl tvca_04
	rts
	;
tvca_03	lda VAR_PLAYER_FACING			; display the player
	jsr SUB_DRAW_PLAYER
	;
	ldx #$00
	;
tvca_01	jsr delay_30_frames
	;
	lda #$01
	sta EXPLOSION_FLAG
	;
	lda time_vaults_door_close,x
	tay
	jsr draw_vault_door
	;
	inx
	cpx #5					; 5 chars
	bne tvca_01
	;
	inc FLAG_TIME_VAULTS_CLOSED		; one-time event 
	;
delay_30_frames
	lda #30
	sta VAR_FRAME_DELAY
	;
tvca_02	lda VAR_FRAME_DELAY
	bne tvca_02
	rts

draw_vault_door
	lda #CONST_WALL_CHAR_2			; draw 1 one char
	sta SCREEN + $0400 + 12 * 40,y
	lda #CONST_WALL_COLOR
	sta SCREEN + 12 * 40,y
	rts

	;
	; ---
	;
SUB_ANIMATE_WALL
	lda VAR_WALL_ANIMATION_DELAY
	bne SAW_RTS
	;
SUB_ANIMATE_WALL_IMMEDIATELY
	lda CHARSET + 2 * 8 + 0
	pha
	lda CHARSET + 2 * 8 + 1
	pha
	;
	lda CHARSET + 3 * 8 + 6
	pha
	lda CHARSET + 3 * 8 + 7
	pha
	;
	ldx #5
	ldy #0
SAW_01	lda CHARSET + 2 * 8 + 2,y
	sta CHARSET + 2 * 8 + 0,y
	lda CHARSET + 3 * 8 + 0,x
	sta CHARSET + 3 * 8 + 2,x
	iny
	dex
	bpl SAW_01
	;
	pla
	sta CHARSET + 3 * 8 + 1
	pla
	sta CHARSET + 3 * 8 + 0
	;
	pla
	sta CHARSET + 2 * 8 + 7
	pla
	sta CHARSET + 2 * 8 + 6
	;
;	ldx VAR_WALL_ANIM_CNT
;	lda V_1698,x
;	tax
;	ldy #$00
;B_20B4	lda V_1688,x
;	sta CHARSET + 2 * 8,y			; wall char animation 1
;	inx
;	txa
;	and #$07
;	tax
;	iny
;	cpy #$08
;	bne B_20B4
;	ldx VAR_WALL_ANIM_CNT
;	lda V_169C,x
;	tax
;	ldy #$00
;B_20CD	lda V_1690,x
;	sta CHARSET + 3 * 8,y			; wall char animation 2
;	inx
;	txa
;	and #$07
;	tax
;	iny
;	cpy #$08
;	bne B_20CD
;	;
;	inc VAR_WALL_ANIM_CNT
;	lda VAR_WALL_ANIM_CNT
;	and #$03
;	sta VAR_WALL_ANIM_CNT
	;
	lda #CONST_WALL_ANIM_SPEED		; constant, wall animation delay
	sta VAR_WALL_ANIMATION_DELAY
	;
SAW_RTS	rts
	; --------
SUB_DRAW_ROOM
	lda #$63				; sync to below first blocks
	cmp $FF1D
	bne *-3
	;
	ldy VAR_MAP_Y
	lda #DAT_GAME_MAP & 255
	clc
	adc VAR_MAP_ROWS,y
	sta src_ptr
	lda #DAT_GAME_MAP >> 8
	adc #0
	sta src_ptr+1
	;
	ldy VAR_MAP_X
	lda (src_ptr),y
	bmi already_visited
	;
	ora #$80				; mark room as visited
	sta (src_ptr),y
	;
	lda #$10
	jsr SUB_ADD_SCORE_TENS
	;
	lda (src_ptr),y				; reload
	;
already_visited
	and #$7F				; ignore high bit
	sta VAR_BLOCK_INDEX
	asl a					; mul * 8
	asl a
	asl a
	adc VAR_BLOCK_INDEX			; mul * 9
	tax					; stored in x
	;
L_2118	; --- first loop, only filled blocks
	;
	txa
	pha
	;
	lda #$00				; loop 9 times
	sta VAR_BLOCK_INDEX
	;
SDR_01	lda VAR_ROOM_LAYOUT,x
	bne SDR_02				; skip non-zero (walls)
	;
	; ---
	;
	ldy VAR_BLOCK_INDEX
	lda VAR_BLOCK_SCREEN_PTR_LO,y		; screen pos
	sta chr_ptr
	sta col_ptr
	lda VAR_BLOCK_SCREEN_PTR_HI,y
	sta chr_ptr+1
	and #$FB
	sta col_ptr+1				; color pos
	;
	; ---
	;
	lda #$07				; 7 chars tall
	sta TMP_INDEX
	;
SDB_01	ldy #0					; 13 chars wide
	lda #CONST_BLOCK_CHAR
	sta (chr_ptr),y				; unrolled loop for speed
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	iny
	sta (chr_ptr),y
	;
BLOCK_COLOR
	lda #$00				; colors
	sta (col_ptr),y				; unrolled loop for speed				
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	;
	lda chr_ptr				; inlined
	clc
	adc #40
	sta chr_ptr
	sta col_ptr
	bcc *+6
	inc chr_ptr+1
	inc col_ptr+1
	;
	dec TMP_INDEX
	bne SDB_01
	;
	; ---
	;
SDR_02	inx
	inc VAR_BLOCK_INDEX
	lda VAR_BLOCK_INDEX
	cmp #$09
	beq SDR_01_CONT
	jmp SDR_01
	;
	; --- second loop, walls only
	;
SDR_01_CONT
	pla
	tax
	;
	lda #$00				; loop 9 times
	sta VAR_BLOCK_INDEX
	;
SDR_03	lda VAR_ROOM_LAYOUT,x
	beq SDR_04				; skip zeroes
	;
	jsr SUB_DRAW_WALLS
	;
SDR_04	inx
	inc VAR_BLOCK_INDEX
	lda VAR_BLOCK_INDEX
	cmp #$09
	bne SDR_03
	;
	; --------------------------------------
	; --- extra check for two drop shadow chars
	;
	lda SCREEN + $0400 + 4 * 40 + 25
	cmp #CONST_WALL_CHAR_2
	bne SDR_05
	lda SCREEN + $0400 + 4 * 40 + 26
	cmp #CONST_BLOCK_CHAR
	bne SDR_05
	;
	lda SCREEN + 4 * 40 + 26 		; add drop shadow
	sec
	sbc #$20				; drop shadow value
	sta SCREEN + 4 * 40 + 26 
	;
SDR_05	lda SCREEN + $0400 + 17 * 40 + 0
	cmp #CONST_WALL_CHAR_1
	bne SDR_06
	lda SCREEN + $0400 + 18 * 40 + 0
	cmp #CONST_BLOCK_CHAR
	bne SDR_06
	;
	lda SCREEN + 18 * 40 + 0		; add drop shadow
	sec
	sbc #$20				; drop shadow value
	sta SCREEN + 18 * 40 + 0
	;
	; ---
	;
SDR_06	ldx #10					; extra checks
	cpx VAR_MAP_X				; in cubic gate room?
	bne SDR_08
	inx
	cpx VAR_MAP_Y
	bne SDR_08
	;
	lda VAR_ZODIAC_FOUND			; got all zodiacs?
	cmp #12
	bcs SDR_07b
	;
	ldy #0					; gate closed
SDR_07	jsr SUB_DRAW_CUBIC_GATE
	tya
	clc
	adc #40
	tay
	cmp #5*40
	bne SDR_07
	;
	lda #TXT_CUBIC_GATE_CLOSED & 255
	ldx #TXT_CUBIC_GATE_CLOSED >> 8
	;
SDR_07c	sta src_ptr
	stx src_ptr+1
	;
	ldy #18
SDR_07a	lda (src_ptr),y
	sta SCREEN + $0400 + 22 * 40 + 10,y
	lda #$71
	sta SCREEN + 22 * 40 + 10,y
	lda #0
	sta SCREEN + $0400 + 21 * 40 + 10,y
	sta SCREEN + $0400 + 23 * 40 + 10,y
	dey
	bpl SDR_07a
	rts
	;
SDR_07b	ldy #0					; gate open
	jsr SUB_DRAW_CUBIC_GATE
	ldy #4*40
	jsr SUB_DRAW_CUBIC_GATE
	;
	lda #TXT_CUBIC_GATE_OPEN & 255
	ldx #TXT_CUBIC_GATE_OPEN >> 8
	bne SDR_07c				; always jump
	;
SDR_08	ldx #11					; extra checks
	cpx VAR_MAP_X				; in Time Vaults?
	bne SDR_10
	cpx VAR_MAP_Y
	bne SDR_10
	;
	ldy #36
SDR_09	lda #CONST_WALL_CHAR_2
	sta SCREEN + $0400 + 22 * 40 + 1,y	; draw extra wall in Time Vaults
	lda #CONST_WALL_COLOR
	sta SCREEN + 22 * 40 + 1,y
	dey
	bpl SDR_09
	;
	ldy #10
SDR_09a	lda TXT_TIME_VAULTS,y
	sta SCREEN + $0400 + 23 * 40 + 14,y
	lda #CONST_TIME_VAULTS_TEXT_COLOR
	sta SCREEN + 23 * 40 + 14,y
	dey
	bpl SDR_09a
	;
SDR_10	rts

SUB_DRAW_CUBIC_GATE
	lda #CONST_GATE_CHAR			; draw gate before time vault
	sta SCREEN + $0400 + 12 * 40 + 30,y
	sta SCREEN + $0400 + 12 * 40 + 31,y
	sta SCREEN + $0400 + 12 * 40 + 32,y
	sta SCREEN + $0400 + 12 * 40 + 33,y
	lda #CONST_GATE_COLOR
	sta SCREEN + 12 * 40 + 30,y
	sta SCREEN + 12 * 40 + 31,y
	sta SCREEN + 12 * 40 + 32,y
	sta SCREEN + 12 * 40 + 33,y
	rts

SUB_DRAW_WALLS	
	asl a
	tay
	lda VAR_LINE_DATA_PTRS,y
	sta src_ptr
	lda VAR_LINE_DATA_PTRS + 1,y
	sta src_ptr+1
	;
	ldy VAR_BLOCK_INDEX
	lda VAR_BLOCK_SCREEN_PTR_LO,y		; screen pos
	sta chr_ptr
	sta col_ptr
	lda VAR_BLOCK_SCREEN_PTR_HI,y
	sta chr_ptr+1
	and #$FB
	sta col_ptr+1				; color pos
	;
	; ---
	;    
	lda #$07				; 7 chars tall
	sta TMP_INDEX
	;
SDW_01	ldy #12					; 13 chars wide
	lda #CONST_SPACE_CHAR
SDW_02	sta (chr_ptr),y				; new code: clear 13x7 block first
	dey
	bpl SDW_02
	;
	lda chr_ptr				; inlined
	clc
	adc #40
	sta chr_ptr
	bcc *+4
	inc chr_ptr+1
	;
	dec TMP_INDEX
	bne SDW_01
	;
	; ---
	;
	ldy VAR_BLOCK_INDEX			; look up chr_ptr pointer again
	lda VAR_BLOCK_SCREEN_PTR_LO,y		; screen pos
	sta chr_ptr
	lda VAR_BLOCK_SCREEN_PTR_HI,y
	sta chr_ptr+1
	;
	; ---
	;
	ldy #$00
	lda (src_ptr),y				; number of horiz. walls
	beq B_2181
	;
	sta LOOP_WALLS_HORIZ
	;
B_2167	iny
	lda (src_ptr),y
	sta VAR_WALL_POS_Y
	iny
	lda (src_ptr),y
	sta VAR_WALL_POS_X
	iny
	lda (src_ptr),y
	sta VAR_WALL_LENGTH
	;
	jsr SUB_DRAW_HORIZ_LINE
	;
	dec LOOP_WALLS_HORIZ
	bne B_2167
	;
B_2181	iny
	lda (src_ptr),y				; number of vert. walls
	beq B_21A3
	;
	sta LOOP_WALLS_VERT
B_2189	iny
	lda (src_ptr),y
	sta VAR_WALL_POS_Y
	iny
	lda (src_ptr),y
	sta VAR_WALL_POS_X
	iny
	lda (src_ptr),y
	sta VAR_WALL_LENGTH
	;
	jsr SUB_DRAW_VERT_LINE
	;
	dec LOOP_WALLS_VERT
	bne B_2189
	;
B_21A3	rts
	; --------
SUB_DRAW_HORIZ_LINE
	sty TMP_SAVE_Y2
	;
	ldy VAR_WALL_POS_Y			; move down by VAR_WALL_POS_Y
	lda chr_ptr
	clc
	adc VAR_MUL_40_LO,y
	sta wall_chr_ptr			; store pointers separately
	sta wall_col_ptr
	lda chr_ptr+1
	adc VAR_MUL_40_HI,y
	sta wall_chr_ptr+1
	and #$FB
	sta wall_col_ptr+1
	;
	lda wall_chr_ptr			; drop shadow pointers
	clc
	adc #41
	sta wall_ds_chr_ptr
	sta wall_ds_col_ptr
	lda wall_chr_ptr+1
	adc #0
	sta wall_ds_chr_ptr+1
	and #$FB
	sta wall_ds_col_ptr+1
	;
	ldy VAR_WALL_POS_X
SDHL_01	lda #CONST_WALL_CHAR_1
	sta (wall_chr_ptr),y
	lda #CONST_WALL_COLOR
	sta (wall_col_ptr),y
	;
	lda (wall_ds_chr_ptr),y
	cmp #CONST_BLOCK_CHAR
	bne SDHL_02 
	;
	lda (wall_ds_col_ptr),y
	sec
	sbc #$20				; drop shadow value
	sta (wall_ds_col_ptr),y 
	;
SDHL_02	iny
	dec VAR_WALL_LENGTH
	bne SDHL_01
	;
	ldy TMP_SAVE_Y2
	rts
	; --------
SUB_DRAW_VERT_LINE
	sty TMP_SAVE_Y2
	;
	ldy VAR_WALL_POS_Y			; move down by VAR_WALL_POS_Y
	lda chr_ptr
	clc
	adc VAR_WALL_POS_X
	adc VAR_MUL_40_LO,y
	sta wall_chr_ptr			; store pointers separately
	sta wall_col_ptr
	lda chr_ptr+1
	adc VAR_MUL_40_HI,y
	sta wall_chr_ptr+1
	and #$FB
	sta wall_col_ptr+1
	;
	lda wall_chr_ptr			; drop shadow pointers
	clc
	adc #41
	sta wall_ds_chr_ptr
	sta wall_ds_col_ptr
	lda wall_chr_ptr+1
	adc #0
	sta wall_ds_chr_ptr+1
	and #$FB
	sta wall_ds_col_ptr+1
	;
	ldy #$00
SDVL_01	lda #CONST_WALL_CHAR_2
	sta (wall_chr_ptr),y
	lda #CONST_WALL_COLOR
	sta (wall_col_ptr),y
	;
	lda (wall_ds_chr_ptr),y 
	cmp #CONST_BLOCK_CHAR
	bne SDVL_02
	;
	lda (wall_ds_col_ptr),y
	sec
	sbc #$20				; drop shadow value
	sta (wall_ds_col_ptr),y 
	;
SDVL_02	tya
	clc
	adc #40
	tay
	;
	dec VAR_WALL_LENGTH
	bne SDVL_01
	;
	ldy TMP_SAVE_Y2
	rts
	; --------
S_2345	lda VAR_MOVE_LEFT
	clc
	adc VAR_MOVE_RIGHT
	adc VAR_MOVE_UP
	adc VAR_MOVE_DOWN
	bne B_2355
	rts
	; --------
B_2355	tax
	lda TAB_MOVE_2,x
	sta TMP_INDEX
	;
	ldx #$00
	lda #CONST_SPACE_CHAR
B_2361	sta VAR_BEHIND_PLAYER,x			; clear buffer
	inx
	cpx #$05
	bne B_2361
	;
	lda #$00
	sta VAR_PLAYER_MOVE_TMP
	sta FLAG_PICKED_ZODIAC
	;
	lda VAR_MOVE_LEFT
	pha
	lda VAR_MOVE_RIGHT
	pha
	lda VAR_MOVE_UP
	pha
	lda VAR_MOVE_DOWN
	pha
	lsr VAR_MOVE_LEFT
	rol VAR_PLAYER_MOVE_TMP
	lsr VAR_MOVE_RIGHT
	rol VAR_PLAYER_MOVE_TMP
	lsr VAR_MOVE_UP
	rol VAR_PLAYER_MOVE_TMP
	lsr VAR_MOVE_DOWN
	rol VAR_PLAYER_MOVE_TMP
	pla
	sta VAR_MOVE_DOWN
	pla
	sta VAR_MOVE_UP
	pla
	sta VAR_MOVE_RIGHT
	pla
	sta VAR_MOVE_LEFT
	ldx VAR_PLAYER_MOVE_TMP
	lda TAB_MOVE_3,x
	tax
	ldy #$00
B_23B2	lda VAR_SAVE_BUFFER,x
	sta VAR_BEHIND_PLAYER,y
	inx
	cpx #$0C
	bne B_23BF
	ldx #$00
B_23BF	iny
	dec TMP_INDEX
	bne B_23B2
	ldx #$00
B_23C7	lda VAR_BEHIND_PLAYER,x
	beq B_23D5
	;
	jsr SUB_CHECK_PLAYER_TOUCH_WALL
	jsr SUB_CHECK_PLAYER_TOUCH_ENEMY
	jsr SUB_CHECK_ZODIAC_PICKUP
	;
B_23D5	inx
	cpx #$05
	bne B_23C7
	;
	lda FLAG_PLAYER_DIES
	bne B_23EC
	;
	lda FLAG_PICKED_ZODIAC
	beq B_23EC
	;
	jsr SUB_ZODIAC_PICKED
	;
	lda #$01
	sta FANFARE_FLAG
	;jsr SUB_SET_SOUND_2			; old sound
	;
B_23EC	rts
	; --------
	; moved, so that all "player dies" code is in a single place
	;
SUB_DOES_ENEMY_CATCH_PLAYER
	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_PLAYER_CHAR_FIRST
	bcc SDECP_1
	;
	lda #CONST_PLAYER_CHAR_LAST
	cmp VAR_BEHIND_PLAYER,x
	bcs SDECP_2
	;
SDECP_1	rts
	;
SDECP_2	lda #$01				; enemy can't move
	sta FLAG_ENEMY_MOVE
	bne player_dies

SUB_CHECK_PLAYER_TOUCH_WALL
	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_WALL_CHAR_1
	beq player_cant_move
	cmp #CONST_WALL_CHAR_2
	beq player_cant_move
	cmp #CONST_GATE_CHAR
	beq player_cant_move
	rts
	;
SUB_CHECK_PLAYER_TOUCH_ENEMY
	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_ENEMY_CHAR_FIRST
	bcc SCPTE_1
	lda #CONST_ENEMY_CHAR_LAST
	cmp VAR_BEHIND_PLAYER,x
	bcc SCPTE_1
	;
player_cant_move
	lda #$00
	sta VAR_MOVE_UP
	sta VAR_MOVE_DOWN
	sta VAR_MOVE_LEFT
	sta VAR_MOVE_RIGHT
	;
player_dies
	lda VAR_CURRENT_POWERUP			; powerup #4: invulnerability
	cmp #4
	beq SCPTE_1				; skip, player doesn't die
	;
	lda #$01
	;sta FLAG_PLAYER_DIES			; comment this out for cheat/testing
	;
SCPTE_1	rts
	; --------
SUB_CHECK_LEAVING_SCREEN
	lda VAR_MOVE_RIGHT
	beq B_2436
	;
	lda VAR_PLAYER_X
	cmp #37					; CONST PLAYER RIGHT EDGE
	bne B_2451
	lda #$00
	sta VAR_PLAYER_X			; move player to left edge (0)
	lda #$02
	sta VAR_PLAYER_FACING
	;
	lda VAR_MAP_X
	cmp #CONST_MAP_SIZE-1
	beq L_2484
	inc VAR_MAP_X				; move right on map
	;
	jmp L_2484
	;
B_2436	lda VAR_MOVE_LEFT
	beq B_2451
	lda VAR_PLAYER_X
	bne B_2451
	lda #37					; CONST PLAYER RIGTH EDGE - move player to right edge
	sta VAR_PLAYER_X
	lda #$04
	sta VAR_PLAYER_FACING
	;
	lda VAR_MAP_X
	beq L_2484
	dec VAR_MAP_X				; move left on map
	;
	jmp L_2484
	;
B_2451	lda VAR_MOVE_UP
	beq B_246C
	;
	lda VAR_PLAYER_Y
	bne B_248A
	lda #19					; CONST_PLAYER_BOTTOM_EDGE
	sta VAR_PLAYER_Y
	lda #$00
	sta VAR_PLAYER_FACING
	;
	lda VAR_MAP_Y
	beq L_2484
	dec VAR_MAP_Y
	;
	jmp L_2484
	;
B_246C	lda VAR_MOVE_DOWN
	beq B_248A
	lda VAR_PLAYER_Y
	cmp #19					; CONST_PLAYER_BOTTOM_EDGE
	bne B_248A
	lda #$00
	sta VAR_PLAYER_Y
	sta VAR_PLAYER_FACING
	;
	lda VAR_MAP_Y
	cmp #CONST_MAP_SIZE-1
	beq L_2484
	inc VAR_MAP_Y				; move down on map
	;
L_2484	lda #$01
	sta FLAG_NEW_SCREEN
	;
B_248A	rts
	; --------
SUB_PLAYER_MOVE
	lda VAR_MOVE_LEFT
	ora VAR_MOVE_RIGHT
	ora VAR_MOVE_UP
	ora VAR_MOVE_DOWN
	bne B_24A2
	;
	lda #$00
	sta VAR_PLAYER_FACING
	jsr SUB_DRAW_PLAYER
	rts
	; --------
B_24A2	lda #$06
	jsr SUB_DRAW_PLAYER
	;
	lda VAR_PLAYER_FACING
	and #$01
	sta VAR_PLAYER_FACING_TMP
	;
	lda VAR_MOVE_UP
	beq B_24BF
	dec VAR_PLAYER_Y
	lda #$01
	eor VAR_PLAYER_FACING_TMP
	sta VAR_PLAYER_FACING
B_24BF	lda VAR_MOVE_DOWN
	beq B_24CF
	inc VAR_PLAYER_Y
	lda #$01
	eor VAR_PLAYER_FACING_TMP
	sta VAR_PLAYER_FACING
B_24CF	lda VAR_MOVE_LEFT
	beq B_24DF
	dec VAR_PLAYER_X
	lda #$05
	eor VAR_PLAYER_FACING_TMP
	sta VAR_PLAYER_FACING
B_24DF	lda VAR_MOVE_RIGHT
	beq B_24EF
	inc VAR_PLAYER_X
	lda #$03
	eor VAR_PLAYER_FACING_TMP
	sta VAR_PLAYER_FACING
	;
B_24EF	lda VAR_PLAYER_FACING
	jsr SUB_DRAW_PLAYER
	;
	lda #$01
	sta STEP_FLAG				; step sound
	;
	rts
	; --------
SUB_DRAW_PLAYER
	asl a					; mul * 4
	asl a
	tax
	;
	ldy VAR_PLAYER_Y			; get pointer to player x/y
	lda VAR_SCREEN_PTRS_LO,y
	clc
	adc VAR_PLAYER_X
	sta chr_ptr
	sta col_ptr
	lda VAR_SCREEN_PTRS_HI,y
	adc #0
	sta chr_ptr+1
	and #$FB
	sta col_ptr+1
	;
	ldy #$00
	lda VAR_PLAYER_CHARS,x			; top/left
	sta (chr_ptr),y
	lda #CONST_PLAYER_COLOR
	sta (col_ptr),y
	;
	iny
	sta (col_ptr),y				; top right
	lda VAR_PLAYER_CHARS+1,x
	sta (chr_ptr),y
	;
	ldy #40
	lda VAR_PLAYER_CHARS+2,x		; bottom left
	sta (chr_ptr),y
	lda #CONST_PLAYER_COLOR
	sta (col_ptr),y
	;
	iny
	sta (col_ptr),y				; bottom right
	lda VAR_PLAYER_CHARS+3,x
	sta (chr_ptr),y
	;
	rts
	; --------
SUB_GET_SCREEN_PTRS
	tay
	;
	lda VAR_SCREEN_PTRS_LO,y
	sta chr_ptr
	sta col_ptr
	lda VAR_SCREEN_PTRS_HI,y
	sta chr_ptr+1
	and #$FB
	sta col_ptr+1
	;
	rts
	; --------
SUB_ADD_CHR_PTR
	clc
	adc chr_ptr
	sta chr_ptr
	lda chr_ptr+1
	adc #$00
	sta chr_ptr+1
	rts
	; --------
SUB_ADD_COL_PTR
	clc
	adc col_ptr
	sta col_ptr
	lda col_ptr+1
	adc #$00
	sta col_ptr+1
	rts
	; --------
SUB_PLACE_ENEMIES
	lda VAR_MAX_ENEMIES			; if no enemies
	beq SPE_04				; exit immediately 
	;
	lda #$40
	sta SCREEN + $0400 + 14 * 40 + 18	; mark the place for the zodiac
	sta SCREEN + $0400 + 14 * 40 + 19
	; 
	lda #0
	sta TMP_INDEX
	sta VAR_ENEMY_FLAGS
	;
SPE_01	jsr SUB_GET_RANDOM			; random y coord
	and #$07
	clc
	adc #6
	sta TMP_SAVE_X
	tax
	lda VAR_SCREEN_PTRS_LO,x
	sta src_ptr
	lda VAR_SCREEN_PTRS_HI,x
	sta src_ptr+1
	;
	jsr SUB_GET_RANDOM			; random x coord
	and #$0F
	clc
	adc #11
	tay
	lda (src_ptr),y				; ensure screen is empty there
	bne SPE_01
	iny
	lda (src_ptr),y				; two characters
	bne SPE_01
	;
	lda #$40				; mark it with $40 space
	sta (src_ptr),y
	dey
	sta (src_ptr),y
	;
	lda TMP_INDEX 				; *3
	asl a
	adc TMP_INDEX
	tax
	lda TMP_SAVE_X
	sta VAR_ENEMY_DATA,x
	tya
	sta VAR_ENEMY_DATA+1,x
	;
	lda FLAG_IN_TIME_VAULTS			; Time Vaults?
	beq SPE_02
	;
	lda #$06				; fixed demon type in Time Vaults
	bne SPE_03				; always jump
	;
SPE_02	lda VAR_ENEMY_FLAGS			; for regular rooms
	clc
	adc #2					; use 0-2-4 as enemy types
	cmp #6					; wrap at 6
	bne *+4
	lda #0					; back to 0
	sta VAR_ENEMY_FLAGS
SPE_03	sta VAR_ENEMY_DATA+2,x
	;
	inc TMP_INDEX
	lda TMP_INDEX
	cmp VAR_MAX_ENEMIES			; stop at max number of enemies
	bne SPE_01
	;
	lda #$00
	sta SCREEN + $0400 + 14 * 40 + 18	; clear the place for the zodiac
	sta SCREEN + $0400 + 14 * 40 + 19
	;
SPE_04	rts
	;	
	; --------
	;
SUB_DRAW_ALL_ENEMIES
	lda VAR_MAX_ENEMIES			; if no enemies...
	beq SDAE_03				; exit immediately
	;
	lda #$00
	sta TMP_INDEX
	;
SDAE_01	jsr SUB_LOAD_ENEMY_DATA
	;
	lda VAR_ENEMY_FLAGS
	bmi SDAE_02				; skip if already killed
	jsr SUB_DRAW_ENEMY
	;
	lda FLAG_IN_TIME_VAULTS
	beq SDAE_02
	;
	lda #$01				; in time vaults...
	sta EXPLOSION_FLAG			; play sound
	;
	lda #30
	sta VAR_FRAME_DELAY			; and wait (for dramatic effect)
	;
SDAE_04	cmp VAR_FRAME_DELAY
	beq SDAE_04
	; 
	ldy VAR_ENEMY_X
	lda (col_ptr),y
	eor #($71 ^ $32)
	sta (col_ptr),y
	iny
	sta (col_ptr),y
	;
	lda VAR_FRAME_DELAY
	bne SDAE_04
	;
SDAE_02	inc TMP_INDEX
	lda TMP_INDEX
	cmp VAR_MAX_ENEMIES
	bne SDAE_01
	;
SDAE_03	rts
	; --------
SUB_LOAD_ENEMY_DATA
	lda TMP_INDEX				; *3
	asl a
	adc TMP_INDEX
	tax
	;
	lda VAR_ENEMY_DATA,x
	sta VAR_ENEMY_Y
	lda VAR_ENEMY_DATA+1,x
	sta VAR_ENEMY_X
	lda VAR_ENEMY_DATA+2,x
	sta VAR_ENEMY_FLAGS
	rts
	; --------
SUB_SAVE_ENEMY_DATA
	lda TMP_INDEX
	asl a
	adc TMP_INDEX
	tax
	lda VAR_ENEMY_Y
	sta VAR_ENEMY_DATA,x
	lda VAR_ENEMY_X
	sta VAR_ENEMY_DATA+1,x
	lda VAR_ENEMY_FLAGS
	sta VAR_ENEMY_DATA+2,x
	rts
	; --------
SUB_DRAW_ENEMY					; also clear enemy
	asl a
	tax
	lda VAR_ENEMY_Y
	jsr SUB_GET_SCREEN_PTRS
	;
	ldy VAR_ENEMY_X				; draw enemy chars
	lda VAR_ENEMY_CHARS,x
	sta (chr_ptr),y
	iny
	lda VAR_ENEMY_CHARS+1,x
	sta (chr_ptr),y
	;
	txa
	lsr a					; div / 4
	lsr a
	tax
	lda VAR_ENEMY_COLORS,x			; draw enemy colors
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	rts
	;
	; --------
	;
SUB_MOVE_ENEMIES
	lda VAR_ENEMY_DELAY			; is delay over?
	bne SME_RET				; nope, do nothing
	;
	lda VAR_CURRENT_ENEMY_DELAY		; reset delay
	sta VAR_ENEMY_DELAY
	;
	lda VAR_MAX_ENEMIES			; allow no enemies
	beq SME_RET
	lda VAR_ENEMIES_IN_ROOM			; or if all killed
	beq SME_RET
	;
SME_01	ldx VAR_LAST_MOVED_ENEMY		; loop through existing enemies
	inx
	cpx VAR_MAX_ENEMIES
	bcc *+4
	ldx #$00				; wrap
	stx VAR_LAST_MOVED_ENEMY
	stx TMP_INDEX
	;
	jsr SUB_LOAD_ENEMY_DATA
	lda VAR_ENEMY_FLAGS
	bmi SME_01				; enemy already killed? loop back
	;
	; ---
	;
	lda #CONST_ERASE_ENEMY_INDEX		; erase enemy
	jsr SUB_DRAW_ENEMY
	;
	jsr S_274B
	jsr SUB_DET_ENEMY_MOVE_VERT
	jsr S_276E
	;
	lda FLAG_PLAYER_DIES
	bne SME_03
	lda FLAG_ENEMY_MOVE
	bne SME_02
	;
	lda VAR_ENEMY_X
	clc
	adc VAR_ENEMY_MOVE_RIGHT
	sec
	sbc VAR_ENEMY_MOVE_LEFT
	sta VAR_ENEMY_X
	
SME_02	jsr S_274B
	jsr SUB_DET_ENEMY_MOVE_HORZ
	jsr S_276E
	;
	lda FLAG_PLAYER_DIES
	bne SME_03
	lda FLAG_ENEMY_MOVE
	bne SME_03
	;
	lda VAR_ENEMY_Y
	clc
	adc VAR_ENEMY_MOVE_DOWN
	sec
	sbc VAR_ENEMY_MOVE_UP
	sta VAR_ENEMY_Y
	;
	; ---
	;
SME_03	lda VAR_ENEMY_FLAGS
	jsr SUB_DRAW_ENEMY
	;
	lda VAR_LAST_MOVED_ENEMY
	sta TMP_INDEX
	;
	jsr SUB_SAVE_ENEMY_DATA
	;
SME_RET	rts
	;
	; --------
	;
SUB_DET_ENEMY_MOVE_VERT
	lda #$00
	sta VAR_ENEMY_MOVE_LEFT
	sta VAR_ENEMY_MOVE_RIGHT
	sta VAR_ENEMY_MOVE_UP
	sta VAR_ENEMY_MOVE_DOWN
	;
	lda VAR_PLAYER_X
	cmp VAR_ENEMY_X
	bpl B_2722
	sec
	rol VAR_ENEMY_MOVE_LEFT
	rts
	;
B_2722	beq B_2728
	sec
	rol VAR_ENEMY_MOVE_RIGHT
B_2728	rts
	;
	; --------
	;
SUB_DET_ENEMY_MOVE_HORZ
	lda #$00
	sta VAR_ENEMY_MOVE_LEFT
	sta VAR_ENEMY_MOVE_RIGHT
	sta VAR_ENEMY_MOVE_UP
	sta VAR_ENEMY_MOVE_DOWN
	;
	lda VAR_PLAYER_Y
	cmp VAR_ENEMY_Y
	bpl B_2744
	sec
	rol VAR_ENEMY_MOVE_UP
	rts
	;
B_2744	beq B_274A
	sec
	rol VAR_ENEMY_MOVE_DOWN
B_274A	rts
	; --------
S_274B	lda VAR_ENEMY_Y
	jsr SUB_GET_SCREEN_PTRS
	;
	lda #$29
	sta VAR_BLOCK_INDEX
	sec
	lda chr_ptr
	sbc VAR_BLOCK_INDEX
	sta chr_ptr
	lda chr_ptr+1
	sbc #$00
	sta chr_ptr+1
	;
	ldx #$00
B_275B	lda TAB_OFFS_2,x
	clc
	adc VAR_ENEMY_X
	tay
	lda (chr_ptr),y
	sta VAR_SAVE_BUFFER,x
	inx
	cpx #$0A
	bne B_275B
	rts
	; --------
S_276E	lda #$00
	sta FLAG_ENEMY_MOVE
	sta VAR_PLAYER_MOVE_TMP
	;
	lda #CONST_SPACE_CHAR
	sta VAR_BEHIND_PLAYER
	sta VAR_BEHIND_PLAYER+1
	;
	lda VAR_ENEMY_MOVE_LEFT
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	lda VAR_ENEMY_MOVE_RIGHT
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	lda VAR_ENEMY_MOVE_UP
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	lda VAR_ENEMY_MOVE_DOWN
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	;
	lda #$01
	sta TMP_INDEX
	;
	lda VAR_PLAYER_MOVE_TMP
	beq B_27D6
	;
	cmp #$08
	beq B_27B0
	;
	cmp #$04
	beq B_27B0
	;
	inc TMP_INDEX
	;
B_27B0	tax
	lda TAB_OFFS_1,x
	tax
	ldy #$00
B_27B7	lda VAR_SAVE_BUFFER,x
	sta VAR_BEHIND_PLAYER,y
	inx
	iny
	dec TMP_INDEX
	bne B_27B7
	;
	ldx #$00
B_27C6	lda VAR_BEHIND_PLAYER,x
	beq B_27D1
	jsr SUB_CAN_ENEMY_MOVE
	jsr SUB_DOES_ENEMY_CATCH_PLAYER
B_27D1	inx
	cpx #$02
	bne B_27C6
B_27D6	rts
	; --------
SUB_CAN_ENEMY_MOVE
	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_WALL_CHAR_1
	beq L_281C
	cmp #CONST_WALL_CHAR_2
	beq L_281C
	cmp #CONST_GATE_CHAR
	beq L_281C
	cmp #CONST_SHOT_CHAR
	beq L_281C
	cmp #CONST_EXPLOSION_CHAR_FIRST
	bcc B_27F9
	lda #CONST_EXPLOSION_CHAR_LAST
	cmp VAR_BEHIND_PLAYER,x
	bcc B_27F9
	jmp L_281C
	;
B_27F9	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_ENEMY_CHAR_FIRST
	bcc B_280C
	lda #CONST_ENEMY_CHAR_LAST
	cmp VAR_BEHIND_PLAYER,x
	bcc B_280C
	jmp L_281C
	;
B_280C	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_ZODIAC_CHAR_FIRST
	bcc B_2822
	lda #CONST_ZODIAC_CHAR_LAST
	cmp VAR_BEHIND_PLAYER,x
	bcc B_2822
	;
L_281C	lda #$01
	sta FLAG_ENEMY_MOVE
	;
B_2822	rts
	;
	; ---
	;
SUB_ANIMATE_EXPLOSIONS
	lda VAR_ENEMY_EXPLOSION_DELAY
	bne SAE_03
	;
	lda #CONST_EXPLOSION_DELAY
	sta VAR_ENEMY_EXPLOSION_DELAY
	;
	lda VAR_MAX_ENEMIES
	beq SAE_03 
	;
	ldx #$00
	ldy #$00
SAE_01	lda VAR_ENEMY_DATA+2,x
	and #$80				; is this enemy dead?
	bne SAE_02
	;
	lda VAR_ENEMY_DATA,x
	sta VAR_ENEMY_Y
	lda VAR_ENEMY_DATA+1,x
	sta VAR_ENEMY_X
	;
	txa
	pha
	tya
	pha
	lda #$01
	eor VAR_ENEMY_DATA+2,x
	sta VAR_ENEMY_DATA+2,x
	jsr SUB_DRAW_ENEMY
	;
	pla
	tay
	pla
	tax
SAE_02	jsr SUB_ANIMATE_EXPLOSION
	inx
	inx
	inx
	iny
	cpy VAR_MAX_ENEMIES
	bne SAE_01
	;
SAE_03	rts
	;
	; --------
	;
SUB_PLAYER_SHOOT
	lda FLAG_IN_TIME_VAULTS			; can't shoot in the Time Vaults
	bne SPS_RET
	;
	lda VAR_SHOOTING			; alreay shooting?
	bne SPS_RET				; then skip
	;
	lda VAR_FIRE				; is fire held down?
	beq SPS_RET				; no, skip
	;
	lda FLAG_ZODIAC_CARRIED
	bne SPS_RET
	;
	lda VAR_MOVE_LEFT
	sta VAR_SHOT_LEFT
	lda VAR_MOVE_RIGHT
	sta VAR_SHOT_RIGHT
	lda VAR_MOVE_UP
	sta VAR_SHOT_UP
	lda VAR_MOVE_DOWN
	sta VAR_SHOT_DOWN
	;
	jsr S_2951
	;
	lda VAR_PLAYER_MOVE_TMP
	beq SPS_RET
	tax
	;
	lda VAR_PLAYER_X
	clc
	sbc #$00
	clc
	adc TAB_SHOT_X,x
	bmi SPS_RET				; shot x negative (out of screen left)?
	cmp #39					; or out of screen right?
	beq SPS_RET
	sta VAR_SHOT_X				; store shot x
	;
	lda VAR_PLAYER_Y
	clc
	sbc #$00
	clc
	adc TAB_SHOT_Y,x
	bmi SPS_RET				; shot y negative (out of screen up)?
	cmp #$15				; or out of screen down?
	beq SPS_RET
	sta VAR_SHOT_Y				; store shot y
	;
	lda #$01
	sta VAR_SHOOTING			; set flag
	;
	lda VAR_CURRENT_POWERUP
	cmp #3
	bne SPS_01
	lda #CONST_POWER_SHOT_DELAY
	db $2C
SPS_01	lda #CONST_SHOT_DELAY			; default
	sta VAR_SHOT_DELAY
	;
	lda #CONST_SHOT_CHAR
	jsr SUB_DRAW_SHOT
	;
	;lda #$00
	;jsr SUB_SET_SOUND_2			; player shooting sound
	;
SPS_RET	rts
	; --------
SUB_DRAW_SHOT
	pha
	;
	lda VAR_SHOT_Y
	jsr SUB_GET_SCREEN_PTRS
	;
	ldy VAR_SHOT_X
	lda (chr_ptr),y
	cmp #CONST_SPACE_CHAR
	beq SDS_01
	cmp #CONST_SHOT_CHAR
	beq SDS_01
	;
	cmp #CONST_ENEMY_CHAR_FIRST		; check for enemy
	bcc SDS_02
	cmp #CONST_ENEMY_CHAR_LAST
	bcs SDS_02
	;
	pla
	jmp enemy_was_hit			; bugfix: enemy can get destroyed (without shot ever being drawn)
	;
SDS_02	cmp #CONST_EXPLOSION_CHAR_FIRST
	bcc shot_immediately_stops
	lda #CONST_EXPLOSION_CHAR_LAST
	cmp (chr_ptr),y
	bcc shot_immediately_stops
	jmp SDS_01
	;
shot_immediately_stops
	pla
	lda #$00				; shot stopped
	sta VAR_SHOOTING
	;
	rts
	; --------
SDS_01	pla
	sta (chr_ptr),y
	;
	lda VAR_CURRENT_POWERUP
	cmp #3
	bne SDS_03
	;
	lda #CONST_POWER_SHOT_COLOR
	db $2C
SDS_03	lda #CONST_SHOT_COLOR
	sta (col_ptr),y
	rts
	; --------
S_2951	lda #$00
	sta VAR_PLAYER_MOVE_TMP
	lda VAR_SHOT_LEFT
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	lda VAR_SHOT_RIGHT
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	lda VAR_SHOT_UP
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	lda VAR_SHOT_DOWN
	lsr a
	rol VAR_PLAYER_MOVE_TMP
	rts
	; --------
S_2973	lda VAR_SHOOTING
	beq B_2986
	;
	lda VAR_SHOT_DELAY
	bne B_2986
	;
	lda VAR_CURRENT_POWERUP
	cmp #3
	bne SPS_02
	lda #CONST_POWER_SHOT_DELAY
	db $2C
SPS_02	lda #CONST_SHOT_DELAY
	sta VAR_SHOT_DELAY
	;
	jsr SUB_MOVE_SHOT
	;
B_2986	rts
	; --------
SUB_MOVE_SHOT
	lda #CONST_SPACE_CHAR
	jsr SUB_DRAW_SHOT
	;
	lda VAR_SHOT_X
	clc
	adc VAR_SHOT_RIGHT
	sec
	sbc VAR_SHOT_LEFT
	bmi LAB_SHOT_STOPPED				; shot out of screen left?
	cmp #39
	beq LAB_SHOT_STOPPED				; or right?
	sta VAR_SHOT_X
	;
	lda VAR_SHOT_Y
	clc
	adc VAR_SHOT_DOWN
	sec
	sbc VAR_SHOT_UP
	bmi LAB_SHOT_STOPPED				; shot out of screen up?
	cmp #$15
	beq LAB_SHOT_STOPPED				; or down?
	sta VAR_SHOT_Y
	;
	jsr SUB_GET_SCREEN_PTRS
	ldy VAR_SHOT_X
	lda (chr_ptr),y
	cmp #CONST_ENEMY_CHAR_FIRST
	bcc SMS_01
	lda #CONST_ENEMY_CHAR_LAST
	cmp (chr_ptr),y
	bcc SMS_01
	;
enemy_was_hit
	lda #$01
	sta EXPLOSION_FLAG
	;
	jsr SUB_FIND_DESTROYED_ENEMY
	;
	jmp LAB_SHOT_STOPPED
	;
SMS_01	lda #CONST_SHOT_CHAR
	jsr SUB_DRAW_SHOT
	;
	rts
	; --------
LAB_SHOT_STOPPED
	lda #$00
	sta VAR_SHOOTING
	;
	rts
	; --------
SUB_FIND_DESTROYED_ENEMY
	ldy #$00
	ldx #$00
	lda VAR_SHOT_X
	sta VAR_BLOCK_INDEX
	dec VAR_BLOCK_INDEX
SFDE_01	lda VAR_ENEMY_DATA,x
	cmp VAR_SHOT_Y
	bne SFDE_02
	lda VAR_ENEMY_DATA+1,x
	cmp VAR_SHOT_X
	beq SFDE_03
	cmp VAR_BLOCK_INDEX
	beq SFDE_03
SFDE_02	iny
	inx
	inx
	inx
	cpx #$30
	bne SFDE_01
	;
SFDE_03	lda VAR_ENEMY_DATA+2,x
	and #$80
	bne SFDE_02
	;
	lda VAR_ENEMY_DATA+2,x
	ora #$80
	sta VAR_ENEMY_DATA+2,x
	;
LAB_ENEMY_DESTROYED	
	lda VAR_ENEMY_DATA,x
	sta VAR_ENEMY_Y
	lda VAR_ENEMY_DATA+1,x
	sta VAR_ENEMY_X
	;
	lda #$01				; start explosion
	sta VAR_EXPLOSION_COUNTS,y
	;
	lda #CONST_ERASE_ENEMY_INDEX
	jsr SUB_DRAW_ENEMY			; clear enemy from screen
	;
	; ---
	stx TMP_SAVE_X
	ldx VAR_MAP_Y
	lda VAR_MAP_ROWS,x
	clc
	adc VAR_MAP_X
	tax
	dec DEMON_COUNT_ZODIAC_FLAG,x 		; decrease demon count in room
	dec VAR_ENEMIES_IN_ROOM
	ldx TMP_SAVE_X
	; ---
	;
	lda #$20
	jmp SUB_ADD_SCORE_TENS			; 20 points for enemies
	;
	; --------
	;
SUB_INIT_RANDOM
	lda $FF00				; Timer 1 Lo
	ldx #$04
SR_01	sta VAR_RANDOM,x
	dex
	bpl SR_01
	;
SUB_GET_RANDOM
	lda #$E0
	and VAR_RANDOM+4
	ora #$20
	sta VAR_RANDOM+4
	clc
	ldx #$04
SR_02	lda VAR_RANDOM,x
	adc VAR_RANDOM,x
	sta VAR_RANDOM+5,x
	dex
	bpl SR_02
	clc
	ldx #$04
SR_03	lda VAR_RANDOM,x
	adc VAR_RANDOM+5,x
	sta VAR_RANDOM,x
	dex
	bpl SR_03
	clc
	ldx #$02
SR_04	lda VAR_RANDOM,x
	adc VAR_RANDOM+7,x
	sta VAR_RANDOM,x
	dex
	bpl SR_04
	;
	lda VAR_RANDOM
	;
	rts
	;
	; --------
	;
SUB_RANDOMLY_PLACE_ZODIACS
	;
	; ---
	;
	lda #$00
	sta VAR_MAP_Y
il04	lda #$00
	sta VAR_MAP_X
il05	ldx VAR_MAP_Y
	lda VAR_MAP_ROWS,x
	clc
	adc VAR_MAP_X
	tax
	lda VAR_MAP_X
	clc
	adc VAR_MAP_Y
	tay
	lda VAR_DEFAULT_DEMON_COUNTS,y		; set demons per room   
	sta DEMON_COUNT_ZODIAC_FLAG,x		; also clears zodiac flags
	;
	lda DAT_GAME_MAP,x			; clear "room visited" flags
	and #$7F
	sta DAT_GAME_MAP,x 
	;
	inc VAR_MAP_X
	lda VAR_MAP_X
	cmp #CONST_MAP_SIZE
	bne il05
	;
	inc VAR_MAP_Y
	lda VAR_MAP_Y
	cmp #CONST_MAP_SIZE
	bne il04
	;
	; --- shuffle orders
	;
	lda #CONST_MAP_SIZE
	sta TMP_INDEX
	;
SRPZ_01	jsr SUB_GET_RANDOM_MAP_COORD
	sta VAR_MAP_X
	jsr SUB_GET_RANDOM_MAP_COORD
	tay
	;
	ldx VAR_MAP_X
	lda VAR_X_ORDER,x
	pha
	lda VAR_X_ORDER,y
	sta VAR_X_ORDER,x
	pla
	sta VAR_X_ORDER,y
	;
	dec TMP_INDEX
	bne SRPZ_01
	;
	; --- place
	;
	lda #0
	sta TMP_INDEX
	;  
SRPZ_02	ldy TMP_INDEX
	lda VAR_X_ORDER,y
	sta VAR_MAP_X
	tax
	;
	cpx #0					; avoid 0,0
	bne SRPZ_03
	cpy #0
	beq SUB_RANDOMLY_PLACE_ZODIACS
	;
SRPZ_03	cpy #CONST_MAP_SIZE-1			; avoid 10,11 and 11,11
	bne SRPZ_04 
	cpx #CONST_MAP_SIZE-2
	bcs SUB_RANDOMLY_PLACE_ZODIACS
	;
SRPZ_04	lda VAR_MAP_ROWS,y
	clc
	adc VAR_MAP_X
	tax
	;
	lda TMP_INDEX 
	clc
	adc #$01
	adc VAR_X_ORDER
	cmp #13
	bcc SPRZ_05
	sbc #12
SPRZ_05	asl a
	asl a
	asl a
	asl a
	ora DEMON_COUNT_ZODIAC_FLAG,x
	sta DEMON_COUNT_ZODIAC_FLAG,x		; place zodiac in room
	;
	inc TMP_INDEX
	lda TMP_INDEX
	cmp #12
	bne SRPZ_02
	;
	rts
	; --------
SUB_GET_RANDOM_MAP_COORD
	jsr SUB_GET_RANDOM
	and #$0F
	cmp #CONST_MAP_SIZE
	bcs SUB_GET_RANDOM_MAP_COORD
	rts
	; --------
	; draw zodiac sign in regular rooms
	;
SUB_DRAW_ZODIAC_1
	tax
	lda #$0A
	jsr SUB_GET_SCREEN_PTRS
	;
	ldy #$12
	;
	bne SDZ_01				; always jump
	;
SUB_DRAW_ZODIAC_2
	ldx VAR_ZODIAC_PLACED
	inx
	lda DAT_ZODIAC_POSITIONS_Y,x
	jsr SUB_GET_SCREEN_PTRS
	;
	lda DAT_ZODIAC_POSITIONS_X,x
	tay
	;
SDZ_01	lda DAT_ZODIAC_CHARS_LO,x
	sta (chr_ptr),y
	cmp #$00
	beq SDZ_02				; clear
	clc
	adc #$01				; second char is always first char +1
SDZ_02	iny
	sta (chr_ptr),y
	;
	lda #CONST_ZODIAC_COLOR
	sta (col_ptr),y
	dey
	sta (col_ptr),y
	;
	rts
	; --------
SUB_CHECK_ZODIAC_PICKUP
	lda VAR_BEHIND_PLAYER,x
	cmp #CONST_ZODIAC_CHAR_FIRST
	bcc B_2B3F
	lda #CONST_ZODIAC_CHAR_LAST
	cmp VAR_BEHIND_PLAYER,x
	bcc B_2B3F
	;
	lda #$01				; picked up a zodiac
	sta FLAG_PICKED_ZODIAC
	;
B_2B3F	rts
	; --------
SUB_GET_ZODIAC_INDEX_FROM_MAP
	ldy VAR_MAP_Y
	lda VAR_MAP_ROWS,y
	clc
	adc VAR_MAP_X
	tay
	lda DEMON_COUNT_ZODIAC_FLAG,y
	lsr a					; take high nibble
	lsr a
	lsr a
	lsr a
	rts
	;
	; --------
	;
SZP_01	ldx VAR_ZODIAC_PLACED
	inx
	lda DAT_ZODIAC_POSITIONS_Y,x
	jsr SUB_GET_SCREEN_PTRS
	lda DAT_ZODIAC_POSITIONS_X,x
	tay
	lda #$00
	sta (chr_ptr),y				; erase zodiac
	iny
	sta (chr_ptr),y
	;
	lda #$01
	sta FLAG_ZODIAC_CARRIED
	;
	lda #$02
	jmp SUB_ADD_SCORE_HUNDREDS		; 200 points for picking up zodiac
	;
SUB_ZODIAC_PICKED
	lda FLAG_IN_TIME_VAULTS
	bne SZP_01
	;
	lda #$00
	jsr SUB_DRAW_ZODIAC_1
	;
	jsr SUB_GET_ZODIAC_INDEX_FROM_MAP
	;
	sta VAR_CURRENT_ZODIAC
	tax
	;
	lda DEMON_COUNT_ZODIAC_FLAG,y		; remove zodiac from map
	and #$0F
	sta DEMON_COUNT_ZODIAC_FLAG,y
	;
	; ---
	;
	lda #$01
	sta VAR_ZODIAC_FOUND,x			; mark it as collected
	;
	; *** powerup handling
	;
	lda tab_powerups,x
	sta VAR_CURRENT_POWERUP
	;
	jsr set_powerup_lo			; set up timer, lo
	;
	lda VAR_CURRENT_POWERUP
	cmp #1
	bne SZP_06
	;
	lda VAR_LIVES
	cmp #$99
	beq SZP_07
	sec
	clc
	adc #$01
	cld
	sta VAR_LIVES
	;
	jsr SUB_PRINT_LIVES
	;
SZP_07	lda #$10				; exception for extra life: 10 seconds countdown
	db $2C
SZP_06	lda #$30
	sta VAR_POWERUP_TIMER_HI		; and hi
	;
	jsr draw_powerup_status
	;
	inc VAR_ZODIAC_FOUND
	;
	lda #$05				; 500 points for collected zodiacs
	jmp SUB_ADD_SCORE_HUNDREDS
	;
	; ---
	;
set_powerup_lo
	lda $FF07
	and #$40
	beq spl_01
	lda #60					; NTSC: one second is 60 frames
	db $2C
spl_01	lda #50					; PAL: one second is 50 frames
	sta VAR_POWERUP_TIMER_LO
	rts
	;
	; --------
	;
SUB_CLEAR_CONTROLS
	lda #$00
	sta VAR_MOVE_UP
	sta VAR_MOVE_DOWN
	sta VAR_MOVE_LEFT
	sta VAR_MOVE_RIGHT
	sta VAR_FIRE
	sta VAR_HELP_SELECT
	rts

	;
	; Joy 1
	;
SUB_POLL_JOYSTICK_1
	lda #$FF
	sta $FD30				; don't check keys
	lda #$FB				; Query joystick #1
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	eor #$FF
	;
	lsr a
	rol VAR_MOVE_UP
	lsr a
	rol VAR_MOVE_DOWN
	lsr a
	rol VAR_MOVE_LEFT
	lsr a
	rol VAR_MOVE_RIGHT
	lsr a
	beq SPJ1_01
	inc VAR_FIRE
	;
SPJ1_01	rts

	;
	; Joy 2
	;
SUB_POLL_JOYSTICK_2
	lda #$FF
	sta $FD30				; don't check keys
	lda #$FD				; Query joystick #2
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	eor #$FF
	;
	lsr a
	rol VAR_MOVE_UP
	lsr a
	rol VAR_MOVE_DOWN
	lsr a
	rol VAR_MOVE_LEFT
	lsr a
	rol VAR_MOVE_RIGHT
	lsr a
	beq SPJ2_01
	inc VAR_FIRE
	;
SPJ2_01	rts

	;
	; Keyboard
	;
SUB_POLL_KEYBOARD
	lda #$EF				; Check column 4
	sta $FD30				; Keyboard Matrix
	lda #$FF
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$40				; Query keyboard for "o"
	bne SPK_01
	;
	inc VAR_MOVE_UP
	bne SPK_02				; always jump
	;
SPK_01	lda #$EF				; Check column 4
	sta $FD30				; Keyboard Matrix
	lda #$FF
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$20				; Query keyboard for "k"
	bne SPK_02
	;
	inc VAR_MOVE_DOWN
	;
SPK_02	lda #$FD				; Check column 1
	sta $FD30				; Keyboard Matrix
	lda #$FF
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$40				; Query keyboard for "e"
	bne SPK_03
	;
	inc VAR_MOVE_LEFT
	bne SPK_04				; always jump
	;
SPK_03	lda #$FB				; Check column 2
	sta $FD30				; Keyboard Matrix
	lda #$FF
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$20				; Query keyboard for "f"
	bne SPK_04
	;
	inc VAR_MOVE_RIGHT
	;
SPK_04	lda #$7F				; Check column 7
	sta $FD30				; Keyboard Matrix
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$10				; Query keyboard for "Space"
	bne SPK_05
	;
	inc VAR_FIRE
	;
SPK_05	rts

	;
	; Cursor keys (alternative keyboard controls)
	;
SUB_POLL_CURSOR
	lda #$DF				; Check column
	sta $FD30				; Keyboard Matrix
	lda #$FF
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$09				; Cursor Down/Up
	cmp #$01
	bne SPC_01
	;
	inc VAR_MOVE_UP
	bne SPC_02				; always jump
	;
SPC_01	cmp #$08
	bne SPC_02
	;
	inc VAR_MOVE_DOWN
	;
SPC_02	lda #$BF				; Check column
	sta $FD30				; Keyboard Matrix
	lda #$FF
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$09				; Cursor Left/Right
	cmp #$08
	bne SPC_03
	;
	inc VAR_MOVE_LEFT
	bne SPC_04				; always jump
	;
SPC_03	cmp #$01
	bne SPC_04
	;
	inc VAR_MOVE_RIGHT
	;
SPC_04	jmp SPK_04

	;
	; SNES controller
	;
snes_read_bit macro value
	lda USERPORT
	and #$02
	bne snes_bit_not_on\?
	;
	lda #$01
	sta value
	;
snes_bit_not_on\?
	lda #(BITS_INPUT)			; Move on to next bit by pulsing clock
	sta USERPORT				; Clock low - Doing it here avoids VICE bug
	sty USERPORT				; Clock high (Y is preloaded)
	endm
snes_drop_bit	macro
	lda #(BITS_INPUT)			; Move on to next bit by pulsing clock
	sta USERPORT				; Clock low - Doing it here avoids VICE bug
	sty USERPORT				; Clock high (Y is preloaded)
	endm
SUB_POLL_SNES
	lda #(BIT_LATCH | BIT_CLOCK | BITS_INPUT)
	sta USERPORT				; Latch+clock high...
	ldy #(BIT_CLOCK | BITS_INPUT)		; ... then latch back low (6502 is so slow that 4021 minimum times should always
	sty USERPORT				; be respeced, as they are hundreds of nanoseconds)
	;
	snes_read_bit VAR_FIRE			; B
	snes_read_bit VAR_FIRE			; Y
	snes_read_bit VAR_HELP_SELECT		; select
	snes_read_bit VAR_FIRE			; start
	snes_read_bit VAR_MOVE_UP		; up
	snes_read_bit VAR_MOVE_DOWN		; down
	snes_read_bit VAR_MOVE_LEFT		; left
	snes_read_bit VAR_MOVE_RIGHT		; right
	;
	snes_read_bit VAR_FIRE			; A
	snes_read_bit VAR_FIRE			; X
	snes_drop_bit				; L
	snes_drop_bit				; R
	snes_drop_bit
	snes_drop_bit
	snes_drop_bit
	snes_drop_bit				; always read 16 bits
	;
	rts
	; ---
SUB_PRINT_LIVES
	lda VAR_LIVES
	lsr a
	lsr a
	lsr a
	lsr a
	ora #$30
	sta SCREEN + $0400 + LIVES_POS + 0	; score screen pos
	lda VAR_LIVES
	and #$0F
	ora #$30
	sta SCREEN + $0400 + LIVES_POS + 1
	;
	rts
	; --------
SUB_PRINT_SCORE
	lda VAR_SCORE
	lsr a
	lsr a
	lsr a
	lsr a
	ora #$30
	sta SCREEN + $0400 + SCORE_POS + 0	; score screen pos
	lda VAR_SCORE
	and #$0F
	ora #$30
	sta SCREEN + $0400 + SCORE_POS + 1
	;
	lda VAR_SCORE+1
	lsr a
	lsr a
	lsr a
	lsr a
	ora #$30
	sta SCREEN + $0400 + SCORE_POS + 2	; score screen pos
	lda VAR_SCORE+1
	and #$0F
	ora #$30
	sta SCREEN + $0400 + SCORE_POS + 3
	;
	lda VAR_SCORE+2
	lsr a
	lsr a
	lsr a
	lsr a
	ora #$30
	sta SCREEN + $0400 + SCORE_POS + 4	; score screen pos
	lda VAR_SCORE+2
	and #$0F
	ora #$30
	sta SCREEN + $0400 + SCORE_POS + 5
	;
	rts
	; --------
SUB_PRINT_HIGH
	ldx #$00
	ldy #$00
	;
SPH_01	lda VAR_HIGH,x
	lsr a
	lsr a
	lsr a
	lsr a
	ora #$30
	sta SCREEN + $0400 + HIGH_POS + 0,y	; HIGH screen pos
	ora #$80
	sta title_screen_high_score + 0,y
	lda VAR_HIGH,x
	and #$0F
	ora #$30
	sta SCREEN + $0400 + HIGH_POS + 1,y
	ora #$80
	sta title_screen_high_score + 1,y
	;
	iny
	iny
	inx
	cpx #3
	bne SPH_01
	;
	rts
	; --------
SUB_ADD_SCORE_TENS
	sta SC_LO+1
	lda #$00
	sta SC_HI+1
	beq SC_01
SUB_ADD_SCORE_HUNDREDS
	sta SC_HI+1
	lda #$00
	sta SC_LO+1
	;
SC_01	stx TMP_SAVE_X
	;
	tax
	;
	sed
	clc
	lda VAR_SCORE+2
SC_LO	adc #$00
	sta VAR_SCORE+2
	lda VAR_SCORE+1
SC_HI	adc #$00
	sta VAR_SCORE+1
	lda VAR_SCORE
	adc #$00
	sta VAR_SCORE
	cld
	;
	jsr SUB_PRINT_SCORE
	;
	ldx TMP_SAVE_X
	rts
	;
	; --------
	;
SUB_HAT_FALL
	lda #$01
	sta DEAD_FLAG				; trigger sound
	;
	ldx #$1F
	lda #$00
SHF_01	sta CHARSET + CONST_FALLING_HAT_CHAR * 8,x
	dex
	bpl SHF_01
	;
	lda VAR_PLAYER_Y
	jsr SUB_GET_SCREEN_PTRS
	ldy VAR_PLAYER_X
	lda #CONST_FALLING_HAT_CHAR
	sta (chr_ptr),y
	iny
	lda #CONST_FALLING_HAT_CHAR+2
	sta (chr_ptr),y
	;
	tya
	clc
	adc #39
	tay
	;
	lda #CONST_FALLING_HAT_CHAR+1
	sta (chr_ptr),y
	iny
	lda #CONST_FALLING_HAT_CHAR+3
	sta (chr_ptr),y
	;
	lda #0
	sta VAR_HAT_TMP
	;
SHF_02	ldy VAR_HAT_TMP
	lda VAR_HAT_TMP
	asl a
	and #$08
	tax
SHF_03	lda falling_hat_gfx,x
	sta CHARSET + CONST_FALLING_HAT_CHAR * 8,y
	lda falling_hat_gfx + 4,x
	sta CHARSET + (CONST_FALLING_HAT_CHAR + 2) * 8,y
	iny
	inx
	txa
	and #$03
	bne SHF_03
	;
	lda #$06
	sta VAR_FRAME_DELAY
SHF_04	lda VAR_FRAME_DELAY
	bne SHF_04
	;
	;jsr SUB_VOLUME_DOWN
	;
	inc VAR_HAT_TMP
	lda VAR_HAT_TMP
	cmp #16-3
	bne SHF_02
	;
;	jsr SUB_ANIMATE_FALLING_HAT
;	;
;	lda #CONST_SPACE_CHAR
;	sta (chr_ptr),y
;	dey
;	sta (chr_ptr),y
;	;
;	lda #$28
;	jsr SUB_ADD_CHR_PTR
;	lda #$28
;	jsr SUB_ADD_COL_PTR
;	;
;	jsr SUB_ANIMATE_FALLING_HAT
	;
	;jsr SUB_VOL_8
	rts
	; --------
SUB_ANIMATE_EXPLOSION
	lda VAR_EXPLOSION_COUNTS,y
	beq B_2EB1
	;
	txa
	pha
	tya
	pha
	;
	lda VAR_EXPLOSION_COUNTS,y
	asl a
	pha
	;
	lda VAR_ENEMY_DATA,x
	jsr SUB_GET_SCREEN_PTRS
	lda VAR_ENEMY_DATA+1,x
	tay
	pla
	tax
	;
	; ---
	;
	lda (chr_ptr),y				; check if explosion would be over player
	cmp #CONST_PLAYER_CHAR_FIRST		; inlined, removed extra flags
	bcc draw_explosion_left
	lda #CONST_PLAYER_CHAR_LAST
	cmp (chr_ptr),y
	bcs skip_explosion_left
	;
draw_explosion_left
	lda VAR_EXPLOSION_CHARS,x
	sta (chr_ptr),y
	lda VAR_EXPLOSION_COLORS,x
	sta (col_ptr),y
	;
skip_explosion_left
	iny
	lda (chr_ptr),y
	cmp #CONST_PLAYER_CHAR_FIRST		; check
	bcc draw_explosion_right
	lda #CONST_PLAYER_CHAR_LAST
	cmp (chr_ptr),y
	bcs skip_explosion_right
	;
draw_explosion_right
	lda VAR_EXPLOSION_CHARS+1,x
	sta (chr_ptr),y
	lda VAR_EXPLOSION_COLORS+1,x
	sta (col_ptr),y
	;
skip_explosion_right
	pla
	tay
	pla
	tax
	;
	lda VAR_EXPLOSION_COUNTS,y		; explosion count
	clc
	adc #$01
	sta VAR_EXPLOSION_COUNTS,y
	cmp #$06				; 5 steps
	bne B_2EB1
	;
	lda #$00
	sta VAR_EXPLOSION_COUNTS,y
	;
B_2EB1	rts
	;
	; ---
	;
SUB_GAME_OVER
	;
	; --- check for new high score
	;
	lda VAR_HIGH
	cmp VAR_SCORE
	bcc new_high_score
	bne no_new_high_score
	;
	lda VAR_HIGH+1
	cmp VAR_SCORE+1
	bcc new_high_score
	bne no_new_high_score
	;
	lda VAR_HIGH+2
	cmp VAR_SCORE+2
	bcs no_new_high_score
	;
new_high_score
	lda VAR_SCORE				; copy score to high score
	sta VAR_HIGH
	lda VAR_SCORE+1
	sta VAR_HIGH+1
	lda VAR_SCORE+2
	sta VAR_HIGH+2
	;
	jsr SUB_PRINT_HIGH			; print on screen (and copy to title)
	;
no_new_high_score
	;
	; ---
	;
	ldx #$0A
SGO_01	lda TXT_GAME_OVER,x
	sta SCREEN + $0400 + 8 * 40 + 14,x	; write text
	lda #CONST_SPACE_CHAR
	sta SCREEN + $0400 + 7 * 40 + 14,x
	sta SCREEN + $0400 + 9 * 40 + 14,x
	lda #$62
	sta SCREEN + 8 * 40 + 14,x
	dex
	bpl SGO_01
	;
	jsr pause_wait_for_fire
	;
	jmp LAB_TITLE_SCREEN
	;
	; ---
	;
SUB_CHECK_ZODIAC_PLACED
	lda FLAG_ZODIAC_CARRIED
	beq CZP_01
	;
	lda VAR_PLAYER_X			; check if player is in the middle of room
	cmp #$12
	bcc CZP_01
	cmp #$14
	bcs CZP_01
	;
	lda VAR_PLAYER_Y
	cmp #$07
	bcc CZP_01
	cmp #$0B
	bcs CZP_01
	;
	lda #$08				; 800 points for placed zodiacs
	jsr SUB_ADD_SCORE_HUNDREDS
	;
	lda #$00
	sta FLAG_ZODIAC_CARRIED
	;
	inc VAR_ZODIAC_PLACED
	;
	ldx VAR_ZODIAC_PLACED			; highlight placed zodiac
	lda VAR_MUL_3,x
	tax
	lda #CONST_PLACED_ZODIAC_COLOR
	sta SCREEN + 2 * 40 + 2,x
	sta SCREEN + 2 * 40 + 3,x
	;
	lda VAR_ZODIAC_PLACED
	cmp #13					; all zodiacs placed in middle?
	bcs CZP_01
	;
	jsr SUB_DRAW_ZODIAC_2
	;
CZP_01	rts
	
	;
	; *** SOUNDS ***
	;

;V_2FDF	db $4D
;V_2FE0	db $31
;V_2FE1	db $37
;V_2FE2	db $18
;VAR_SOUND_1
;	db $34
;VAR_SOUND_2
;	db $52
;VAR_SOUND_3
;	db $4F
;VAR_SOUND_4
;	db $4F
;V_2FE7	db $4D
;V_2FE8	db $31
;V_2FE9	db $38
;V_2FEA	db $0B,$E6
;V_2FEC	db $C8,$88,$58,$38,$28,$0A,$3A,$6A,$9A,$CA
;V_2FF6	db $03
;V_2FF7	db $C8,$03,$00
;V_2FFA	db $1D
;V_2FFB	db $40,$00,$01,$05,$18
;V_3000	db $04,$0C,$02,$60,$03,$11
;V_3006	db $00,$01,$01,$01,$00,$00,$00,$01,$00,$00,$00,$00,$00,$00,$00,$01
;V_3016	db $00,$01,$01,$01,$01,$00,$01,$01,$00,$00,$01,$01,$00,$00,$00,$00
;
;TED_VOICE_ON
;	db $10,$20,$40
;
;TED_VOICE_OFF
;	db $EF,$DF,$BF
;
;	; $302C JumpTable
;V_302C	dw L_322B-1,L_31FD-1,L_31FD-1,L_3259-1
;
;	; $3034 JumpTable
;V_3034	dw L_31E6-1,V_3034,L_3214-1,L_3242-1
;
;SUB_SOUND_INIT
;	lda #$08
;	sta $FF11
;	;
;	ldx #$FF
;	stx V_2FE7
;	stx V_2FE8
;	;
;	inx
;	stx VAR_SOUND_1
;	stx VAR_SOUND_2
;	stx VAR_SOUND_3
;	stx VAR_SOUND_4
;	;
;	rts
;;$3060  --------
;;$3060  --------
;S_3060	lda V_2FEA,x
;	sta $FF0E	; Sound1 Freq Lo
;	rts
;;$3067  --------
;S_3067	txa
;	asl a
;	tax
;	lda V_2FF6,x
;	sta $FF10	; Sound2 Freq Hi
;	lda V_2FF7,x
;	sta $FF0F	; Sound2 Freq Lo
;	rts
;;$3077  --------
;SUB_TED_VOICE_ON
;	lda $FF11	; Volume
;	ora TED_VOICE_ON,x
;	sta $FF11	; Volume
;	rts
;	;
;SUB_TED_VOICE_OFF
;	lda $FF11
;	and TED_VOICE_OFF,x
;	sta $FF11
;	rts
;;$308B  --------
;SUB_VOL_8
;	lda $FF11	; Volume
;	and #$F0
;	ora #$08
;	sta $FF11	; Volume
;	rts
;;$3096  --------
;;$3096  --------
;	;db $AD,$11,$FF,$29,$F0,$8D,$11,$FF,$60,$AD,$11,$FF,$29,$08,$D0,$03
;	;db $EE,$11,$FF,$60
;	;
;SUB_VOLUME_DOWN
;	lda $FF11	; Volume
;	and #$0F
;	beq B_30B4
;	dec $FF11	; Volume
;B_30B4	rts
;S_30B5	lda V_2FFA,x
;	sta V_2FDF
;	lda V_2FFB,x
;	sta V_2FE1
;	rts
;;$30C2  --------
;S_30C2	lda V_2FFA,x
;	sta V_2FE0
;	lda V_2FFB,x
;	sta V_2FE2
;	rts
;;$30CF  --------
;;$30CF  --------
;SUB_PLAY_SOUND
;	lda VAR_SOUND_1
;	beq B_30EB
;	;
;	jsr S_3140
;	dec V_2FE1
;	bne B_30EB
;	lda #$00
;	sta VAR_SOUND_1
;	lda #$FF
;	sta V_2FE7
;	ldx #$00
;	jsr SUB_TED_VOICE_OFF
;	;
;B_30EB	lda VAR_SOUND_2
;	beq B_3107
;	;
;	jsr S_314B
;	dec V_2FE2
;	bne B_3107
;	lda #$00
;	sta VAR_SOUND_2
;	lda #$FF
;	sta V_2FE8
;	ldx #$02
;	jsr SUB_TED_VOICE_OFF
;	;
;B_3107	lda VAR_SOUND_3
;	beq B_3123
;	;
;	jsr S_315E
;	dec V_2FE1
;	bne B_3123
;	lda #$00
;	sta VAR_SOUND_3
;	lda #$FF
;	sta V_2FE7
;	ldx #$00
;	jsr SUB_TED_VOICE_OFF
;	;
;B_3123	lda VAR_SOUND_4
;	beq B_313F
;	;
;	jsr S_3169
;	dec V_2FE2
;	bne B_313F
;	lda #$00
;	sta VAR_SOUND_4
;	lda #$FF
;	sta V_2FE8
;	ldx #$02
;	jsr SUB_TED_VOICE_OFF
;	;
;B_313F	rts
;;$3140  --------
;S_3140	clc
;	lda $FF0E	; Sound1 Freq Lo
;	adc V_2FDF
;	sta $FF0E	; Sound1 Freq Lo
;	rts
;;$314B  --------
;S_314B	clc
;	lda $FF0F	; Sound2 Freq Lo
;	adc V_2FE0
;	sta $FF0F	; Sound2 Freq Lo
;	lda $FF10	; Sound2 Freq Hi
;	adc #$00
;	sta $FF10	; Sound2 Freq Hi
;	rts
;;$315E  --------
;S_315E	sec
;	lda $FF0E	; Sound1 Freq Lo
;	sbc V_2FDF
;	sta $FF0E	; Sound1 Freq Lo
;	rts
;;$3169  --------
;S_3169	sec
;	lda $FF0F	; Sound2 Freq Lo
;	sbc V_2FE0
;	sta $FF0F	; Sound2 Freq Lo
;	lda $FF10	; Sound2 Freq Hi
;	sbc #$00
;	sta $FF10	; Sound2 Freq Hi
;	rts
;;$317C  --------
;SUB_SET_SOUND_2
;	sta V_2FE9
;	txa
;	pha
;	lda V_2FE7
;	bmi B_3195
;	asl a	; mul * 4
;	asl a
;	clc
;	adc V_2FE9
;	tax
;	lda V_3006,x
;	bne B_3195
;	jmp L_31AE
;	;
;B_3195	lda #$00
;	sta VAR_SOUND_1
;	sta VAR_SOUND_3
;	lda V_2FE9
;	sta V_2FE7
;	asl a
;	tax
;	lda V_302C + 1,x
;	pha
;	lda V_302C,x
;	pha
;	rts
;;$31AE  --------
;L_31AE	pla
;	tax
;	rts
;;$31B1  --------
;SUB_SET_SOUND_1
;	sta V_2FE9
;	txa
;	pha
;	lda V_2FE8
;	bmi B_31CA
;	asl a	; mul * 4
;	asl a
;	clc
;	adc V_2FE9
;	tax
;	lda V_3016,x
;	bne B_31CA
;	jmp L_31E3
;	;
;B_31CA	lda #$00
;	sta VAR_SOUND_2
;	sta VAR_SOUND_4
;	lda V_2FE9
;	sta V_2FE8
;	asl a
;	tax
;	lda V_3034+1,x
;	pha
;	lda V_3034,x
;	pha
;	rts
;;$31E3  --------
;L_31E3	pla
;	tax
;	rts
;;$31E6  --------
;L_31E6	ldx #$00
;	jsr S_3067
;	ldx #$02
;	jsr S_30C2
;	lda #$01
;	sta VAR_SOUND_2
;	ldx #$02
;	jsr SUB_TED_VOICE_ON
;	jmp L_31E3
;	;
;L_31FD	ldx #$00
;	jsr S_3060
;	ldx #$00
;	jsr S_30B5
;	lda #$01
;	sta VAR_SOUND_1
;	ldx #$00
;	jsr SUB_TED_VOICE_ON
;	jmp L_31AE
;	;
;L_3214	ldx #$00
;	jsr S_3067
;	ldx #$04
;	jsr S_30C2
;	lda #$01
;	sta VAR_SOUND_4
;	ldx #$02
;	jsr SUB_TED_VOICE_ON
;	jmp L_31E3
;	;
;L_322B	ldx #$01
;	jsr S_3060
;	ldx #$06
;	jsr S_30B5
;	lda #$01
;	sta VAR_SOUND_1
;	ldx #$00
;	jsr SUB_TED_VOICE_ON
;	jmp L_31AE
;	;
;L_3242	ldx #$01
;	jsr S_3067
;	ldx #$08
;	jsr S_30C2
;	lda #$01
;	sta VAR_SOUND_2
;	ldx #$02
;	jsr SUB_TED_VOICE_ON
;	jmp L_31E3
;	;
;L_3259	ldx #$0A
;	jsr S_30B5
;	lda #$01
;	sta VAR_SOUND_1
;	ldx #$00
;	jsr SUB_TED_VOICE_ON
;	jmp L_31AE
;;$326B  --------

	include "music/!player.asm"
	include "music/!player_data.asm"
	include "music/music.asm"
	
	include "map_chars_charmap.asm"
	
draw_map
	dec FLAG_MAP_MODE			; flag we're in map mode, so powerups stop
	;
	lda #$10				; BPL opcode, always reset map feature
	sta dm_cheat_01
	lda #$D0				; BNE opcode
	sta dm_cheat_02
	;
redraw_map
	jsr screen_off_clear			; clear screen and turn it off
	;
	lda #$38
	sta $FF13				; switch to new charset
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07				; hires, 256 chars enabled, 40 chars
	;
	lda #$02				; start from x=2, y=0
	sta col_ptr
	sta chr_ptr
	lda #SCREEN >> 8
	sta col_ptr+1
	ora #$04
	sta chr_ptr+1
	;
	lda #0
	sta TMP_SAVE_Y				; x & y loop counters
	sta TMP_SAVE_X
	;
dm_01	ldy TMP_SAVE_Y
	lda VAR_MAP_ROWS,y
	clc
	adc TMP_SAVE_X
	tax
	;
	lda DEMON_COUNT_ZODIAC_FLAG,x		; load this value for checking the zodiac placements
	sta dm_cheat_03+1			; self-mod
	;
	lda DAT_GAME_MAP,x
dm_cheat_01
	bpl dm_02				; room not yet visited
	;
	asl a					; *6
	sta TMP_INDEX
	asl a
	clc
	adc TMP_INDEX
	;
	tax
	ldy #0
	lda map_chars_charmap,x			; set chars
	sta (chr_ptr),y
	iny
	lda map_chars_charmap+1,x
	sta (chr_ptr),y
	iny
	lda map_chars_charmap+2,x
	sta (chr_ptr),y
	ldy #40
	lda map_chars_charmap+3,x
	sta (chr_ptr),y
	iny
	lda map_chars_charmap+4,x
	sta (chr_ptr),y
	iny
	lda map_chars_charmap+5,x
	sta (chr_ptr),y
	;
	lda TMP_SAVE_X
	clc
	adc TMP_SAVE_Y
	tax
	lda VAR_BLOCK_COLORS,x
dm_cheat_02	
	bne dm_06				; always jump, block colors are never black
	;
dm_cheat_03
	lda #$00
	and #$F0
	beq *+5
	lda #$55
	db $2C 
	lda #$11
	;
dm_06	jsr map_set_colors
	;
dm_02	lda TMP_SAVE_X				; player in this room?
	cmp VAR_MAP_X
	bne dm_03
	lda TMP_SAVE_Y
	cmp VAR_MAP_Y
	bne dm_03
	;
	lda col_ptr				; save room's pointer
	sta src_ptr
	lda col_ptr+1
	sta src_ptr+1
	;
dm_03	lda #3
	jsr col_chr_ptr_add
	;
	inc TMP_SAVE_X				; x loop
	lda TMP_SAVE_X
	cmp #CONST_MAP_SIZE
dm_04	bne dm_01
	;
	lda #44
	jsr col_chr_ptr_add
	;
	lda #0
	sta TMP_SAVE_X
	inc TMP_SAVE_Y				; y loop
	lda TMP_SAVE_Y
	cmp #CONST_MAP_SIZE
	bne dm_04				; dm_01
	;
	; ---
	; 
	ldx #$1B
	jsr screen_on_off
	;
	lda src_ptr				; restore room's pointer
	sta col_ptr
	lda src_ptr+1
	sta col_ptr+1
	;
	lda #0
	sta TMP_INDEX
map_loop
	jsr frame_sync
	;
	ldx #$24
	cpx dm_cheat_01				; already applied?
	beq dm_07
	;
	lda #$FD
	sta $FD30
	lda #$FF
	sta $FF08
	lda $FF08
	and #$14				; Query keyboard for Z+A
	bne dm_07
	;
	stx dm_cheat_01
	stx dm_cheat_02
	jmp redraw_map
	;
dm_07	inc TMP_INDEX
	lda TMP_INDEX
	and #$0F
	bne dm_05
	;
	ldy #0
	lda (col_ptr),y
	eor #$40
	jsr map_set_colors
	;
dm_05	jsr check_fire
	bcc map_loop
	;
	jsr game_screen_off
	jsr game_init_screen
	jsr SUB_DRAW_ROOM
	;
	lda FLAG_IN_TIME_VAULTS
	beq dm_08
	;
	jsr time_vaults_close_anim		; draw wall closed
	;
dm_08	jmp LAB_ROOM_DRAWN

map_set_colors
	ldy #0					; set colors
	jsr map_set_colors_row
	ldy #40
map_set_colors_row
	sta (col_ptr),y
	iny
	sta (col_ptr),y
	iny
	sta (col_ptr),y
	rts

col_chr_ptr_add
	clc
	adc col_ptr
	sta col_ptr
	sta chr_ptr
	bcc *+6
	inc col_ptr+1
	inc chr_ptr+1
	rts
code_end

	ds ($3FF8 - $34*8) - *			; align so that last used characters is on $3FF0-$3FF7
	include "map_chars_charset.asm"
; EOF