SHOW_FREE_SPACE = 0

	org $0400-2
	dw  $0400

; vars
src_ptr		= $C0	
chr_ptr		= $C2
col_ptr 	= $C4
dst_idx		= $C6
current_color	= $C7
restore_ptr	= $C8
column_idx	= $CA

space_fire	= $CB

; const
BACKGROUND_CLR	= $0D
NL		= $10
PAUSE		= $FE
EOF		= $FF

; SNES controller support
BIT_CLOCK 	= 1 << 7
BIT_LATCH 	= 1 << 6
BIT_P1_DATA0	= 1 << 1
BIT_P2_DATA0 	= 1 << 0
BITS_INPUT 	= BIT_P1_DATA0 | BIT_P2_DATA0    ; Userport bits that must always be kept HIGH (so that they act as INPUTs)
USERPORT 	= $FD10

	include "intro_music/!playerv.asm"
	
	include "background_charmap.asm"
	
	org $0800
	sei
	sta $FF3F
	;
	lda #pat_noise >> 8
	ldx #pat_noise & 255
	ldy #vol_1 & 255
	cmp #vol_1 >> 8
	beq music_ok
	inc $FF19
	jmp *-3
music_ok
	;
	ldy #$00
	ldx #$FF
	lda $FF07
	and #$40
	beq *+4
	ldx #$F7
	cpx $FF1D
	bne *-3
	;
	sty $FF15				; Black background color and
	sty $FF19				; border Color
	sty $FF12
	sty space_fire
	;
	dey					; y=$FF
	sty $FF0C
	sty $FF0D
	;
	lda #irq & 255
	sta $FFFE
	lda #irq >> 8
	sta $FFFF
	lda #$03
	sta $FF0B
	lda #$A2
	sta $FF0A
	;
	jsr PLAYER_INIT
	;
	lda #(BIT_CLOCK | BITS_INPUT)   	; Set things up in order to be able to poll NES/SNES controllers
	sta USERPORT				; Start with latch low
	;
	lda #text_data & 255
	sta src_ptr
	lda #text_data >> 8
	sta src_ptr+1
	;
	lda $FF07
	and #$40
	ora #$88
	sta $FF07
	;
	lda #$38
	sta $FF13
	;
	lda #$08
	sta $FF14
	;
	lda #$1B
	sta $FF06
	;
	cli
	;
	if SHOW_FREE_SPACE = 0
	jmp start
	else
	lda #$C4
	sta $FF12
	lda #$D1
	sta $FF13
	;
	ldx #$00
sfs_01	lda #$20
	sta $0900,x
	sta $0B00,x
	sta $0C00,x
	sta $0E00,x
	lda #$41
	sta $0A00,x
	inx
	bne sfs_01
	;
	lda #"$"
	sta $0C00 + 13 * 40 + 0
	lda #(background_charset - code_end) >> 8
	jsr conv_hex_byte
	sty $0C00 + 13 * 40 + 1
	sta $0C00 + 13 * 40 + 2
	lda #(background_charset - code_end) & 255
	jsr conv_hex_byte
	sty $0C00 + 13 * 40 + 3
	sta $0C00 + 13 * 40 + 4
	jmp *

conv_hex_byte
	tax
	lsr a
	lsr a
	lsr a
	lsr a
	jsr conv_hex
	tay
	txa
	and #$0F
conv_hex
	cmp #$0A
	bcs conv_hex_1
	ora #$30
	rts
conv_hex_1
	sbc #$09
	rts
	endif
	
	org $0C00
	ds $0400

	org $1001	
	include "zodiac_comp_hex.asm"

start	jsr reveal_columns
	;
tw_06	lda #4 * 40 + 5
	jsr setup_ptrs_a
	;
	lda #$00
	sta dst_idx
	;
tw_01	jsr sync
	;
	jsr poll_controls
	lda space_fire
	bne tw_quit
	;
	ldy #$00
tw_05	lda (src_ptr),y
	;
	inc src_ptr
	bne *+4
	inc src_ptr+1
	;
	cmp #EOF
	beq tw_done
	cmp #PAUSE
	beq pause
	bmi tw_02
	cmp #NL+1
	bcs tw_04
	cmp #NL
	beq tw_03
	;
	sta dst_idx
	bne tw_05
	;
tw_03	jsr line_down
	;
	lda #$00
	sta dst_idx
	beq tw_01
	;
tw_04	sta current_color
	bne tw_05				; always jump
	;
tw_02	ldy dst_idx
	cmp #$E0
	beq skip_space
	;
	sta (chr_ptr),y
	lda current_color
	sta (col_ptr),y
	;
skip_space
	iny
	sty dst_idx
	;
	bne tw_01				; always jump

pause	ldx #8
delay1	ldy #50
	lda $FF07
	and #$40
	beq *+4
	ldy #60
delay2	jsr sync
	;
	txa
	pha
	tya
	pha
	;
	jsr poll_controls
	lda space_fire
	bne tw_quit
	;
	pla
	tay
	pla
	tax
	;
	dey
	bpl delay2
	dex
	bpl delay1
	;
	jsr restore_columns
	;
	jmp tw_06
	;
tw_done	jsr restore_columns
	;
tw_quit	ldx #$00
	stx rc_color+1				; remove background
	inx
	stx vol_dn_and				; start volume down
	;
	jsr restore_columns
	;
	lda #$00
	tax
	tay
	;
	jmp $100D				; start decrunch

restore_columns
	ldx #$00
rc_02	jsr restore_2_columns
	;
	lda column_idx
	tax
vol_dn_and
	and #$00
	beq rc_03
	;
	lda vol_dn+1
	cmp #$50				; volume down
	beq rc_03
	;
	dec vol_dn+1
	;
rc_03	inx
	cpx #20
	bne rc_02
	rts
	
setup_ptrs
	lda #$00
setup_ptrs_a
	sta restore_ptr
	sta chr_ptr
	sta col_ptr
	;
	lda #$04
	sta restore_ptr+1
	lda #$0C
	sta chr_ptr+1
	and #$FB
	sta col_ptr+1
	;
	ldx #24
	rts

line_down
	lda restore_ptr
	clc
	adc #40
	sta restore_ptr
	sta chr_ptr
	sta col_ptr
	bcc *+8
	inc restore_ptr+1
	inc chr_ptr+1
	inc col_ptr+1
	rts

restore_2_columns
	stx column_idx
	;
	jsr sync
	;
	ldy column_idx
	jsr restore_column
	;
	lda #39
	sec
	sbc column_idx
	tay
	;
restore_column
	jsr setup_ptrs
	;
rc_01	lda (restore_ptr),y
	sta (chr_ptr),y
rc_color
	lda #BACKGROUND_CLR
	sta (col_ptr),y
	;
	jsr line_down
	;
	dex
	bpl rc_01
	;
	rts

reveal_columns
	ldx #19
rv_02	jsr restore_2_columns
	;
	ldx column_idx
	dex
	bpl rv_02
	rts

sync	lda #$CB
	cmp $FF1D
	bne *-3
	cmp $FF1D
	beq *-3
	rts
	
	;
	; ---
	;
pressed	inc space_fire
	rts
	;
poll_controls
	ldy #$FF
	sty $FD30				; don't check keys
	lda #$FB				; Query joystick #1
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$40
	beq pressed
	;
	; Joy 2
	;
JOYSTICK_2
	sty $FD30				; don't check keys
	lda #$FD				; Query joystick #2
	sta $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$80
	beq pressed
	;
	; Keyboard
	;
KEYBOARD
	lda #$7F				; Check column 7
	sta $FD30				; Keyboard Matrix
	sty $FF08				; Keyboard Latch
	lda $FF08				; Keyboard Latch
	and #$10				; Query keyboard for "Space"
	beq pressed
	;
	; SNES controller
	;
snes_read_bit macro
	lda USERPORT
	and #$02
	bne snes_bit_not_on\?
	;
	inc space_fire
	;
snes_bit_not_on\?
	lda #(BITS_INPUT)			; Move on to next bit by pulsing clock
	sta USERPORT				; Clock low - Doing it here avoids VICE bug
	sty USERPORT				; Clock high (Y is preloaded)
	endm
snes_drop_bit	macro
	lda #(BITS_INPUT)			; Move on to next bit by pulsing clock
	sta USERPORT				; Clock low - Doing it here avoids VICE bug
	sty USERPORT				; Clock high (Y is preloaded)
	endm
POLL_SNES
	lda #(BIT_LATCH | BIT_CLOCK | BITS_INPUT)
	sta USERPORT				; Latch+clock high...
	ldy #(BIT_CLOCK | BITS_INPUT)		; ... then latch back low (6502 is so slow that 4021 minimum times should always
	sty USERPORT				; be respeced, as they are hundreds of nanoseconds)
	;
	ldx #9
snes_1	;
	snes_read_bit				; all buttons
	dex
	bpl snes_1
	ldx #5
snes_2	;
	snes_drop_bit				; always read 16 bits
	dex
	bpl snes_2
	;
	rts

	;
	; ---
	;	
irq	pha
	txa
	pha
	tya
	pha
	;
	jsr PLAYER
	;
vol_dn	lda #$58
	cmp $FF11
	bcs no_vol_dn
	sta $FF11
no_vol_dn
	;
	lda $FF0B
	eor #($03 ^ $CD)
	sta $FF0B
	;
	asl $FF09
	;
	pla
	tay
	pla
	tax
	pla
	rti
	
	cmap " ",$E0
	cmap "A",$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF
	cmap "P",$F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA
	cmap ".",$FB
	cmap ",",$FC
	cmap "!",$FD
text_data
	;  |012345678901234567890123456789|
	db $5D,$06,"THE ",$71,"MASTERS",$5D," IN THE",NL
	db $04,"BLACK ARTS HAVE STOLEN",NL
	db $05,"THE TWELVE SIGNS OF",NL
	db $09,"THE ",$71,"ZODIAC",$5D,".",NL
	db NL,NL,NL
	db $07,"THEY HAVE BEEN",NL
	db $06,"SCATTERED AROUND",NL
	db $04,"THE CORRIDORS OF TIME.",NL
	db NL,NL,NL
	db $04,"AS YOU SEARCH FOR THEM,",NL
	db $05,"BEWARE OF THE ",$71,"DEMONS",$5D,NL
	db $04,"WHO WILL ATTACK WITHOUT",NL
	db $09,"PROVOCATION.",NL
	db PAUSE
	
	db NL
	db $06,"ALAS, YOU CANNOT",NL
	db $04,"AFFORD TO STAND STILL.",NL
	db $06,"YOU CAN ONLY FIRE",NL
	db $07,"WHILE IN MOTION.",NL
	db NL,NL,NL
	db $0A,"EACH OF THE",NL
	db $07,"ZODIAC SIGNS WILL", NL
	db $03,"GRANT YOU ",$71,"SPECIAL POWERS",$5D,".",NL
	;  |012345678901234567890123456789|
	db NL,NL,NL
	db "ONCE ALL SIGNS ARE COLLECTED,",NL
	db "FIND AND ENTER THE ",$71,"CUBIC GATE",$5D,".",NL
	db PAUSE
	
	db NL,NL,NL
	db $5D
	;  |012345678901234567890123456789|
	db $07,"YOU WILL HAVE TO",NL
	db $07,"PLACE ALL SIGNS",NL
	db $06,"IN THE ",$71,"TIME VAULTS",$5D,".",NL
	db NL,NL,NL
	;  |012345678901234567890123456789|
	db $04,"BUT BEWARE, THE MASTERS",NL
	db $03,"PLACED THEIR MOST POWERFUL",NL
	db $09,"DEMONS THERE.",NL
	db $07,"YOU ",$32,"CANNOT",$5D," SHOOT",NL
	db $06,"IN THEIR PRESENCE!"
	db PAUSE
	;
	db NL,NL,NL,NL,NL,NL
	db $5D,$08,"IN GAME KEYS",NL,NL
	;  |012345678901234567890123456789|
	db "ESC ..................... QUIT",NL
	db "HELP ..................... MAP",NL
	db "M ............... TOGGLE MUSIC",NL
	
	db PAUSE
	
	db EOF
	cmap
	
	align 256
	include "intro_music/!player.asm"
	include "intro_music/!player_data.asm"
	
	include "intro_music/music.asm"
code_end

	org $3800
	include "background_charset.asm"
	
	db $00,$00,$00,$00,$00,$00,$00,$00
	db $10,$7C,$C6,$C6,$DE,$F6,$C6,$00	; $00 - $0000
	db $FC,$C6,$C2,$DC,$F2,$C6,$FC,$00	; $01
	db $7C,$C6,$C0,$C0,$C0,$C6,$7C,$00	; $02
	db $FC,$C6,$C6,$C6,$C6,$C6,$FC,$00	; $03
	db $7C,$C6,$80,$98,$F0,$C6,$7C,$00	; $04
	db $FC,$C6,$C0,$D8,$F0,$C0,$C0,$00	; $05
	db $FC,$C6,$C0,$DE,$D2,$C6,$FC,$00	; $06
	db $C6,$C6,$C6,$DE,$F6,$C6,$C6,$00	; $07
	db $7E,$D8,$18,$18,$30,$36,$FC,$00	; $08
	db $1E,$36,$36,$16,$06,$C6,$7C,$00	; $09
	db $C6,$C6,$CC,$D8,$F4,$C6,$C6,$00	; $0A
	db $C0,$C0,$C0,$C0,$C0,$C6,$FC,$00	; $0B
	db $6C,$D6,$D6,$D6,$D6,$D6,$D6,$00	; $0C
	db $C6,$C6,$F6,$DE,$C6,$C6,$C6,$00	; $0D
	db $7C,$C6,$C6,$C6,$C6,$C6,$7C,$00	; $0E
	db $FC,$C6,$C6,$DC,$F0,$C0,$C0,$00	; $0F
	db $7C,$C6,$C6,$D6,$DE,$C6,$7C,$00	; $10
	db $FC,$C6,$C6,$DC,$F6,$C6,$C6,$00	; $11
	db $7C,$FE,$80,$7C,$02,$FE,$7C,$00	; $12
	db $7C,$D6,$10,$10,$30,$30,$30,$00	; $13
	db $C6,$C6,$C6,$C6,$C6,$76,$1E,$00	; $14
	db $C6,$C6,$C6,$C6,$C6,$7C,$10,$00	; $15
	db $D6,$D6,$D6,$D6,$D6,$D6,$6C,$00	; $16
	db $C6,$C6,$6C,$38,$6C,$C6,$C6,$00	; $17
	db $C6,$C6,$C6,$7C,$18,$18,$30,$00	; $18
	db $7E,$C6,$0C,$38,$60,$C6,$FC,$00	; $19
	db $00,$00,$00,$00,$00,$30,$30,$00
	db $00,$00,$00,$00,$00,$30,$30,$10
	db $70,$30,$30,$30,$30,$00,$30,$00
;eof