;
; LOD Player Version 2
;
F1LO	= $FF0E
F1HI	= $FF12
F2LO	= $FF0F
F2HI	= $FF10

OFF	= $04
	
; COMMAND BYTES

END_MARK	= $FE
SET_VOLTAB	= $C0
LEN		= $10

; Constants
base_note = -10
C0	= base_note + 0
Ci0	= base_note + 1
D0	= base_note + 2
Di0	= base_note + 3
E0	= base_note + 4
F0	= base_note + 5
Fi0	= base_note + 6
G0	= base_note + 7
Gi0	= base_note + 8
A0	= base_note + 9
Ai0	= base_note + 10
B0	= base_note + 11

C1	= base_note + 12
Ci1	= base_note + 13
D1	= base_note + 14
Di1	= base_note + 15
E1	= base_note + 16
F1	= base_note + 17
Fi1	= base_note + 18
G1	= base_note + 19
Gi1	= base_note + 20
A1	= base_note + 21
Ai1	= base_note + 22
B1	= base_note + 23

C2	= base_note + 24
Ci2	= base_note + 25
D2	= base_note + 26
Di2	= base_note + 27
E2	= base_note + 28
F2	= base_note + 29
Fi2	= base_note + 30
G2	= base_note + 31
Gi2	= base_note + 32
A2	= base_note + 33
Ai2	= base_note + 34
B2	= base_note + 35

C3	= base_note + 36
Ci3	= base_note + 37
D3	= base_note + 38
Di3	= base_note + 39
E3	= base_note + 40
F3	= base_note + 41
Fi3	= base_note + 42
G3	= base_note + 43
Gi3	= base_note + 44
A3	= base_note + 45
Ai3	= base_note + 46
B3	= base_note + 47

C4	= base_note + 48
Ci4	= base_note + 49
D4	= base_note + 50
Di4	= base_note + 51
E4	= base_note + 52
F4	= base_note + 53
Fi4	= base_note + 54
G4	= base_note + 55
Gi4	= base_note + 56
A4	= base_note + 57
Ai4	= base_note + 58
B4	= base_note + 59

C5	= base_note + 60
Ci5	= base_note + 61
D5	= base_note + 62

;-----
          
PLAYER_INIT
	;         
	; *** Init
	;
	ldx #$FF
	stx VOLTAB_CNT
	stx FRAME_CNT
	inx       				; x=0
	stx NOTE1
	stx NOTE2
	;
	jsr pattern_reset
	inx
	stx NOTELEN1
	stx NOTELEN2
	;
	lda #$03				; for the noise channel, high byte is fixed
	sta F2HI
	;
pattern_reset
	ldy #$00
	db $2C
	;
pattern_advance
	ldy PCH1,x
	; 
	txa
	bne adv2
	;
	lda Channel1,y
	beq pattern_reset
	bne adv3
	;
adv2	lda Channel2,y
	beq pattern_reset
	;
adv3	sta CH1_LO,x
	;
	iny
	sty PCH1,x
	;
ret1	rts
	
	;
	;##################
	;

pattern_end
	jsr pattern_advance
	bne next_note				; should never be zero
	;
PLAYER	lda $FF07
	and #$40
	beq pal
	;
	ldx FRAME_CNT
	inx
	cpx #12					; count to 12 (6 frames * 2 calls)
	bne *+4
	ldx #$00
	stx FRAME_CNT
	cpx #10					; on NTSC, the last two calls (1 frame) do nothing
	bcs ret1
pal	;
	ldx #$01
channel_loop
	inc NOTE1,x
	;
	lda NOTE1,x
	cmp NOTELEN1,x
	bne channel_loop_end
	;
next_note 
	lda CH1_LO,x
	sta CH_TEMP
	;lda CH1_HI,x
	lda #pat_default >> 8
	sta CH_TEMP+1
	;
	ldy #$00
	sty NOTE1,x				; reset note counter
	;   
	lda (CH_TEMP),y				; get byte
	iny
	;
	cmp #END_MARK				; $FF goes to new pattern
	beq pattern_end
	;
	cmp #SET_VOLTAB
	bcc pl_12
	;
	and #$3F
	sta VOLTAB_CNT
	dec VOLTAB_CNT
	;
	lda (CH_TEMP),y				; get byte
	iny
	;
pl_12	cmp #LEN				; set note length?
	bcc pl_02
	;
	sbc #LEN				; we know carry is always set
	sta NOTELEN1,x
	;
	lda (CH_TEMP),y
	iny
	;
pl_02	sta TONE1,x				; store the note
	;
	tya					; pattern_advance pointer (from y)
	clc
	adc CH1_LO,x
	sta CH1_LO,x
	bcc noi_1
	inc CH1_HI,x
noi_1	;
	;
	; -----------------------------------------------------------------
	;
channel_loop_end
	dex
	bpl channel_loop
	;
	; --- SOUND PROCESSING
	;
PLAYER_SOUND
	;
	; ---
	;
	ldx #$01				; channel 2
	jsr noisy				; fixed instrument
	sta F2LO				; only set lo byte
	;
	ldx #$00				; channel 1
	jsr vibrato
	sta F1LO
	sty F1HI_store+1
	lda F1HI
	and #$FC
F1HI_store
	ora #$00
	sta F1HI
	;
	; ---
	;
pl_71	ldy VOLTAB_CNT
	iny
res_v	lda vol_1,y				; fixed address
	bpl noi_v				; check for end marker ($80 and higher)
	and #$7F
	tay
	bpl res_v				; always jump
	;
noi_v	sty VOLTAB_CNT
	tax					; save volume in x
	;
	; ---
	;
	lda #$FE
	cmp F1LO
	bne setvol				; not silent
	cmp F2LO
	beq sil					; silent: skip setting $FF11 to avoid clicks
	;
setvol	stx $FF11
	;
sil	rts     

freq_off
	lda #$FE
	ldy #$03
	rts
	;
vibrato	
	lda TONE1				; fixed to x=0
	cmp #OFF
	beq freq_off
	tax
	;
	lda NOTE1				; repeat every 8 bytes
	and #$07
	tay
	;
	lda NOTE1				; toggle add/subtract
	and #$08				; 8 bytes add, 8 bytes subtract
	beq vib_up
	;
	lda #$FF				; effectively subtract
	;
vib_up	eor vibrato_data,y
	clc
	adc freqs_lo,x
	ldy #$00				; high byte is always 0
	rts

vibrato_data
	db $00,$03,$05,$07,$08,$07,$05,$03
	;
	; ---
	;
noisy	lda TONE1,x
	cmp #OFF
	beq freq_off
	asl a
	asl a
	rts
;[eof]